/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit;

import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.PostalAddressBuilder;
import com.varial.framework.domain.payment.sepa.data.LocationData;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.PostalAddress6;
import java.util.List;

public class PartyIdentificationBuilder {
    private final PartyData dto;
    private boolean withName;
    private boolean withPostalAddress;
    private boolean withStructuredPostalAddress;

    public PartyIdentificationBuilder(PartyData dto) {
        this.dto = dto;
        this.withName = false;
        this.withPostalAddress = false;
        this.withStructuredPostalAddress = false;
    }

    public PartyIdentificationBuilder withName() {
        this.withName = true;
        return this;
    }

    public PartyIdentificationBuilder withUnstructuredPostalAddress() {
        this.withPostalAddress = true;
        this.withStructuredPostalAddress = false;
        return this;
    }

    public PartyIdentificationBuilder withStructuredPostalAddress() {
        this.withStructuredPostalAddress = true;
        this.withPostalAddress = true;
        return this;
    }

    public PartyIdentification32 build() {
        if (this.dto == null) {
            return null;
        }
        PartyIdentification32 result = new PartyIdentification32();
        if (this.withName) {
            result.setNm(this.dto.getName());
        }
        if (this.withPostalAddress) {
            result.setPstlAdr(this.mapPostalAddress());
        }
        return result;
    }

    private PostalAddress6 mapPostalAddress() {
        List<LocationData> locations = this.dto.getLocations();
        return locations != null && !locations.isEmpty() ? new PostalAddressBuilder(locations.get(0)).withStructuredAddress(this.withStructuredPostalAddress).build() : null;
    }
}

