/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.payment.sepa.ForeignPaymentHelperISO20022;
import com.varial.accounting.domain.payment.sepa.SepaChargesType;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.CreditSchemaMapper;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.PartyIdentificationBuilder;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.PostalAddressBuilder;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import iso.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4;
import iso.sepa.version3.credit.ClearingSystemMemberIdentification2;
import iso.sepa.version3.credit.FinancialInstitutionIdentification7;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.RegulatoryReporting3;

public class ForeignPaymentCreditSchemaMapper
extends CreditSchemaMapper {
    @Override
    protected BranchAndFinancialInstitutionIdentification4 getCreditorAgent(PaymentData payment) {
        return new CreditorAgentMapper().map(payment);
    }

    @Override
    protected SepaChargesType getChargesType(PaymentData payment, PaymentInfoData paymentInfo) {
        return SepaChargesType.getChargesTypeForNonSepaForeignPayment(payment, paymentInfo.getBankAccountCountry().getIsoCode());
    }

    @Override
    protected boolean getBtchBookgValue() {
        return false;
    }

    @Override
    protected PartyIdentification32 mapDebtor(PartyData debtor) {
        return new PartyIdentificationBuilder(debtor).withName().build();
    }

    @Override
    protected PartyIdentification32 mapInitiatingParty(PartyData initiatingParty) {
        return new PartyIdentificationBuilder(initiatingParty).withName().build();
    }

    @Override
    protected PartyIdentification32 mapCreditor(PartyData creditor) {
        return new PartyIdentificationBuilder(creditor).withName().withStructuredPostalAddress().build();
    }

    @Override
    protected RegulatoryReporting3 mapRegulatoryReporting(PaymentData payment) {
        return null;
    }

    @Override
    protected String getServiceLevelCode() {
        return "NURG";
    }

    private class CreditorAgentMapper {
        private CreditorAgentMapper() {
        }

        private BranchAndFinancialInstitutionIdentification4 map(PaymentData dto) {
            BranchAndFinancialInstitutionIdentification4 result = new BranchAndFinancialInstitutionIdentification4();
            result.setFinInstnId(this.getFinancialInstitutionIdentification(dto));
            return result;
        }

        private FinancialInstitutionIdentification7 getFinancialInstitutionIdentification(PaymentData dto) {
            ClearingSystemMemberIdentification2 clrSysMbId;
            FinancialInstitutionIdentification7 instID = new FinancialInstitutionIdentification7();
            if (StringUtil.isNotEmpty((String)dto.getBic())) {
                instID.setBIC(dto.getBic());
            }
            if (this.withClearingSystemMemberIdentification(dto) && (clrSysMbId = this.getClearingSystemMemberIdentification(dto)) != null) {
                instID.setClrSysMmbId(clrSysMbId);
                instID.setNm(dto.getBankName());
                instID.setPstlAdr(new PostalAddressBuilder(dto.getBankAddress()).withStructuredAddress(true).build());
            }
            return instID;
        }

        private boolean withClearingSystemMemberIdentification(PaymentData dto) {
            return ForeignPaymentHelperISO20022.withBankSortingCode(dto);
        }

        private ClearingSystemMemberIdentification2 getClearingSystemMemberIdentification(PaymentData dto) {
            if (StringUtil.isEmpty((String)dto.getBankSortingCode()) && StringUtil.isEmpty((String)dto.getAbaNumber())) {
                return null;
            }
            ClearingSystemMemberIdentification2 result = new ClearingSystemMemberIdentification2();
            String memberID = StringUtil.isNotEmpty((String)dto.getAbaNumber()) ? dto.getAbaNumber() : dto.getBankSortingCode();
            result.setMmbId(memberID);
            return result;
        }
    }
}

