/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit;

import com.varial.accounting.domain.payment.sepa.SepaChargesType;
import com.varial.accounting.domain.payment.sepa.schemamapper.version3.credit.AmountMapper;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaHeaderData;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.version3.credit.AccountIdentification4Choice;
import iso.sepa.version3.credit.AccountSchemeName1Choice;
import iso.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4;
import iso.sepa.version3.credit.CashAccount16;
import iso.sepa.version3.credit.ChargeBearerType1Code;
import iso.sepa.version3.credit.CreditTransferTransactionInformation10;
import iso.sepa.version3.credit.CustomerCreditTransferInitiationV03;
import iso.sepa.version3.credit.FinancialInstitutionIdentification7;
import iso.sepa.version3.credit.GenericAccountIdentification1;
import iso.sepa.version3.credit.GroupHeader32;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.PaymentIdentification1;
import iso.sepa.version3.credit.PaymentInstructionInformation3;
import iso.sepa.version3.credit.PaymentMethod3Code;
import iso.sepa.version3.credit.PaymentTypeInformation19;
import iso.sepa.version3.credit.RegulatoryReporting3;
import iso.sepa.version3.credit.RemittanceInformation5;
import iso.sepa.version3.credit.ServiceLevel8Choice;
import java.util.Iterator;

public abstract class CreditSchemaMapper {
    public CustomerCreditTransferInitiationV03 toSchema(SepaData sepaData) {
        CustomerCreditTransferInitiationV03 noun = new CustomerCreditTransferInitiationV03();
        noun.setGrpHdr(this.mapHeader(sepaData.getHeader()));
        Iterator iter = sepaData.getPaymentInfos().iterator();
        while (iter.hasNext()) {
            noun.getPmtInf().add(this.mapPaymentInformation((PaymentInfoData)iter.next()));
        }
        return noun;
    }

    private GroupHeader32 mapHeader(SepaHeaderData header) {
        GroupHeader32 result = new GroupHeader32();
        result.setCreDtTm(new DateAdapter().getCalendarInYYYYMMDDHHmmSS(header.getCreationDateTime()));
        result.setInitgPty(this.mapInitiatingParty(header.getInitiatingParty()));
        result.setMsgId(header.getMessageID());
        result.setNbOfTxs(Integer.toString(header.getNumberOfTransactions()));
        result.setCtrlSum(header.getControlSum());
        return result;
    }

    private PaymentInstructionInformation3 mapPaymentInformation(PaymentInfoData paymentInfo) {
        PaymentInstructionInformation3 result = new PaymentInstructionInformation3();
        result.setPmtInfId(paymentInfo.getPaymentInfoID());
        result.setPmtMtd(PaymentMethod3Code.TRF);
        result.setReqdExctnDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfo.getRequestedExecutionDate()));
        result.setCtrlSum(paymentInfo.getControlSum());
        result.setNbOfTxs(String.valueOf(paymentInfo.getNumberOfTransactions()));
        result.setBtchBookg(Boolean.valueOf(this.getBtchBookgValue()));
        result.setPmtTpInf(this.mapPaymentTypeInformation());
        PartyIdentification32 debtor = this.mapDebtor(paymentInfo.getPartyData());
        result.setDbtr(debtor);
        result.setDbtrAcct(this.getCashAccountIBAN(paymentInfo.getCompanyIban()));
        if (!StringMapper.isNullString((String)paymentInfo.getCompanyBic())) {
            result.setDbtrAgt(this.getFinancialInstitution(paymentInfo.getCompanyBic()));
        }
        for (PaymentData tx : paymentInfo.getPayments()) {
            result.getCdtTrfTxInf().add(this.getTxInfo(tx, paymentInfo));
        }
        return result;
    }

    private CreditTransferTransactionInformation10 getTxInfo(PaymentData payment, PaymentInfoData paymentInfo) {
        CreditTransferTransactionInformation10 result = new CreditTransferTransactionInformation10();
        result.setPmtId(this.getPaymentIdentification(payment));
        result.setAmt(new AmountMapper().toAmountType3Choice(payment.getAmount(), payment.getCurrencyCode()));
        result.setChrgBr(this.getChargeBearerType(payment, paymentInfo));
        BranchAndFinancialInstitutionIdentification4 creditorAgent = this.getCreditorAgent(payment);
        if (creditorAgent != null) {
            result.setCdtrAgt(creditorAgent);
        }
        result.setCdtrAcct(this.getCreditorAccount(payment));
        result.setCdtr(this.mapCreditor(payment.getPartyData()));
        if (!StringMapper.isNullString((String)payment.getDeviatingOwner())) {
            PartyIdentification32 ultimateCreditor = new PartyIdentification32();
            ultimateCreditor.setNm(payment.getDeviatingOwner());
            result.setUltmtCdtr(ultimateCreditor);
        }
        result.setRmtInf(this.getRemittanceInfo(payment));
        RegulatoryReporting3 regulatoryReporting = this.mapRegulatoryReporting(payment);
        if (regulatoryReporting != null) {
            result.getRgltryRptg().add(regulatoryReporting);
        }
        return result;
    }

    protected abstract BranchAndFinancialInstitutionIdentification4 getCreditorAgent(PaymentData var1);

    protected abstract RegulatoryReporting3 mapRegulatoryReporting(PaymentData var1);

    private PaymentTypeInformation19 mapPaymentTypeInformation() {
        PaymentTypeInformation19 result = new PaymentTypeInformation19();
        ServiceLevel8Choice level = new ServiceLevel8Choice();
        level.setCd(this.getServiceLevelCode());
        result.setSvcLvl(level);
        return result;
    }

    protected abstract String getServiceLevelCode();

    private CashAccount16 getCreditorAccount(PaymentData payment) {
        if (!StringMapper.isNullString((String)payment.getIban())) {
            return this.getCashAccountIBAN(payment.getIban());
        }
        return this.getCashAccountBBAN(payment.getBankAccountNumber());
    }

    protected BranchAndFinancialInstitutionIdentification4 getFinancialInstitution(String bic) {
        BranchAndFinancialInstitutionIdentification4 inst = new BranchAndFinancialInstitutionIdentification4();
        FinancialInstitutionIdentification7 instID = new FinancialInstitutionIdentification7();
        instID.setBIC(bic);
        inst.setFinInstnId(instID);
        return inst;
    }

    private CashAccount16 getCashAccountIBAN(String iban) {
        CashAccount16 account = new CashAccount16();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        id.setIBAN(iban);
        account.setId(id);
        return account;
    }

    private CashAccount16 getCashAccountBBAN(String bban) {
        CashAccount16 account = new CashAccount16();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        GenericAccountIdentification1 genericAccountIdentification = new GenericAccountIdentification1();
        AccountSchemeName1Choice accountSchemeName1Choice = new AccountSchemeName1Choice();
        accountSchemeName1Choice.setCd("BBAN");
        genericAccountIdentification.setId(bban);
        genericAccountIdentification.setSchmeNm(accountSchemeName1Choice);
        id.setOthr(genericAccountIdentification);
        account.setId(id);
        return account;
    }

    protected abstract SepaChargesType getChargesType(PaymentData var1, PaymentInfoData var2);

    private ChargeBearerType1Code getChargeBearerType(PaymentData payment, PaymentInfoData paymentInfo) {
        return this.mapToChargeBearerType(this.getChargesType(payment, paymentInfo));
    }

    private ChargeBearerType1Code mapToChargeBearerType(SepaChargesType chargesType) {
        switch (chargesType) {
            case SHAR: {
                return ChargeBearerType1Code.SHAR;
            }
            case DEBT: {
                return ChargeBearerType1Code.DEBT;
            }
            case CRED: {
                return ChargeBearerType1Code.CRED;
            }
            case SLEV: {
                return ChargeBearerType1Code.SLEV;
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)((Object)chargesType)));
    }

    protected abstract boolean getBtchBookgValue();

    protected abstract PartyIdentification32 mapInitiatingParty(PartyData var1);

    protected abstract PartyIdentification32 mapCreditor(PartyData var1);

    protected abstract PartyIdentification32 mapDebtor(PartyData var1);

    private RemittanceInformation5 getRemittanceInfo(PaymentData payment) {
        RemittanceInformation5 ri = new RemittanceInformation5();
        ri.getUstrd().add(payment.getUnstructuredRemittanceInfoID());
        return ri;
    }

    private PaymentIdentification1 getPaymentIdentification(PaymentData payment) {
        PaymentIdentification1 pi = new PaymentIdentification1();
        pi.setEndToEndId(payment.getPaymentEndToEndID());
        pi.setInstrId(payment.getPaymentInstrID());
        return pi;
    }
}

