/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.sepa.SepaPaymentHelper;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.IBankAccount;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class SepaVersionManager {
    private static final String VALID_FROM_ISO_V3 = "2012-04-03";
    private static final String VALID_FROM_ISO_V5 = "2013-05-01";
    private static final String VALID_FROM_ISO_V7 = "2016-01-01";
    private static final String VALID_FROM_ISO_V8 = "2017-01-01";
    private static final String VALID_FROM_DE_2_5 = "2010-11-01";
    private static final String VALID_FROM_DE_2_7 = "2013-11-04";
    private static final String VALID_FROM_DE_3_0 = "2016-11-20";
    private static final String VALID_FROM_DE_3_1 = "2017-11-19";
    private static final String VALID_FROM_DE_3_3 = "2020-07-01";
    private final Date executeDate;
    private final IBankAccount bankAccount;
    private final SepaType sepaType;

    public SepaVersionManager(FinancePaymentSession session, SepaType sepaType) {
        this(SepaPaymentHelper.getExecutionDate((FinancePaymentSession)session), session.getIBankAccount(), sepaType);
    }

    public SepaVersionManager(Date executeDate, IBankAccount bankAccount, SepaType sepaType) {
        this.executeDate = executeDate;
        this.bankAccount = bankAccount;
        this.sepaType = sepaType;
    }

    public SepaVersion getSepaVersion() {
        SepaVersion sepaVersionByBankAccount = this.getSepaVersionByBankAccount();
        return sepaVersionByBankAccount != null ? sepaVersionByBankAccount : this.getValidSepaVersion();
    }

    private SepaVersion getValidSepaVersion() {
        switch (this.sepaType) {
            case ISO: {
                return this.getValidSepaVersionISO();
            }
            case DE: {
                return this.getValidSepaVersionDE();
            }
            case CH: {
                return this.getValidSepaVersionCH();
            }
            case IT: {
                return this.getValidSepaVersionIT();
            }
            case AT: {
                return this.getValidSepaVersionAT();
            }
        }
        return null;
    }

    private SepaVersion getValidSepaVersionDE() {
        if (this.isValid(SepaVersion.DE_33)) {
            return this.getValidSepaVersion(SepaVersion.DE_33);
        }
        if (this.isValid(SepaVersion.DE_31)) {
            return this.getValidSepaVersion(SepaVersion.DE_31);
        }
        if (this.isValid(SepaVersion.DE_30)) {
            return this.getValidSepaVersion(SepaVersion.DE_30);
        }
        if (this.isValid(SepaVersion.DE_27)) {
            return this.getValidSepaVersion(SepaVersion.DE_27);
        }
        if (this.isValid(SepaVersion.DE_25)) {
            return this.getValidSepaVersion(SepaVersion.DE_25);
        }
        return this.getValidSepaVersion(SepaVersion.DE_23);
    }

    private SepaVersion getValidSepaVersionISO() {
        if (this.isValid(SepaVersion.ISO20022_V8)) {
            return this.getValidSepaVersion(SepaVersion.ISO20022_V8);
        }
        if (this.isValid(SepaVersion.ISO20022_V7)) {
            return this.getValidSepaVersion(SepaVersion.ISO20022_V7);
        }
        if (this.isValid(SepaVersion.ISO20022_V5)) {
            return this.getValidSepaVersion(SepaVersion.ISO20022_V5);
        }
        if (this.isValid(SepaVersion.ISO20022_V3)) {
            return this.getValidSepaVersion(SepaVersion.ISO20022_V3);
        }
        return this.getValidSepaVersion(SepaVersion.ISO20022_V2);
    }

    private SepaVersion getValidSepaVersion(SepaVersion sepaVersion) {
        if (sepaVersion.getPreviousSepaVersion() != null && ISoftware.getEnablePreviosSepaVersion()) {
            return sepaVersion.getPreviousSepaVersion();
        }
        return sepaVersion;
    }

    private SepaVersion getSepaVersionByBankAccount() {
        return this.bankAccount != null && this.bankAccount.getNote() != null ? this.getSepaVersionByBankAccount(this.bankAccount.getNote()) : null;
    }

    private SepaVersion getSepaVersionByBankAccount(String bankAccountNote) {
        switch (this.sepaType) {
            case ISO: {
                return this.getSepaVersionByBankAccountISO(bankAccountNote);
            }
            case DE: {
                return this.getSepaVersionByBankAccountDE(bankAccountNote);
            }
            case AT: {
                return this.getSepaVersionByBankAccountAT(bankAccountNote);
            }
            case IT: {
                return this.getSepaVersionByBankAccountIT(bankAccountNote);
            }
            case CH: {
                return null;
            }
        }
        return null;
    }

    private SepaVersion getSepaVersionByBankAccountISO(String bankAccountNote) {
        if (bankAccountNote.indexOf("#SEPA8") >= 0) {
            return SepaVersion.ISO20022_V8;
        }
        if (bankAccountNote.indexOf("#SEPA7") >= 0) {
            return SepaVersion.ISO20022_V7;
        }
        if (bankAccountNote.indexOf("#SEPA5") >= 0) {
            return SepaVersion.ISO20022_V5;
        }
        if (bankAccountNote.indexOf("#SEPA3") >= 0) {
            return SepaVersion.ISO20022_V3;
        }
        if (bankAccountNote.indexOf("#SEPA2") >= 0) {
            return SepaVersion.ISO20022_V2;
        }
        return null;
    }

    private SepaVersion getSepaVersionByBankAccountAT(String bankAccountNote) {
        return bankAccountNote.indexOf("#SEPA32") >= 0 ? SepaVersion.AT_3_2 : null;
    }

    private SepaVersion getSepaVersionByBankAccountIT(String bankAccountNote) {
        if (bankAccountNote.indexOf("#SEPA000308") >= 0) {
            return SepaVersion.IT_00_03_08;
        }
        if (bankAccountNote.indexOf("#SEPA000309") >= 0) {
            return SepaVersion.IT_00_03_09;
        }
        return null;
    }

    private SepaVersion getSepaVersionByBankAccountDE(String bankAccountNote) {
        if (bankAccountNote.indexOf("#SEPA31") >= 0) {
            return SepaVersion.DE_31;
        }
        if (bankAccountNote.indexOf("#SEPA30") >= 0) {
            return SepaVersion.DE_30;
        }
        if (bankAccountNote.indexOf("#SEPA27") >= 0) {
            return SepaVersion.DE_27;
        }
        if (bankAccountNote.indexOf("#SEPA25") >= 0) {
            return SepaVersion.DE_25;
        }
        if (bankAccountNote.indexOf("#SEPA23") >= 0) {
            return SepaVersion.DE_23;
        }
        return null;
    }

    private SepaVersion getValidSepaVersionIT() {
        if (this.isValid(SepaVersion.IT_00_04_00)) {
            return this.getValidSepaVersion(SepaVersion.IT_00_04_00);
        }
        if (this.isValid(SepaVersion.IT_00_03_09)) {
            return this.getValidSepaVersion(SepaVersion.IT_00_03_09);
        }
        return this.getValidSepaVersion(SepaVersion.IT_00_03_08);
    }

    private SepaVersion getValidSepaVersionCH() {
        return SepaVersion.CH_3;
    }

    private SepaVersion getValidSepaVersionAT() {
        if (this.isValid(SepaVersion.AT_6_0)) {
            return this.getValidSepaVersion(SepaVersion.AT_6_0);
        }
        return this.getValidSepaVersion(SepaVersion.AT_3_2);
    }

    private boolean isValid(SepaVersion sepaVersion) {
        return DateHelper.between((Date)this.executeDate, (Date)sepaVersion.getValidFrom(), (Date)sepaVersion.getValidUntil());
    }

    public static SepaVersion getSepaVersion(FinancePaymentSession session, SepaType sepaType) {
        return new SepaVersionManager(SepaPaymentHelper.getExecutionDate((FinancePaymentSession)session), session.getIBankAccount(), sepaType).getSepaVersion();
    }

    public static CountrySchemaVersion getCountrySchemaVersion(IBankAccount bankAccount) {
        String countryIsoCode = bankAccount.getCountry().getIsoCode();
        if ("LU".equals(countryIsoCode)) {
            return CountrySchemaVersion.SEPA_LU;
        }
        if ("ES".equals(countryIsoCode)) {
            return CountrySchemaVersion.SEPA_ES;
        }
        if ("PL".equals(countryIsoCode)) {
            return CountrySchemaVersion.SEPA_PL;
        }
        if ("FI".equals(countryIsoCode)) {
            return CountrySchemaVersion.SEPA_FI;
        }
        return CountrySchemaVersion.DEFAULT;
    }

    public static enum SepaVersion {
        ISO20022_V2(null, VDate.getDateMin(), DateHelper.yesterday((Date)DateMapper.toDate((String)"2012-04-03")), false),
        ISO20022_V3(ISO20022_V2, DateMapper.toDate((String)"2012-04-03"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2013-05-01")), false),
        ISO20022_V5(ISO20022_V3, DateMapper.toDate((String)"2013-05-01"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2016-01-01")), false),
        ISO20022_V7(ISO20022_V5, DateMapper.toDate((String)"2016-01-01"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2017-01-01")), false),
        ISO20022_V8(ISO20022_V7, DateMapper.toDate((String)"2017-01-01"), VDate.getDateMax(), false),
        DE_23(null, VDate.getDateMin(), DateHelper.yesterday((Date)DateMapper.toDate((String)"2010-11-01")), false),
        DE_25(DE_23, DateMapper.toDate((String)"2010-11-01"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2013-11-04")), false),
        DE_27(DE_25, DateMapper.toDate((String)"2013-11-04"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2016-11-20")), false),
        DE_30(DE_27, DateMapper.toDate((String)"2016-11-20"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2017-11-19")), true),
        DE_31(DE_30, DateMapper.toDate((String)"2017-11-19"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2020-07-01")), true),
        DE_33(DE_31, DateMapper.toDate((String)"2020-07-01"), VDate.getDateMax(), true),
        IT_00_03_08(null, VDate.getDateMin(), DateHelper.yesterday((Date)DateMapper.toDate((String)"2012-11-17")), false),
        IT_00_03_09(IT_00_03_08, DateMapper.toDate((String)"2012-11-17"), DateHelper.yesterday((Date)DateMapper.toDate((String)"2014-02-01")), false),
        IT_00_04_00(IT_00_03_09, DateMapper.toDate((String)"2014-02-01"), VDate.getDateMax(), false),
        AT_3_2(null, VDate.getDateMin(), DateHelper.yesterday((Date)DateMapper.toDate((String)"2013-11-04")), false),
        AT_6_0(AT_3_2, DateMapper.toDate((String)"2013-09-30"), VDate.getDateMax(), false),
        CH_3(null, VDate.getDateMin(), VDate.getDateMax(), false);

        private final SepaVersion previousSepaVersion;
        private final Date validFrom;
        private final Date validUntil;
        private final boolean replaceCOR1ByCORE;

        private SepaVersion(SepaVersion previousSepaVersion, Date validFrom, Date validUntil, boolean replaceCOR1ByCORE) {
            this.validFrom = validFrom;
            this.validUntil = validUntil;
            this.previousSepaVersion = previousSepaVersion;
            this.replaceCOR1ByCORE = replaceCOR1ByCORE;
        }

        public Date getValidFrom() {
            return this.validFrom;
        }

        public Date getValidUntil() {
            return this.validUntil;
        }

        public SepaVersion getPreviousSepaVersion() {
            return this.previousSepaVersion;
        }

        public boolean getReplaceCOR1ByCORE() {
            return this.replaceCOR1ByCORE;
        }
    }

    public static enum CountrySchemaVersion {
        DEFAULT,
        LV,
        SEPA_LU,
        DK,
        SEPA_ES,
        SEPA_PL,
        SEPA_FI,
        FOREIGN_PAYMENT_ISO20022;

    }

    public static enum SepaType {
        ISO,
        DE,
        IT,
        AT,
        CH;

    }
}

