/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import at.varial.accounting.domain.payment.sepa.SepaPaymentExporterAT;
import ch.varial.accounting.domain.payment.sepa.SepaPaymentExporterCH;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.FinancePaymentExporter;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.sepa.SepaDataMapper;
import com.varial.accounting.domain.payment.sepa.SepaPaymentExporterISO20022;
import com.varial.accounting.domain.payment.sepa.SepaPaymentHelper;
import com.varial.accounting.domain.payment.sepa.SepaVersionManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.framework.domain.payment.sepa.base.SepaService;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.interfaces.IBankAccount;
import com.varial.serverbase.mapper.ExceptionMapper;
import de.varial.accounting.domain.payment.sepa.SepaPaymentExporterDE;
import it.varial.accounting.domain.payment.sepa.SepaPaymentExporterIT;
import java.io.UnsupportedEncodingException;
import java.util.List;

public abstract class SepaPaymentExporter
extends FinancePaymentExporter {
    private final SepaVersionManager.SepaVersion sepaVersion;

    public SepaPaymentExporter(FinancePaymentSession paymentSession, SepaVersionManager.SepaType sepaType) throws BusinessDomainException {
        this(paymentSession, SepaVersionManager.getSepaVersion(paymentSession, sepaType));
    }

    public SepaPaymentExporter(FinancePaymentSession paymentSession, SepaVersionManager.SepaVersion sepaVersion) throws BusinessDomainException {
        super(paymentSession);
        this.checkSepaVersion(paymentSession, sepaVersion);
        this.sepaVersion = sepaVersion;
    }

    public List<SepaData> getSepaData() throws BusinessDomainException {
        return new SepaDataMapper(this.getPaymentSession(), this.sepaVersion).createSepaData();
    }

    public SepaVersionManager.SepaVersion getSepaVersion() {
        return this.sepaVersion;
    }

    public abstract SepaService getSepaService();

    private void checkSepaVersion(FinancePaymentSession paymentSession, SepaVersionManager.SepaVersion sepaVersion) throws BusinessDomainException {
        if (paymentSession.getIsDirectDebit() && SepaVersionManager.SepaVersion.DE_23.equals((Object)sepaVersion)) {
            throw FinancePaymentExceptionMapper.makeSepaVersionD23NotSupportedDomainException();
        }
        if (paymentSession.getIsDirectDebit() && SepaVersionManager.SepaVersion.ISO20022_V2.equals((Object)sepaVersion)) {
            throw FinancePaymentExceptionMapper.makeSepaVersionIsoV2NotSupportedDomainException();
        }
    }

    public FileExportStruct[] getFileExport() throws BusinessDomainException, UnsupportedEncodingException {
        SepaService service = this.getSepaService();
        FileExportStruct[] files = service != null ? service.getXMLFiles(this.getSepaData()) : null;
        this.checkFiles(files);
        return files;
    }

    private void checkFiles(FileExportStruct[] files) {
        if (!this.fileCreated(files)) {
            throw ExceptionMapper.makeApplicationException((String)"SEPA XML-File failed.");
        }
    }

    private boolean fileCreated(FileExportStruct[] files) {
        if (files == null || files.length == 0) {
            return false;
        }
        for (FileExportStruct file : files) {
            if (file != null && file.binaryData.length != 0) continue;
            return false;
        }
        return true;
    }

    public boolean completeFileName() {
        return true;
    }

    public static SepaPaymentExporter getSepaPaymentExporter(FinancePaymentSession paymentSession) throws BusinessDomainException {
        SepaVersionManager.SepaType sepaType = SepaPaymentHelper.getSepaType((IBankAccount)paymentSession.getIBankAccount());
        if (sepaType.equals((Object)SepaVersionManager.SepaType.AT)) {
            return new SepaPaymentExporterAT(paymentSession);
        }
        if (sepaType.equals((Object)SepaVersionManager.SepaType.DE)) {
            return new SepaPaymentExporterDE(paymentSession);
        }
        if (sepaType.equals((Object)SepaVersionManager.SepaType.IT)) {
            return new SepaPaymentExporterIT(paymentSession);
        }
        if (sepaType.equals((Object)SepaVersionManager.SepaType.CH)) {
            return new SepaPaymentExporterCH(paymentSession);
        }
        return new SepaPaymentExporterISO20022(paymentSession);
    }
}

