/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentDetailsHolder;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.dtaus.SplitEcTransfer;
import com.varial.accounting.domain.payment.sepa.SepaPaymentHelper;
import com.varial.accounting.domain.payment.sepa.SepaVersionManager;
import com.varial.accounting.domain.personalaccount.ChargeAtTheExpenseOfType;
import com.varial.accounting.domain.personalaccount.ExpenseArrangementTypeMapper;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.payment.sepa.base.SepaHelper;
import com.varial.framework.domain.payment.sepa.base.UnicodeCharacterEscapeHandler;
import com.varial.framework.domain.payment.sepa.base.UnicodeCharacterEscapeHandlerDE;
import com.varial.framework.domain.payment.sepa.data.LocationData;
import com.varial.framework.domain.payment.sepa.data.MandateData;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaHeaderData;
import com.varial.framework.domain.payment.sepa.data.SepaLocalInstrumentTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaSequenceTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaServiceLevelTypeEnum;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SepaDataMapper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)SepaDataMapper.class.getName());
    private static final int NAME_MAX_LENGHT = 140;
    private static final int POST_CODE_MAX_LENGHT = 16;
    private static final int TOWN_NAME_MAX_LENGHT = 35;
    private static final char SLASH = '/';
    private final FinancePaymentSession mPaymentSession;
    private final Date mCreationDate;
    private final String mCurrentTime;
    private final AccountingCompany mCompany;
    private final PostalAddress mCompanyAddress;
    private final BankAccount mBankAccount;
    private final IBankData mCompanyBankData;
    private final PaymentDetailsHolder mPaymentDetailsHolder;
    private final String mCountryIsoCode;
    private final boolean mSepaMultiCollector;
    private final SepaVersionManager.SepaVersion mSepaVersion;
    private final boolean directDebit;

    public SepaDataMapper(FinancePaymentSession paymentSession, SepaVersionManager.SepaVersion sepaVersion) throws BusinessDomainException {
        this.mPaymentSession = paymentSession;
        this.mCreationDate = paymentSession.getCreationDate();
        this.mCompany = paymentSession.getAccountingCompany();
        this.mCompanyAddress = this.mCompany.getAddress(this.mCreationDate).getPostalAddress();
        this.mPaymentDetailsHolder = PaymentHelper.getPaymentDetailsHolder((PaymentSession)paymentSession);
        this.mCountryIsoCode = paymentSession.getIBankAccount().getCountry().getIsoCode();
        this.mSepaMultiCollector = this.mCompany.getFinanceSetup().getSepaMultiCollector();
        this.mBankAccount = (BankAccount)paymentSession.getIBankAccount();
        this.mCompanyBankData = this.mBankAccount.getBankData();
        this.mSepaVersion = sepaVersion;
        this.mCurrentTime = this.getCurrentTime();
        this.directDebit = paymentSession.getIsDirectDebit();
    }

    private Payment[] getPayments() throws BusinessDomainException {
        boolean splittEUStandardAllowed = false;
        if (this.mPaymentSession.isGeneratePaymentSession()) {
            splittEUStandardAllowed = ((GeneratePaymentSession)this.mPaymentSession).getSplitEcTransfer();
        }
        return SplitEcTransfer.splitEcTransfers((Payment[])PaymentHelper.getPayments((PaymentSession)this.mPaymentSession, (boolean)this.mPaymentSession.getIsDirectDebit()), (boolean)splittEUStandardAllowed);
    }

    public List<SepaData> createSepaData() throws BusinessDomainException {
        Payment[] payments;
        ArrayList<Payment> listB2B = new ArrayList<Payment>();
        ArrayList<Payment> listCORE = new ArrayList<Payment>();
        ArrayList<Payment> listCOR1 = new ArrayList<Payment>();
        ArrayList<Payment> listSEPA = new ArrayList<Payment>();
        ArrayList<SepaData> result = new ArrayList<SepaData>();
        for (Payment payment : payments = this.getPayments()) {
            if (!payment.isFinancePayment()) continue;
            FinancePayment financePayment = (FinancePayment)payment;
            if (this.directDebit) {
                if (financePayment.getSepaDirectDebitType().value() == 1) {
                    if (SepaPaymentHelper.isCOR1((BankAccount)this.mBankAccount, (SepaVersionManager.SepaVersion)this.mSepaVersion)) {
                        listCOR1.add(payment);
                        continue;
                    }
                    listCORE.add(payment);
                    continue;
                }
                listB2B.add(payment);
                continue;
            }
            listSEPA.add(payment);
        }
        if (!listB2B.isEmpty()) {
            result.addAll(this.createSepaData(listB2B, SepaLocalInstrumentTypeEnum.B2B, SepaServiceLevelTypeEnum.NONE, !this.mSepaMultiCollector));
        }
        if (!listCORE.isEmpty()) {
            result.addAll(this.createSepaData(listCORE, SepaLocalInstrumentTypeEnum.CORE, SepaServiceLevelTypeEnum.NONE, !this.mSepaMultiCollector));
        }
        if (!listCOR1.isEmpty()) {
            result.addAll(this.createSepaData(listCOR1, SepaLocalInstrumentTypeEnum.COR1, SepaServiceLevelTypeEnum.NONE, !this.mSepaMultiCollector));
        }
        if (!listSEPA.isEmpty()) {
            result.addAll(this.createSepaData(listSEPA, SepaLocalInstrumentTypeEnum.NONE, SepaServiceLevelTypeEnum.SEPA, !this.mSepaMultiCollector));
        }
        return result;
    }

    private List<SepaData> createSepaData(List<Payment> payments, SepaLocalInstrumentTypeEnum localInstrumentType, SepaServiceLevelTypeEnum serviceLevel, boolean isSingleCollector) throws BusinessDomainException {
        ArrayList<SepaData> result = new ArrayList<SepaData>();
        BigDecimal controlSum = BigDecimal.ZERO;
        int countOfPayments = 0;
        List<PaymentInfoData> paymentInfoDataList = this.createPaymentInfoDataList(payments, localInstrumentType, serviceLevel, isSingleCollector);
        if (isSingleCollector) {
            for (PaymentInfoData paymentInfoData : paymentInfoDataList) {
                SepaData sepaData = new SepaData(this.mCountryIsoCode);
                String fileName = this.completeFileName(isSingleCollector, localInstrumentType, paymentInfoData.getSequenceType());
                sepaData.setHeader(this.createHeader(paymentInfoData.getControlSum(), paymentInfoData.getNumberOfTransactions(), fileName));
                sepaData.getPaymentInfos().add(paymentInfoData);
                result.add(sepaData);
            }
        } else {
            SepaData sepaData = new SepaData(this.mCountryIsoCode);
            for (PaymentInfoData paymentInfoData : paymentInfoDataList) {
                controlSum = controlSum.add(paymentInfoData.getControlSum());
                countOfPayments += paymentInfoData.getNumberOfTransactions();
            }
            String fileName = this.completeFileName(isSingleCollector, localInstrumentType, SepaSequenceTypeEnum.NONE);
            sepaData.setHeader(this.createHeader(controlSum, countOfPayments, fileName));
            sepaData.getPaymentInfos().addAll(paymentInfoDataList);
            result.add(sepaData);
        }
        return result;
    }

    private String completeFileName(boolean isSingleCollector, SepaLocalInstrumentTypeEnum localInstrumentType, SepaSequenceTypeEnum sepaSequenceType) {
        String fileName = "SEPA";
        if (this.mPaymentSession.getIsForeignPayment()) {
            fileName = this.mCountryIsoCode.equals("AT") || this.mCountryIsoCode.equals("CH") || this.mCountryIsoCode.equals("DE") ? "SEPA_AZV" : "SEPA_FOREIGN";
        }
        StringBuilder completeFileName = new StringBuilder();
        completeFileName.append(fileName);
        String fileType = this.getFileType(localInstrumentType, sepaSequenceType, isSingleCollector);
        if (!StringMapper.isNullString((String)fileType)) {
            completeFileName.append('_').append(fileType);
        }
        completeFileName.append('_').append(this.mCompany.getCode());
        return completeFileName.toString();
    }

    private String getFileType(SepaLocalInstrumentTypeEnum localInstrumentType, SepaSequenceTypeEnum sequenceType, boolean isSingleCollector) {
        String result = "";
        if (localInstrumentType.equals((Object)SepaLocalInstrumentTypeEnum.NONE)) {
            result = "";
        } else {
            result = localInstrumentType.value();
            if (isSingleCollector) {
                result = result.concat("_").concat(sequenceType.value());
            }
        }
        return result;
    }

    private List<PaymentInfoData> createPaymentInfoDataList(List<Payment> payments, SepaLocalInstrumentTypeEnum localInstrumentType, SepaServiceLevelTypeEnum serviceLevel, boolean isSingleCollector) throws BusinessDomainException {
        ArrayList<PaymentInfoData> result = new ArrayList<PaymentInfoData>();
        PaymentInfoData paymentInfoDataNONE = null;
        PaymentInfoData paymentInfoDataFRST = null;
        PaymentInfoData paymentInfoDataRCUR = null;
        PaymentInfoData paymentInfoDataOOFF = null;
        for (Payment payment : payments) {
            if (!payment.isFinancePayment()) continue;
            FinancePayment financePayment = (FinancePayment)payment;
            SepaSequenceTypeEnum sepaSequenceType = SepaPaymentHelper.getSepaSequenceType((FinancePayment)financePayment);
            switch (sepaSequenceType) {
                case NONE: {
                    paymentInfoDataNONE = this.addPayment(paymentInfoDataNONE, payment, sepaSequenceType, serviceLevel, localInstrumentType);
                    if (!this.completeCollector(isSingleCollector, paymentInfoDataNONE)) break;
                    result.add(paymentInfoDataNONE);
                    paymentInfoDataNONE = null;
                    break;
                }
                case OOFF: {
                    paymentInfoDataOOFF = this.addPayment(paymentInfoDataOOFF, payment, sepaSequenceType, serviceLevel, localInstrumentType);
                    if (!this.completeCollector(isSingleCollector, paymentInfoDataOOFF)) break;
                    result.add(paymentInfoDataOOFF);
                    paymentInfoDataOOFF = null;
                    break;
                }
                case FRST: {
                    paymentInfoDataFRST = this.addPayment(paymentInfoDataFRST, payment, sepaSequenceType, serviceLevel, localInstrumentType);
                    if (!this.completeCollector(isSingleCollector, paymentInfoDataFRST)) break;
                    result.add(paymentInfoDataFRST);
                    paymentInfoDataFRST = null;
                    break;
                }
                case RCUR: {
                    paymentInfoDataRCUR = this.addPayment(paymentInfoDataRCUR, payment, sepaSequenceType, serviceLevel, localInstrumentType);
                    if (!this.completeCollector(isSingleCollector, paymentInfoDataRCUR)) break;
                    result.add(paymentInfoDataRCUR);
                    paymentInfoDataRCUR = null;
                    break;
                }
            }
        }
        if (this.checkCollector(paymentInfoDataFRST)) {
            result.add(paymentInfoDataFRST);
        }
        if (this.checkCollector(paymentInfoDataRCUR)) {
            result.add(paymentInfoDataRCUR);
        }
        if (this.checkCollector(paymentInfoDataOOFF)) {
            result.add(paymentInfoDataOOFF);
        }
        if (this.checkCollector(paymentInfoDataNONE)) {
            result.add(paymentInfoDataNONE);
        }
        return result;
    }

    private boolean checkCollector(PaymentInfoData paymentInfoData) {
        return paymentInfoData != null && !paymentInfoData.getPayments().isEmpty();
    }

    private boolean completeCollector(boolean isSingleCollector, PaymentInfoData paymentInfoData) {
        int numberOfTransactions = paymentInfoData.getNumberOfTransactions();
        return isSingleCollector && numberOfTransactions % 2000 == 0 && !paymentInfoData.getPayments().isEmpty();
    }

    private PaymentInfoData addPayment(PaymentInfoData paymentInfoData, Payment payment, SepaSequenceTypeEnum seqType, SepaServiceLevelTypeEnum serviceLevel, SepaLocalInstrumentTypeEnum localInstrumentType) throws BusinessDomainException {
        PaymentInfoData result = paymentInfoData;
        if (result == null) {
            result = this.createPaymentInfoData(serviceLevel, localInstrumentType, seqType);
        }
        result.addControlSum(payment.getAmount());
        result.addNumberOfTransactions();
        result.getPayments().add(this.createPayments(payment, result.getNumberOfTransactions(), seqType));
        return result;
    }

    private PaymentInfoData createPaymentInfoData(SepaServiceLevelTypeEnum serviceLevel, SepaLocalInstrumentTypeEnum localInstrumentType, SepaSequenceTypeEnum seqType) throws BusinessDomainException {
        PaymentInfoData result = new PaymentInfoData();
        result.setServiceLevelType(serviceLevel);
        result.setSepaLocalInstrumentType(localInstrumentType);
        result.setSequenceType(seqType);
        result.setBankSortingCode(StringMapper.removeChars((String)this.mCompanyBankData.getBankSortingCode(), (char[])new char[]{' '}));
        result.setCompanyBic(StringMapper.removeChars((String)this.mCompanyBankData.getSwift(), (char[])new char[]{' '}));
        result.setPartyData(this.createPartyData());
        result.setCompanyIban(PaymentHelper.getIbanForElectronicFormat((String)this.mCompanyBankData.getOtherReference()));
        result.setBankAccountCountry(this.mCompanyBankData.getCountry());
        result.setPaymentInfoID(this.formatPaymentInfoID(this.mPaymentSession.getName() + "/" + seqType.toString()));
        Date requestedExecutionDate = SepaPaymentHelper.getRequestedExecutionDate((Date)SepaPaymentHelper.getExecutionDate((FinancePaymentSession)this.mPaymentSession), (SepaLocalInstrumentTypeEnum)localInstrumentType, (SepaSequenceTypeEnum)seqType, (SepaVersionManager.SepaVersion)this.mSepaVersion);
        result.setRequestedExecutionDate(requestedExecutionDate);
        return result;
    }

    private SepaHeaderData createHeader(BigDecimal controlSum, int countOfPayments, String fileName) throws BusinessDomainException {
        SepaHeaderData header = new SepaHeaderData();
        header.setControlSum(controlSum.setScale(2, RoundingMode.HALF_DOWN));
        header.setCreationDateTime(this.mCreationDate);
        header.setInitiatingParty(this.createInitiatingParty());
        header.setMessageID(this.getSubstring(this.mPaymentSession.getName(), 35));
        header.setNumberOfTransactions(countOfPayments);
        header.setFileName(fileName);
        return header;
    }

    private String getSubstring(String value, int maxLength) {
        if (StringUtil.isEmpty((String)value)) {
            return "";
        }
        String result = value;
        if (SepaHelper.characterConventionDE((String)this.mCountryIsoCode)) {
            result = FactoringHelper.checkField((String)value);
            result = new UnicodeCharacterEscapeHandlerDE().checkField(result.toCharArray());
        } else {
            result = this.deleteTabsAndBreaks(value);
            result = new UnicodeCharacterEscapeHandler().checkField(result.toCharArray());
        }
        if (maxLength > result.length()) {
            maxLength = result.length();
        }
        result = StringMapper.maxLength((String)result, (int)maxLength);
        return result;
    }

    private String deleteTabsAndBreaks(String value) {
        if (StringMapper.isNullString((String)value)) {
            return "";
        }
        value = value.replace('\b', ' ');
        value = value.replace('\t', ' ');
        value = value.replace('\n', ' ');
        value = value.replace('\f', ' ');
        value = value.replace('\r', ' ');
        value = value.replace('\\', ' ');
        return value;
    }

    private PartyData createInitiatingParty() throws BusinessDomainException {
        String cucNumber;
        PartyData result = new PartyData();
        result.setName(this.getSubstring(this.mCompanyAddress.getName(), 70));
        if (!this.mCountryIsoCode.equals("AT") || !this.mCountryIsoCode.equals("DE")) {
            result.getLocations().add(this.createLocation((IPostalAddress)this.mCompanyAddress));
        }
        if (StringMapper.isNullString((String)(cucNumber = this.mBankAccount.getReferenceReceiverBACS()))) {
            cucNumber = this.mCompany.getCUCNumber();
        }
        result.setCUCNumber(cucNumber);
        result.setCompanyTaxNumber(this.mCompany.getUKTaxNumber());
        result.setCompanyECTaxNumber(this.mCompany.getECTaxNumber(false));
        result.setCreditorID(this.mCompany.getUniqueCreditorIdent());
        result.setCompanyCode(this.mCompany.getCode());
        if (this.mBankAccount != null && this.mBankAccount.getNote() != null && this.mBankAccount.getNote().indexOf("#SENDERID=") >= 0) {
            String senderId = "";
            int pos1 = this.mBankAccount.getNote().indexOf("#SENDERID=");
            int pos2 = this.mBankAccount.getNote().indexOf(61, pos1);
            int pos3 = this.mBankAccount.getNote().indexOf(35, pos2);
            senderId = this.mBankAccount.getNote().substring(pos2 + 1, pos3);
            if (!StringMapper.isNullString((String)senderId)) {
                result.setSenderId(senderId);
            }
        }
        return result;
    }

    private PartyData createPartyData() throws BusinessDomainException {
        PartyData result = new PartyData();
        result.setName(this.getSubstring(this.mCompanyAddress.getName(), 70));
        result.setAccountHolderName(this.getAccountHolderName());
        result.getLocations().add(this.createLocation((IPostalAddress)this.mCompanyAddress));
        result.setCreditorID(this.mCompany.getUniqueCreditorIdent());
        String cucNumber = this.mBankAccount.getReferenceReceiverBACS();
        if (StringMapper.isNullString((String)cucNumber)) {
            cucNumber = this.mCompany.getCUCNumber();
        }
        result.setCUCNumber(cucNumber);
        result.setCompanyTaxNumber(this.mCompany.getUKTaxNumber());
        result.setCompanyECTaxNumber(this.mCompany.getECTaxNumber(false));
        result.setServiceID(this.mBankAccount.getSepaServiceID());
        return result;
    }

    private LocationData createLocation(IPostalAddress address) {
        LocationData location = new LocationData();
        if (address != null) {
            String bankCountryIsoCode = this.mCompanyBankData.getCountry().getIsoCode();
            String street = address.getPostOfficeBox();
            String postalCode = address.getPostcodePostOfficeBox();
            if (StringMapper.isNullString((String)street) || StringMapper.isNullString((String)postalCode)) {
                street = address.getStreet();
                postalCode = address.getPostalCode();
            }
            if (bankCountryIsoCode.equals("BE") || bankCountryIsoCode.equals("NL") || bankCountryIsoCode.equals("FR") || bankCountryIsoCode.equals("IT")) {
                location.setAddress(this.getSubstring(street, 35));
                location.setAddress1(this.getSubstring(postalCode + " " + address.getTown(), 35));
            } else {
                String addressLine = street + " " + postalCode + " " + address.getTown();
                location.setAddress(this.getSubstring(addressLine, 70));
            }
            location.setCountryCode(address.getCountry().getIsoCode());
            location.setCity(this.getSubstring(address.getTown(), 35));
            location.setPostalCode(this.getSubstring(address.getPostalCode(), 16));
        }
        return location;
    }

    private PaymentData createPayments(Payment payment, int paymentCount, SepaSequenceTypeEnum seqType) throws BusinessDomainException {
        PaymentData result = new PaymentData();
        result.setPartyData(this.getPartyData(payment));
        result.setAmount(payment.getAmount().setScale(2, RoundingMode.HALF_DOWN));
        result.setCurrencyCode(payment.getCurrency().getSwift());
        result.setBic(StringMapper.removeChars((String)payment.getSwift(), (char[])new char[]{' '}));
        result.setIban(PaymentHelper.getIbanForElectronicFormat((String)payment.getShortAddressOwner()));
        result.setBankAccountNumber(StringMapper.removeChars((String)payment.getBankAccountNumber(), (char[])new char[]{' '}));
        result.setBankSortingCode(payment.getBankSortingCode());
        result.setBankCountry(payment.getBankCountry() != null ? payment.getBankCountry().getIsoCode() : null);
        IPersonalAccountBankAddress bankAddress = this.getPersonalAccountBankAddress(payment);
        result.setAbaNumber(this.getAbaNumber(bankAddress));
        result.setBankName(this.getBankName(bankAddress));
        result.setBankAddress(this.getBankAddress(bankAddress));
        result.setPaymentInstrID(this.getSubstring(this.mPaymentSession.getName() + "/" + paymentCount, 35));
        String endToEndId = this.getEndToEndId(payment, paymentCount, seqType);
        result.setPaymentEndToEndID(endToEndId);
        result.setUnstructuredRemittanceInfoID(this.getSubstring(this.getUnstructuredRemittanceInfo(payment), 140));
        String deviatingOwner = PaymentHelper.getPaymentBankDeviatingOwner((Payment)payment);
        result.setDeviatingOwner(deviatingOwner);
        result.setMandateData(this.getMandateData(payment));
        result.setOidPayment(payment.getObjectid());
        result.setIsForeignPayment(this.mPaymentSession.getIsForeignPayment());
        return result;
    }

    private PartyData getPartyData(Payment payment) {
        IPostalAddress postalAddress;
        PartyData result = new PartyData();
        CustSupAddress custSupAddress = PaymentHelper.getCustSupAddress((Payment)payment);
        if (custSupAddress != null) {
            result.setTaxNumber(custSupAddress.getVatTaxNumber());
            result.setEcTaxNumber(custSupAddress.getEcTaxNumber());
            if (custSupAddress.getTaxDataIT() != null) {
                result.setCodiceFiscale(custSupAddress.getTaxDataIT().getCodiceFiscaleOrGuiridice());
            }
        }
        if ((postalAddress = payment.getPostalAddress()) != null) {
            result.setName(this.getSubstring(postalAddress.getName(), 70));
            result.setBeneficiaryCountry(postalAddress.getCountry().getIsoCode());
            result.getLocations().add(this.createLocation(postalAddress));
        }
        PersonalAccount pa = PaymentHelper.getPersonalAccount((Payment)payment);
        String paymentDetailsCode = "";
        if (pa != null) {
            if (!StringMapper.isNullString((String)pa.getPaymentDetailsCode())) {
                paymentDetailsCode = pa.getPaymentDetailsCode();
            }
            result.setPaymentChargesAtExpenseOf(ExpenseArrangementTypeMapper.mapToPaymentChargesAtExpenceOf((ChargeAtTheExpenseOfType)pa.getExpenseArrangementType()));
        }
        result.setPaymentDetailsCode(paymentDetailsCode);
        return result;
    }

    private MandateData getMandateData(Payment payment) {
        MandateData result = new MandateData();
        result.setMandateID("");
        result.setMandateDate(DateHelper.today());
        if (payment.isFinancePayment()) {
            FinancePayment fp = (FinancePayment)payment;
            if (!StringMapper.isNullString((String)fp.getSepaMandate())) {
                result.setMandateID(fp.getSepaMandate());
            }
            if (fp.getSepaMandateDate() != null) {
                result.setMandateDate(fp.getSepaMandateDate());
            }
        }
        return result;
    }

    private String getUnstructuredRemittanceInfo(Payment payment) throws BusinessDomainException {
        String result = PaymentHelper.getFixedOrFreePaymentDetailsAsString((Payment)payment, (int)140, (boolean)true, (PaymentDetailsHolder)this.mPaymentDetailsHolder);
        LOGGER.debug("SEPA-Verwendungszweck:  {}", (Object)result);
        return result;
    }

    private String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
        String currentTime = sdf.format(new Date());
        return currentTime;
    }

    private String getEndToEndId(Payment payment, int paymentCount, SepaSequenceTypeEnum seqType) {
        Object endToEndId = !StringMapper.isNullString((String)payment.getReferenceNumber()) ? payment.getReferenceNumber() : DateMapper.toYYYYMMDDString((Date)this.mCreationDate) + "/" + this.mCurrentTime + "/" + seqType.toString() + "/" + paymentCount;
        return this.getSubstring((String)endToEndId, 35);
    }

    private String getAccountHolderName() {
        return this.mBankAccount.getDeviatingOwner() == null ? "" : this.getSubstring(this.mBankAccount.getDeviatingOwner(), 70);
    }

    private LocationData getBankAddress(IPersonalAccountBankAddress bankAddress) {
        if (bankAddress == null || bankAddress.getBankData() == null || bankAddress.getBankData().getPostalAddress() == null) {
            return null;
        }
        LocationData location = new LocationData();
        IPostalAddress postalAddress = bankAddress.getBankData().getPostalAddress();
        location.setCity(this.getCity(postalAddress));
        location.setCountryCode(postalAddress.getCountry().getIsoCode());
        location.setPostalCode(this.getPostalCode(postalAddress));
        return location;
    }

    private String getCity(IPostalAddress postalAddress) {
        return this.getSubstring(postalAddress.getTown(), 35);
    }

    private String getBankName(IPersonalAccountBankAddress bankAddress) {
        return bankAddress != null && bankAddress.getBankData() != null ? this.getSubstring(bankAddress.getBankData().getBankName(), 140) : "";
    }

    private String getPostalCode(IPostalAddress postalAddress) {
        return this.getSubstring(postalAddress.getPostalCode(), 16);
    }

    private String getAbaNumber(IPersonalAccountBankAddress bankAddress) {
        return bankAddress != null && bankAddress.getBankData() != null ? bankAddress.getBankData().getAbaNumber() : "";
    }

    private IPersonalAccountBankAddress getPersonalAccountBankAddress(Payment payment) {
        return payment.isGeneratePayment() ? PaymentHelper.getPersonalAccountBankAddress((Payment)payment) : null;
    }

    private String formatPaymentInfoID(String paymentInfoID) {
        StringBuilder sb = new StringBuilder(this.getSubstring(paymentInfoID, 35));
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
            sb.deleteCharAt(sb.length() - 1);
        }
        while (sb.length() > 0 && sb.charAt(0) == '/') {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }
}

