/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import com.varial.accounting.domain.payment.sepa.ForeignPaymentHelperISO20022;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.paymentbase.PaymentChargesAtExpenseOf;

public enum SepaChargesType {
    DEBT,
    CRED,
    SHAR,
    SLEV;


    public static SepaChargesType getChargesTypeForNonSepaForeignPayment(PaymentData payment, String bankAccountCountry) {
        if (ForeignPaymentHelperISO20022.isEUAndEEACountry(payment.getBankCountry()) && ForeignPaymentHelperISO20022.isEUAndEEACountry(bankAccountCountry)) {
            return SHAR;
        }
        PaymentChargesAtExpenseOf chargesAtExpenseOf = payment.getPartyData().getPaymentChargesAtExpenseOf();
        if (chargesAtExpenseOf == null) {
            return SHAR;
        }
        switch (chargesAtExpenseOf) {
            case BOTH: {
                return SHAR;
            }
            case SENDER: {
                return DEBT;
            }
            case RECEIVER: {
                return CRED;
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)chargesAtExpenseOf));
    }

    public static SepaChargesType getChargesTypeForKronospanDK(PaymentData payment) {
        PaymentChargesAtExpenseOf chargesAtExpenseOf = payment.getPartyData().getPaymentChargesAtExpenseOf();
        if (chargesAtExpenseOf == null) {
            return SLEV;
        }
        switch (chargesAtExpenseOf) {
            case BOTH: {
                return SLEV;
            }
            case SENDER: {
                return DEBT;
            }
            case RECEIVER: {
                return CRED;
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)chargesAtExpenseOf));
    }
}

