/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import com.infor.igf.core.util.StringUtil;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Arrays;

public class ForeignPaymentHelperISO20022 {
    private static final String[] EU_AND_EEA_COUNTRIES = new String[]{"AT", "BE", "BG", "HR", "CY", "CZ", "DK", "EE", "FI", "FR", "DE", "GR", "HU", "IS", "IE", "IT", "LV", "LI", "LT", "LU", "MT", "NL", "NO", "PL", "PT", "RO", "SK", "SI", "ES", "SE"};

    private ForeignPaymentHelperISO20022() {
    }

    public static boolean isEUAndEEACountry(String countryIsoCode) {
        return StringUtil.isNotEmpty((String)countryIsoCode) && Arrays.stream(EU_AND_EEA_COUNTRIES).anyMatch(euAndEeaCountry -> StringMapper.equalWithTrim((String)euAndEeaCountry, (String)countryIsoCode));
    }

    public static boolean withBankSortingCode(PaymentData payment) {
        return "US".equals(payment.getBankCountry()) && "USD".equals(payment.getCurrencyCode()) || "HK".equals(payment.getBankCountry()) && "HKD".equals(payment.getCurrencyCode()) || "CN".equals(payment.getBankCountry()) && "CNY".equals(payment.getCurrencyCode());
    }
}

