/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.sepa;

import com.varial.accounting.domain.payment.FinancePaymentExporter;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.report.PaymentReportHelper;
import com.varial.accounting.domain.payment.sepa.SepaPaymentExporterISO20022;
import com.varial.accounting.domain.payment.sepa.SepaVersionManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.serverbase.mapper.StringMapper;
import java.io.UnsupportedEncodingException;

public class ForeignPaymentExporterISO20022
extends FinancePaymentExporter {
    public ForeignPaymentExporterISO20022(FinancePaymentSession paymentSession) {
        super(paymentSession);
    }

    public FileExportStruct[] getFileExport() throws BusinessDomainException, UnsupportedEncodingException {
        SepaPaymentExporterISO20022 sepaExporter = new SepaPaymentExporterISO20022(this.getPaymentSession(), SepaVersionManager.SepaVersion.ISO20022_V3, SepaVersionManager.CountrySchemaVersion.FOREIGN_PAYMENT_ISO20022);
        FileExportStruct[] result = sepaExporter.getFileExport();
        result[0].fileName = this.getFileName();
        return result;
    }

    public boolean completeFileName() {
        return false;
    }

    private String getFileName() {
        String fileName = PaymentReportHelper.getFileName(true, true, "ISO_" + StringMapper.toStringWithTrim((String)this.getPaymentSession().getAccountingCompany().getCode()), this.getPaymentSession());
        fileName = fileName.concat(".xml");
        return fileName;
    }
}

