/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.eurofactor;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringExporter;
import com.varial.accounting.domain.payment.reversefactoring.eurofactor.EurofactorReverseFactoringLineGeneratorImpl;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.domain.textoutput.OutputStringWriter;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.StringWriter;
import java.util.Date;

public class EurofactorReverseFactoringExporter
extends ReverseFactoringExporter {
    private static final int CONTRACT_NUMBER_LENGTH = 5;

    public EurofactorReverseFactoringExporter(GeneratePaymentSession paymentSession) {
        super(paymentSession);
    }

    public FileExportStruct[] getFileExport() throws BusinessDomainException {
        GeneratePayment[] generatePayments = ((GeneratePaymentSession)this.getPaymentSession()).getGeneratePayments();
        FileExportStruct[] files = new FileExportStruct[generatePayments.length];
        for (int i = 0; i < generatePayments.length; ++i) {
            files[i] = this.createFileExport(generatePayments[i]);
        }
        return files;
    }

    private FileExportStruct createFileExport(GeneratePayment generatePayment) throws BusinessDomainException {
        StringWriter appender = new StringWriter();
        OutputStringWriter lineWriter = new OutputStringWriter((Appendable)appender, LineSeparator.CRLF);
        lineWriter.write((LineGenerator)new EurofactorReverseFactoringLineGeneratorImpl(generatePayment));
        return new FileExportStruct(this.getFileName(generatePayment), ((Object)appender).toString().getBytes());
    }

    private String getFileName(GeneratePayment generatePayment) {
        return this.getContractNumber(generatePayment) + "-" + StringMapper.toString((String)generatePayment.getDepositNumber()) + "_" + DateMapper.toDDMMYYPointSeparationString((Date)generatePayment.getDepositDate()) + ".CSV";
    }

    private String getContractNumber(GeneratePayment generatePayment) {
        StringBuilder builder = new StringBuilder("DE");
        String numberAtFactoringCompany = generatePayment.getNumberAtFactoringCompany();
        if (!StringMapper.isNullString((String)numberAtFactoringCompany) && numberAtFactoringCompany.length() >= 5) {
            builder.append(numberAtFactoringCompany.substring(0, 5));
        }
        return builder.toString();
    }

    public boolean completeFileName() {
        return false;
    }
}

