/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.report;

import com.varial.accounting.domain.payment.AdvancePaymentSession;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExporter;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.sepa.SepaPaymentExporter;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountNote;
import com.varial.accounting.persistency.genpayremitoi.GenpayremitoiContainer;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunSessionMapper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.common.persistency.payment.PaymentContainer;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaLocalInstrumentTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaSequenceTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaServiceLevelTypeEnum;
import com.varial.framework.domain.paymentbase.PaymentExporter;
import com.varial.framework.domain.paymentbase.PaymentRunAction;
import com.varial.framework.domain.paymentexportformat.PaymentExportFormat;
import com.varial.framework.mapper.PaymentTypeMapper;
import com.varial.framework.paymentbase.PaymentTypeEnum;
import com.varial.interfaces.IBankAccount;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGeneratorViewDescription;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class PaymentReportHelper {
    public static final String NO_PAYMENT_FILE_MARK = "~~~~~";

    public static SelectGeneratorViewDescription[] getViewDescriptionGeneratePayment() {
        return new SelectGeneratorViewDescription[]{new SelectGeneratorViewDescription("genpayremitoi_V", "g", GenpayremitoiContainer.class), new SelectGeneratorViewDescription("personalaccount_T", "p", new String[]{"code"}, String.class, new String[]{""}), new SelectGeneratorViewDescription("OPENITEM_T", "oi", new String[]{"objectid", "oidpersonalacc"}, String[].class, new String[]{"objectid", "oidpersonalacc"}), new SelectGeneratorViewDescription("personalaccount_T", "p1", new String[]{"code", "shortaddress"}, String[].class, new String[]{"code", "shortaddress"}), new SelectGeneratorViewDescription("currency_T", "c", new String[]{"code"}, String.class, new String[]{""})};
    }

    public static Criterion getPaymentsInFilter(List<String> oidPaymentList) {
        return Restrictions.in((String)"g.p_objectid", oidPaymentList);
    }

    public static Criterion getJoinGeneratePayment(GeneratePaymentSession gps, List<String> oidPaymentList) {
        Criterion paymentFilter = Subqueries.exists((SubSelect)new SubSelect("select objectid from PAYMENT_T", Restrictions.and((Criterion)PaymentReportHelper.getPaymentsInFilter(oidPaymentList), (Criterion)Restrictions.eqProperty((String)"g.p_objectid", (String)"PAYMENT_T.objectid"))));
        Conjunction result = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"g.oidpersonalacc", (String)"p.objectid"), Restrictions.eq((String)"g.oidsession", (String)gps.getObjectid()), Restrictions.eqProperty((String)"g.OI_OBJECTID", (String)"oi.objectid"), Restrictions.eqProperty((String)"oi.oidpersonalacc", (String)"p1.OBJECTID"), Restrictions.eqProperty((String)"g.oidenteredcurrency", (String)"c.OBJECTID")});
        if (!oidPaymentList.isEmpty()) {
            result.add(paymentFilter);
        }
        return result;
    }

    public static Criterion getFilterGeneratePayment(GeneratePaymentSession session, List<String> oidPaymentList) {
        Criterion result = Restrictions.and((Criterion)PaymentReportHelper.getJoinGeneratePayment(session, oidPaymentList), (Criterion)PaymentReportHelper.getPaymentType(session));
        return result;
    }

    public static Order[] getSortSettlementAdviceGeneratePayment(GeneratePaymentSession session) {
        String sortByPayment = "";
        if (!session.getPaymentPerOpenItem()) {
            sortByPayment = "g.p_objectid";
        }
        LinkedList<String> orderList = new LinkedList<String>();
        orderList.add("g.oidsession");
        orderList.add("p.code");
        orderList.add("g.oidpersonalacc");
        orderList.add("c.code");
        orderList.add(sortByPayment);
        orderList.add("p1.code");
        orderList.add("g.oi_documentdate");
        orderList.add("g.oi_referencenumber");
        orderList.add("g.duedate");
        Order[] result = new Order[orderList.size()];
        for (int i = 0; i < orderList.size(); ++i) {
            result[i] = Order.asc((String)((String)orderList.get(i)));
        }
        return result;
    }

    public static BigDecimal setSignum(BigDecimal amount, boolean isDebit, boolean isPayment) {
        BigDecimal result = amount;
        if (result != null) {
            boolean isCreditNote = false;
            if (isPayment) {
                isCreditNote = isDebit;
            } else {
                boolean bl = isCreditNote = !isDebit;
            }
            if (isCreditNote) {
                result = result.negate();
            }
        }
        return result;
    }

    public static BigDecimal format(BigDecimal amount, ICurrency currency) {
        BigDecimal result = amount;
        if (result != null) {
            result = currency.round(result);
        }
        return result;
    }

    public static SelectGeneratorViewDescription[] getViewDescriptionAdvancePaymentPersAcc() {
        return new SelectGeneratorViewDescription[]{new SelectGeneratorViewDescription("payment_T", "p", PaymentContainer.class), new SelectGeneratorViewDescription("personalaccount_T", "pa", new String[]{"code", "shortaddress"}, String[].class, new String[]{"code", "shortaddress"}), new SelectGeneratorViewDescription("currency_T", "c", new String[]{"code"}, String.class, new String[]{""})};
    }

    public static Criterion getFilterAdvancePaymentPersAcc(AdvancePaymentSession session, List<String> oidPaymentList) {
        return Restrictions.and((Criterion)PaymentReportHelper.getJoinAdvancePayment(session, oidPaymentList), (Criterion)PaymentReportHelper.getPaymentType());
    }

    private static Criterion getJoinAdvancePayment(AdvancePaymentSession session, List<String> oidPaymentList) {
        Conjunction result = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"p.oidpersonalacc", (String)"pa.objectid"), Restrictions.eq((String)"p.oidsession", (String)session.getObjectid()), Restrictions.eqProperty((String)"p.oidcurrency", (String)"c.OBJECTID")});
        if (!oidPaymentList.isEmpty()) {
            result.add(Restrictions.in((String)"p.objectid", oidPaymentList));
        }
        return result;
    }

    public static Order[] getSortSettlementAdviceAdvancePayment() {
        LinkedList<String> orderList = new LinkedList<String>();
        orderList.add("p.oidsession");
        orderList.add("pa.code");
        orderList.add("p.oidpersonalacc");
        orderList.add("c.code");
        orderList.add("p.documentdate");
        orderList.add("p.referencenumber");
        orderList.add("p.duedate");
        Order[] result = new Order[orderList.size()];
        for (int i = 0; i < orderList.size(); ++i) {
            result[i] = Order.asc((String)((String)orderList.get(i)));
        }
        return result;
    }

    public static Criterion getFilterAdvanceSettlementAdvise() {
        return Restrictions.or((Criterion)Restrictions.ne((String)"pa.remittancetype", (String)"0"), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"pa.remittancetype", (String)"0"), (Criterion)Restrictions.eq((String)"pa.oneoffaccount", (String)BooleanMapper.toString((boolean)true))));
    }

    private static Criterion getPaymentType(GeneratePaymentSession session) {
        Criterion result = session.getIsDirectDebit() ? Restrictions.in((String)"typeofpayment", (String[])new String[]{PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_DIRECTDEBIT), PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BANKCOLLECTION)}) : (session.getIsReverseFactoring() ? Restrictions.eq((String)"typeofpayment", (String)PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_FACTORING)) : Restrictions.in((String)"typeofpayment", (String[])new String[]{PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BACS), PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BACS_BILLOFEXCHANGE), PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BILLOFEXCHANGE), PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BILLOFEXCHANGE_ACCEPTED)}));
        return result;
    }

    private static Criterion getPaymentType() {
        return Restrictions.eq((String)"typeofpayment", (String)PaymentTypeMapper.toString((PaymentTypeEnum)PaymentTypeEnum.PTE_BACS));
    }

    public static Criterion getEntryLimitFilter(GeneratePaymentSession session, String oidPA, String oidPayment) {
        Conjunction result = Restrictions.conjunction();
        result.add(Restrictions.eq((String)"oidsession", (String)session.getObjectid()));
        result.add(PaymentReportHelper.getPaymentType(session));
        result.add(Restrictions.eq((String)"oidpersonalacc", (String)oidPA));
        result.add(Restrictions.eq((String)"p_objectid", (String)oidPayment));
        return result;
    }

    public static SelectGeneratorViewDescription[] getViewDescriptionAdvancePaymentNlAcc() {
        return new SelectGeneratorViewDescription[]{new SelectGeneratorViewDescription("payment_T", "p", PaymentContainer.class), new SelectGeneratorViewDescription("NLITEMCOSETTING_V", "s", new String[]{"code", "shortname"}, String[].class, new String[]{"code", "shortname"}), new SelectGeneratorViewDescription("currency_T", "c", new String[]{"code"}, String.class, new String[]{""})};
    }

    public static Criterion getFilterAdvancePaymentNlAcc(AdvancePaymentSession session, List<String> oidPaymentList) {
        Conjunction result = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eqProperty((String)"p.oidnominalaccount", (String)"s.s_objectid"), Restrictions.eq((String)"p.oidsession", (String)session.getObjectid()), Restrictions.eqProperty((String)"p.oidcurrency", (String)"c.OBJECTID"), PaymentReportHelper.getPaymentType()});
        if (!oidPaymentList.isEmpty()) {
            result.add(Restrictions.in((String)"p.objectid", oidPaymentList));
        }
        return result;
    }

    public static List<SepaData> getSepaDataList(FinancePaymentSession session) throws BusinessDomainException {
        SepaPaymentExporter sepaExporter = SepaPaymentExporter.getSepaPaymentExporter(session);
        return sepaExporter.getSepaData();
    }

    public static PaymentInfoData makePaymentInfoDataForAsciiFile(FinancePaymentSession session) {
        PaymentExportFormat format;
        PaymentInfoData result = new PaymentInfoData();
        String paymentInfoId = "";
        IBankAccount bankAccount = session.getIBankAccount();
        if (bankAccount != null && (format = bankAccount.getExportFormat()) != null) {
            paymentInfoId = format.getCode();
        }
        result.setPaymentInfoID(paymentInfoId);
        result.setRequestedExecutionDate(session.getExecuteDate());
        return result;
    }

    public static PaymentInfoData makePaymentInfoData(FinancePaymentSession session) {
        PaymentInfoData result = new PaymentInfoData();
        result.setPaymentInfoID(NO_PAYMENT_FILE_MARK);
        result.setRequestedExecutionDate(session.getExecuteDate());
        result.setSepaLocalInstrumentType(SepaLocalInstrumentTypeEnum.NONE);
        result.setSequenceType(SepaSequenceTypeEnum.NONE);
        result.setServiceLevelType(SepaServiceLevelTypeEnum.NONE);
        return result;
    }

    public static String getFileName(boolean complete, boolean withTime, String fileName, FinancePaymentSession session) {
        ICurrency currency;
        StringBuilder sb = new StringBuilder(fileName);
        if (complete) {
            String bankAccountCode = session.getIBankAccount().getCode();
            sb.append("_").append(StringMapper.toString((String)bankAccountCode)).append("_").append(DateMapper.toDDMMYYYYString((Date)session.getCreationDate()));
        }
        if ((currency = session.getCurrency()) != null) {
            sb.append("_").append(currency.getCode());
        }
        if (session.getExecuteDate() != null && PaymentRunSessionMapper.getCreatePaymentFilePerExecuteDate((FinancePaymentSession)session)) {
            sb.append("_").append(DateMapper.toDDMMYYYYString((Date)session.getExecuteDate()));
        }
        if (complete && withTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("HHmmss");
            String currentTime = sdf.format(new Date());
            sb.append("_").append(currentTime);
        }
        String result = sb.toString();
        result = StringMapper.removeChars((String)result, (char[])new char[]{' '});
        return result;
    }

    public static String getFileNameAscii(FinancePaymentSession session, PaymentRunAction paymentRunAction) throws BusinessDomainException, UnsupportedEncodingException {
        PaymentExporter exporter = FinancePaymentExporter.getPaymentExporter(session, paymentRunAction);
        exporter.createExport();
        FileExportStruct[] files = exporter.getFileExport();
        String fileName = "paymentFile";
        if (files != null && files.length > 0) {
            fileName = files[0].fileName;
        }
        return PaymentReportHelper.getFileName(exporter.completeFileName(), false, fileName, session);
    }

    public static List<String> getPaymentListSepa(PaymentInfoData paymentInfoData) {
        ArrayList<String> result = new ArrayList<String>();
        for (PaymentData paymentData : paymentInfoData.getPayments()) {
            if (result.contains(paymentData.getOidPayment())) continue;
            result.add(paymentData.getOidPayment());
        }
        return result;
    }

    public static List<String> getPaymentList(FinancePaymentSession session, boolean isExportPayment) {
        ArrayList<String> result = new ArrayList<String>();
        for (FinancePayment payment : session.getFinancePayments()) {
            if (isExportPayment != payment.isExportPayment()) continue;
            result.add(payment.getObjectid());
        }
        return result;
    }

    public static String getPersonalAccontNotes(PersonalAccount personalAccount) {
        String result = "";
        StringBuilder persAccNotesBuffer = new StringBuilder();
        PersonalAccountNote[] persAccNotes = personalAccount.getNotes();
        for (int i = 0; i < persAccNotes.length; ++i) {
            persAccNotesBuffer.append(DateMapper.toString((ILanguage)personalAccount.getAccountingCompany().getDefaultLanguage(), (Date)persAccNotes[i].getDate()));
            persAccNotesBuffer.append(' ');
            persAccNotesBuffer.append(persAccNotes[i].getNote());
            persAccNotesBuffer.append('\n');
        }
        if (persAccNotesBuffer.length() > 0) {
            result = persAccNotesBuffer.toString();
        }
        return result;
    }
}

