/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringExporter;
import com.varial.accounting.domain.payment.sepa.ForeignPaymentExporterISO20022;
import com.varial.accounting.domain.payment.sepa.SepaPaymentExporter;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.paymentbase.PaymentExporter;
import com.varial.framework.domain.paymentbase.PaymentRunAction;
import com.varial.framework.domain.paymentbase.PaymentSession;

public abstract class FinancePaymentExporter
extends PaymentExporter {
    public FinancePaymentExporter(FinancePaymentSession paymentSession) {
        this.setPaymentSessions((PaymentSession[])new FinancePaymentSession[]{paymentSession});
    }

    public void createExport() throws BusinessDomainException {
    }

    public FinancePaymentSession getPaymentSession() {
        return (FinancePaymentSession)this.mPaymentSessions[0];
    }

    public boolean isDirectDebit() {
        return this.getPaymentSession().getIsDirectDebit();
    }

    public static PaymentExporter getPaymentExporter(FinancePaymentSession exportPaymentSession, PaymentRunAction paymentRunAction) throws BusinessDomainException {
        if (exportPaymentSession.getGenerateSepa()) {
            return SepaPaymentExporter.getSepaPaymentExporter(exportPaymentSession);
        }
        if (exportPaymentSession.getIsReverseFactoring()) {
            return ReverseFactoringExporter.getReverseFactoringExporter((GeneratePaymentSession)exportPaymentSession);
        }
        if (PaymentHelper.isForeignPayment((PaymentSession)exportPaymentSession) && ((BankAccount)exportPaymentSession.getIBankAccount()).isForeignPaymentAsIso()) {
            return new ForeignPaymentExporterISO20022(exportPaymentSession);
        }
        return PaymentExporter.getPaymentExporter((PaymentSession[])new FinancePaymentSession[]{exportPaymentSession}, (PaymentRunAction)paymentRunAction);
    }
}

