/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nominaltransactionbase;

import ce.varial.accounting.domain.taxreportcountry.TaxReportCountry;
import ce.varial.accounting.domain.taxreportcountry.TaxReportCountryHelper;
import ce.varial.accounting.domain.vatreturn.VATReturnCEHelper;
import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.ageddatatransaction.AgedDataEntry;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.cashtransaction.CashTransaction;
import com.varial.accounting.domain.chambercontribution.ChamberContribution;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.custsupaddress.CustSupAddressPersistencyManagerBase;
import com.varial.accounting.domain.documenttype.DocumentCategoryType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.PersonalAccountAdjustmentTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransaction;
import com.varial.accounting.domain.nlaccountopenitem.NLAccountOpenItem;
import com.varial.accounting.domain.nlaccountopenitem.NLAccountOpenItemPersistencyManager;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySettingPersistencyManager;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.TaxAccountTypeEnum;
import com.varial.accounting.domain.nominalledger.TaxAccountTypeMapper;
import com.varial.accounting.domain.nominalledgertransaction.NominalLedgerTransaction;
import com.varial.accounting.domain.nominalledgertransaction.NominalLedgerTransactionPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.BankAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.BaseDifferenceEntry;
import com.varial.accounting.domain.nominaltransactionbase.ChequeDepositData;
import com.varial.accounting.domain.nominaltransactionbase.EUVATNumber;
import com.varial.accounting.domain.nominaltransactionbase.EntryTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.EntryTypeMapper;
import com.varial.accounting.domain.nominaltransactionbase.IEUVATNumber;
import com.varial.accounting.domain.nominaltransactionbase.JournalTransactionGroupEnum;
import com.varial.accounting.domain.nominaltransactionbase.JournalTransactionGroupMapper;
import com.varial.accounting.domain.nominaltransactionbase.NLAccountFixTaxPosting;
import com.varial.accounting.domain.nominaltransactionbase.NLAccountSplitHeadData;
import com.varial.accounting.domain.nominaltransactionbase.NLEntryTaxPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NlentryTaxRegister;
import com.varial.accounting.domain.nominaltransactionbase.NlentryTaxRegisterPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalEntryBaseData;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryData;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.PersEntryAddressPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.PrepaidTax;
import com.varial.accounting.domain.nominaltransactionbase.TransactionManager;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUseTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUseTypeMapper;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.personalaccount.PersonalAccountPlafond;
import com.varial.accounting.domain.purchaseregister.PurchaseRegisterInvoice;
import com.varial.accounting.domain.ritenutareport.RitenutaReport;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxCodePersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.domain.vatreturn.VATReturn;
import com.varial.accounting.persistency.nlentry.INlentryDao;
import com.varial.accounting.persistency.nlentry.NlentryContainer;
import com.varial.base.CacheUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.cache.Cache;
import com.varial.base.cache.CacheProvider;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.base.session.SessionContext;
import com.varial.costing.base.domain.actcostingdata.ActCosting;
import com.varial.costing.base.domain.actcostingdata.ActCostingPersistencyManager;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.country.Country;
import com.varial.framework.domain.country.CountryPersistencyManager;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.jpkvat.IJPKVAT;
import com.varial.framework.domain.jpkvat.JPKVATPersistentUtils;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import com.varial.serverbase.persistency.SelectGenerator;
import com.varial.serverbase.persistency.SelectGeneratorDataSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Element;
import pl.varial.accounting.domain.taxconfirmation.TaxConfirmationEntry;

public class NominalLedgerEntryPersistencyManager {
    private static final INlentryDao dao = (INlentryDao)UtilitiesManager.getBean((String)"nlentryDao", INlentryDao.class);
    private static final CacheProvider cacheManager = (CacheProvider)UtilitiesManager.getBean((String)"localCacheManager", CacheProvider.class);

    public static NominalLedgerEntry[] getEntries(NominalTransactionBase transaction) {
        return NominalLedgerEntryPersistencyManager.query(null, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()), transaction);
    }

    public static NominalLedgerEntry[] getPersonalAccountEntries(PersonalAccount personalAccount, Date documentdateFrom, Date documentdateUntil) {
        Conjunction crit = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpersonalacc", (String)personalAccount.getObjectid()), Restrictions.eq((String)"isunfinished", (String)"F"), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"entrytype", (String)EntryTypeMapper.toString((EntryTypeEnum)EntryTypeEnum.ETE_PERSONALACCOUNTENTRY)), Restrictions.eq((String)"entrytype", (String)EntryTypeMapper.toString((EntryTypeEnum)EntryTypeEnum.ETE_AGEDDATAENTRY))})});
        if (documentdateFrom != null) {
            crit.add(Restrictions.ge((String)"documentdate", (String)DateMapper.toString((Date)documentdateFrom)));
        }
        if (documentdateUntil != null) {
            crit.add(Restrictions.le((String)"documentdate", (String)DateMapper.toString((Date)documentdateUntil)));
        }
        return NominalLedgerEntryPersistencyManager.query(new Order[]{Order.asc((String)"documentdate"), Order.asc((String)"referencenumber")}, (Criterion)crit, null);
    }

    public static NlentryContainer[] getEntryContainers(Order[] sort, Criterion filter) {
        return dao.getRows(sort, filter);
    }

    public static PersistencyDataSet getDataSetNLEntries(Order[] sort, Criterion filter) {
        return dao.getDataSet(sort, filter);
    }

    public static long getRowCountNLEntries(Criterion filter) {
        return dao.getRowCount(filter);
    }

    public static NominalLedgerEntry[] getTaxEntries(RitenutaReport report) {
        return NominalLedgerEntryPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidritenutareport", (String)report.getObjectid()), Restrictions.eq((String)"taxaccounttype", (String)Integer.toString(4))}), null);
    }

    public static NominalLedgerEntry[] getTaxEntriesWithActTaxation(VATReturn taxReport) {
        return NominalLedgerEntryPersistencyManager.query(null, Subqueries.in((String)"objectid", (SubSelect)new SubSelect("select distinct oidtaxentry from acttaxation_T", Restrictions.eq((String)"oidvatreturn", (String)taxReport.getObjectid()))), null);
    }

    public static NominalLedgerEntry[] getTaxEntriesWithActTaxation(RitenutaReport ritenutaReport) {
        return NominalLedgerEntryPersistencyManager.query(null, Subqueries.in((String)"objectid", (SubSelect)new SubSelect("select distinct oidtaxentry from acttaxation_T", Restrictions.eq((String)"oidritenutareport", (String)ritenutaReport.getObjectid()))), null);
    }

    public static NominalLedgerEntry[] getTaxEntriesWithActTaxation(TaxReportCountry taxReportCountry) {
        return NominalLedgerEntryPersistencyManager.query(null, Subqueries.in((String)"objectid", (SubSelect)new SubSelect("select distinct oidtaxentry from acttaxation_T", Restrictions.eq((String)"oiddivcounttaxrep", (String)taxReportCountry.getObjectid()))), null);
    }

    public static PersistencyDataSet getPaymentTransactionsForPersonalAccounts(Date transactionDate, PersonalAccount pa) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"transactiondate", (String)DateMapper.toString((Date)transactionDate)), Restrictions.eq((String)"oidpersonalacc", (String)pa.getObjectid()), Restrictions.eq((String)"transactiontype", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)TransactionType.CASH_TRANSACTION)), Restrictions.eq((String)"isunfinished", (String)BooleanMapper.toString((boolean)false)), Restrictions.eq((String)"iscanceled", (String)BooleanMapper.toString((boolean)false)), Restrictions.ge((String)"basetotalamount", (String)"0")});
        Order[] orderBy = new Order[]{Order.desc((String)"documentdate")};
        return dao.getDataSet(orderBy, (Criterion)filter);
    }

    public static boolean existPostings(TaxRate taxRate, NominalLedgerAccount taxAccount, TaxAccountTypeEnum taType) {
        try {
            return dao.exists((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidtaxrate", (String)taxRate.getObjectid()), Restrictions.eq((String)"taxaccounttype", (String)Integer.toString(taType.value())), Restrictions.eq((String)"entrytype", (String)EntryTypeMapper.toString((EntryTypeEnum)EntryTypeEnum.ETE_TAXENTRY)), Subqueries.in((String)"oidaccount", (SubSelect)new SubSelect("select objectid from nlitemcompanyset_T", Restrictions.eq((String)"oidnomledgeritem", (String)taxAccount.getObjectid())))}));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostings(boolean isPersonalAccount, String oidAccount, Date keyDate, FinancialYear currentFinYear, boolean checkCurrentYearOnly) {
        String[] oidsPrevFinYears = new String[]{};
        if (!checkCurrentYearOnly && currentFinYear != null) {
            Set yearsList = FinancialYear.getOIDListOfPreviousFinYears((FinancialYear)currentFinYear);
            yearsList.remove(currentFinYear.getObjectid());
            oidsPrevFinYears = new String[yearsList.size()];
            yearsList.toArray(oidsPrevFinYears);
        }
        Conjunction crit = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccount", (String)oidAccount)});
        if (isPersonalAccount) {
            crit = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpersonalacc", (String)oidAccount)});
        }
        if (oidsPrevFinYears.length > 0) {
            crit.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.and((Criterion)Restrictions.eq((String)"oidfinancialyear", (String)currentFinYear.getObjectid()), (Criterion)Restrictions.lt((String)"transactiondate", (String)DateMapper.toString((Date)keyDate))), Restrictions.in((String)"oidfinancialyear", (String[])oidsPrevFinYears)}));
        } else {
            crit.add(Restrictions.lt((String)"transactiondate", (String)DateMapper.toString((Date)keyDate)));
            if (currentFinYear != null) {
                crit.add(Restrictions.eq((String)"oidfinancialyear", (String)currentFinYear.getObjectid()));
            }
        }
        try {
            return dao.exists((Criterion)crit);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existTaxRepostings(TaxRate taxRate, NominalLedgerAccount taxAccount) {
        try {
            return dao.exists(Subqueries.in((String)"oidtransaction", (SubSelect)new SubSelect("select oidtaxreposting from acttaxation_T", Subqueries.in((String)"oidtaxentry", (SubSelect)new SubSelect("select objectid from nlentry_T", Restrictions.and((Criterion)Restrictions.eq((String)"oidtaxrate", (String)taxRate.getObjectid()), (Criterion)Subqueries.in((String)"oidaccount", (SubSelect)new SubSelect("select objectid from nlitemcompanyset_T", Restrictions.eq((String)"oidnomledgeritem", (String)taxAccount.getObjectid())))))))));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerEntry[] getCorrespEntriesForTaxEntry(NominalTransactionBase transaction, Criterion filter) {
        return NominalLedgerEntryPersistencyManager.query(null, filter, transaction);
    }

    public static NominalLedgerEntry[] getNLAccountEntries(boolean orderByDocumentDate, NLAccountCompanySetting setting, FinancialYear financialYear, Date fromDate, Date toDate, boolean isBalanceChangesForYearOnly, boolean onlyPrintedInAccStatement, boolean onlyNotPrintedInAccStatement) {
        Order[] orderBy = orderByDocumentDate ? new Order[]{Order.asc((String)"documentdate"), Order.asc((String)"referencenumber")} : new Order[]{Order.asc((String)"transactiondate"), Order.asc((String)"documentdate"), Order.asc((String)"referencenumber")};
        Conjunction filters = Restrictions.conjunction();
        filters.add(Restrictions.and((Criterion)Restrictions.eq((String)"oidaccount", (String)setting.getObjectid()), (Criterion)Restrictions.eq((String)"isunfinished", (String)"F")));
        if (isBalanceChangesForYearOnly) {
            filters.add(Restrictions.eq((String)"oidfinancialyear", (String)financialYear.getObjectid()));
        } else {
            Set set = FinancialYear.getOIDListOfPreviousFinYears((FinancialYear)financialYear);
            String[] oidFinYears = new String[set.size()];
            set.toArray(oidFinYears);
            filters.add(Restrictions.in((String)"oidfinancialyear", (String[])oidFinYears));
        }
        if (fromDate != null) {
            filters.add(Restrictions.ge((String)"transactiondate", (String)DateMapper.toString((Date)fromDate)));
        }
        if (toDate != null) {
            filters.add(Restrictions.le((String)"transactiondate", (String)DateMapper.toString((Date)toDate)));
        }
        if (onlyPrintedInAccStatement) {
            filters.add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.gt((String)"ACCSTMTPRINTNO", (String)"0"), Restrictions.isNotNull((String)"ACCSTMTPRINTNO")}));
        }
        if (onlyNotPrintedInAccStatement) {
            filters.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"ACCSTMTPRINTNO", (String)"0"), Restrictions.isNull((String)"ACCSTMTPRINTNO")}));
        }
        return NominalLedgerEntryPersistencyManager.query(orderBy, (Criterion)filters, null);
    }

    public static PersonalAccountEntry[] getPersonalAccountEntries(Criterion filter) {
        NominalLedgerEntry[] entries = NominalLedgerEntryPersistencyManager.query(null, filter, null);
        PersonalAccountEntry[] result = new PersonalAccountEntry[entries.length];
        System.arraycopy(entries, 0, result, 0, entries.length);
        return result;
    }

    public static boolean existPostings(NLAccountCompanySetting setting) {
        try {
            return dao.exists(Restrictions.eq((String)"oidaccount", (String)setting.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostingsWithoutConsolidation(NLAccountCompanySetting setting) {
        try {
            return dao.exists((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccount", (String)setting.getObjectid()), Restrictions.eq((String)"isconsolitrans", (String)BooleanMapper.toString((boolean)false))}));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostingsInAnotherCurrency(NLAccountCompanySetting setting, ICurrency currency) {
        try {
            return dao.exists((Criterion)Restrictions.conjunction().add(Restrictions.eq((String)"oidaccount", (String)setting.getObjectid())).add(Restrictions.ne((String)"oidenteredcurrency", (String)currency.getObjectid())));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostings(TaxCode taxCode) {
        try {
            return dao.exists(Restrictions.eq((String)"oidtaxcode", (String)taxCode.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostings(TaxRate taxRate) {
        try {
            return dao.exists(Restrictions.eq((String)"oidtaxrate", (String)taxRate.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerEntry getTypedNominalLedgerEntry(String objectid, NominalTransactionBase transaction) {
        NominalLedgerEntry[] result = NominalLedgerEntryPersistencyManager.query(null, Restrictions.eq((String)"objectid", (String)objectid), transaction);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    private static NominalLedgerEntry[] query(Order[] order, Criterion filters, NominalTransactionBase transaction) {
        try {
            NlentryContainer[] containers = dao.getRows(order, filters);
            int count = containers.length;
            NominalLedgerEntry[] result = new NominalLedgerEntry[count];
            for (int i = 0; i < count; ++i) {
                result[i] = NominalLedgerEntryPersistencyManager.buildObjectFromContainer(containers[i], transaction, true);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(NominalLedgerEntry bo) {
        NlentryContainer container;
        try {
            container = dao.getRowByObjectID(bo.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container != null) {
            if (bo instanceof BankAccountEntry) {
                NominalLedgerEntryPersistencyManager.fillBankAccountEntry((BankAccountEntry)bo, container);
            } else if (bo instanceof TaxConfirmationEntry) {
                NominalLedgerEntryPersistencyManager.fillTaxConfirmationEntry((TaxConfirmationEntry)bo, container);
            } else if (bo instanceof NominalTaxEntry) {
                NominalLedgerEntryPersistencyManager.fillNominalTaxEntry((NominalTaxEntry)bo, container);
            } else if (bo instanceof BaseDifferenceEntry) {
                NominalLedgerEntryPersistencyManager.fillBaseDifferenceEntry((BaseDifferenceEntry)bo, container);
            } else if (bo instanceof PersonalAccountEntry) {
                NominalLedgerEntryPersistencyManager.fillPersonalAccountEntry((PersonalAccountEntry)bo, container);
            } else if (bo instanceof AgedDataEntry) {
                NominalLedgerEntryPersistencyManager.fillAgedDataEntry((AgedDataEntry)bo, container);
            } else {
                NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry(bo, container);
            }
        } else {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)bo.getObjectid());
        }
    }

    public static void save(NominalLedgerEntry bo) {
        NlentryContainer container = dao.getInitializedInstance();
        NominalLedgerEntryPersistencyManager.fillContainer(container, bo);
        if (bo instanceof TaxConfirmationEntry) {
            NominalLedgerEntryPersistencyManager.fillContainer(container, (TaxConfirmationEntry)bo);
        }
        try {
            String userCode = TransactionManager.getTransactionManager((JurisdictionType)bo.getTransaction().getCompany().getJurisdictionType()).getLastUserid(bo.getTransaction().getTransactionType(), container.creatorid);
            if (bo.isNew()) {
                container = dao.insert(userCode, container);
            } else {
                container = dao.update(userCode, container);
                if (bo instanceof PersonalAccountEntry && bo.getTransaction().isPersonalAccountAdjustmentTransaction() && ((PersonalAccountEntry)bo).getOneOffAccountAddress() != null) {
                    PersEntryAddressPersistencyManager.delete((PersonalAccountEntry)((PersonalAccountEntry)bo));
                }
                if (bo.hadSeveralTaxRates()) {
                    NLEntryTaxPersistencyManager.delete((NominalLedgerEntry)bo);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        bo.setObjectid(container.getObjectid());
        bo.setTimestamp(container.getObjectTS());
        bo.setLastuser(container.getLastUserid());
        bo.setVersion(container.getVersion());
        if (bo instanceof PersonalAccountEntry && bo.getTransaction().isPersonalAccountAdjustmentTransaction() && ((PersonalAccountEntry)bo).getOneOffAccountAddress() != null) {
            PersEntryAddressPersistencyManager.insert((PersonalAccountEntry)((PersonalAccountEntry)bo));
        }
        if (bo.hasSeveralTaxRates()) {
            NLEntryTaxPersistencyManager.insert((NominalLedgerEntry)bo);
        }
    }

    public static void delete(NominalLedgerEntry bo) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), bo.getObjectid(), bo.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillNominalLedgerEntry(NominalLedgerEntry bo, NlentryContainer container) {
        if (!bo.hasTransaction()) {
            bo.setTransaction(NominalTransactionBase.getNominalTransactionBase((String)container.oidtransaction, (int)0));
        }
        String[] analysisCodes = new String[]{container.ac0, container.ac1, container.ac2, container.ac3, container.ac4, container.ac5, container.ac6, container.ac7, container.ac8, container.ac9};
        ActCosting costing = null;
        if (!StringMapper.isNullString((String)container.oidactcosting)) {
            costing = ActCostingPersistencyManager.getActCosting((String)container.oidactcosting, (int)0);
        }
        TaxRate[] taxRates = container.hasseveraltaxrates ? NLEntryTaxPersistencyManager.getTaxRates((String)container.getObjectid()) : (!StringMapper.isNullString((String)container.oidtaxrate) ? new TaxRate[]{TaxRatePersistencyManager.getTaxRate((String)container.oidtaxrate)} : new TaxRate[]{});
        NLAccountOpenItem nlAccountOpenItem = null;
        if (!StringMapper.isNullString((String)container.oidnlaccopenitem)) {
            nlAccountOpenItem = NLAccountOpenItemPersistencyManager.getNLAccountOpenItem((String)container.oidnlaccopenitem, (NominalLedgerEntry)bo);
        }
        BankAccount contraBankAccount = null;
        if (!StringMapper.isNullString((String)container.oidcontrabankacc)) {
            contraBankAccount = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(container.oidcontrabankacc);
        }
        PersonalAccount contraPersonalAccount = null;
        if (!StringMapper.isNullString((String)container.oidcontrapersacc)) {
            contraPersonalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidcontrapersacc);
        }
        NLAccountCompanySetting contraNominalAccount = null;
        if (!StringMapper.isNullString((String)container.oidcontranlaccount)) {
            contraNominalAccount = NLItemCompanySettingPersistencyManager.getNLAccountCompanySetting((String)container.oidcontranlaccount);
        }
        CustSupAddress contraOneOffAddress = null;
        if (!StringMapper.isNullString((String)container.oidcontroneoffadr)) {
            contraOneOffAddress = CustSupAddressPersistencyManagerBase.getCustSupAddress((String)container.oidcompany, (String)container.oidcontroneoffadr);
        }
        NLAccountFixTaxPosting nlAccountFixTaxPosting = null;
        if (container.transactiontype == PersistableEnumUtils.toPersistentValue((PersistableEnum)TransactionType.CHEQUE_DEPOSIT)) {
            if (container.entrytype == 1) {
                nlAccountFixTaxPosting = new NLAccountFixTaxPosting(container.isinputtax);
            } else if (container.entrytype == 0 && !StringMapper.isNullString((String)container.oiddopaybapotaxent)) {
                NominalTaxEntry taxEntry = NominalTaxEntry.getNominalTaxEntry((String)container.oiddopaybapotaxent, (int)0);
                NominalTaxEntry additionalTaxEntry = null;
                if (!StringMapper.isNullString((String)container.oidadddopaytaxent)) {
                    additionalTaxEntry = NominalTaxEntry.getNominalTaxEntry((String)container.oidadddopaytaxent, (int)0);
                }
                nlAccountFixTaxPosting = new NLAccountFixTaxPosting(container.isinputtax, taxEntry, additionalTaxEntry);
            }
        }
        ChequeDepositData chequeDepositData = null;
        if (container.transactiontype == PersistableEnumUtils.toPersistentValue((PersistableEnum)TransactionType.CHEQUE_DEPOSIT) && container.entrytype != 2) {
            chequeDepositData = new ChequeDepositData(container.referencenumber, container.processid);
        }
        NLAccountSplitHeadData nlAccountSplitHeadData = null;
        if (container.isnlsplit) {
            nlAccountSplitHeadData = new NLAccountSplitHeadData(container.nlsplitno, container.nlsplittotal, container.nlsplitbasetotal, container.isinputtax, container.costalreadyposted, container.processid);
        }
        NominalEntryBaseData baseData = new NominalEntryBaseData();
        baseData.setAccount(NLItemCompanySettingPersistencyManager.getNLAccountCompanySetting((String)container.oidaccount));
        baseData.setAnalysisCodes(analysisCodes);
        baseData.setDebit(container.debit);
        baseData.setGross(container.gross);
        baseData.setQuantity(container.quantity);
        baseData.setDescription(container.description);
        baseData.setEntryNumber(container.entryno);
        AccountingCompany relatedCompany = null;
        if (!StringMapper.isNullString((String)container.oidrelatedcompany)) {
            relatedCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)container.oidrelatedcompany);
        }
        baseData.setRelatedCompany(relatedCompany);
        EUVATNumber euVatNumber = null;
        if (!StringMapper.isNullString((String)container.oideccountry)) {
            Country country = CountryPersistencyManager.getCountry((String)container.oideccountry);
            euVatNumber = new EUVATNumber(container.ectaxnumber, container.persaccname, container.persaccstreet, container.persacctown, container.persaccpostcode, (ICountry)country);
        }
        bo.setData(new NominalLedgerEntryData(baseData, costing, container.isdiscountable, container.oidjournal, container.journalno, container.oidsecondjournal, container.secondaryjournalno, container.isdownpayment, taxRates, nlAccountOpenItem, container.isinputtaxdeduct, container.taxableamount, container.journalrownumber, container.enteredamount, container.baseamount, container.seccurr1amount, container.seccurr2amount, container.seccurr3amount, container.seccur4amount, container.nonetbalance, contraBankAccount, contraPersonalAccount, contraNominalAccount, contraOneOffAddress, container.taxdate, (IEUVATNumber)euVatNumber, container.isassetdiscount, nlAccountFixTaxPosting, chequeDepositData, container.accstmtprintno, nlAccountSplitHeadData));
        bo.setObjectid(container.getObjectid());
        bo.setTimestamp(container.getObjectTS());
        bo.setLastuser(container.getLastUserid());
        bo.setVersion(container.getVersion());
    }

    private static void fillNominalTaxEntry(NominalTaxEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)bo, container);
        NlentryTaxRegister nlentryTaxRegister = null;
        if (!StringMapper.isNullString((String)container.oidtaxreturnreport) && StringMapper.equal((String)container.oidtaxreturnreport, (String)"0")) {
            nlentryTaxRegister = NlentryTaxRegisterPersistencyManager.getNlentryTaxRegister((NominalTaxEntry)bo);
        }
        bo.setData(container.taxvariance, container.netamount, container.oidchambcontrib, container.taxconfirmdate, container.oidritenutareport, nlentryTaxRegister, ConversionRate.makeConversionRateFromContainer((BigDecimal)container.taxofficerate, (BigDecimal)container.inversetaxoffrate), container.isinputtax, TaxAccountTypeMapper.toTaxAccountType((int)container.taxaccounttype));
    }

    private static void fillBaseDifferenceEntry(BaseDifferenceEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)bo, container);
        bo.setData(ConversionRate.makeConversionRateFromContainer((BigDecimal)container.taxofficerate, (BigDecimal)container.inversetaxoffrate));
    }

    private static void fillBankAccountEntry(BankAccountEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)bo, container);
        bo.setData(((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(container.oidbankaccount), container.reconciled);
    }

    private static void fillAgedDataEntry(AgedDataEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)bo, container);
        PersonalAccount personalacc = null;
        if (!StringMapper.isNullString((String)container.oidpersonalacc)) {
            personalacc = PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidpersonalacc);
        }
        BankAccount bankAccount = null;
        if (!StringMapper.isNullString((String)container.oidbankaccount)) {
            bankAccount = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(container.oidbankaccount);
        }
        bo.setData(personalacc, bankAccount, container.reconciled, container.basenetbalance, container.netbalance);
    }

    private static void fillPersonalAccountEntry(PersonalAccountEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)bo, container);
        TaxCode downPaymentTaxCode = null;
        if (!StringMapper.isNullString((String)container.oiddownpaymtaxcode)) {
            downPaymentTaxCode = TaxCodePersistencyManager.getTaxCode((String)container.oiddownpaymtaxcode);
        }
        NominalLedgerTransaction downPaymentTaxAdjustment = null;
        if (!StringMapper.isNullString((String)container.oiddownpaymtaxadj)) {
            downPaymentTaxAdjustment = NominalLedgerTransaction.getNominalLedgerTransactionWithoutCache((String)container.oiddownpaymtaxadj);
        }
        PersonalAccountAdjustmentTransaction downPaymentDiscountAdjustment = null;
        if (!StringMapper.isNullString((String)container.oiddownpaymdiscadj)) {
            downPaymentDiscountAdjustment = PersonalAccountAdjustmentTransaction.getPersonalAccountAdjustmentTransaction((String)container.oiddownpaymdiscadj);
        }
        OpenItemAllocation downPaymentOiAllocation = null;
        if (!StringMapper.isNullString((String)container.oiddopayoialloc)) {
            downPaymentOiAllocation = OpenItemAllocationPersistencyManager.getOpenItemAllocation((String)container.oiddopayoialloc);
        }
        PrepaidTax prepaidTax = null;
        if (!StringMapper.isNullString((String)container.oiddopaybaponoment)) {
            NominalLedgerEntry additionalNominalEntry = null;
            NominalTaxEntry additionalTaxEntry = null;
            if (!StringMapper.isNullString((String)container.oidadddopaynoment)) {
                additionalNominalEntry = NominalLedgerEntryPersistencyManager.getNominalLedgerEntry(container.oidadddopaynoment, 0);
                additionalTaxEntry = NominalTaxEntry.getNominalTaxEntry((String)container.oidadddopaytaxent, (int)0);
            }
            prepaidTax = new PrepaidTax(NominalLedgerEntryPersistencyManager.getNominalLedgerEntry(container.oiddopaybaponoment, 0), NominalTaxEntry.getNominalTaxEntry((String)container.oiddopaybapotaxent, (int)0), additionalNominalEntry, additionalTaxEntry);
        }
        bo.setData(PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidpersonalacc), downPaymentTaxCode, container.downpaymdiscamount, downPaymentTaxAdjustment, downPaymentDiscountAdjustment, prepaidTax, downPaymentOiAllocation, container.processid, container.allocationnumber);
    }

    private static void fillTaxConfirmationEntry(TaxConfirmationEntry bo, NlentryContainer container) {
        NominalLedgerEntryPersistencyManager.fillNominalTaxEntry((NominalTaxEntry)bo, container);
        NominalLedgerTransaction transaction = null;
        if (!StringMapper.isNullString((String)container.oidtaxconfirmpost)) {
            transaction = NominalLedgerTransactionPersistencyManager.getNominalLedgerTransaction((String)container.oidtaxconfirmpost, (int)0);
        }
        bo.setConfirmTransaction(transaction);
    }

    private static void fillContainer(NlentryContainer container, TaxConfirmationEntry entry) {
        container.oidtaxconfirmpost = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)entry.getConfirmTransaction());
    }

    private static void fillContainer(NlentryContainer container, NominalLedgerEntry bo) {
        container.oidtransaction = bo.getTransaction().getObjectid();
        container.oidaccount = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getAccount());
        container.debit = bo.getIsDebit();
        container.gross = bo.getIsGross();
        container.oidactcosting = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getCosting());
        container.description = bo.getDescription();
        container.quantity = bo.getQuantity();
        container.isinputtaxdeduct = bo.getIsNonDeductibleInputTax();
        container.hasseveraltaxrates = bo.hasSeveralTaxRates();
        container.oidtaxrate = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTaxRate());
        container.nonetbalance = bo.getNoNetBalance();
        container.isassetdiscount = bo.getIsFixedAssetPreDiscount();
        TaxCode taxCode = null;
        if (bo.getTaxRate() != null) {
            taxCode = bo.getTaxRate().getTaxCode();
        }
        container.oidtaxcode = PersistentObjectUtils.getObjectidForContainer(taxCode);
        container.oidrelatedcompany = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getRelatedCompany());
        String[] analysisCodes = bo.getAnalysisCodes();
        container.ac0 = StringMapper.extractValue((String[])analysisCodes, (int)0);
        container.ac1 = StringMapper.extractValue((String[])analysisCodes, (int)1);
        container.ac2 = StringMapper.extractValue((String[])analysisCodes, (int)2);
        container.ac3 = StringMapper.extractValue((String[])analysisCodes, (int)3);
        container.ac4 = StringMapper.extractValue((String[])analysisCodes, (int)4);
        container.ac5 = StringMapper.extractValue((String[])analysisCodes, (int)5);
        container.ac6 = StringMapper.extractValue((String[])analysisCodes, (int)6);
        container.ac7 = StringMapper.extractValue((String[])analysisCodes, (int)7);
        container.ac8 = StringMapper.extractValue((String[])analysisCodes, (int)8);
        container.ac9 = StringMapper.extractValue((String[])analysisCodes, (int)9);
        container.creatorid = bo.getTransaction().getCreatorID();
        container.creationdate = bo.getTransaction().getCreationDate();
        container.correctiontype = 0;
        if (bo.getTransaction().getIsCorrection()) {
            container.correctiontype = 1;
        }
        container.usetype = TransactionUseTypeMapper.toInt((TransactionUseTypeEnum)bo.getTransaction().getUseType());
        container.oidforeigncurrency = null;
        if (bo.getTransaction().getForeignCurrencyRate() != null) {
            container.oidforeigncurrency = bo.getTransaction().getForeignCurrencyRate().getCurrency().getObjectid();
        }
        container.referencenumber = bo.getTransaction().getReferenceNumber();
        container.processid = bo.getTransaction().getProcessId();
        if (bo.getChequeDepositData() != null) {
            container.referencenumber = bo.getChequeDepositData().getReferenceNumber();
            container.processid = bo.getChequeDepositData().getProcessId();
        } else if (bo.getNLAccountSplitHeadData() != null) {
            container.processid = bo.getNLAccountSplitHeadData().getProcessid();
        } else if (bo.isPersonalAccountEntry() && bo.getTransaction().isCashTransaction() && (bo.getIsDownPayment() || ((CashTransaction)bo.getTransaction()).isSeveralAccounts())) {
            container.processid = ((PersonalAccountEntry)bo).getProcessId();
        }
        container.jourtransactgroup = Integer.MIN_VALUE;
        JournalTransactionGroupEnum journalTransactionGroup = bo.getTransaction().getJournalTransactionGroup();
        if (journalTransactionGroup != null) {
            container.jourtransactgroup = JournalTransactionGroupMapper.toInt((JournalTransactionGroupEnum)journalTransactionGroup);
        }
        container.isunfinished = bo.getTransaction().getIsUnfinished();
        container.transactiondate = bo.getTransaction().getTransactionDate();
        container.isjournalized = bo.getTransaction().getIsJournalized();
        container.oidfinancialyear = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTransaction().getFinancialYear());
        container.taxdate = bo.getTransaction().getTaxDate();
        container.oidcompany = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTransaction().getCompany());
        container.sequencenumber = bo.getTransaction().getSequenceNumber();
        container.valuedate = bo.getTransaction().getValueDate();
        container.documentdate = bo.getTransaction().getDocumentDate();
        container.transactiontype = bo.getTransaction().getTransactionType().persistentValue();
        container.totalamount = bo.getTransaction().getTotal();
        container.basetotalamount = bo.getTransaction().getBaseTotal();
        container.oidenteredcurrency = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTransaction().getEnteredCurrency());
        container.conversionrate = ConversionRate.makeRate((ConversionRate)bo.getTransaction().getConversionRate());
        container.inverseconversrate = ConversionRate.makeInverseRate((ConversionRate)bo.getTransaction().getConversionRate());
        container.transactjournalno = bo.getTransaction().getJournalNumber();
        container.note = bo.getTransaction().getNote();
        container.multipletaxcodes = bo.getTransaction().getMultipleTaxCodes();
        container.oidfixtaxrate = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTransaction().getFixTaxRate());
        container.basetaxtotal = null;
        container.taxtotal = null;
        container.isdpayfinalinvoice = false;
        container.postedinvoice = false;
        container.jpkvat = null;
        if (bo.getTransaction().isInvoiceTransaction()) {
            InvoiceTransaction invoiceTransaction = (InvoiceTransaction)bo.getTransaction();
            container.basetaxtotal = invoiceTransaction.getBaseTaxTotal();
            container.taxtotal = invoiceTransaction.getTaxTotal();
            container.isdpayfinalinvoice = invoiceTransaction.getIsDownPaymentFinalInvoice();
            if (invoiceTransaction.isPurchaseRegisterInvoice()) {
                container.postedinvoice = ((PurchaseRegisterInvoice)invoiceTransaction).getIsPostedInvoice();
            }
            container.jpkvat = JPKVATPersistentUtils.toPersistentValue((IJPKVAT)invoiceTransaction.getJpkVAT());
        } else if (bo.getTransaction().isCashTransaction()) {
            container.basetaxtotal = ((CashTransaction)bo.getTransaction()).getBaseTaxTotal();
            container.taxtotal = ((CashTransaction)bo.getTransaction()).getTaxTotal();
        }
        container.oidfinancesetup = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getTransaction().getFinanceSetup());
        container.documentcategory = PersistableEnumUtils.toPersistentValue((PersistableEnum)bo.getTransaction().getDocumentCategory_New());
        container.markforoutsource = 0;
        container.iscanceled = bo.getTransaction().getReverseTransactionBase() != null && !bo.getTransaction().getIsCancelTransaction();
        container.costalreadyposted = bo.getCostingAlreadyPosted();
        container.seccurr1convrate = ConversionRate.makeRate((ConversionRate)bo.getTransaction().getSeccurr1ConversionRate());
        container.seccurr2convrate = ConversionRate.makeRate((ConversionRate)bo.getTransaction().getSeccurr2ConversionRate());
        container.seccurr3convrate = ConversionRate.makeRate((ConversionRate)bo.getTransaction().getSeccurr3ConversionRate());
        container.seccurr4convrate = ConversionRate.makeRate((ConversionRate)bo.getTransaction().getSeccurr4ConversionRate());
        container.inverseseccur1rate = ConversionRate.makeInverseRate((ConversionRate)bo.getTransaction().getSeccurr1ConversionRate());
        container.inverseseccur2rate = ConversionRate.makeInverseRate((ConversionRate)bo.getTransaction().getSeccurr2ConversionRate());
        container.inverseseccur3rate = ConversionRate.makeInverseRate((ConversionRate)bo.getTransaction().getSeccurr3ConversionRate());
        container.inverseseccur4rate = ConversionRate.makeInverseRate((ConversionRate)bo.getTransaction().getSeccurr4ConversionRate());
        container.isdiscountable = bo.getIsDiscountable();
        container.entryno = bo.getEntryNumber();
        container.isdownpayment = bo.getIsDownPayment();
        container.oiddopayoialloc = null;
        container.oiddopaybaponoment = null;
        container.oiddopaybapotaxent = null;
        container.oidadddopaynoment = null;
        container.oidadddopaytaxent = null;
        container.isinputtax = bo.getTransaction().getIsInputTax();
        container.hasfixtaxpost = false;
        if (bo.getNLAccountFixTaxPosting() != null) {
            container.hasfixtaxpost = true;
            container.isinputtax = bo.getNLAccountFixTaxPosting().getIsInputTax();
            container.oiddopaybapotaxent = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getNLAccountFixTaxPosting().getTaxEntry());
            container.oidadddopaytaxent = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getNLAccountFixTaxPosting().getAdditionalTaxEntry());
        }
        container.nlsplitno = 0;
        container.nlsplittotal = null;
        container.nlsplitbasetotal = null;
        container.isnlsplit = false;
        if (bo.getNLAccountSplitHeadData() != null) {
            container.nlsplitno = bo.getNLAccountSplitHeadData().getNLSplitNo();
            container.nlsplitbasetotal = bo.getNLAccountSplitHeadData().getBaseTotal();
            container.nlsplittotal = bo.getNLAccountSplitHeadData().getTotal();
            container.isinputtax = bo.getNLAccountSplitHeadData().getIsInputTax();
            container.isnlsplit = true;
        }
        container.taxaccounttype = Integer.MIN_VALUE;
        container.reconciled = false;
        container.journalrownumber = bo.getJournalRowNumber();
        container.oidcontrabankacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getContraBankAccount());
        container.oidcontranlaccount = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getContraNLAccount());
        container.oidcontrapersacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getContraPersonalAccount());
        container.oidcontroneoffadr = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getContraOneOffAddress());
        container.ectaxnumber = null;
        container.oideccountry = null;
        container.persaccname = null;
        container.persaccpostcode = null;
        container.persaccstreet = null;
        container.persacctown = null;
        IEUVATNumber euVatNumber = bo.getEuVatNumber();
        if (euVatNumber != null) {
            container.ectaxnumber = euVatNumber.getVatNumber();
            container.oideccountry = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)euVatNumber.getCountry());
            container.persaccname = euVatNumber.getName();
            container.persaccpostcode = euVatNumber.getPostcode();
            container.persaccstreet = euVatNumber.getStreet();
            container.persacctown = euVatNumber.getTown();
        }
        container.oidpersonalacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getPersonalAccount());
        container.netbalance = null;
        container.basenetbalance = null;
        container.taxofficerate = null;
        container.inversetaxoffrate = null;
        if (bo.isBankAccountEntry()) {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_BANKACCOUNTENTRY);
            container.oidbankaccount = ((BankAccountEntry)bo).getBankAccount().getObjectid();
            container.reconciled = ((BankAccountEntry)bo).getIsReconciled();
        } else if (bo.isNominalTaxEntry()) {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_TAXENTRY);
            NominalTaxEntry te = (NominalTaxEntry)bo;
            container.taxvariance = te.getBaseVariance();
            container.netamount = te.getBaseNetAmount();
            container.oidchambcontrib = te.getOidChamberContribution();
            container.taxaccounttype = TaxAccountTypeMapper.toInt((TaxAccountTypeEnum)te.getTaxAccountType());
            container.taxconfirmdate = te.getTaxConfirmDate();
            container.oidritenutareport = te.getOidRitenutaReport();
            container.oidtaxreturnreport = "";
            if (te.getNlentryTaxRegister() != null) {
                container.oidtaxreturnreport = "0";
            }
            container.taxofficerate = ConversionRate.makeRate((ConversionRate)te.getTaxOfficeRate());
            container.inversetaxoffrate = ConversionRate.makeInverseRate((ConversionRate)te.getTaxOfficeRate());
        } else if (bo.isBaseDifferenceEntry()) {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_ROUNDINGDIFFERENCEENTRY);
            container.taxofficerate = ConversionRate.makeRate((ConversionRate)((BaseDifferenceEntry)bo).getTaxOfficeRate());
            container.inversetaxoffrate = ConversionRate.makeInverseRate((ConversionRate)((BaseDifferenceEntry)bo).getTaxOfficeRate());
        } else if (bo.isPersonalAccountEntry()) {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_PERSONALACCOUNTENTRY);
            container.oiddownpaymtaxcode = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((PersonalAccountEntry)bo).getDownPaymentTaxCode());
            container.oiddownpaymdiscadj = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((PersonalAccountEntry)bo).getDownPaymentDiscountAdjustment());
            container.oiddownpaymtaxadj = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((PersonalAccountEntry)bo).getDownPaymentTaxAdjustment());
            container.downpaymdiscamount = ((PersonalAccountEntry)bo).getDownPaymentDiscountAmount();
            container.oiddopayoialloc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((PersonalAccountEntry)bo).getDownPaymentOiAllocation());
            container.allocationnumber = ((PersonalAccountEntry)bo).getAllocationNumber();
            PrepaidTax prepaidTax = ((PersonalAccountEntry)bo).getPrepaidTax();
            if (prepaidTax != null) {
                container.oiddopaybaponoment = prepaidTax.getNominalEntry().getObjectid();
                container.oiddopaybapotaxent = prepaidTax.getTaxEntry().getObjectid();
                container.oidadddopaynoment = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)prepaidTax.getAdditionalNominalEntry());
                container.oidadddopaytaxent = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)prepaidTax.getAdditionalTaxEntry());
            }
            if (bo.getIsDownPayment()) {
                container.isinputtax = ((PersonalAccountEntry)bo).getDownPaymentInputTax();
                container.oidfixtaxrate = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((PersonalAccountEntry)bo).getDownPaymentTaxRate());
            }
        } else if (bo.isAgedDataEntry()) {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_AGEDDATAENTRY);
            container.oidbankaccount = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)((AgedDataEntry)bo).getBankAccount());
            container.reconciled = ((AgedDataEntry)bo).getIsReconciled();
            container.basenetbalance = ((AgedDataEntry)bo).getNetBalanceDebit();
            container.netbalance = ((AgedDataEntry)bo).getNetBalanceCredit();
            container.nonetbalance = bo.getNoNetBalance();
        } else {
            container.entrytype = EntryTypeMapper.toInt((EntryTypeEnum)EntryTypeEnum.ETE_NOMINALLEDGERENTRY);
        }
        container.taxableamount = bo.getUseTaxNetAmount();
        container.oidjournal = bo.getOidJournal();
        container.journalno = bo.getJournalNo();
        container.oidsecondjournal = bo.getOidSecondJournal();
        container.secondaryjournalno = bo.getSecondaryJournalNo();
        container.oidnlaccopenitem = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getNLAccountOpenItem());
        container.enteredamount = bo.getEnteredAmount();
        container.baseamount = bo.getBaseAmount();
        container.seccurr1amount = bo.getSeccurr1Amount();
        container.seccurr2amount = bo.getSeccurr2Amount();
        container.seccurr3amount = bo.getSeccurr3Amount();
        container.seccur4amount = bo.getSeccurr4Amount();
        container.turnovertype = 0;
        container.accstmtprintno = bo.getAccStatemNumber();
        container.createdbytransfer = bo.getTransaction().isCreatedByTransfer();
        container.isconsolitrans = bo.getTransaction().getIsConsolidationTransaction();
        container.setObjectid(bo.getObjectid());
        container.setObjectTS(bo.getTimestamp());
        container.setLastUserid(bo.getLastuser());
        container.setVersion(bo.getVersion());
    }

    public static void updateTransactionDate(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.transactiondate = transaction.getTransactionDate();
            dao.updateAttributes(container, new String[]{"transactiondate"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void setTransactionJournalNo(String oidTransaction, String journalNo) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.transactjournalno = journalNo;
            container.isjournalized = true;
            dao.updateAttributes(container, new String[]{"transactjournalno", "isjournalized"}, Restrictions.eq((String)"oidtransaction", (String)oidTransaction));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateTaxDate(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.taxdate = transaction.getTaxDate();
            dao.updateAttributes(container, new String[]{"taxdate"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateIsCancelled(NominalTransactionBase transaction, boolean isCancelled) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.iscanceled = isCancelled;
            dao.updateAttributes(container, new String[]{"iscanceled"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateIsJournalized(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.isjournalized = transaction.getIsJournalized();
            dao.updateAttributes(container, new String[]{"isjournalized"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateIsUnfinished(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.isunfinished = transaction.getIsUnfinished();
            dao.updateAttributes(container, new String[]{"isunfinished"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateFinancialYear(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oidfinancialyear = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)transaction.getFinancialYear());
            dao.updateAttributes(container, new String[]{"oidfinancialyear"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateSequenceNumber(NominalTransactionBase transaction) {
        NominalLedgerEntryPersistencyManager.updateSequenceNumber(transaction.getObjectid(), transaction.getSequenceNumber());
    }

    public static void updateSequenceNumber(String oidtransaction, String sequenceNumber) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.sequencenumber = sequenceNumber;
            dao.updateAttributes(container, new String[]{"sequencenumber"}, Restrictions.eq((String)"oidtransaction", (String)oidtransaction));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateProcessId(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.processid = transaction.getProcessId();
            dao.updateAttributes(container, new String[]{"processid"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateProcessId(NominalTransactionBase transaction, boolean isDownPayment) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.processid = transaction.getProcessId();
            dao.updateAttributes(container, new String[]{"processid"}, Restrictions.and((Criterion)Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()), (Criterion)Restrictions.eq((String)"isdownpayment", (String)BooleanMapper.toString((boolean)isDownPayment))));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateReferenceNumber(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.referencenumber = transaction.getReferenceNumber();
            dao.updateAttributes(container, new String[]{"referencenumber"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void cleanEntries(ChamberContribution chamberContribution) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oidchambcontrib = null;
            dao.updateAttributes(container, new String[]{"oidchambcontrib"}, Restrictions.eq((String)"oidchambcontrib", (String)chamberContribution.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void cleanEntries(RitenutaReport report) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oidritenutareport = null;
            dao.updateAttributes(container, new String[]{"oidritenutareport"}, Restrictions.eq((String)"oidritenutareport", (String)report.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static Date getDateOfLastPosting(NLAccountCompanySetting nLAccountCompanySetting) {
        Date[] result = (Date[])new SelectGenerator("nlentry_t", new String[]{"MAX(transactiondate)"}, null, Restrictions.eq((String)"oidaccount", (String)nLAccountCompanySetting.getObjectid()), null, false, Date.class, new String[]{""}).select();
        if (result.length != 1) {
            return null;
        }
        return result[0];
    }

    public static Date getDateOfLastPosting(NLAccountCompanySetting nLAccountCompanySetting, FinancialYear year) {
        Date[] result;
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidaccount", (String)nLAccountCompanySetting.getObjectid()));
        filter.add(Restrictions.eq((String)"oidfinancialyear", (String)year.getObjectid()));
        FinanceSetup financeSetup = year.getCompany().getFinanceSetup();
        if (financeSetup != null && financeSetup.getWithOpeningAndClosingEntries()) {
            String[] useTypes = new String[]{TransactionUseTypeMapper.toString((TransactionUseTypeEnum)TransactionUseTypeEnum.TUTE_OPENING_YEAR_TRANSACTION), TransactionUseTypeMapper.toString((TransactionUseTypeEnum)TransactionUseTypeEnum.TUTE_CLOSING_YEAR_TRANSACTION)};
            filter.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.isNull((String)"USETYPE"), Restrictions.not((Criterion)Restrictions.in((String)"USETYPE", (String[])useTypes))}));
        }
        if ((result = (Date[])new SelectGenerator("nlentry_t", new String[]{"MAX(transactiondate)"}, null, (Criterion)filter, null, false, Date.class, new String[]{""}).select()).length != 1) {
            return null;
        }
        return result[0];
    }

    public static Date getDateOfLastPosting(TaxRate taxRate) {
        Date[] result = (Date[])new SelectGenerator("nlentry_t", new String[]{"MAX(taxdate)"}, null, Restrictions.and((Criterion)Restrictions.eq((String)"oidtaxrate", (String)taxRate.getObjectid()), (Criterion)Restrictions.ne((String)"transactiontype", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)TransactionType.PERSONAL_ACCOUNT_ADJUSTMENT))), null, false, Date.class, new String[]{""}).select();
        if (result.length != 1) {
            return null;
        }
        return result[0];
    }

    public static Date getDateOfFirstPosting(TaxRate taxRate) {
        Date[] result = (Date[])new SelectGenerator("nlentry_t", new String[]{"MIN(taxdate)"}, null, Restrictions.and((Criterion)Restrictions.eq((String)"oidtaxrate", (String)taxRate.getObjectid()), (Criterion)Restrictions.ne((String)"transactiontype", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)TransactionType.PERSONAL_ACCOUNT_ADJUSTMENT))), null, false, Date.class, new String[]{""}).select();
        if (result.length != 1) {
            return null;
        }
        return result[0];
    }

    public static Date getDateOfLastPosting(PersonalAccountPlafond plafond) {
        StringBuffer select = new StringBuffer("oidtransaction in (select oidtransaction from nlentry_T where oidcontrapersacc = ");
        select.append(plafond.getPersonalAccount().getObjectid());
        select.append(") and oidtaxcode = ");
        select.append(plafond.getTaxCode().getObjectid());
        select.append(" and isunfinished = '" + BooleanMapper.toString((boolean)false) + "'");
        Date[] result = (Date[])new SelectGenerator("nlentry_t", new String[]{"MAX(taxdate)"}, null, Restrictions.sqlRestriction((String)select.toString()), null, false, Date.class, new String[]{""}).select();
        if (result.length != 1) {
            return null;
        }
        return result[0];
    }

    public static long getLastJournalRowNumber(FinancialYear financialYear) {
        BigDecimal[] result = (BigDecimal[])new SelectGenerator("nlentry_t", new String[]{"MAX(JOURNALROWNUMBER)"}, null, Restrictions.eq((String)"OIDFINANCIALYEAR", (String)financialYear.getObjectid()), null, false, BigDecimal.class, new String[]{""}).select();
        if (result.length != 1) {
            return 0L;
        }
        String rowNumber = BigDecimalMapper.toString((BigDecimal)result[0]);
        if (!StringMapper.isNullString((String)rowNumber)) {
            return Long.parseLong(rowNumber);
        }
        return 0L;
    }

    public static boolean existPostings(PersonalAccountPlafond plafond) {
        try {
            return dao.exists((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidcontrapersacc", (String)plafond.getPersonalAccount().getObjectid()), Restrictions.eq((String)"oidtaxcode", (String)plafond.getTaxCode().getObjectid()), Restrictions.eq((String)"isunfinished", (String)BooleanMapper.toString((boolean)false)), Restrictions.ge((String)"taxdate", (String)DateMapper.toString((Date)plafond.getValidFrom())), Restrictions.le((String)"taxdate", (String)DateMapper.toString((Date)plafond.getValidTo()))}));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostings(PersonalAccount persAccount) {
        try {
            return dao.exists(Restrictions.eq((String)"OIDPERSONALACC", (String)persAccount.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existDownPaymentPostings(PersonalAccount persAccount) {
        try {
            return dao.exists(Restrictions.and((Criterion)Restrictions.eq((String)"OIDPERSONALACC", (String)persAccount.getObjectid()), (Criterion)Restrictions.eq((String)"ISDOWNPAYMENT", (String)BooleanMapper.toString((boolean)true))));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean existPostings(NLItemCompanySetting nlItemCompSetting) {
        try {
            return dao.exists(Restrictions.eq((String)"oidaccount", (String)nlItemCompSetting.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void setDownPaymentOiAllocationToNull(PersonalAccountEntry entry) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oiddopayoialloc = null;
            dao.updateAttributes(container, new String[]{"oiddopayoialloc"}, Restrictions.eq((String)"objectid", (String)entry.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void setDownPaymentOiAllocationToNull(OpenItemAllocation downPaymentOiAllocation) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oiddopayoialloc = null;
            dao.updateAttributes(container, new String[]{"oiddopayoialloc"}, Restrictions.eq((String)"oiddopayoialloc", (String)downPaymentOiAllocation.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateNLAccountOpenItem(NominalLedgerEntry entry, NLAccountOpenItem openItem) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.oidnlaccopenitem = openItem == null ? null : openItem.getObjectid();
            dao.updateAttributes(container, new String[]{"oidnlaccopenitem"}, Restrictions.eq((String)"objectid", (String)entry.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateAccStmtPrintNo(String oidNLEntry, int printNo) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.accstmtprintno = printNo;
            dao.updateAttributes(container, new String[]{"accstmtprintno"}, Restrictions.eq((String)"objectid", (String)oidNLEntry));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateInAccStatementNo(String oidNLEntry, int printNo) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.inaccstatementno = printNo;
            dao.updateAttributes(container, new String[]{"inaccstatementno"}, Restrictions.eq((String)"objectid", (String)oidNLEntry));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void updateCashBookPrintNo(String oidNLEntry, int printNo) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.cashbookprintno = printNo;
            dao.updateAttributes(container, new String[]{"cashbookprintno"}, Restrictions.eq((String)"objectid", (String)oidNLEntry));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerEntry[] getTaxEntriesForBE(VATReturn vatReturn, String[] inFilter) {
        return NominalLedgerEntryPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{VATReturnCEHelper.getInEntryRelationFilter((String)vatReturn.getObjectid()), Restrictions.eq((String)"DOCUMENTCATEGORY", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)DocumentCategoryType.PURCHASECREDITNOTES)), Subqueries.in((String)"oidtaxcode", (SubSelect)new SubSelect("select objectid from taxcode_t", Restrictions.in((String)"taxtype", (String[])inFilter)))}), null);
    }

    public static NominalLedgerEntry getEntryForActCosting(String oidActCosting) {
        NominalLedgerEntry[] nlEntryForActCosting = NominalLedgerEntryPersistencyManager.query(null, Restrictions.eq((String)"OIDACTCOSTING", (String)oidActCosting), null);
        if (nlEntryForActCosting == null || nlEntryForActCosting.length == 0) {
            return null;
        }
        return nlEntryForActCosting[0];
    }

    public static ICurrency[] getCurrenciesPosted(String oidNLItemCompSet, Date untilDate) {
        SelectGenerator selectGen = new SelectGenerator("NLENTRY_T", new String[]{"oidenteredcurrency"}, null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccount", (String)oidNLItemCompSet), Restrictions.le((String)"transactiondate", (String)DateMapper.toString((Date)untilDate))}), null, true, String.class, new String[]{"oidenteredcurrency"});
        SelectGeneratorDataSet dataSet = selectGen.makeDataset();
        ArrayList<ICurrency> currList = new ArrayList<ICurrency>();
        while (dataSet.hasNext()) {
            String oidCurrency = (String)dataSet.getNext()[0];
            ICurrency currency = CurrencyPersistencyManager.getCurrency((String)oidCurrency);
            currList.add(currency);
        }
        ICurrency[] result = new ICurrency[currList.size()];
        return currList.toArray(result);
    }

    public static Set<String> getTaxCodesPosted(String oidNLItemCompSet, String oidFinYear, Date fromDate, Date untilDate) {
        SelectGenerator selectGen = new SelectGenerator("NLENTRY_T", new String[]{"oidtaxcode"}, null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidaccount", (String)oidNLItemCompSet), Restrictions.eq((String)"oidfinancialyear", (String)oidFinYear), Restrictions.ge((String)"transactiondate", (String)DateMapper.toString((Date)fromDate)), Restrictions.le((String)"transactiondate", (String)DateMapper.toString((Date)untilDate))}), null, true, String.class, new String[]{"oidtaxcode"});
        SelectGeneratorDataSet dataSet = selectGen.makeDataset();
        HashSet<String> taxCodes = new HashSet<String>();
        while (dataSet.hasNext()) {
            String oidTaxCode = (String)dataSet.getNext()[0];
            taxCodes.add(oidTaxCode);
        }
        return taxCodes;
    }

    public static NominalLedgerEntry buildObjectFromContainer(NlentryContainer container, NominalTransactionBase transaction, boolean readOnly) {
        BaseDifferenceEntry result;
        switch (container.entrytype) {
            case 2: {
                result = new BankAccountEntry(readOnly, transaction, 0);
                NominalLedgerEntryPersistencyManager.fillBankAccountEntry((BankAccountEntry)result, container);
                break;
            }
            case 1: {
                result = new NominalTaxEntry(readOnly, transaction, 0);
                NominalLedgerEntryPersistencyManager.fillNominalTaxEntry((NominalTaxEntry)result, container);
                break;
            }
            case 3: {
                result = new BaseDifferenceEntry(readOnly, transaction);
                NominalLedgerEntryPersistencyManager.fillBaseDifferenceEntry(result, container);
                break;
            }
            case 4: {
                result = new PersonalAccountEntry(readOnly, transaction, 0);
                NominalLedgerEntryPersistencyManager.fillPersonalAccountEntry((PersonalAccountEntry)result, container);
                break;
            }
            case 0: {
                result = new NominalLedgerEntry(readOnly, transaction, 0);
                NominalLedgerEntryPersistencyManager.fillNominalLedgerEntry((NominalLedgerEntry)result, container);
                break;
            }
            case 5: {
                result = new AgedDataEntry(readOnly, transaction);
                NominalLedgerEntryPersistencyManager.fillAgedDataEntry((AgedDataEntry)result, container);
                break;
            }
            default: {
                throw ExceptionMapper.makeApplicationException((String)"Unknown entry type");
            }
        }
        return result;
    }

    public static PersistencyDataSet makeDataSet(VATReturn vatReturn) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{VATReturnCEHelper.getInEntryRelationFilter((String)vatReturn.getObjectid()), VATReturnCEHelper.getEntryTypeFilter()});
        return NominalLedgerEntryPersistencyManager.makeDataSet((Criterion)filter);
    }

    public static PersistencyDataSet makeDataSet(Criterion criterion) {
        try {
            PersistencyDataSet dataSet = dao.getDataSet(null, criterion);
            return dataSet;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerEntry getNominalLedgerEntry(String objectid, int transactionPersistencyType) {
        NominalLedgerEntry result;
        Cache cache = cacheManager.getCache(NominalLedgerEntry.CLASSNAME);
        IPersistentObject po = CacheUtil.value((Element)cache.get((Object)objectid));
        if (po == null) {
            result = new NominalLedgerEntry(objectid, transactionPersistencyType);
            cache.put(CacheUtil.element((IPersistentObject)result));
        } else {
            result = (NominalLedgerEntry)po;
        }
        return result;
    }

    public static NominalLedgerEntry getNominalLedgerEntry(String objectid) {
        return NominalLedgerEntryPersistencyManager.getNominalLedgerEntry(objectid, 0);
    }

    public static PersistencyDataSet makeDataSet(TaxReportCountry taxReportCountry) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{TaxReportCountryHelper.getInEntryRelationFilter((String)taxReportCountry.getObjectid()), TaxReportCountryHelper.getEntryTypeFilter()});
        return NominalLedgerEntryPersistencyManager.makeDataSet((Criterion)filter);
    }

    public static void updateIsPostedInvoice(NominalTransactionBase transaction) {
        try {
            NlentryContainer container = new NlentryContainer();
            container.postedinvoice = transaction.getIsPostedInvoice();
            dao.updateAttributes(container, new String[]{"postedinvoice"}, Restrictions.eq((String)"oidtransaction", (String)transaction.getObjectid()));
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean isDownPaymentTaxPostingLine(NlentryContainer nlentryContainer) {
        if (nlentryContainer == null || nlentryContainer.entrytype != 1) {
            return false;
        }
        return nlentryContainer.isdpayfinalinvoice && nlentryContainer.isdownpayment || nlentryContainer.usetype == 30;
    }
}

