/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nominalledger.balance;

import com.varial.accounting.domain.accountingbudget.AccountingBudget;
import com.varial.accounting.domain.accountingbudget.AccountingBudgetRow;
import com.varial.accounting.domain.balancedisplay.BalanceDisplayRow;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.bankaccount.balance.BankAccountBalanceManager;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nominalledger.AccountType;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySettingPersistencyManager;
import com.varial.accounting.domain.nominalledger.NominalLedger;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerItem;
import com.varial.accounting.domain.nominalledger.balance.Balances;
import com.varial.accounting.domain.nominalledger.balance.NLAccountBalance;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerCurrencyAmount;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUseTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.TransactionUseTypeMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Disjunction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.balance.BalanceSum;
import com.varial.framework.domain.balance.DailyBalance;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.persistency.SelectGenerator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NLAccountBalanceManager {
    private static Logger LOGGER = LoggerFactory.getLogger((String)NLAccountBalanceManager.class.getName());

    private NLAccountBalanceManager() {
    }

    public static BalanceSum getCurrentBalance(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, boolean readOnly) {
        BalanceSum startBalance = NLAccountBalanceManager.getStartBalanceForYear(account, financialYear, readOnly);
        BalanceSum actBalance = NLAccountBalanceManager.getBalanceForYear(account, financialYear, baseCurrency, readOnly);
        return startBalance.add(actBalance);
    }

    public static BalanceSum getCurrentBalance(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, Date date, boolean readOnly) {
        BalanceSum startBalance = NLAccountBalanceManager.getStartBalanceForYear(account, financialYear, readOnly);
        BalanceSum actBalance = NLAccountBalanceManager.getBalanceForYear(account, financialYear, baseCurrency, date, readOnly);
        return startBalance.add(actBalance);
    }

    public static BalanceSum getBalanceForYear(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, boolean readOnly) {
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)baseCurrency, (boolean)true, (boolean)readOnly);
        return balance.getCurrentBalance();
    }

    public static BalanceSum getClosingEntryBalanceForYear(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, boolean readOnly) {
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)baseCurrency, (boolean)readOnly);
        return balance.getBalanceForBalanceType(DailyBalance.BalanceType.CLOSINGENTRY);
    }

    public static BalanceSum getOpeningEntryBalanceForYear(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, boolean readOnly) {
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)baseCurrency, (boolean)readOnly);
        return balance.getBalanceForBalanceType(DailyBalance.BalanceType.OPENINGENTRY);
    }

    public static BalanceSum getBalanceForYear(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, Date date, boolean readOnly) {
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)baseCurrency, (boolean)true, (boolean)readOnly);
        return balance.getCurrentBalance(date);
    }

    public static BalanceSum getBalanceChangesForYear(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, Date from, Date until) {
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)baseCurrency, (boolean)true, (boolean)true);
        return balance.getBalanceChanges(from, until);
    }

    public static void addEntry(NLAccountCompanySetting account, NominalLedgerEntry entry) {
        BigDecimal enteredAmount;
        Map amounts = entry.getCurrencyAmounts();
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)entry.getTransaction().getFinancialYear(), (ICurrency)((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getCurrency(), (boolean)false);
        if (account.getForeignCurrency() == null) {
            enteredAmount = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getAmount();
        } else {
            if (!account.getForeignCurrency().equals(((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getCurrency()) && !account.getForeignCurrency().equals(((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.ENTEREDCURRENCY)).getCurrency())) {
                throw ExceptionMapper.makeApplicationException((String)"Accounts with currency can only be posted in the currency of the account.");
            }
            enteredAmount = entry.getForeignNetAmount();
        }
        BigDecimal sec1 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC1CURRENCY) != null) {
            sec1 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC1CURRENCY)).getAmount();
        }
        BigDecimal sec2 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC2CURRENCY) != null) {
            sec2 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC2CURRENCY)).getAmount();
        }
        BigDecimal sec3 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC3CURRENCY) != null) {
            sec3 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC3CURRENCY)).getAmount();
        }
        BigDecimal sec4 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC4CURRENCY) != null) {
            sec4 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC4CURRENCY)).getAmount();
        }
        balance.add(TransactionUseTypeMapper.getBalanceType((TransactionUseTypeEnum)entry.getTransaction().getUseType()), entry.getIsDebit(), entry.getTransaction().getTransactionDate(), ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getAmount(), entry.getQuantity(), enteredAmount, sec1, sec2, sec3, sec4);
    }

    public static void removeEntry(NLAccountCompanySetting account, NominalLedgerEntry entry) {
        BigDecimal enteredAmount;
        Map amounts = entry.getCurrencyAmounts();
        NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)entry.getTransaction().getFinancialYear(), (ICurrency)((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getCurrency(), (boolean)false);
        if (account.getForeignCurrency() == null) {
            enteredAmount = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getAmount();
        } else {
            if (!account.getForeignCurrency().equals(((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getCurrency()) && !account.getForeignCurrency().equals(((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.ENTEREDCURRENCY)).getCurrency())) {
                throw ExceptionMapper.makeApplicationException((String)"Accounts with currency can only be posted in the currency of the account.");
            }
            enteredAmount = entry.getForeignNetAmount();
        }
        BigDecimal sec1 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC1CURRENCY) != null) {
            sec1 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC1CURRENCY)).getAmount();
        }
        BigDecimal sec2 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC2CURRENCY) != null) {
            sec2 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC2CURRENCY)).getAmount();
        }
        BigDecimal sec3 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC3CURRENCY) != null) {
            sec3 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC3CURRENCY)).getAmount();
        }
        BigDecimal sec4 = BigDecimalMapper.ZERO;
        if (amounts.get(NominalLedgerEntry.SEC4CURRENCY) != null) {
            sec4 = ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.SEC4CURRENCY)).getAmount();
        }
        balance.subtract(TransactionUseTypeMapper.getBalanceType((TransactionUseTypeEnum)entry.getTransaction().getUseType()), entry.getIsDebit(), entry.getTransaction().getTransactionDate(), ((NominalLedgerCurrencyAmount)amounts.get(NominalLedgerEntry.BASECURRENCY)).getAmount(), entry.getQuantity(), enteredAmount, sec1, sec2, sec3, sec4);
    }

    public static BalanceSum getStartBalanceForYear(NLAccountCompanySetting account, FinancialYear financialYear, boolean readOnly) {
        BalanceSum result;
        AccountType type = account.getNominalLedgerItem().getAccountType();
        if (type == AccountType.PROFIT || type == AccountType.LOSS) {
            AccountingCompany company = account.getAccountingCompany();
            FinanceSetup financeSetup = company.getFinanceSetup();
            result = account.getForeignCurrency() == null ? new BalanceSum(financeSetup.getBaseCurrency()) : new BalanceSum(financeSetup.getBaseCurrency(), account.getForeignCurrency());
        } else {
            AccountingCompany company = account.getAccountingCompany();
            FinanceSetup financeSetup = company.getFinanceSetup();
            if (financialYear.getOpeningNLBalanceSet() && !account.getNominalLedgerAccount().equals((Object)financeSetup.getRetainedEarningsAccount())) {
                NLAccountBalance balance = NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)financialYear, (ICurrency)financeSetup.getBaseCurrency(), (boolean)true, (boolean)readOnly);
                result = new BalanceSum(balance.getCurrency(), balance.getForeignCurrency(), balance.getStartTotalAmountDebit(), balance.getStartTotalAmountCredit(), balance.getStartTotalQuantityDebit(), balance.getStartTotalQuantityCredit(), balance.getStartTotalForeignAmountDebit(), balance.getStartTotalForeignAmountCredit(), balance.getStartTotalSec1AmountDebit(), balance.getStartTotalSec1AmountCredit(), balance.getStartTotalSec2AmountDebit(), balance.getStartTotalSec2AmountCredit(), balance.getStartTotalSec3AmountDebit(), balance.getStartTotalSec3AmountCredit(), balance.getStartTotalSec4AmountDebit(), balance.getStartTotalSec4AmountCredit());
            } else {
                result = NLAccountBalanceManager.getPreviousYearBalance(account, financialYear, financeSetup.getBaseCurrency(), readOnly);
            }
            if (account.getNominalLedgerAccount().equals((Object)financeSetup.getRetainedEarningsAccount())) {
                result = result.add(NLAccountBalanceManager.getPreviousYearProfitAndLossBalance(financialYear, readOnly));
            }
        }
        return result;
    }

    public static BalanceSum getPreviousYearProfitAndLossBalance(FinancialYear financialYear, boolean readOnly) {
        NLAccountCompanySetting[] losses;
        NLAccountCompanySetting[] profits;
        AccountingCompany company = financialYear.getCompany();
        FinanceSetup financeSetup = company.getFinanceSetup();
        ICurrency baseCurrency = financeSetup.getBaseCurrency();
        BalanceSum result = new BalanceSum(baseCurrency, baseCurrency);
        for (NLAccountCompanySetting profit : profits = NLAccountBalanceManager.getNLAccountCompanySettings(financeSetup.getNominalLedger(), company, AccountType.PROFIT)) {
            result = result.add(NLAccountBalanceManager.getPreviousYearBalance(profit, financialYear, baseCurrency, readOnly));
        }
        for (NLAccountCompanySetting loss : losses = NLAccountBalanceManager.getNLAccountCompanySettings(financeSetup.getNominalLedger(), company, AccountType.LOSS)) {
            result = result.add(NLAccountBalanceManager.getPreviousYearBalance(loss, financialYear, baseCurrency, readOnly));
        }
        return result;
    }

    private static BalanceSum getPreviousYearBalance(NLAccountCompanySetting account, FinancialYear financialYear, ICurrency baseCurrency, boolean readOnly) {
        BalanceSum result;
        FinancialYear prevYear = account.getAccountingCompany().getPreviousFinancialYear(financialYear);
        if (prevYear == null) {
            result = account.getForeignCurrency() == null ? new BalanceSum(baseCurrency) : new BalanceSum(baseCurrency, account.getForeignCurrency());
        } else {
            NLAccountBalance.getNLAccountBalance((NLAccountCompanySetting)account, (FinancialYear)prevYear, (ICurrency)baseCurrency, (boolean)true, (boolean)readOnly);
            result = NLAccountBalanceManager.getCurrentBalance(account, prevYear, baseCurrency, readOnly);
        }
        return result;
    }

    public static BalanceSum convertBalanceSumToBaseCurrency(BalanceSum originalBalanceSum, ICurrency baseCurrency, FinanceSetup.FinanceCurrencyType currencyType) {
        BalanceSum newBalanceSum = new BalanceSum(baseCurrency);
        if (currencyType == FinanceSetup.FinanceCurrencyType.BASECURRENCY) {
            newBalanceSum.setAmountDebit(originalBalanceSum.getAmountDebit());
            newBalanceSum.setAmountCredit(originalBalanceSum.getAmountCredit());
        } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_1_CURRENCY) {
            newBalanceSum.setAmountDebit(originalBalanceSum.getSec1AmountDebit());
            newBalanceSum.setAmountCredit(originalBalanceSum.getSec1AmountCredit());
        } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_2_CURRENCY) {
            newBalanceSum.setAmountDebit(originalBalanceSum.getSec2AmountDebit());
            newBalanceSum.setAmountCredit(originalBalanceSum.getSec2AmountCredit());
        } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_3_CURRENCY) {
            newBalanceSum.setAmountDebit(originalBalanceSum.getSec3AmountDebit());
            newBalanceSum.setAmountCredit(originalBalanceSum.getSec3AmountCredit());
        } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_4_CURRENCY) {
            newBalanceSum.setAmountDebit(originalBalanceSum.getSec4AmountDebit());
            newBalanceSum.setAmountCredit(originalBalanceSum.getSec4AmountCredit());
        }
        newBalanceSum.setQuantityDebit(originalBalanceSum.getQuantityDebit());
        newBalanceSum.setQuantityCredit(originalBalanceSum.getQuantityCredit());
        return newBalanceSum;
    }

    public static BalanceSum getStartBalanceForYearByTransactions(NLAccountCompanySetting account, ICurrency currency, FinancialYear financialYear, Criterion analCodesFilter) {
        BalanceSum result = null;
        AccountType type = account.getNominalLedgerItem().getAccountType();
        if (type == AccountType.PROFIT || type == AccountType.LOSS) {
            result = account.getForeignCurrency() == null ? new BalanceSum(currency) : new BalanceSum(currency, account.getForeignCurrency());
        } else {
            FinancialYear prevFinancialYear = account.getAccountingCompany().getPreviousFinancialYear(financialYear);
            if (prevFinancialYear != null) {
                BalanceDisplayRow[] values = NLAccountBalanceManager.getBalanceDisplayRowsByTransaction(account, false, prevFinancialYear, null, prevFinancialYear.getYearEndDate(), analCodesFilter, false);
                result = account.getForeignCurrency() == null ? new BalanceSum(currency) : new BalanceSum(currency, account.getForeignCurrency());
                for (BalanceDisplayRow value : values) {
                    if (value.mDebit) {
                        result.setAmountDebit(value.mTotalamount);
                        continue;
                    }
                    result.setAmountCredit(value.mTotalamount);
                }
                AccountingCompany company = account.getAccountingCompany();
                FinanceSetup financeSetup = company.getFinanceSetup();
                if (account.getNominalLedgerAccount().equals((Object)financeSetup.getRetainedEarningsAccount())) {
                    result = result.add(NLAccountBalanceManager.getProfitAndLossBalanceByTransactions(currency, prevFinancialYear, prevFinancialYear.getYearEndDate(), analCodesFilter));
                }
            }
        }
        return result;
    }

    public static BalanceSum getCurrentBalanceByTransactions(NLAccountCompanySetting account, ICurrency currency, FinancialYear financialYear, Date untilDate, Criterion analCodesFilter, boolean useDocumentDate) {
        BalanceDisplayRow[] values = NLAccountBalanceManager.getBalanceDisplayRowsByTransaction(account, false, financialYear, null, untilDate, analCodesFilter, useDocumentDate);
        BalanceSum result = account.getForeignCurrency() == null ? new BalanceSum(currency) : new BalanceSum(currency, account.getForeignCurrency());
        for (BalanceDisplayRow value : values) {
            if (value.mDebit) {
                result.setAmountDebit(value.mTotalamount);
                continue;
            }
            result.setAmountCredit(value.mTotalamount);
        }
        AccountingCompany company = account.getAccountingCompany();
        FinanceSetup financeSetup = company.getFinanceSetup();
        FinancialYear prevFinancialYear = account.getAccountingCompany().getPreviousFinancialYear(financialYear);
        if (account.getNominalLedgerAccount().equals((Object)financeSetup.getRetainedEarningsAccount())) {
            result = result.add(NLAccountBalanceManager.getProfitAndLossBalanceByTransactions(currency, prevFinancialYear, prevFinancialYear.getYearEndDate(), analCodesFilter));
        }
        return result;
    }

    public static BalanceSum getBalanceChangesForYearByTransactions(NLAccountCompanySetting account, ICurrency currency, FinancialYear financialYear, Date fromDate, Date untilDate, Criterion analCodesFilter, boolean useDocumentDate) {
        BalanceDisplayRow[] values = NLAccountBalanceManager.getBalanceDisplayRowsByTransaction(account, true, financialYear, fromDate, untilDate, analCodesFilter, useDocumentDate);
        BalanceSum result = account.getForeignCurrency() == null ? new BalanceSum(currency) : new BalanceSum(currency, account.getForeignCurrency());
        for (BalanceDisplayRow value : values) {
            if (value.mDebit) {
                result.setAmountDebit(value.mTotalamount);
                result.setSec1AmountDebit(value.mSeccurr1Amount);
                result.setSec2AmountDebit(value.mSeccurr2Amount);
                result.setSec3AmountDebit(value.mSeccurr3Amount);
                result.setSec4AmountDebit(value.mSeccurr4Amount);
                result.setQuantityDebit(value.mQuantity);
                continue;
            }
            result.setAmountCredit(value.mTotalamount);
            result.setSec1AmountCredit(value.mSeccurr1Amount);
            result.setSec2AmountCredit(value.mSeccurr2Amount);
            result.setSec3AmountCredit(value.mSeccurr3Amount);
            result.setSec4AmountCredit(value.mSeccurr4Amount);
            result.setQuantityCredit(value.mQuantity);
        }
        return result;
    }

    private static BalanceSum getProfitAndLossBalanceByTransactions(ICurrency currency, FinancialYear financialYear, Date untilDate, Criterion analCodesFilter) {
        NLAccountCompanySetting[] losses;
        NLAccountCompanySetting[] profits;
        BalanceSum result = new BalanceSum(currency);
        AccountingCompany company = financialYear.getCompany();
        FinanceSetup financeSetup = company.getFinanceSetup();
        for (NLAccountCompanySetting profit : profits = NLAccountBalanceManager.getNLAccountCompanySettings(financeSetup.getNominalLedger(), company, AccountType.PROFIT)) {
            result = result.add(NLAccountBalanceManager.getCurrentBalanceByTransactions(profit, currency, financialYear, untilDate, analCodesFilter, false));
        }
        for (NLAccountCompanySetting loss : losses = NLAccountBalanceManager.getNLAccountCompanySettings(financeSetup.getNominalLedger(), company, AccountType.LOSS)) {
            result = result.add(NLAccountBalanceManager.getCurrentBalanceByTransactions(loss, currency, financialYear, untilDate, analCodesFilter, false));
        }
        return result;
    }

    private static BalanceDisplayRow[] getBalanceDisplayRowsByTransaction(NLAccountCompanySetting account, boolean isBalanceChangesForYearOnly, FinancialYear financialYear, Date validFrom, Date validUntil, Criterion analCodesFilter, boolean useDocumentDate) {
        LOGGER.debug("NLAccountBalanceManager - getBaseCurrencyBalancesByTransaction");
        String[] attributes = new String[]{"sum(baseamount)", "SUM(SECCURR1AMOUNT)", "SUM(SECCURR2AMOUNT)", "SUM(SECCURR3AMOUNT)", "SUM(SECCUR4AMOUNT)", "debit", "SUM(QUANTITY)"};
        String view = "nlentry_t";
        Conjunction elements = Restrictions.conjunction();
        elements.add(Restrictions.eq((String)"OIDACCOUNT", (String)account.getObjectid()));
        elements.add(Restrictions.eq((String)"ISUNFINISHED", (String)"F"));
        elements.add(Restrictions.eq((String)"ISCONSOLITRANS", (String)BooleanMapper.toString((boolean)false)));
        if (isBalanceChangesForYearOnly) {
            elements.add(Restrictions.eq((String)"OIDFINANCIALYEAR", (String)financialYear.getObjectid()));
            if (validUntil != null) {
                if (useDocumentDate) {
                    elements.add(Restrictions.le((String)"DOCUMENTDATE", (String)DateMapper.toString((Date)validUntil)));
                } else {
                    elements.add(Restrictions.le((String)"TRANSACTIONDATE", (String)DateMapper.toString((Date)validUntil)));
                }
            }
        } else {
            Set set = FinancialYear.getOIDListOfPreviousFinYears((FinancialYear)financialYear);
            if (validUntil != null) {
                String[] oidFinYears;
                if (useDocumentDate) {
                    elements.add(Restrictions.le((String)"DOCUMENTDATE", (String)DateMapper.toString((Date)validUntil)));
                    oidFinYears = new String[set.size()];
                    set.toArray(oidFinYears);
                    elements.add(Restrictions.in((String)"OIDFINANCIALYEAR", (String[])oidFinYears));
                } else {
                    set.remove(financialYear.getObjectid());
                    oidFinYears = new String[set.size()];
                    set.toArray(oidFinYears);
                    Disjunction disjunction = Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.in((String)"OIDFINANCIALYEAR", (String[])oidFinYears), Restrictions.and((Criterion)Restrictions.le((String)"TRANSACTIONDATE", (String)DateMapper.toString((Date)validUntil)), (Criterion)Restrictions.eq((String)"OIDFINANCIALYEAR", (String)financialYear.getObjectid()))});
                    elements.add((Criterion)disjunction);
                }
            }
        }
        if (validFrom != null) {
            if (useDocumentDate) {
                elements.add(Restrictions.ge((String)"DOCUMENTDATE", (String)DateMapper.toString((Date)validFrom)));
            } else {
                elements.add(Restrictions.ge((String)"TRANSACTIONDATE", (String)DateMapper.toString((Date)validFrom)));
            }
        }
        if (analCodesFilter != null) {
            elements.add(analCodesFilter);
        }
        String[] groupBy = new String[]{"debit"};
        String[] fields = new String[]{"mTotalamount", "mSeccurr1Amount", "mSeccurr2Amount", "mSeccurr3Amount", "mSeccurr4Amount", "mDebit", "mQuantity"};
        SelectGenerator generator = new SelectGenerator("nlentry_t", attributes, null, (Criterion)elements, groupBy, false, BalanceDisplayRow.class, fields);
        return (BalanceDisplayRow[])generator.select();
    }

    public static Balances getBalances(NominalLedgerItem[] nlItem, AccountingCompany company, boolean withoutCarryOver, boolean withoutClosingBalances, ICurrency currency, FinancialYear finYear, Date fromDate, Date untilDate, AccountingBudget budget, BigDecimal conversionRate, boolean isOtherCurrency, Criterion analCodesFilter, boolean readOnly, boolean useDocumentDate) {
        BigDecimal openingBalance = BigDecimalMapper.ZERO;
        BigDecimal debit = BigDecimalMapper.ZERO;
        BigDecimal credit = BigDecimalMapper.ZERO;
        BigDecimal balance = BigDecimalMapper.ZERO;
        BigDecimal quantityDebit = BigDecimalMapper.ZERO;
        BigDecimal quantityCredit = BigDecimalMapper.ZERO;
        FinanceSetup financeSetup = company.getFinanceSetup();
        FinanceSetup.FinanceCurrencyType currencyType = !isOtherCurrency ? financeSetup.getCurrencyType(currency) : FinanceSetup.FinanceCurrencyType.NO_FINANCE_CURRENCY;
        for (int i = 0; i < nlItem.length; ++i) {
            BalanceSum balanceSumTemp2;
            BalanceSum balanceSum2;
            BigDecimal temp;
            BalanceSum balanceSum1;
            NLAccountCompanySetting companySetting = ((NominalLedgerAccount)nlItem[i]).getNLAccountCompanySetting(company);
            boolean isBalanceSheetAccount = true;
            if (companySetting.getNominalLedgerItem().getAccountType() == AccountType.PROFIT || companySetting.getNominalLedgerItem().getAccountType() == AccountType.LOSS) {
                isBalanceSheetAccount = false;
            }
            if (budget != null) {
                AccountingBudgetRow budgetRow = budget.getAccountingBudgetRow(companySetting);
                if (budgetRow == null) continue;
                BigDecimal nlSingleItemBalanceBudget = BigDecimalMapper.ZERO;
                nlSingleItemBalanceBudget = budgetRow.getAccountingBudgetRowValue(withoutCarryOver, currency, fromDate, untilDate, analCodesFilter, readOnly, useDocumentDate);
                balance = balance.add(nlSingleItemBalanceBudget);
                continue;
            }
            BankAccount bankAccount = null;
            if (isOtherCurrency) {
                bankAccount = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccountByControlAccount(companySetting);
            }
            if (!isBalanceSheetAccount || withoutCarryOver) {
                BalanceSum balanceSumTemp;
                if (bankAccount != null) {
                    if (analCodesFilter == null && !useDocumentDate) {
                        balanceSum1 = BankAccountBalanceManager.getBalanceChangesForYear((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)fromDate, (Date)untilDate, (boolean)readOnly);
                        if (financeSetup.getWithOpeningAndClosingEntries() && !withoutClosingBalances && untilDate.equals(finYear.getYearEndDate())) {
                            balanceSum1 = balanceSum1.add(BankAccountBalanceManager.getClosingEntryBalanceForYear((BankAccount)bankAccount, (FinancialYear)finYear, (ICurrency)currency, (boolean)readOnly));
                        }
                    } else {
                        balanceSum1 = BankAccountBalanceManager.getBalanceChangesForYearByTransactions((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)fromDate, (Date)untilDate, (Criterion)analCodesFilter, (boolean)useDocumentDate);
                    }
                    debit = debit.add(balanceSum1.getQuantityDebit());
                    credit = credit.add(balanceSum1.getQuantityCredit());
                    balance = balance.add(balanceSum1.getQuantityBalance());
                    continue;
                }
                if (analCodesFilter == null && !useDocumentDate) {
                    balanceSumTemp = companySetting.getBalanceChangesForYear(finYear, currency, fromDate, untilDate);
                    if (financeSetup.getWithOpeningAndClosingEntries() && !withoutClosingBalances && untilDate.equals(finYear.getYearEndDate())) {
                        balanceSumTemp = balanceSumTemp.add(NLAccountBalanceManager.getClosingEntryBalanceForYear(companySetting, finYear, currency, readOnly));
                    }
                    balanceSum1 = isOtherCurrency ? balanceSumTemp : NLAccountBalanceManager.convertBalanceSumToBaseCurrency(balanceSumTemp, currency, currencyType);
                } else {
                    balanceSumTemp = NLAccountBalanceManager.getBalanceChangesForYearByTransactions(companySetting, currency, finYear, fromDate, untilDate, analCodesFilter, useDocumentDate);
                    balanceSum1 = NLAccountBalanceManager.convertBalanceSumToBaseCurrency(balanceSumTemp, currency, currencyType);
                }
                if (isOtherCurrency) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getForeignAmountDebit())) {
                        debit = debit.add(balanceSum1.getForeignAmountDebit());
                    }
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getForeignAmountCredit())) {
                        credit = credit.add(balanceSum1.getForeignAmountCredit());
                    }
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getForeignBalance())) continue;
                    balance = balance.add(balanceSum1.getForeignBalance());
                    continue;
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getAmountDebit())) {
                    debit = debit.add(balanceSum1.getAmountDebit());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getAmountCredit())) {
                    credit = credit.add(balanceSum1.getAmountCredit());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getBalance())) {
                    balance = balance.add(balanceSum1.getBalance());
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getQuantityDebit())) {
                    quantityDebit = quantityDebit.add(balanceSum1.getQuantityDebit());
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)balanceSum1.getQuantityCredit())) continue;
                quantityCredit = quantityCredit.add(balanceSum1.getQuantityCredit());
                continue;
            }
            if (bankAccount != null) {
                if (analCodesFilter == null && !useDocumentDate) {
                    balanceSum1 = BankAccountBalanceManager.getCurrentBalance((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)untilDate, (boolean)readOnly);
                    if (financeSetup.getWithOpeningAndClosingEntries() && !withoutClosingBalances && untilDate.equals(finYear.getYearEndDate())) {
                        balanceSum1 = balanceSum1.add(BankAccountBalanceManager.getClosingEntryBalanceForYear((BankAccount)bankAccount, (FinancialYear)finYear, (ICurrency)currency, (boolean)readOnly));
                    }
                } else {
                    balanceSum1 = BankAccountBalanceManager.getCurrentBalanceByTransactions((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)untilDate, (Criterion)analCodesFilter, (boolean)useDocumentDate);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(temp = balanceSum1.getQuantityBalance())) && temp.scale() > 3) {
                    temp = temp.setScale(3, RoundingMode.HALF_DOWN);
                }
                balance = balance.add(temp);
            } else {
                if (analCodesFilter == null && !useDocumentDate) {
                    BalanceSum balanceSumTemp1 = NLAccountBalanceManager.getCurrentBalance(companySetting, finYear, currency, untilDate, readOnly);
                    if (financeSetup.getWithOpeningAndClosingEntries() && !withoutClosingBalances && untilDate.equals(finYear.getYearEndDate())) {
                        balanceSumTemp1 = balanceSumTemp1.add(NLAccountBalanceManager.getClosingEntryBalanceForYear(companySetting, finYear, currency, readOnly));
                    }
                    balanceSum1 = NLAccountBalanceManager.makeBalanceSum(balanceSumTemp1, currencyType, currency);
                } else {
                    balanceSum1 = NLAccountBalanceManager.getCurrentBalanceByTransactions(companySetting, currency, finYear, untilDate, analCodesFilter, useDocumentDate);
                }
                balance = balance.add(balanceSum1.getBalance());
            }
            if (bankAccount != null) {
                balanceSum2 = fromDate.equals(finYear.getValidFrom()) ? (analCodesFilter == null ? BankAccountBalanceManager.getStartBalanceForYear((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (boolean)readOnly) : BankAccountBalanceManager.getStartBalanceForYearByTransactions((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Criterion)analCodesFilter)) : (analCodesFilter == null && !useDocumentDate ? BankAccountBalanceManager.getCurrentBalance((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)DateHelper.yesterday((Date)fromDate), (boolean)readOnly) : BankAccountBalanceManager.getCurrentBalanceByTransactions((BankAccount)bankAccount, (ICurrency)currency, (FinancialYear)finYear, (Date)DateHelper.yesterday((Date)fromDate), (Criterion)analCodesFilter, (boolean)useDocumentDate));
                if (financeSetup.getWithOpeningAndClosingEntries() && company.getPreviousFinancialYear(finYear) != null && company.getPreviousFinancialYear(finYear).getCloseMark()) {
                    BalanceSum tempBalSum = BankAccountBalanceManager.getOpeningEntryBalanceForYear((BankAccount)bankAccount, (FinancialYear)finYear, (ICurrency)currency, (boolean)readOnly);
                    openingBalance = isOtherCurrency ? tempBalSum.getForeignBalance() : tempBalSum.getBalance();
                    if (!fromDate.equals(finYear.getValidFrom())) {
                        BalanceSum balanceChanges = companySetting.getBalanceChangesForYear(finYear, currency, finYear.getValidFrom(), DateHelper.yesterday((Date)fromDate));
                        openingBalance = isOtherCurrency ? openingBalance.add(balanceChanges.getForeignBalance()) : openingBalance.add(balanceChanges.getBalance());
                    }
                    balanceSum1 = balanceSum1.subtract(tempBalSum);
                }
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(temp = balanceSum2.getQuantityBalance())) && temp.scale() > 3) {
                    temp = temp.setScale(3, RoundingMode.HALF_DOWN);
                }
                openingBalance = openingBalance.add(temp);
                debit = debit.add(balanceSum1.getQuantityDebit().subtract(balanceSum2.getQuantityDebit()));
                credit = credit.add(balanceSum1.getQuantityCredit().subtract(balanceSum2.getQuantityCredit()));
                continue;
            }
            if (fromDate.equals(finYear.getValidFrom())) {
                if (analCodesFilter == null) {
                    balanceSumTemp2 = NLAccountBalanceManager.getStartBalanceForYear(companySetting, finYear, readOnly);
                    balanceSum2 = NLAccountBalanceManager.makeBalanceSum(balanceSumTemp2, currencyType, currency);
                } else {
                    balanceSum2 = NLAccountBalanceManager.getStartBalanceForYearByTransactions(companySetting, currency, finYear, analCodesFilter);
                }
            } else if (analCodesFilter == null && !useDocumentDate) {
                balanceSumTemp2 = NLAccountBalanceManager.getCurrentBalance(companySetting, finYear, currency, DateHelper.yesterday((Date)fromDate), readOnly);
                balanceSum2 = NLAccountBalanceManager.makeBalanceSum(balanceSumTemp2, currencyType, currency);
            } else {
                balanceSum2 = NLAccountBalanceManager.getCurrentBalanceByTransactions(companySetting, currency, finYear, DateHelper.yesterday((Date)fromDate), analCodesFilter, useDocumentDate);
            }
            if (financeSetup.getWithOpeningAndClosingEntries() && company.getPreviousFinancialYear(finYear) != null && company.getPreviousFinancialYear(finYear).getCloseMark()) {
                BalanceSum openingBalanceSumTemp = NLAccountBalanceManager.getOpeningEntryBalanceForYear(companySetting, finYear, currency, readOnly);
                BalanceSum openingBalanceSum = NLAccountBalanceManager.makeBalanceSum(openingBalanceSumTemp, currencyType, currency);
                openingBalance = openingBalanceSum.getBalance();
                if (!fromDate.equals(finYear.getValidFrom())) {
                    BalanceSum balanceChangesTemp = NLAccountBalanceManager.getBalanceChangesForYear(companySetting, finYear, currency, finYear.getValidFrom(), DateHelper.yesterday((Date)fromDate));
                    BalanceSum balanceChanges = NLAccountBalanceManager.makeBalanceSum(balanceChangesTemp, currencyType, currency);
                    openingBalance = openingBalance.add(balanceChanges.getBalance());
                }
                balanceSum1 = balanceSum1.subtract(openingBalanceSum);
            }
            openingBalance = BigDecimalMapper.add((BigDecimal)openingBalance, (BigDecimal)balanceSum2.getBalance());
            debit = debit.add(balanceSum1.getAmountDebit().subtract(balanceSum2.getAmountDebit()));
            credit = credit.add(balanceSum1.getAmountCredit().subtract(balanceSum2.getAmountCredit()));
            quantityDebit = quantityDebit.add(balanceSum1.getQuantityDebit().subtract(balanceSum2.getQuantityDebit()));
            quantityCredit = quantityCredit.add(balanceSum1.getQuantityCredit().subtract(balanceSum2.getQuantityCredit()));
        }
        Balances balances = new Balances();
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)conversionRate) && !isOtherCurrency) {
            balances.openingBalance = openingBalance.multiply(conversionRate);
            balances.debit = debit.multiply(conversionRate);
            balances.credit = credit.multiply(conversionRate);
            balances.balance = balances.openingBalance.add(balances.debit).subtract(balances.credit);
        } else {
            balances.openingBalance = openingBalance;
            balances.debit = debit;
            balances.credit = credit;
            balances.balance = balance;
        }
        if (currencyType != null) {
            if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_1_CURRENCY) {
                balances.sec1OpeningBalance = balances.openingBalance;
                balances.sec1Debit = balances.debit;
                balances.sec1Credit = balances.credit;
                balances.sec1Balance = balances.balance;
            } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_2_CURRENCY) {
                balances.sec2OpeningBalance = balances.openingBalance;
                balances.sec2Debit = balances.debit;
                balances.sec2Credit = balances.credit;
                balances.sec2Balance = balances.balance;
            } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_3_CURRENCY) {
                balances.sec3OpeningBalance = balances.openingBalance;
                balances.sec3Debit = balances.debit;
                balances.sec3Credit = balances.credit;
                balances.sec3Balance = balances.balance;
            } else if (currencyType == FinanceSetup.FinanceCurrencyType.SECONDARY_4_CURRENCY) {
                balances.sec4OpeningBalance = balances.openingBalance;
                balances.sec4Debit = balances.debit;
                balances.sec4Credit = balances.credit;
                balances.sec4Balance = balances.balance;
            }
        }
        balances.quantityDebit = quantityDebit;
        balances.quantityCredit = quantityCredit;
        return balances;
    }

    public static BalanceSum[] getBalanceChangesForYearByTransactionsAndCurr(NLAccountCompanySetting account, FinancialYear financialYear, Date fromDate, Date untilDate, Criterion analCodesFilter) {
        BalanceDisplayRow[] values = NLAccountBalanceManager.getBalanceDisplayRowsByTransactionAndCurr(account, financialYear, fromDate, untilDate, analCodesFilter);
        ArrayList<BalanceSum> list = new ArrayList<BalanceSum>();
        BalanceSum balanceSum = null;
        String oidEnteredCurr = "";
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].mOIDEnteredCurrency.equals(oidEnteredCurr)) {
                if (i > 0) {
                    list.add(balanceSum);
                }
                ICurrency currency = CurrencyPersistencyManager.getCurrency((String)values[i].mOIDEnteredCurrency);
                balanceSum = account.getForeignCurrency() == null ? new BalanceSum(currency) : new BalanceSum(currency, account.getForeignCurrency());
                oidEnteredCurr = values[i].mOIDEnteredCurrency;
            }
            if (values[i].mDebit) {
                balanceSum.setAmountDebit(values[i].mBaseamount);
                balanceSum.setNetAmountDebit(values[i].mEnteredamount);
                continue;
            }
            balanceSum.setAmountCredit(values[i].mBaseamount);
            balanceSum.setNetAmountCredit(values[i].mEnteredamount);
        }
        if (balanceSum != null) {
            list.add(balanceSum);
        }
        BalanceSum[] result = new BalanceSum[list.size()];
        list.toArray(result);
        return result;
    }

    private static BalanceDisplayRow[] getBalanceDisplayRowsByTransactionAndCurr(NLAccountCompanySetting account, FinancialYear financialYear, Date validFrom, Date validUntil, Criterion analCodesFilter) {
        LOGGER.debug("BankAccountBalanceManager - getBaseCurrencyBalancesByTransaction");
        String[] attributes = new String[]{"sum(totalamount)", "sum(enteredamount)", "sum(baseamount)", "debit", "oidenteredcurrency"};
        String view = "nlentry_t";
        Conjunction elements = Restrictions.conjunction();
        elements.add(Restrictions.eq((String)"OIDACCOUNT", (String)account.getObjectid()));
        elements.add(Restrictions.eq((String)"ISUNFINISHED", (String)BooleanMapper.toString((boolean)false)));
        elements.add(Restrictions.eq((String)"ISCONSOLITRANS", (String)BooleanMapper.toString((boolean)false)));
        elements.add(Restrictions.eq((String)"OIDFINANCIALYEAR", (String)financialYear.getObjectid()));
        if (validFrom != null) {
            elements.add(Restrictions.ge((String)"TRANSACTIONDATE", (String)DateMapper.toString((Date)validFrom)));
        }
        if (validUntil != null) {
            elements.add(Restrictions.le((String)"TRANSACTIONDATE", (String)DateMapper.toString((Date)validUntil)));
        }
        if (analCodesFilter != null) {
            elements.add(analCodesFilter);
        }
        Order[] sortBy = new Order[]{Order.asc((String)"OIDENTEREDCURRENCY")};
        String[] groupBy = new String[]{"debit", "oidenteredcurrency"};
        String[] fields = new String[]{"mTotalamount", "mEnteredamount", "mBaseamount", "mDebit", "mOIDEnteredCurrency"};
        SelectGenerator generator = new SelectGenerator("nlentry_t", attributes, sortBy, (Criterion)elements, groupBy, false, BalanceDisplayRow.class, fields);
        return (BalanceDisplayRow[])generator.select();
    }

    private static BalanceSum makeBalanceSum(BalanceSum balanceSumTemp, FinanceSetup.FinanceCurrencyType currencyType, ICurrency currency) {
        BalanceSum result;
        if (currencyType == FinanceSetup.FinanceCurrencyType.NO_FINANCE_CURRENCY) {
            result = balanceSumTemp;
            result.setAmountCredit(balanceSumTemp.getForeignAmountCredit());
            result.setAmountDebit(balanceSumTemp.getForeignAmountDebit());
        } else {
            result = NLAccountBalanceManager.convertBalanceSumToBaseCurrency(balanceSumTemp, currency, currencyType);
        }
        return result;
    }

    private static NLAccountCompanySetting[] getNLAccountCompanySettings(NominalLedger ledger, AccountingCompany company, AccountType type) {
        return NLAccountCompanySetting.convert((NLItemCompanySetting[])NLItemCompanySettingPersistencyManager.getNLAccountCompanySettings((NominalLedger)ledger, (AccountingCompany)company, (AccountType)type));
    }
}

