/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.nominalledger;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.nominalledger.NominalLedger;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerItemPersistencyManager;
import com.varial.accounting.domain.nominalledger.NominalLedgerTaxAccounts;
import com.varial.accounting.domain.nominalledger.TransitoryPresetType;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.persistency.nltaxaccounts.INltaxaccountsDao;
import com.varial.accounting.persistency.nltaxaccounts.NltaxaccountsContainer;
import com.varial.base.CacheUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.cache.Cache;
import com.varial.base.cache.CacheProvider;
import com.varial.base.persistency.IdentifiableBusinessObject;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.base.session.SessionContext;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sf.ehcache.Element;

public class NominalLedgerTaxAccountsPersistencyManager {
    private static final INltaxaccountsDao dao = (INltaxaccountsDao)UtilitiesManager.getBean((String)"nltaxaccountsDao", INltaxaccountsDao.class);
    private static final CacheProvider cacheManager = (CacheProvider)UtilitiesManager.getBean((String)"localCacheManager", CacheProvider.class);

    public static NominalLedgerTaxAccounts getNominalLedgerTaxAccounts(NominalLedger nominalLedger, TaxRate taxRate) {
        try {
            NominalLedgerTaxAccounts[] result = NominalLedgerTaxAccountsPersistencyManager.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"OIDTAXRATE", (String)taxRate.getObjectid()), (Criterion)Restrictions.eq((String)"OIDNOMINALLEDGER", (String)nominalLedger.getObjectid())), nominalLedger);
            if (result != null && result.length > 0) {
                return result[0];
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerTaxAccounts[] getNominalLedgerTaxAccounts(NominalLedger nl) {
        return NominalLedgerTaxAccountsPersistencyManager.query(null, Restrictions.eq((String)"OIDNOMINALLEDGER", (String)StringMapper.toString((String)nl.getObjectid())), nl);
    }

    public static NominalLedgerTaxAccounts[] getNominalLedgerTaxAccounts(NominalLedger nominalLedger, TaxRate[] taxRates) {
        if (taxRates == null || taxRates.length == 0) {
            return new NominalLedgerTaxAccounts[0];
        }
        HashMap<String, TaxRate> rateMap = new HashMap<String, TaxRate>();
        for (int i = 0; i < taxRates.length; ++i) {
            rateMap.put(taxRates[i].getObjectid(), taxRates[i]);
        }
        try {
            int MAX_OIDS_FOR_SELECT = 999;
            AtomicInteger counter = new AtomicInteger();
            Collection<List<TaxRate>> splits = Arrays.stream(taxRates).collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 999)).values();
            return (NominalLedgerTaxAccounts[])splits.stream().map(listOfTaxRate -> {
                Conjunction elements = Restrictions.conjunction();
                if (listOfTaxRate.size() == 1) {
                    elements.add(Restrictions.eq((String)"OIDTAXRATE", (String)((TaxRate)listOfTaxRate.get(0)).getObjectid()));
                } else if (!listOfTaxRate.isEmpty()) {
                    elements.add(Restrictions.in((String)"OIDTAXRATE", (Collection)listOfTaxRate.stream().map(IdentifiableBusinessObject::getObjectid).collect(Collectors.toList())));
                }
                NltaxaccountsContainer[] containers = dao.getRows(null, Restrictions.and((Criterion)elements, (Criterion)Restrictions.eq((String)"OIDNOMINALLEDGER", (String)nominalLedger.getObjectid())));
                List nominalLedgerTaxAccounts = Arrays.stream(containers).map(container -> {
                    TaxRate taxRate = (TaxRate)rateMap.get(container.oidtaxrate);
                    NominalLedgerTaxAccounts result = new NominalLedgerTaxAccounts(true, nominalLedger);
                    NominalLedgerTaxAccountsPersistencyManager.fillNominalLedgerTaxAccounts(result, container, taxRate);
                    return result;
                }).collect(Collectors.toList());
                return nominalLedgerTaxAccounts;
            }).flatMap(Collection::stream).toArray(NominalLedgerTaxAccounts[]::new);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static NominalLedgerTaxAccounts[] getNominalLedgerTaxAccounts(NominalLedger nominalLedger, JurisdictionType jurisdictionType, Date taxDate) {
        Criterion criterion = Restrictions.and((Criterion)Subqueries.in((String)"OIDTAXRATE", (SubSelect)new SubSelect("SELECT OBJECTID FROM TAXRATE_T", (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"JURISDICTION", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)jurisdictionType)), Restrictions.le((String)"VALIDFROM", (String)DateMapper.toString((Date)taxDate)), Restrictions.ge((String)"VALIDUNTIL", (String)DateMapper.toString((Date)taxDate))}))), (Criterion)Restrictions.eq((String)"oidnominalledger", (String)nominalLedger.getObjectid()));
        return NominalLedgerTaxAccountsPersistencyManager.query(null, criterion, nominalLedger);
    }

    private static NominalLedgerTaxAccounts[] query(Order[] order, Criterion criterion, NominalLedger nl) {
        try {
            NltaxaccountsContainer[] containers = dao.getRows(order, criterion);
            int count = containers.length;
            NominalLedgerTaxAccounts[] result = new NominalLedgerTaxAccounts[count];
            for (int i = 0; i < count; ++i) {
                result[i] = new NominalLedgerTaxAccounts(true, nl);
                NominalLedgerTaxAccountsPersistencyManager.fillNominalLedgerTaxAccounts(result[i], containers[i], null);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(NominalLedgerTaxAccounts tas) {
        NltaxaccountsContainer container;
        try {
            container = dao.getRowByObjectID(tas.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)tas.getObjectid());
        }
        NominalLedgerTaxAccountsPersistencyManager.fillNominalLedgerTaxAccounts(tas, container, null);
    }

    public static void save(NominalLedgerTaxAccounts tas) {
        NltaxaccountsContainer container = dao.getInitializedInstance();
        NominalLedgerTaxAccountsPersistencyManager.fillContainer(container, tas);
        try {
            container = tas.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        tas.setObjectid(container.getObjectid());
        tas.setTimestamp(container.getObjectTS());
        tas.setLastuser(container.getLastUserid());
        tas.setVersion(container.getVersion());
    }

    public static void delete(NominalLedgerTaxAccounts tas) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), tas.getObjectid(), tas.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean usedInChartOfAccounts(TaxCode taxCode) {
        try {
            long count = dao.getRowCount(Subqueries.in((String)"OIDTAXRATE", (SubSelect)new SubSelect("SELECT OBJECTID FROM TAXRATE_T", Restrictions.eq((String)"OIDTAXCODE", (String)taxCode.getObjectid()))));
            return count != 0L;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static boolean usedInChartOfAccounts(TaxRate taxRate) {
        try {
            long count = dao.getRowCount(Restrictions.eq((String)"OIDTAXRATE", (String)taxRate.getObjectid()));
            return count != 0L;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static void fillNominalLedgerTaxAccounts(NominalLedgerTaxAccounts tas, NltaxaccountsContainer container, TaxRate taxRate) {
        NominalLedgerAccount inputTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidinputtaxacc)) {
            inputTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidinputtaxacc);
        }
        NominalLedgerAccount notDueInputTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidinputnotdueacc)) {
            notDueInputTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidinputnotdueacc);
        }
        NominalLedgerAccount outputTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidoutputtaxacc)) {
            outputTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidoutputtaxacc);
        }
        NominalLedgerAccount notDueOutputTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidoutputnotdueacc)) {
            notDueOutputTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidoutputnotdueacc);
        }
        NominalLedgerAccount ritenutaTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidritenutataxacc)) {
            ritenutaTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidritenutataxacc);
        }
        NominalLedgerAccount outputTaxPrepaymentAccount = null;
        if (!StringMapper.isNullString((String)container.oidoutputtaxpreacc)) {
            outputTaxPrepaymentAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidoutputtaxpreacc);
        }
        NominalLedgerAccount inputTaxPrepaymentAccount = null;
        if (!StringMapper.isNullString((String)container.oidinputtaxpreacc)) {
            inputTaxPrepaymentAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidinputtaxpreacc);
        }
        NominalLedgerAccount transitoryRevenueAccount = null;
        if (!StringMapper.isNullString((String)container.oidtransrevenue)) {
            transitoryRevenueAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidtransrevenue);
        }
        NominalLedgerAccount transitoryPurchaseAccount = null;
        if (!StringMapper.isNullString((String)container.oidtranspurchase)) {
            transitoryPurchaseAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidtranspurchase);
        }
        NominalLedgerAccount salesNationalAccount = null;
        if (!StringMapper.isNullString((String)container.oidsalesnationacc)) {
            salesNationalAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidsalesnationacc);
        }
        NominalLedgerAccount notDueRitenutaTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidnotduerittaxacc)) {
            notDueRitenutaTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidnotduerittaxacc);
        }
        if (taxRate == null) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)container.oidtaxrate);
        }
        NominalLedgerAccount nonDeductibleInputTaxAccount = null;
        if (!StringMapper.isNullString((String)container.oidnondeducttaxacc)) {
            nonDeductibleInputTaxAccount = NominalLedgerItemPersistencyManager.getNominalLedgerAccount((String)container.oidnondeducttaxacc);
        }
        tas.setData(taxRate, inputTaxAccount, outputTaxAccount, notDueInputTaxAccount, notDueOutputTaxAccount, ritenutaTaxAccount, notDueRitenutaTaxAccount, outputTaxPrepaymentAccount, inputTaxPrepaymentAccount, transitoryRevenueAccount, transitoryPurchaseAccount, salesNationalAccount, (TransitoryPresetType)PersistableEnumUtils.toEnum(TransitoryPresetType.class, (int)container.transitorypreset), nonDeductibleInputTaxAccount);
        tas.setObjectid(container.getObjectid());
        tas.setTimestamp(container.getObjectTS());
        tas.setLastuser(container.getLastUserid());
        tas.setVersion(container.getVersion());
    }

    private static void fillContainer(NltaxaccountsContainer container, NominalLedgerTaxAccounts tas) {
        container.oidtaxrate = tas.getTaxRate().getObjectid();
        container.oidnominalledger = tas.getNominalLedger().getObjectid();
        container.oidinputtaxacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getInputTaxAccount());
        container.oidoutputtaxacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getOutputTaxAccount());
        container.oidinputnotdueacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getNotDueInputTaxAccount());
        container.oidoutputnotdueacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getNotDueOutputTaxAccount());
        container.oidritenutataxacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getRitenutaTaxAccount());
        container.oidnotduerittaxacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getNotDueRitenutaTaxAccount());
        container.oidoutputtaxpreacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getOutputTaxPrepaymentAccount());
        container.oidinputtaxpreacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getInputTaxPrepaymentAccount());
        container.oidtransrevenue = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getTransitoryRevenueAccount());
        container.oidtranspurchase = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getTransitoryPurchaseAccount());
        container.oidsalesnationacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getSalesNationalAccount());
        container.transitorypreset = PersistableEnumUtils.toPersistentValue((PersistableEnum)tas.getTransitoryPresetType());
        container.oidnondeducttaxacc = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)tas.getNonDeductibleInputTaxAccount());
        container.setObjectid(tas.getObjectid());
        container.setObjectTS(tas.getTimestamp());
        container.setLastUserid(tas.getLastuser());
        container.setVersion(tas.getVersion());
    }

    public static NominalLedgerTaxAccounts getNominalLedgerTaxAccountsWithCache(String objectid, NominalLedger nominalLedger) {
        NominalLedgerTaxAccounts result;
        Cache cache = cacheManager.getCache(NominalLedgerTaxAccounts.CLASSNAME);
        IPersistentObject po = CacheUtil.value((Element)cache.get((Object)objectid));
        if (po == null) {
            result = new NominalLedgerTaxAccounts(objectid, nominalLedger);
            cache.put(CacheUtil.element((IPersistentObject)result));
        } else {
            result = (NominalLedgerTaxAccounts)po;
        }
        return result;
    }
}

