/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.keyperformanceindicators;

import com.varial.accounting.accountingbudget.PlanMethodEnum;
import com.varial.accounting.domain.accountingbudget.AccountingBudget;
import com.varial.accounting.domain.accountingbudget.AccountingBudgetPersistencyManager;
import com.varial.accounting.domain.balancereport.BalanceReportForm;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialPeriod;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.financialyear.FinancialYearPersistencyManager;
import com.varial.accounting.domain.keyperformanceindicators.KPIExceptionMapper;
import com.varial.accounting.domain.keyperformanceindicators.KPIFormulaComp;
import com.varial.accounting.domain.keyperformanceindicators.KPIFormulaData;
import com.varial.accounting.domain.keyperformanceindicators.KPIFormulaDataPersistencyManager;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariableAccount;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariableAccountPersistencyManager;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariablePersistencyManager;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariableType;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariableVal;
import com.varial.accounting.domain.keyperformanceindicators.KPIVariableValPersistencyManager;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerItem;
import com.varial.accounting.domain.nominalledger.balance.Balances;
import com.varial.accounting.domain.nominalledger.balance.NLAccountBalanceManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.interfaces.ICurrency;
import com.varial.interfaces.IPayrollCompany;
import com.varial.interfaces.factory.PayrollCompanyFactory;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.language.LocalizedStringStruct;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.application.localizedstring.ILocalizedString;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedString;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedStringContainer;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedStringContainerHolder;
import com.varial.serverbase.persistency.application.localizedstring.LocalizedStringMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class KPIVariable
extends PersistentObject
implements LocalizedStringContainerHolder {
    private static final int PRIORITY = 1;
    protected static final String CLASSNAME = BalanceReportForm.class.getName();
    protected static final String LS_VIEWNAME = "KPIVARIABLELS_T";
    private LocalizedStringContainer mDescription;
    private String mCode;
    private String mNote;
    private KPIVariableType mVariableType;
    private KPIVariableAccount[] mKpiVariableAccounts;

    public KPIVariable() {
        super(1);
    }

    KPIVariable(String objectid) {
        super(1, objectid);
    }

    public KPIVariable(String objectid, int version) {
        super(1, objectid, version);
    }

    public KPIVariable(boolean readonly) {
        super(1, readonly);
    }

    protected void check() throws BusinessDomainException {
        LocalizedString[] ls;
        if (StringMapper.isNullString((String)this.mCode)) {
            throw KPIExceptionMapper.makeCodeMissingDomainException();
        }
        char[] code = this.mCode.toCharArray();
        for (int i = 0; i < code.length; ++i) {
            if (Character.isLetterOrDigit(code[i]) || code[i] == '_') continue;
            throw KPIExceptionMapper.makeCodeNotValidDomainException((char)code[i]);
        }
        boolean descriptionFilled = false;
        if (this.getLocalizedStringContainer() != null && (ls = this.getLocalizedStringContainer().getLocalizedStrings()) != null && ls.length > 0) {
            for (int i = 0; i < ls.length; ++i) {
                if (StringMapper.isNullString((String)ls[i].getText())) continue;
                descriptionFilled = true;
                break;
            }
        }
        if (!descriptionFilled) {
            throw KPIExceptionMapper.makeDescriptionMissingDomainException();
        }
    }

    public LocalizedStringContainer getLocalizedStringContainer() {
        if (this.mDescription == null) {
            this.mDescription = new LocalizedStringContainer((IPersistentObject)this, LS_VIEWNAME);
        }
        return this.mDescription;
    }

    public PersistentObject getAsPersistentObject() {
        return this;
    }

    protected void load() {
        KPIVariablePersistencyManager.load((KPIVariable)this);
    }

    protected void saveImpl() throws BusinessDomainException {
        KPIVariablePersistencyManager.save((KPIVariable)this);
    }

    protected void deleteImpl() {
        KPIVariablePersistencyManager.delete((KPIVariable)this);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return null;
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.mDescription != null) {
            this.mDescription.unregister();
        }
    }

    public void setCode(String code) {
        this.protocol("code", this.mCode, code);
        this.mCode = code;
    }

    public String getCode() {
        this.requireLoaded();
        return this.mCode;
    }

    public void setNote(String note) {
        this.protocol("note", this.mNote, note);
        this.mNote = note;
    }

    public String getNote() {
        this.requireLoaded();
        return this.mNote;
    }

    public KPIVariableType getVariableType() {
        this.requireLoaded();
        return this.mVariableType;
    }

    public void setVariableType(KPIVariableType variableType) {
        this.mVariableType = variableType;
    }

    protected void setData(String code, String note, KPIVariableType variableType) {
        this.mCode = code;
        this.mNote = note;
        this.mVariableType = variableType;
    }

    public void setKpiVariableAccounts(KPIVariableAccount[] kpiVariableAccounts) {
        this.protocol("kpiVariableAccounts", "old", "new");
        this.mKpiVariableAccounts = kpiVariableAccounts;
    }

    public KPIVariableAccount[] getKpiVariableAccounts() {
        if (this.mKpiVariableAccounts == null) {
            if (!this.isNew()) {
                KPIVariableAccountPersistencyManager.fillAccounts((KPIVariable)this);
            }
            if (this.mKpiVariableAccounts == null) {
                this.mKpiVariableAccounts = new KPIVariableAccount[0];
            }
        }
        return this.mKpiVariableAccounts;
    }

    public NominalLedgerAccount[] getAccounts(String oidNominalLedger) {
        ArrayList<NominalLedgerAccount> result = new ArrayList<NominalLedgerAccount>();
        for (KPIVariableAccount account : this.getKpiVariableAccounts()) {
            if (!account.getNLAccount().getNominalLedger().getObjectid().equals(oidNominalLedger)) continue;
            result.add(account.getNLAccount());
        }
        return result.toArray(new NominalLedgerAccount[result.size()]);
    }

    public String getDescription(Language language) {
        return this.getLocalizedStringContainer().getString((ILanguage)language);
    }

    public void setDescriptions(LocalizedStringStruct[] strings) throws BusinessDomainException {
        this.protocol("descriptions", "old", "new");
        LocalizedStringMapper.toContainer((LocalizedStringStruct[])strings, (LocalizedStringContainer)this.getLocalizedStringContainer());
    }

    public ILocalizedString[] getLocalizedDescriptions() {
        return this.getLocalizedStringContainer().getLocalizedStrings();
    }

    public static KPIVariable makeACopy(String sourceOID, String newCode) {
        KPIVariable sourceKPIVariable = KPIVariablePersistencyManager.getKPIVariable((String)sourceOID);
        KPIVariable targetKPIVariable = new KPIVariable();
        targetKPIVariable.setData(newCode, sourceKPIVariable.getNote(), sourceKPIVariable.getVariableType());
        int accCount = sourceKPIVariable.getKpiVariableAccounts().length;
        KPIVariableAccount[] accounts = new KPIVariableAccount[accCount];
        for (int index = 0; index < accCount; ++index) {
            accounts[index] = KPIVariableAccount.makeACopy((KPIVariableAccount)sourceKPIVariable.getKpiVariableAccounts()[index], (KPIVariable)targetKPIVariable);
        }
        targetKPIVariable.setKpiVariableAccounts(accounts);
        return targetKPIVariable;
    }

    public static void calculate(String oidFinYear, String oidBudget, KPIFormulaComp ... kpiFormulaComps) {
        FinancialYear finYear = FinancialYearPersistencyManager.getFinancialYear((String)oidFinYear);
        AccountingBudget budget = oidBudget == null || oidBudget.isEmpty() ? null : AccountingBudgetPersistencyManager.getAccountingBudget((String)oidBudget);
        KPIVariable.calculate(finYear, budget, kpiFormulaComps);
    }

    public static void calculate(FinancialYear finYear, AccountingBudget budget, KPIFormulaComp ... kpiFormulaComps) {
        if (kpiFormulaComps.length == 0) {
            return;
        }
        Set usedKPIVariables = KPIFormulaComp.getUsedKPIVariablen((KPIFormulaComp[])kpiFormulaComps);
        AccountingCompany company = kpiFormulaComps[0].getCompany();
        ICurrency currency = kpiFormulaComps[0].getCompany().getFinanceSetup().getBaseCurrency();
        for (KPIVariable kpiVariable : usedKPIVariables) {
            FinancialPeriod[] periods;
            List<NominalLedgerItem> accounts = KPIVariable.getUsedAccounts(kpiVariable, company.getObjectid());
            KPIVariable.calculate(finYear, null, null, company, currency, kpiVariable, accounts, false);
            if (budget != null) {
                KPIVariable.calculate(finYear, null, budget, company, currency, kpiVariable, accounts, false);
            }
            for (FinancialPeriod period : periods = finYear.getFinancialPeriodDistribution().getFinancialPeriods()) {
                KPIVariable.calculate(finYear, period, null, company, currency, kpiVariable, accounts, false);
                if (budget == null) continue;
                KPIVariable.calculate(finYear, period, budget, company, currency, kpiVariable, accounts, false);
            }
        }
        for (KPIFormulaComp kpiFormulaComp : kpiFormulaComps) {
            KPIFormulaData formulaDataValue = KPIFormulaDataPersistencyManager.getKPIFormulaData((boolean)false, (String)kpiFormulaComp.getObjectid(), (String)finYear.getObjectid(), null);
            if (formulaDataValue == null) {
                formulaDataValue = new KPIFormulaData();
            }
            formulaDataValue.setData(kpiFormulaComp, finYear, null, new Date());
            if (budget == null) continue;
            KPIFormulaData formulaDataBudget = KPIFormulaDataPersistencyManager.getKPIFormulaData((boolean)false, (String)kpiFormulaComp.getObjectid(), (String)finYear.getObjectid(), (String)budget.getObjectid());
            if (formulaDataBudget == null) {
                formulaDataBudget = new KPIFormulaData();
            }
            formulaDataBudget.setData(kpiFormulaComp, finYear, budget, new Date());
        }
    }

    public static List<NominalLedgerItem> getUsedAccounts(KPIVariable kpiVariable, String oidCompany) {
        String oidNomLedger = AccountingCompanyPersistencyManager.getAccountingCompany((String)oidCompany).getFinanceSetup().getNominalLedger().getObjectid();
        ArrayList<NominalLedgerItem> accounts = new ArrayList<NominalLedgerItem>();
        for (KPIVariableAccount kpiAccount : kpiVariable.getKpiVariableAccounts()) {
            if (!kpiAccount.getNLAccount().getNominalLedger().getObjectid().equals(oidNomLedger)) continue;
            accounts.add((NominalLedgerItem)kpiAccount.getNLAccount());
        }
        return accounts;
    }

    public static KPIVariableVal calculate(FinancialYear finYear, FinancialPeriod finPeriod, AccountingBudget budget, AccountingCompany company, ICurrency currency, KPIVariable kpiVariable, List<NominalLedgerItem> accounts, boolean dontSaveToDB) {
        String oidFinPeriod;
        Date untilDate;
        Date fromDate;
        boolean isForMonth = true;
        String oidBudget = budget == null ? null : budget.getObjectid();
        KPIVariableType variableType = kpiVariable.getVariableType();
        if (finPeriod == null) {
            fromDate = finYear.getValidFrom();
            untilDate = finYear.getYearEndDate();
            oidFinPeriod = null;
            isForMonth = false;
            if (budget != null && budget.getPlanMethod() == PlanMethodEnum.PM_BALANCES) {
                untilDate = finYear.getValidUntil();
            }
        } else {
            fromDate = finPeriod.getValidFrom();
            untilDate = finPeriod.getValidUntil();
            oidFinPeriod = finPeriod.getObjectid();
        }
        Balances balances = new Balances();
        if (variableType == KPIVariableType.EMPLOYEE) {
            balances = KPIVariable.makeEmployeeNumbers(finYear, budget, company, fromDate, isForMonth);
        } else if (variableType != KPIVariableType.NONE) {
            for (NominalLedgerItem nominalLedgerItem : accounts) {
                Balances accBalances = NLAccountBalanceManager.getBalances(new NominalLedgerItem[]{nominalLedgerItem}, company, false, false, currency, finYear, fromDate, untilDate, budget, null, false, null, true, false);
                if (nominalLedgerItem.getSwitchOver()) {
                    if (variableType == KPIVariableType.ASSET && accBalances.balance.signum() > 0) {
                        balances.add(accBalances);
                        continue;
                    }
                    if (variableType != KPIVariableType.LIABILITY || accBalances.balance.signum() >= 0) continue;
                    balances.add(accBalances);
                    continue;
                }
                balances.add(accBalances);
            }
        } else {
            balances = NLAccountBalanceManager.getBalances(accounts.toArray(new NominalLedgerItem[accounts.size()]), company, false, false, currency, finYear, fromDate, untilDate, budget, null, false, null, true, false);
        }
        KPIVariableVal kpiVariableVal = KPIVariableValPersistencyManager.getKPIVariableVal((boolean)dontSaveToDB, (String)kpiVariable.getObjectid(), (String)company.getObjectid(), (String)finYear.getObjectid(), (String)oidFinPeriod, (String)oidBudget);
        if (kpiVariableVal == null) {
            kpiVariableVal = dontSaveToDB ? new KPIVariableVal(true) : new KPIVariableVal();
        }
        kpiVariableVal.setData(kpiVariable, company, finYear, finPeriod, budget, balances.balance, balances.sec1Balance, balances.sec2Balance, balances.sec3Balance, balances.sec4Balance);
        return kpiVariableVal;
    }

    private static Balances makeEmployeeNumbers(FinancialYear finYear, AccountingBudget budget, AccountingCompany company, Date fromDate, boolean isForMonth) {
        Date untilDateUntil = finYear.getValidUntil();
        String objectid = company.getObjectid();
        IPayrollCompany payrollCompany = PayrollCompanyFactory.getFactory().getPayrollCompany(objectid);
        int numberEmployees = 0;
        if (payrollCompany != null) {
            numberEmployees = isForMonth ? (fromDate.after(untilDateUntil) ? payrollCompany.getNumberOfActivelyEmployedEmployees(untilDateUntil) : payrollCompany.getNumberOfActivelyEmployedEmployees(fromDate)) : payrollCompany.getNumberOfActivelyEmployedEmployees(untilDateUntil);
        }
        Balances balances = new Balances();
        BigDecimal numberOfEmployees = BigDecimal.valueOf(numberEmployees);
        if (budget != null) {
            numberOfEmployees = BigDecimal.valueOf(0L);
        }
        balances.balance = numberOfEmployees;
        balances.netBalance = numberOfEmployees;
        balances.sec1Balance = numberOfEmployees;
        balances.sec2Balance = numberOfEmployees;
        balances.sec3Balance = numberOfEmployees;
        balances.sec4Balance = numberOfEmployees;
        balances.sec1NetBalance = numberOfEmployees;
        balances.sec2NetBalance = numberOfEmployees;
        balances.sec3NetBalance = numberOfEmployees;
        balances.sec4NetBalance = numberOfEmployees;
        return balances;
    }
}

