/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.globaljournal.report;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.batch.BatchPersistencyManager;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialPeriod;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.globaljournal.GlobalFinalJournal;
import com.varial.accounting.domain.globaljournal.GlobalFinalJournalReportFlags;
import com.varial.accounting.domain.globaljournal.GlobalJournalExceptionMapper;
import com.varial.accounting.domain.globaljournal.GlobalJournalHelper;
import com.varial.accounting.domain.globaljournal.GlobalJournalPresetData;
import com.varial.accounting.domain.globaljournal.GlobalJournalPrintNameType;
import com.varial.accounting.domain.globaljournal.GlobalJournalSortType;
import com.varial.accounting.domain.globaljournal.GlobalJournalSortTypeMapper;
import com.varial.accounting.domain.globaljournal.JournalTransactionStateMapper;
import com.varial.accounting.domain.globaljournal.JournalTransactionStateType;
import com.varial.accounting.domain.globaljournal.report.GlobalJournalReportContainer;
import com.varial.accounting.domain.globaljournal.report.OiAllocationSubReportDataSource;
import com.varial.accounting.domain.roughbookandjournal.CostingSplitSubReportDataSource;
import com.varial.accounting.persistency.nlacctransact.NlacctransactContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.dao.dcp.DataSourceFieldAccessor;
import com.varial.dao.dcp.JRDataSourceWithRawValue;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.company.CompanyExceptionMapper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.isoftware.ConfidentialStateLovat;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.printservice.RegionalSettingManager;
import com.varial.framework.domain.reports.JasperReportDataSourceBase;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.SimplePeriod;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalJournalReportDataSource
extends JasperReportDataSourceBase
implements JRDataSourceWithRawValue {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)GlobalJournalReportDataSource.class.getName());
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    public static final String PROPKEY_SOFTWARENAME = "com.varial.reports.SoftwareName";
    private final GlobalJournalPresetData mPreset;
    private final PersistencyDataSet mDataset;
    private final int mDatasetLength;
    private final AccountingCompany mCompany;
    private FinancialYear mFinancialYear;
    private final BigDecimalFormatter mBigDecimalFormatter;
    private final ICurrency mCurrency;
    private final CurrencyType mCurrencyType;
    private NlacctransactContainer mNlacctransactContainer;
    private GlobalJournalReportContainer mContainer;
    private int mContainerCounter = 0;
    private long mInternalRowCounter;
    private int mRowsProcessed = 0;
    private final boolean mIsFinalPrint;
    private GlobalFinalJournal[] mFinalJournals;
    private GlobalFinalJournalReportFlags mGlobalFinalJournalReportFlags;
    private BigDecimal mTotalDebit;
    private BigDecimal mTotalCredit;
    private long mFirstJournalRowNumber;
    private int mFirstPageNumber;
    private final boolean mIsPrintBatch;
    private Batch mBatch;
    private final boolean mIsMigration;
    private final RegionalSettingManager mRegionalSettingManager;
    private final boolean mITSpecials;
    private JurisdictionType mJurisdictionType;
    private final SimplePeriod mReportPeriod;
    private boolean mIsSpecialJournalPrintsForKronospanPL;
    private final FinancialPeriod mFinancialPeriod;
    private final String mSTATICTEXT_MessageForClient;
    private final String mSTATICTEXT_Note;
    private final String mSTATICTEXT_SeveralContraAccounts;
    private final String mSTATICTEXT_ConversionRate;
    public static final String P_FORMATTER = "P_Formatter";
    public static final String P_COMPANYSHORT = "P_CompanyShort";
    public static final String P_PRINTDATE = "P_PrintDate";
    public static final String P_PRINTTIME = "P_PrintTime";
    public static final String P_USER = "P_User";
    public static final String P_PERIOD = "P_Period";
    public static final String P_ISDONEORPROVISIONALASSTRING = "P_IsDoneOrProvisionalAsString";
    public static final String P_YEAR = "P_Year";
    public static final String P_DAY = "P_Day";
    public static final String P_SORTTYPE = "P_SortType";
    public static final String P_WITHCOSTINGSPLIT = "P_WithCostingSplit";
    public static final String P_ISTRANSACTIONREPORT = "P_IsTransactionReport";
    public static final String P_TAXNUMBER = "P_Taxnumber";
    public static final String P_CURRENCY = "P_Currency";
    public static final String P_WITHJOURNALNO = "P_WithJournalNo";
    public static final String P_FOOTNOTE = "P_FootNote";
    public static final String P_ISDONEREPORT = "P_IsDoneReport";
    public static final String P_TRANSACIONSTATE = "P_TransactionState";
    public static final String P_WITHNOTES = "P_WithNotes";
    public static final String P_STARTDEBIT = "P_StartDebit";
    public static final String P_STARTCREDIT = "P_StartCredit";
    public static final String P_STARTPAGENUMBER = "P_StartPageNumber";
    private static final String P_GLOBALFINALJOURNALREPORTFLAGS = "P_GlobalFinalJournalReportFlags";
    public static final String P_ITSPECIALS = "P_ITSpecials";
    public static final String P_PRINTACCOUNTGROUPS = "P_PrintAccountGroups";
    public static final String P_CODICEFISCALE = "P_CodiceFiscale";
    public static final String P_JOURNALFORYEAR = "P_JournalForYear";
    public static final String S_COMPANY = "S_Company";
    public static final String S_PRINTDATE = "S_PrintDate";
    public static final String S_TITLE = "S_Title";
    public static final String S_PAGE = "S_Page";
    public static final String S_PERIOD = "S_Period";
    public static final String S_USER = "S_User";
    public static final String S_ISDONE = "S_IsDone";
    public static final String S_ISPROVISIONAL = "S_IsProvisional";
    public static final String S_TOTAL = "S_Total";
    public static final String S_GRANDTOTAL = "S_GrandTotal";
    public static final String S_YEAR = "S_Year";
    public static final String S_DAY = "S_Day";
    public static final String S_CARRYFORWARD = "S_CarryForward";
    public static final String S_CARRYOVER = "S_CarryOver";
    public static final String S_CONVERSIONRATE = "S_ConversionRate";
    public static final String S_SORTTYPE = "S_SortType";
    public static final String S_NOTE = "S_Note";
    public static final String S_COSTCENTRES = "S_CostCentres";
    public static final String S_COSTUNITS = "S_CostUnits";
    public static final String S_TAXNUMBER = "S_Taxnumber";
    public static final String S_CURRENCY = "S_Currency";
    public static final String S_CODICEFISCALE = "S_CodiceFiscale";
    public static final String S_DEBIT_SHORT = "S_Debit_Short";
    public static final String S_CREDIT_SHORT = "S_Credit_Short";
    public static final String S_TITLE1 = "S_Title1";
    public static final String S_YEAR1 = "S_Year1";
    public static final String S_CURRENCY1 = "S_Currency1";
    public static final String S_PAGE1 = "S_Page1";
    public static final String S_TRANSACIONSTATE = "S_TransactionState";
    private static final int COMPANY = 0;
    private static final int PRINTDATE = 1;
    private static final int TITLE = 2;
    private static final int PAGE = 3;
    private static final int PERIOD = 4;
    private static final int USER = 5;
    private static final int ISDONE = 6;
    private static final int ISPROVISIONAL = 7;
    private static final int TOTAL = 8;
    private static final int GRANDTOTAL = 9;
    private static final int YEAR = 10;
    private static final int DAY = 11;
    private static final int CARRYFORWARD = 12;
    private static final int CARRYOVER = 13;
    private static final int CONVERSIONRATE = 14;
    private static final int SORTTYPE = 15;
    private static final int NOTE = 16;
    private static final int COSTCENTRES_STATIC = 17;
    private static final int COSTUNITS_STATIC = 18;
    private static final int PROGRMESSAGE_GETDATA = 19;
    private static final int BATCH = 20;
    private static final int CREATOR = 21;
    private static final int TAXNUMBER = 22;
    private static final int CURRENCY = 23;
    private static final int CREATIONDATE = 24;
    private static final int CODICEFISCALE = 25;
    private static final int DEBIT_SHORT = 26;
    private static final int CREDIT_SHORT = 27;
    private static final int TITLE1 = 28;
    private static final int YEAR1 = 29;
    private static final int CURRENCY1 = 30;
    private static final int PAGE1 = 31;
    private static final int TRANSACIONSTATE = 32;
    private static final int SEVERALCONTRAACCOUNTS = 33;
    private static final int CARRYFORWARD_KRONOSPAN = 34;
    private static final int CARRYOVER_KRONOSPAN = 35;
    private static final int SEVERALCONTRAACCOUNTS_KRONOSPAN = 36;
    private static TranslateableResourceList mGlobalJournalReportList = TranslateableResourceList.createTranslateableResourceList("GlobalJournalReportList", new String[]{"Company", "Print Date", "Global Journal", "Page", "Period", "User", "Done", "Provisional", "Total", "Grand Total", "Year", "Day", "Carry Forward", "Carry Over", "Conversion Rate", "Sort Type", "Note", "Cost Centres", "Cost Units", "Collecting Data...", "Batch", "Created from", "Taxnumber", "Currency", "Crated am", "Codice fiscale", "D", "C", "LIBRO GIORNALE", "Anno", "Divisa", "pagina", "Transaction State", "Mehrere", "Z przeniesienia", "Do przeniesienia", "BRAK"});
    public static final String H_SEQUENCENUMBER = "H_SequenceNumber";
    public static final String H_TRANSACTIONDATE = "H_TransactionDate";
    public static final String H_DOCUMENTDATE = "H_DocumentDate";
    public static final String H_REFERENCENUMBER = "H_ReferenceNumber";
    public static final String H_ACCOUNTCODE = "H_AccountCode";
    public static final String H_NAME = "H_Name";
    public static final String H_SHORTNAME = "H_ShortName";
    public static final String H_DESCRIPTION = "H_Description";
    public static final String H_CONTRAACCOUNT = "H_ContraAccount";
    public static final String H_TAXCODE = "H_TaxCode";
    public static final String H_DEBIT = "H_Debit";
    public static final String H_CREDIT = "H_Credit";
    public static final String H_TRANSACTIONTYPE = "H_TransactionType";
    public static final String H_ROWNUMBER = "H_RowNumber";
    public static final String H_CONTROLACCOUNT = "H_ControlAccount";
    public static final String H_JOURNALNUMBER = "H_JournalNumber";
    public static final String H_TAXREGISTERNUMBER = "H_TaxRegisterNumber";
    public static final String H_ACCOUNTGROUP_ACCOUNTCODE = "H_AccountGroup_AccountCode";
    public static final String H_COSTINGSPLIT = "H_CostingSplit";
    public static final String H_OIALLOCATION = "H_OiAllocation";
    public static final String H_TRANSACTIONDATE1 = "H_TransactionDate1";
    public static final String H_DOCUMENTDATE1 = "H_DocumentDate1";
    public static final String H_IMPORTO = "H_Importo";
    public static final String H_REMARKS = "H_Remarks";
    public static final String H_ROWNUMBER1 = "H_RowNumber1";
    public static final String H_TRANSACTIONDATE2 = "H_TransactionDate2";
    public static final String H_TRANSACTIONTYPE1 = "H_TransactionType1";
    public static final String H_ACCOUNTCODE1 = "H_AccountCode1";
    public static final String H_SHORTNAME1 = "H_ShortName1";
    public static final String H_DOCUMENTDATE2 = "H_DocumentDate2";
    public static final String H_REFERENCENUMBER1 = "H_ReferenceNumber1";
    public static final String H_SEQUENCENUMBER1 = "H_SequenceNumber1";
    public static final String H_JOURNALNUMBER1 = "H_JournalNumber1";
    public static final String H_FOREIGNORIGINALAMOUNT = "H_ForeignOriginalAmount";
    public static final String H_USEROFPOSTING = "H_User";
    public static final String H_CREATIONDATE = "H_CreationDate";
    public static final String H_DELIVERYDATE = "H_DeliveryDate";
    public static final String H_FOREIGNCURRENCY = "H_ForeignCurrency";
    private static final int SEQUENCENUMBER = 0;
    private static final int TRANSACTIONDATE = 1;
    private static final int DOCUMENTDATE = 2;
    private static final int REFERENCENUMBER = 3;
    private static final int ACCOUNTCODE = 4;
    private static final int SHORTNAME = 5;
    private static final int DESCRIPTION = 6;
    private static final int CONTRAACCOUNT = 7;
    private static final int TAXCODE = 8;
    private static final int DEBIT = 9;
    private static final int CREDIT = 10;
    private static final int TRANSACTIONTYPE = 11;
    private static final int ROWNUMBER = 12;
    private static final int CONTROLACCOUNT = 13;
    private static final int JOURNALNUMBER = 14;
    private static final int NAME = 15;
    private static final int TAXREGISTERNUMBER = 16;
    private static final int ACCOUNTGROUP_ACCOUNTCODE = 17;
    private static final int COSTINGSPLIT = 18;
    private static final int OIALLOCATION = 19;
    private static final int TRANSACTIONDATE1 = 20;
    private static final int DOCUMENTDATE1 = 21;
    private static final int IMPORTO = 22;
    private static final int REMARKS = 23;
    private static final int ROWNUMBER1 = 24;
    private static final int TRANSACTIONDATE2 = 25;
    private static final int TRANSACTIONTYPE1 = 26;
    private static final int ACCOUNTCODE1 = 27;
    private static final int SHORTNAME1 = 28;
    private static final int DOCUMENTDATE2 = 29;
    private static final int REFERENCENUMBER1 = 30;
    private static final int SEQUENCENUMBER1 = 31;
    private static final int JOURNALNUMBER1 = 32;
    private static final int FOREIGNORIGINALAMOUNT = 33;
    private static final int USEROFPOSTING = 34;
    private static final int DATEOFCREATION = 35;
    private static final int FOREIGNCURRENCY = 36;
    private static final int DATEOFDELIVERY = 37;
    private static final int JOURNALNUMBER_KRONOSPAN = 38;
    private static final int ACCOUNTNAME_KRONOSPAN = 39;
    private static final int CONTRAACCOUNT_KRONOSPAN = 40;
    private static final int DESCRIPTION_KRONOSPAN = 41;
    private static TranslateableResourceList mGlobalJournalReportHeaderList = TranslateableResourceList.createTranslateableResourceList("GlobalJournalReportHeaderList", new String[]{"Sequence Number", "Transaction Date", "Document Date", "Reference Number", "Account Code", "Short Name", "Description", "Contra Account", "Tax Code", "Debit", "Credit", "Transaction Type", "Row Number", "Control Account", "Journal Number", "Name", "Numero registro", "Account Group Account Code", "Costing Split", "Open Item Allocation", "Transaction Date", "Document Date", "Importo", "Remarks", "Riga", "Data reg.", "Causale", "Cod. conto", "Descrizione / ragione sociale", "Data doc.", "Num. doc.", "Protocollo", "Bereichsjournal Nr.", "Foreign original amount", "Uzytkownik", "Date of Creation", "Kod waluty", "Data operacji gosp.", "Nr dziennika", "Opis konta", "Konto przeciwstawne", "Opis operacji"});
    public static final String F_SEQUENCENUMBER = "F_SequenceNumber";
    public static final String F_TRANSACTIONDATE = "F_TransactionDate";
    public static final String F_DOCUMENTDATE = "F_DocumentDate";
    public static final String F_REFERENCENUMBER = "F_ReferenceNumber";
    public static final String F_ACCOUNTCODE = "F_AccountCode";
    public static final String F_SHORTNAME = "F_ShortName";
    public static final String F_DESCRIPTION = "F_Description";
    public static final String F_CONTRAACCOUNT = "F_ContraAccount";
    public static final String F_CONTROLACCOUNT = "F_ControlAccount";
    public static final String F_TAXCODE = "F_TaxCode";
    public static final String F_DEBITAMOUNT = "F_DebitAmount";
    public static final String F_CREDITAMOUNT = "F_CreditAmount";
    public static final String F_TRANSACTIONGROUP = "F_TransactionGroup";
    public static final String F_TRANSACTIONTYPE = "F_TransactionType";
    public static final String F_MONTHYEAR = "F_MonthYear";
    public static final String F_ROWNUMBER = "F_RowNumber";
    public static final String F_DUMMY = "F_Dummy";
    public static final String F_JOURNALNUMBER = "F_JournalNumber";
    public static final String F_JOURNALNUMBER1 = "F_JournalNumber1";
    public static final String F_GLOBALJOURNALNUMBER = "F_GlobalJournalNumber";
    public static final String F_TAXREGISTERNUMBER = "F_TaxRegisterNumber";
    public static final String F_FOREIGNCURRENCYCODE = "F_ForeignCurrencyCode";
    public static final String F_FOREIGNORIGINALAMOUNT = "F_ForeignOriginalAmount";
    public static final String F_CONVERSIONRATE = "F_ConversionRate";
    public static final String F_ISDEBIT = "F_IsDebit";
    public static final String F_TRANSACTIONNOTE = "F_TransactionNote";
    public static final String F_OIDJOURNAL = "F_OidJournal";
    public static final String F_OIDTRANSACTION = "F_OidTransaction";
    public static final String F_SUBREPORTCOSTINGSPLITDATASOURCE = "F_SubReportCostingSplitDataSource";
    public static final String F_SUBREPORTOIALLOCATIONDATASOURCE = "F_SubReportOiAllocationDataSource";
    public static final String F_ARCHIVEKEYWORDS = "F_ArchiveKeywords";
    public static final String F_ACCOUNTGROUP = "F_AccountGroup";
    public static final String F_ACCOUNTGROUPSHORTNAME = "F_AccountGroupShortName";
    public static final String F_YEAR = "F_Year";
    public static final String F_USEROFPOSTING = "F_User";
    public static final String F_CREATIONDATE = "F_CreationDate";
    public static final String F_DELIVERYDATE = "F_DeliveryDate";
    private static final int NLTRANSACTIONS = 0;
    private static final int CASHTRANSACTIONS = 1;
    private static final int SALESTRANSACTIONS = 2;
    private static final int PURCHASETRANSACTIONS = 3;
    private static TranslateableResourceList mGlobalJournalReportSubHeaderList = TranslateableResourceList.createTranslateableResourceList("GlobalJournalReportSubHeaderList", new String[]{"N/L Transactions", "Cash Transactions", "Sales Transactions", "Purchase Transactions"});

    public GlobalJournalReportDataSource(PersistencyDataSet dataset, GlobalJournalPresetData preset, Language globalLanguage, Language selectedLanguage, int datasetLength, GlobalFinalJournal[] journals, GlobalFinalJournalReportFlags globalFinalJournalReportFlags, GlobalJournalHelper.GlobalJournalPrintTypeEnum printType, FinancialPeriod financialPeriod) throws BusinessDomainException {
        super(globalLanguage, selectedLanguage);
        this.mDataset = dataset;
        this.mDatasetLength = datasetLength;
        this.mPreset = preset;
        this.mIsFinalPrint = printType == GlobalJournalHelper.GlobalJournalPrintTypeEnum.JOURNAL_FINAL;
        this.mIsPrintBatch = printType == GlobalJournalHelper.GlobalJournalPrintTypeEnum.BATCH_ACCOUNTING || printType == GlobalJournalHelper.GlobalJournalPrintTypeEnum.BATCH_MIGRATION;
        this.mIsMigration = printType == GlobalJournalHelper.GlobalJournalPrintTypeEnum.BATCH_MIGRATION;
        this.mFinancialPeriod = financialPeriod;
        Date dateFrom = null;
        Date dateUntil = null;
        if (this.mIsFinalPrint) {
            if (journals == null || journals.length == 0) {
                throw GlobalJournalExceptionMapper.makeFinalJournalNotCreatedDomainException();
            }
            this.mFinalJournals = journals;
            this.mGlobalFinalJournalReportFlags = globalFinalJournalReportFlags;
            this.mCompany = this.mFinalJournals[0].getAccountingCompany();
            this.mFinancialYear = this.mFinalJournals[0].getFinancialYear();
            this.mJurisdictionType = this.mCompany.getJurisdictionType();
            this.mTotalCredit = this.mFinalJournals[0].getStartCredit();
            this.mTotalDebit = this.mFinalJournals[0].getStartDebit();
            this.mFirstJournalRowNumber = this.mFinalJournals[0].getFirstJournalRowNumber();
            this.mFirstPageNumber = this.mFinalJournals[0].getFirstPageNumber();
            this.mInternalRowCounter = this.mFirstJournalRowNumber - 1L;
            dateFrom = this.mFinalJournals[0].getFinancialPeriod().getValidFrom();
            dateUntil = this.mFinalJournals[this.mFinalJournals.length - 1].getFinancialPeriod().getValidUntil();
            if (ISoftware.getSpecialJournalPrintsForKronospanPL() && this.mJurisdictionType == JurisdictionType.PL) {
                this.mIsSpecialJournalPrintsForKronospanPL = true;
            }
        } else {
            this.mCompany = this.mPreset.getAccountingCompany();
            this.mJurisdictionType = this.mCompany.getJurisdictionType();
            if (this.mPreset.getFinancialYear() != null) {
                this.mFinancialYear = this.mPreset.getFinancialYear();
                dateFrom = this.mFinancialYear.getValidFrom();
                dateUntil = this.mFinancialYear.getValidUntil();
            }
            if (this.mPreset.getPeriodFrom() != null) {
                dateFrom = this.mPreset.getPeriodFrom();
            }
            if (this.mPreset.getPeriodUntil() != null) {
                dateUntil = this.mPreset.getPeriodUntil();
            }
            this.mBatch = null;
            if (!StringMapper.isNullString((String)this.mPreset.getPresetName())) {
                this.mBatch = BatchPersistencyManager.getBatch((String)this.mPreset.getPresetName());
            }
        }
        this.checkPreset();
        this.mReportPeriod = new SimplePeriod(dateFrom, dateUntil);
        if (this.mPreset.getCurrency() != null && !StringMapper.isNullString((String)this.mPreset.getCurrency().getObjectid())) {
            this.mCurrency = CurrencyPersistencyManager.getCurrency((String)this.mPreset.getCurrency().getObjectid());
            this.mCurrencyType = this.mCompany.getFinanceSetup().getBaseCurrencyType(this.mCurrency);
        } else {
            this.mCurrencyType = CurrencyType.BASE_CURRENCY;
            this.mCurrency = this.mCompany.getFinanceSetup().getBaseCurrency();
        }
        this.mBigDecimalFormatter = this.mSelectedLanguage.hasLocale() ? new BigDecimalFormatter(this.mSelectedLanguage.getLocale()) : new BigDecimalFormatter();
        this.mRegionalSettingManager = new RegionalSettingManager(null);
        this.mITSpecials = this.mIsFinalPrint && this.mJurisdictionType == JurisdictionType.IT;
        this.mSTATICTEXT_Note = mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 16) + ":";
        this.mSTATICTEXT_MessageForClient = mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 19);
        this.mSTATICTEXT_SeveralContraAccounts = ISoftware.getSpecialJournalPrintsForKronospanPL() && this.mJurisdictionType == JurisdictionType.PL ? mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 36) : mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 33);
        this.mSTATICTEXT_ConversionRate = mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 14);
    }

    private void checkPreset() throws BusinessDomainException {
        if (this.mCompany == null) {
            throw CompanyExceptionMapper.makeCompanyNotFoundException((String)"");
        }
        if (this.mIsPrintBatch && this.mBatch == null) {
            throw GlobalJournalExceptionMapper.makeMissingBatchDomainException();
        }
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        return this.getParameters(true);
    }

    public Map<String, Object> getRawParameters() throws BusinessDomainException {
        return this.getParameters(false);
    }

    public Map<String, Object> getParameters(boolean jasperiseFields) throws BusinessDomainException {
        Map parameters = super.getParameters(jasperiseFields);
        Object companyAddress = "";
        PostalAddress postalAddress = this.mCompany.getCurrentAddress().getPostalAddress();
        switch (this.mJurisdictionType) {
            case IT: {
                companyAddress = postalAddress.getName1() + "\n" + postalAddress.getStreet() + " " + postalAddress.getPostalCode() + " " + postalAddress.getTown();
                break;
            }
            case PL: {
                companyAddress = postalAddress.getName1() + "\n" + postalAddress.getTown();
                break;
            }
            default: {
                companyAddress = this.mCompany.getCurrentAddress().getShortName();
            }
        }
        parameters.put(P_COMPANYSHORT, companyAddress);
        parameters.put(P_PRINTDATE, this.mRegionalSettingManager.getDateByAccessMode(DateHelper.today(), jasperiseFields, this.mSelectedLanguage));
        parameters.put(P_PRINTTIME, VDate.getCurrentLocalizedTime());
        parameters.put(P_FORMATTER, this.mBigDecimalFormatter);
        if (!this.mIsPrintBatch) {
            parameters.put(P_PERIOD, this.buildPeriodString());
        }
        parameters.put(P_USER, SessionContext.getInstance().getSession().getUserCode());
        parameters.put(P_ISDONEORPROVISIONALASSTRING, this.getIsDoneOrProvisional());
        parameters.put(P_ISDONEREPORT, this.mIsFinalPrint);
        if (this.mFinancialYear != null) {
            parameters.put(P_YEAR, this.mFinancialYear.getCode());
            if (this.mITSpecials) {
                parameters.put(P_YEAR, this.mFinancialYear.getCalendarYear());
            }
        }
        parameters.put(P_DAY, this.buildDayString());
        parameters.put(P_STARTCREDIT, this.mCurrency.round(this.mTotalCredit));
        parameters.put(P_STARTDEBIT, this.mCurrency.round(this.mTotalDebit));
        parameters.put(P_STARTPAGENUMBER, this.mFirstPageNumber);
        if (!this.mIsPrintBatch) {
            parameters.put(P_SORTTYPE, GlobalJournalSortTypeMapper.toString((Language)this.mSelectedLanguage, (GlobalJournalSortType)this.mPreset.getGlobalJournalSortType()));
        }
        parameters.put(P_WITHCOSTINGSPLIT, this.mPreset.getWithCostingSplit());
        parameters.put(P_WITHJOURNALNO, this.mPreset.getWithJournalNo());
        parameters.put(P_ISTRANSACTIONREPORT, this.mPreset.getGlobalJournalSortType() == GlobalJournalSortType.TRANSACTION);
        if (this.mPreset.getTransactionState() != null && this.mPreset.getTransactionState() != JournalTransactionStateType.ALL) {
            parameters.put(P_TRANSACIONSTATE, JournalTransactionStateMapper.toString((Language)this.mSelectedLanguage, (JournalTransactionStateType)this.mPreset.getTransactionState()));
        }
        parameters.put(P_WITHNOTES, this.mPreset.getPrintNotes());
        parameters.put(P_ITSPECIALS, this.mITSpecials);
        parameters.put(P_JOURNALFORYEAR, this.mFinancialPeriod == null);
        parameters.put(P_PRINTACCOUNTGROUPS, this.mPreset.printNLGroups());
        String taxnumber = this.mCompany.getUKTaxNumber();
        if (this.mJurisdictionType == JurisdictionType.IT) {
            parameters.put(P_TAXNUMBER, taxnumber + "/ C.F.");
        } else {
            parameters.put(P_TAXNUMBER, taxnumber);
        }
        parameters.put(P_CURRENCY, this.mCurrency.getCode());
        parameters.put(P_GLOBALFINALJOURNALREPORTFLAGS, this.mGlobalFinalJournalReportFlags);
        parameters.put(P_CODICEFISCALE, this.mCompany.getCompanyNumber());
        parameters.put(S_CARRYFORWARD, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 12));
        parameters.put(S_COMPANY, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 0));
        parameters.put(S_DAY, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 11));
        parameters.put(S_GRANDTOTAL, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 9));
        parameters.put(S_ISDONE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 6));
        parameters.put(S_ISPROVISIONAL, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 7));
        parameters.put(S_PAGE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 3));
        if (!this.mIsPrintBatch) {
            parameters.put(S_PERIOD, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 4));
            if (ISoftware.getAlternativeGlobalFinalJournalIT() && this.mITSpecials && this.mFinancialYear != null && this.mPreset.getPeriodFrom() != null && this.mPreset.getPeriodUntil() != null) {
                Date validFrom = this.mPreset.getPeriodFrom();
                Date validUntil = this.mPreset.getPeriodUntil();
                if (DateHelper.equal((Date)validFrom, (Date)this.mFinancialYear.getValidFrom()) && DateHelper.equal((Date)validUntil, (Date)this.mFinancialYear.getYearEndDate())) {
                    parameters.put(P_PERIOD, this.mFinancialYear.getCalendarYear());
                    parameters.put(S_PERIOD, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 10));
                }
            }
        }
        parameters.put(S_PRINTDATE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 1));
        if (this.mIsPrintBatch) {
            parameters.put(S_TITLE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 20) + " " + this.mPreset.getPresetName() + "\n" + mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 21) + " " + this.mBatch.getCreator().getCode() + "\n" + mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 24) + ": " + DateMapper.toString((ILanguage)this.mSelectedLanguage, (Date)this.mBatch.getCreationDate()));
        } else {
            parameters.put(S_TITLE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 2) + " (" + this.getIsDoneOrProvisional() + ")");
        }
        parameters.put(S_TOTAL, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 8));
        parameters.put(S_USER, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 5));
        parameters.put(S_YEAR, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 10));
        parameters.put(S_CARRYOVER, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 13));
        if (!this.mIsPrintBatch) {
            parameters.put(S_SORTTYPE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 15));
        }
        parameters.put(S_COSTCENTRES, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 17));
        parameters.put(S_COSTUNITS, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 18));
        parameters.put(S_TAXNUMBER, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 22));
        parameters.put(S_CURRENCY, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 23));
        parameters.put(S_CODICEFISCALE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 25));
        parameters.put(S_DEBIT_SHORT, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 26));
        parameters.put(S_CREDIT_SHORT, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 27));
        parameters.put(S_TITLE1, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 28));
        parameters.put(S_YEAR1, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 29));
        parameters.put(S_CURRENCY1, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 30));
        parameters.put(S_PAGE1, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 31));
        if (this.mPreset.getTransactionState() != null && this.mPreset.getTransactionState() != JournalTransactionStateType.ALL) {
            parameters.put(S_TRANSACIONSTATE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 32));
        }
        parameters.put(H_ACCOUNTCODE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 4));
        parameters.put(H_ACCOUNTGROUP_ACCOUNTCODE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 17));
        parameters.put(H_CONTRAACCOUNT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 7));
        parameters.put(H_CREDIT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 10));
        parameters.put(H_DEBIT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 9));
        parameters.put(H_DESCRIPTION, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 6));
        if (ISoftware.isDPV() && (this.mJurisdictionType == JurisdictionType.IT || this.mJurisdictionType == JurisdictionType.ES)) {
            parameters.put(H_DESCRIPTION, "");
        }
        parameters.put(H_DOCUMENTDATE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 2));
        parameters.put(H_DOCUMENTDATE1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 21));
        parameters.put(H_REFERENCENUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 3));
        parameters.put(H_SEQUENCENUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 0));
        parameters.put(H_NAME, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 15));
        parameters.put(H_SHORTNAME, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 5));
        if (this.mPreset.getPrintNameType() != null && this.mPreset.getPrintNameType() == GlobalJournalPrintNameType.SHORTNAME) {
            parameters.put(H_SHORTNAME, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 5));
        }
        parameters.put(H_TAXCODE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 8));
        parameters.put(H_TRANSACTIONDATE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 1));
        parameters.put(H_TRANSACTIONDATE1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 20));
        parameters.put(H_TRANSACTIONTYPE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 11));
        if (ISoftware.getSpecialJournalPrintsForKronospanPL() && this.mJurisdictionType == JurisdictionType.PL) {
            parameters.put(H_ROWNUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 38));
            parameters.put(H_SHORTNAME, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 39));
            parameters.put(H_CONTRAACCOUNT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 40));
            parameters.put(H_DESCRIPTION, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 41));
            parameters.put(S_CARRYOVER, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 35));
            parameters.put(S_CARRYFORWARD, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 34));
            String softwareName = this.configuration.getString(PROPKEY_SOFTWARENAME);
            if (StringMapper.isNullString((String)softwareName)) {
                softwareName = "Infor Global Financials";
            }
            parameters.put("P_Release", (softwareName + " ").concat(Version.getVersion()));
        } else {
            parameters.put(H_ROWNUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 12));
        }
        parameters.put(H_CONTROLACCOUNT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 13));
        parameters.put(H_JOURNALNUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 14));
        if (ISoftware.isLovat()) {
            String confidentialState = ConfidentialStateLovat.getConfidentialState((String)"GlobalJournal");
            parameters.put(P_FOOTNOTE, confidentialState);
        }
        if (ISoftware.isKronospan() && this.mITSpecials) {
            parameters.put(H_TAXREGISTERNUMBER, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 16));
        }
        parameters.put(H_COSTINGSPLIT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 18));
        parameters.put(H_OIALLOCATION, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 19));
        parameters.put(H_IMPORTO, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 22));
        parameters.put(H_REMARKS, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 23));
        parameters.put(H_ROWNUMBER1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 24));
        parameters.put(H_TRANSACTIONDATE2, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 25));
        parameters.put(H_TRANSACTIONTYPE1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 26));
        parameters.put(H_ACCOUNTCODE1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 27));
        parameters.put(H_SHORTNAME1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 28));
        parameters.put(H_DOCUMENTDATE2, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 29));
        parameters.put(H_REFERENCENUMBER1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 30));
        parameters.put(H_SEQUENCENUMBER1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 31));
        parameters.put(H_JOURNALNUMBER1, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 32));
        parameters.put(S_CONVERSIONRATE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 14));
        parameters.put(S_NOTE, mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 16));
        parameters.put(H_FOREIGNORIGINALAMOUNT, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 33));
        parameters.put(H_USEROFPOSTING, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 34));
        parameters.put(H_CREATIONDATE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 35));
        parameters.put(H_DELIVERYDATE, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 37));
        parameters.put(H_FOREIGNCURRENCY, mGlobalJournalReportHeaderList.getString((ILanguage)this.mSelectedLanguage, 36));
        return parameters;
    }

    private String buildDayString() {
        String result = "";
        String from = "";
        String until = "";
        if (this.mPreset.getPeriodFrom() != null || this.mPreset.getPeriodUntil() != null) {
            from = DateMapper.toString((Date)this.mPreset.getPeriodFrom());
            until = DateMapper.toString((Date)this.mPreset.getPeriodUntil());
        } else {
            from = DateMapper.toString((Date)this.mFinalJournals[0].getFinancialPeriod().getValidFrom());
            until = DateMapper.toString((Date)this.mFinalJournals[this.mFinalJournals.length - 1].getFinancialPeriod().getValidUntil());
        }
        if (!StringMapper.isNullString((String)from) && !StringMapper.isNullString((String)until) && from.equals(until)) {
            result = DateMapper.toString((ILanguage)this.mSelectedLanguage, (Date)DateMapper.toDate((String)from));
        }
        return result;
    }

    private String buildPeriodString() {
        String dateFromString = "";
        String dateUntilString = "";
        if (this.mReportPeriod.getValidFrom() != null) {
            dateFromString = DateMapper.toString((ILanguage)this.mSelectedLanguage, (Date)this.mReportPeriod.getValidFrom());
        }
        if (this.mReportPeriod.getValidUntil() != null) {
            dateUntilString = DateMapper.toString((ILanguage)this.mSelectedLanguage, (Date)this.mReportPeriod.getValidUntil());
        }
        return dateFromString + " - " + dateUntilString;
    }

    private String buildTransactionGroupString() {
        String result = "";
        switch (this.mNlacctransactContainer.jourtransactgroup) {
            case 0: {
                result = mGlobalJournalReportSubHeaderList.getString((ILanguage)this.mSelectedLanguage, 0);
                break;
            }
            case 1: {
                result = mGlobalJournalReportSubHeaderList.getString((ILanguage)this.mSelectedLanguage, 1);
                break;
            }
            case 2: {
                result = mGlobalJournalReportSubHeaderList.getString((ILanguage)this.mSelectedLanguage, 2);
                break;
            }
            case 3: {
                result = mGlobalJournalReportSubHeaderList.getString((ILanguage)this.mSelectedLanguage, 3);
                break;
            }
        }
        return result;
    }

    private String getIsDoneOrProvisional() {
        if (this.mIsFinalPrint) {
            return mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 6);
        }
        return mGlobalJournalReportList.getString((ILanguage)this.mSelectedLanguage, 7);
    }

    public boolean next() throws JRException {
        boolean result = this.mDataset.hasNext();
        try {
            if (result) {
                this.mNlacctransactContainer = (NlacctransactContainer)this.mDataset.getNext();
                this.mContainer = new GlobalJournalReportContainer(this.mCompany, this.mNlacctransactContainer, this.mSelectedLanguage, this.mBigDecimalFormatter, this.mCurrencyType, this.mCurrency, this.mPreset.getJournalType(), this.mIsSpecialJournalPrintsForKronospanPL);
                ++this.mContainerCounter;
                ++this.mInternalRowCounter;
                this.mHasDataToPrint = true;
                if (this.mIsFinalPrint) {
                    this.addTotalSums(this.mContainer);
                }
                ++this.mRowsProcessed;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(field, true);
    }

    public Object getFieldRawValue(String fieldName) throws JRException {
        return this.getFieldValue((JRField)new DataSourceFieldAccessor(fieldName), false);
    }

    private Object getFieldValue(JRField field, boolean jasperiseFields) {
        Object value = null;
        if (this.mContainer != null) {
            try {
                if (F_ACCOUNTCODE.equals(field.getName())) {
                    value = this.mContainer.getAccountCode();
                } else if (F_CONTRAACCOUNT.equals(field.getName())) {
                    value = StringMapper.isNullString((String)this.mContainer.getContraAccount()) ? this.mSTATICTEXT_SeveralContraAccounts : this.mContainer.getContraAccount();
                } else if (F_CONTROLACCOUNT.equals(field.getName())) {
                    value = this.mContainer.getControlAccount();
                } else if (F_CREDITAMOUNT.equals(field.getName())) {
                    value = this.mCurrency.round(this.mContainer.getCreditAmount());
                } else if (F_DEBITAMOUNT.equals(field.getName())) {
                    value = this.mCurrency.round(this.mContainer.getDebitAmount());
                } else if (F_TRANSACTIONNOTE.equals(field.getName())) {
                    if (this.mPreset.getPrintNotes() && !StringMapper.isNullString((String)this.mContainer.getTransactionNote())) {
                        value = this.mContainer.getTransactionNote();
                    }
                } else if (F_DESCRIPTION.equals(field.getName())) {
                    value = this.mContainer.getDescription();
                    if (ISoftware.isDPV() && (this.mJurisdictionType == JurisdictionType.IT || this.mJurisdictionType == JurisdictionType.ES)) {
                        value = null;
                    }
                } else if (F_DOCUMENTDATE.equals(field.getName())) {
                    value = this.mContainer.getDocumentDate();
                } else if (F_REFERENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getReferenceNumber();
                } else if (F_SEQUENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getSequenceNumber();
                } else if (F_SHORTNAME.equals(field.getName())) {
                    if (this.mPreset.getPrintNameType() != null) {
                        switch (this.mPreset.getPrintNameType()) {
                            case SHORTNAME: {
                                value = this.mContainer.getShortName();
                                break;
                            }
                            case NAME: {
                                value = this.mContainer.getName();
                                break;
                            }
                            case NAME1: {
                                value = this.mContainer.getName1();
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (F_TAXCODE.equals(field.getName())) {
                    value = this.mContainer.getTaxCode();
                } else if (F_TRANSACTIONDATE.equals(field.getName())) {
                    value = this.mContainer.getTransactionDate();
                } else if (F_TRANSACTIONGROUP.equals(field.getName())) {
                    value = this.buildTransactionGroupString();
                } else if (F_TRANSACTIONTYPE.equals(field.getName())) {
                    value = this.mContainer.getTransactionType();
                } else if (F_MONTHYEAR.equals(field.getName())) {
                    value = this.mContainer.getMonthYear();
                } else if (F_ROWNUMBER.equals(field.getName())) {
                    value = Long.toString(this.mInternalRowCounter);
                } else if (F_JOURNALNUMBER.equals(field.getName())) {
                    value = this.mContainer.getJournalNumber();
                } else if (F_JOURNALNUMBER1.equals(field.getName())) {
                    value = this.mContainer.getJournalNumber1();
                } else if (F_GLOBALJOURNALNUMBER.equals(field.getName())) {
                    value = BigDecimalMapper.toString((BigDecimal)this.mContainer.getGlobalJournalNumber());
                } else if (F_TAXREGISTERNUMBER.equals(field.getName()) && this.mITSpecials && ISoftware.isKronospan()) {
                    value = this.mContainer.getTaxRegisterNumber();
                } else if (F_DUMMY.equals(field.getName())) {
                    value = this.mContainerCounter < this.mDatasetLength;
                } else if (F_FOREIGNCURRENCYCODE.equals(field.getName())) {
                    value = this.mContainer.getForeignCurrencyCode();
                } else if (F_FOREIGNORIGINALAMOUNT.equals(field.getName())) {
                    if (!BigDecimalMapper.isZero((BigDecimal)this.mContainer.getForeignOriginalAmount())) {
                        value = this.mCurrency.round(this.mContainer.getForeignOriginalAmount());
                    }
                } else if (F_CONVERSIONRATE.equals(field.getName())) {
                    if (!BigDecimalMapper.isZero((BigDecimal)this.mContainer.getConversionRate())) {
                        value = this.mContainer.getConversionRate();
                    }
                } else if (F_ISDEBIT.equals(field.getName())) {
                    value = this.mContainer.getIsDebit();
                } else if (F_OIDJOURNAL.equals(field.getName())) {
                    if (this.mFinalJournals != null && this.mFinalJournals.length != 0) {
                        value = this.mFinalJournals[0].getObjectid();
                    }
                } else if (F_SUBREPORTCOSTINGSPLITDATASOURCE.equals(field.getName())) {
                    if (this.mPreset.getWithCostingSplit() && !StringMapper.isNullString((String)this.mContainer.getOidActCosting())) {
                        value = this.getCostingSplitSubreportDataSource(this.mCurrency, this.mContainer.getOidActCosting());
                    }
                } else if (F_SUBREPORTOIALLOCATIONDATASOURCE.equals(field.getName())) {
                    if (this.mPreset.getGlobalJournalSortType() == GlobalJournalSortType.TRANSACTION && this.mContainer.getJourTransActGroup().value() == 1 && !StringMapper.isNullString((String)this.mNlacctransactContainer.oidpersonalacc)) {
                        value = this.getOiAllocationSubreportDataSource(this.mContainer.getOidNlEntry());
                    }
                } else if (F_OIDTRANSACTION.equals(field.getName())) {
                    value = this.mContainer.getOidTransaction();
                } else if (F_ARCHIVEKEYWORDS.equals(field.getName())) {
                    value = this.getArchiveKeywords();
                } else if (F_ACCOUNTGROUP.equals(field.getName())) {
                    value = this.mContainer.getAccountGroupCode();
                } else if (F_ACCOUNTGROUPSHORTNAME.equals(field.getName())) {
                    if (this.mPreset.getPrintNameType() != null) {
                        switch (this.mPreset.getPrintNameType()) {
                            case SHORTNAME: {
                                value = this.mContainer.getAccountGroupShortName();
                                break;
                            }
                            case NAME: {
                                value = this.mContainer.getAccountGroupName();
                                break;
                            }
                            case NAME1: {
                                value = this.mContainer.getAccountGroupName();
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (F_YEAR.equals(field.getName())) {
                    value = this.mITSpecials ? this.mContainer.getCalendarYear() : this.mContainer.getFinancialYearCode();
                } else if (F_USEROFPOSTING.equals(field.getName())) {
                    value = this.mContainer.getUserOfPosting();
                } else if (F_CREATIONDATE.equals(field.getName())) {
                    value = this.mContainer.getCreationDate();
                } else if (F_DELIVERYDATE.equals(field.getName())) {
                    value = this.mContainer.getDeliveryDate();
                } else if (S_NOTE.equals(field.getName())) {
                    if (this.mPreset.getPrintNotes() && !StringMapper.isNullString((String)this.mContainer.getTransactionNote())) {
                        value = this.mSTATICTEXT_Note;
                    }
                } else if (S_CONVERSIONRATE.equals(field.getName()) && !BigDecimalMapper.isZero((BigDecimal)this.mContainer.getForeignOriginalAmount())) {
                    value = this.mSTATICTEXT_ConversionRate;
                }
                if (jasperiseFields && value instanceof String) {
                    value = StringUtil.toJasperString((String)value);
                }
            }
            catch (Exception e) {
                throw ExceptionMapper.makeApplicationException((Throwable)e);
            }
        }
        return value;
    }

    private String getArchiveKeywords() throws BusinessDomainException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("C21003:");
        strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)DateHelper.today())).append(' ');
        strBuffer.append("C21004:");
        strBuffer.append(this.mCompany.getCode()).append(' ');
        strBuffer.append("C21005:");
        String financialYearCode = "";
        if (this.mFinancialYear != null) {
            financialYearCode = this.mFinancialYear.getCode();
        }
        strBuffer.append(financialYearCode).append(' ');
        strBuffer.append("C21015:");
        if (this.mReportPeriod.getValidFrom() != null) {
            strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mReportPeriod.getValidFrom())).append(' ');
        } else {
            strBuffer.append("").append(' ');
        }
        strBuffer.append("C21016:");
        if (this.mReportPeriod.getValidUntil() != null) {
            strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mReportPeriod.getValidUntil())).append(' ');
        } else {
            strBuffer.append("").append(' ');
        }
        strBuffer.append("C21040:");
        if (!this.mIsPrintBatch) {
            strBuffer.append(GlobalJournalReportDataSource.getReportType(this.mPreset)).append(' ');
        } else if (this.mIsMigration) {
            strBuffer.append(this.buildTransactionGroupString()).append(' ');
        }
        if (!this.mIsPrintBatch) {
            strBuffer.append("C21030:Gesamtjournal").append(' ');
        } else if (this.mIsMigration) {
            strBuffer.append("C21030:Stapel Uebernahme").append(' ');
        } else {
            strBuffer.append("C21030:Stapel").append(' ').append(this.mPreset.getPresetName()).append(' ');
        }
        strBuffer.append("C21017:");
        return strBuffer.toString();
    }

    public static String getReportType(GlobalJournalPresetData preset) {
        String result = "";
        if (preset != null) {
            switch (preset.getJournalType()) {
                case PROVISIONAL: {
                    result = "Vorlaeufig";
                    break;
                }
                case FINAL: {
                    result = "Endgueltig";
                    break;
                }
                case POSTINGCONTROL: {
                    result = "Buchungskontrolle";
                    break;
                }
            }
        }
        return result;
    }

    private CostingSplitSubReportDataSource getCostingSplitSubreportDataSource(ICurrency currency, String oidactcosting) {
        return new CostingSplitSubReportDataSource(currency, oidactcosting, this.getGlobalLanguage());
    }

    private OiAllocationSubReportDataSource getOiAllocationSubreportDataSource(String oidNlEntry) {
        return new OiAllocationSubReportDataSource(oidNlEntry, this.getGlobalLanguage());
    }

    private void addTotalSums(GlobalJournalReportContainer container) {
        this.mTotalCredit = this.mTotalCredit.add(container.getCreditAmount());
        this.mTotalDebit = this.mTotalDebit.add(container.getDebitAmount());
    }

    public BigDecimal getTotalAmountCredit() {
        return this.mTotalCredit;
    }

    public BigDecimal getTotalAmountDebit() {
        return this.mTotalDebit;
    }

    public Language getGlobalLanguage() {
        return this.mGlobalLanguage;
    }

    public int getRestRowCount() {
        return this.mDatasetLength - this.mRowsProcessed;
    }

    public boolean getHasDataToPrintBeforeRun() {
        return true;
    }

    public boolean getHasDataToPrintAfterRun() {
        return this.mHasDataToPrint;
    }
}

