/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.factoringheller;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.factoringbase.FactoringExceptionMapper;
import com.varial.accounting.domain.factoringbase.FactoringFieldDescription;
import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.factoringbase.FactoringTextField;
import com.varial.accounting.domain.factoringheller.FactoringHellerFieldDescriptionContainer;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemType;
import com.varial.accounting.domain.personalaccount.Customer;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.termsofpayment.IPaymentCondition;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.accounting.factoringheller.FactoringHellerPresetStruct;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.filter.ExtendedFilterHelper;
import com.varial.serverbase.extendedquery.ExtendedFilterStruct;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoringHellerHelper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)FactoringHellerHelper.class.getName());
    private static String rowSeparator = "\n";

    public static StringBuilder getOpenItemEntry(PersonalAccount pa, OpenItem oi, String companyNumber, ICurrency baseCurrency, List<FactoringFieldDescription> listFieldDescription, FactoringHellerFieldDescriptionContainer c, FactoringHellerPresetStruct struct, boolean cutReferenceNumberLeft) throws BusinessDomainException {
        LOGGER.debug("getOpenItemEntry parameters:");
        boolean isSimonFleisch = ISoftware.isSimonFleisch();
        StringBuilder result = new StringBuilder();
        String fieldName = "";
        int fieldLength = 0;
        boolean isAlphaNumeric = true;
        boolean isMandatory = false;
        ICurrency currency = oi.getEnteredCurrency();
        String taxAmount = "";
        if (oi.getFixTaxRate() != null) {
            taxAmount = ISoftware.getUseBaseAmountForFactoring() ? FactoringHelper.getFormatAmountWithComma((ICurrency)baseCurrency, (BigDecimal)oi.getBaseTaxAmount()) : FactoringHelper.getFormatAmountWithComma((ICurrency)currency, (BigDecimal)oi.getTaxAmount());
        }
        ITermOfPayment termOfPayment = oi.getTermOfPayment();
        IPaymentCondition paymentCondition = null;
        if (termOfPayment != null) {
            paymentCondition = termOfPayment.getStandardPaymentCondition();
        }
        CustSupAddress address = null;
        PostalAddress postalAddress = null;
        if (!pa.getOneOffAccount()) {
            address = pa.getAddress();
        } else if (pa.getDeviatingAddress() != null) {
            address = pa.getDeviatingAddress();
        }
        if (address != null) {
            postalAddress = address.getPostalAddress();
        }
        for (FactoringFieldDescription fd : listFieldDescription) {
            try {
                String ac0;
                fieldName = fd.getFieldName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("FieldName: " + fieldName);
                }
                fieldLength = fd.getfieldLength();
                isAlphaNumeric = fd.isAlphaNumeric();
                isMandatory = fd.isMandatory();
                String res = "";
                if (fieldName == c.DATEIKENNZEICHNUNG) {
                    res = "10";
                    if (struct.completeOIs) {
                        res = "20";
                    }
                } else if (fieldName == c.KONZERNNUMMER) {
                    res = FactoringHellerHelper.getConcernNummer(struct.type.value());
                } else if (fieldName == c.KUNDENNUMMER) {
                    res = companyNumber;
                } else if (fieldName == c.ABNEHMERNUMMER) {
                    res = pa.getCode();
                } else if (fieldName == c.ABNEHMER_KZ) {
                    res = "2";
                } else if (fieldName == c.RECHNUNGSNUMMER) {
                    res = oi.getReferenceNumber();
                    if (res.length() > 10 && cutReferenceNumberLeft) {
                        res = res.substring(res.length() - 10);
                    }
                } else if (fieldName == c.RECHNUNGSDATUM) {
                    res = DateMapper.toDDMMYYYYString((Date)oi.getDocumentDate());
                } else if (fieldName == c.VALUTADATUM) {
                    res = DateMapper.toDDMMYYYYString((Date)oi.getDocumentDate());
                    if (!DateHelper.equal((Date)oi.getDocumentDate(), (Date)oi.getValueDate())) {
                        res = DateMapper.toDDMMYYYYString((Date)oi.getValueDate());
                    }
                } else if (fieldName == c.RECHNUNGSBETRAG) {
                    res = struct.completeOIs ? (ISoftware.getUseBaseAmountForFactoring() ? FactoringHelper.getFormatAmountWithComma((ICurrency)baseCurrency, (BigDecimal)oi.getBaseOpenAmount()) : FactoringHelper.getFormatAmountWithComma((ICurrency)currency, (BigDecimal)oi.getOpenAmount())) : (ISoftware.getUseBaseAmountForFactoring() ? FactoringHelper.getFormatAmountWithComma((ICurrency)baseCurrency, (BigDecimal)oi.getBaseOriginalAmount()) : FactoringHelper.getFormatAmountWithComma((ICurrency)currency, (BigDecimal)oi.getOriginalAmount()));
                } else if (fieldName == c.RECHNUNGS_KZ) {
                    res = "+";
                    if (!oi.getIsDebit()) {
                        res = "-";
                    }
                } else if (fieldName == c.MWST_BETRAG) {
                    if (taxAmount != "") {
                        res = taxAmount;
                    }
                } else if (fieldName == c.ISO_WAEHRUNGCODE) {
                    res = ISoftware.getUseBaseAmountForFactoring() ? baseCurrency.getSwift() : currency.getSwift();
                } else if (fieldName == c.TERMCODE) {
                    if (isSimonFleisch && termOfPayment != null) {
                        res = termOfPayment.getCode();
                    }
                } else if (fieldName == c.NETTO_TAGE) {
                    if (paymentCondition != null) {
                        res = isSimonFleisch ? "" : String.valueOf(paymentCondition.getPaymentDueDays().getDueDays());
                    }
                } else if (fieldName == c.FAELLIGKEITSDATUM) {
                    res = isSimonFleisch && paymentCondition != null ? "" : DateMapper.toDDMMYYYYString((Date)oi.getDueDate());
                } else if (fieldName == c.SKONTOTAGE1) {
                    if (paymentCondition != null) {
                        if (isSimonFleisch) {
                            res = "";
                        } else if (paymentCondition.getSettlementDiscount1() != null) {
                            res = String.valueOf(paymentCondition.getSettlementDiscount1().getDueDays().getDueDays());
                        }
                    }
                } else if (fieldName == c.SKONTO1) {
                    res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)BigDecimal.valueOf(0L));
                    if (paymentCondition != null && termOfPayment != null && !isSimonFleisch && paymentCondition.getSettlementDiscount1() != null) {
                        res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)termOfPayment.getPercentDiscount1(oi.getTransactionDate()));
                    }
                } else if (fieldName == c.SKONTOTAGE2) {
                    if (paymentCondition != null) {
                        if (isSimonFleisch) {
                            res = "";
                        } else if (paymentCondition.getSettlementDiscount2() != null) {
                            res = String.valueOf(paymentCondition.getSettlementDiscount2().getDueDays().getDueDays());
                        }
                    }
                } else if (fieldName == c.SKONTO2) {
                    res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)BigDecimal.valueOf(0L));
                    if (paymentCondition != null && termOfPayment != null && !isSimonFleisch && paymentCondition.getSettlementDiscount2() != null) {
                        res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)termOfPayment.getPercentDiscount2(oi.getTransactionDate()));
                    }
                } else if (fieldName == c.SKONTOTAGE3) {
                    if (paymentCondition != null) {
                        if (isSimonFleisch) {
                            res = "";
                        } else if (paymentCondition.getSettlementDiscount3() != null) {
                            res = String.valueOf(paymentCondition.getSettlementDiscount3().getDueDays().getDueDays());
                        }
                    }
                } else if (fieldName == c.SKONTO3) {
                    res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)BigDecimal.valueOf(0L));
                    if (paymentCondition != null && termOfPayment != null && !isSimonFleisch && paymentCondition.getSettlementDiscount3() != null) {
                        res = FactoringHelper.getFormatAmountWithCommaAndFourPositionsAfterDecimalPoint((ICurrency)baseCurrency, (BigDecimal)termOfPayment.getPercentDiscount3(oi.getTransactionDate()));
                    }
                } else if (fieldName == c.KZ_KONDITION) {
                    res = "0";
                } else if (fieldName == c.ABNEHMERNAME) {
                    res = pa.getShortAddress();
                    if (postalAddress != null) {
                        res = postalAddress.getName();
                    }
                } else if (fieldName == c.ABNEHMERADRESSE) {
                    if (postalAddress != null) {
                        res = postalAddress.getStreet();
                    }
                } else if (fieldName == c.PLZ) {
                    if (postalAddress != null) {
                        res = postalAddress.getPostalCode();
                    }
                } else if (fieldName == c.ORT) {
                    if (postalAddress != null) {
                        res = postalAddress.getTown();
                    }
                } else if (fieldName == c.ISO_LANDCODE) {
                    if (postalAddress != null) {
                        res = postalAddress.getCountry().getIsoCode();
                    }
                } else if (fieldName == c.FINANZ_MARKIERUNGSCODE) {
                    if (struct.completeOIs) {
                        if (ISoftware.isANTEHOLZ() && oi.getIsOpeningBalance()) {
                            ac0 = FactoringHellerHelper.getAnalyseCodeValue(oi);
                            if (ac0.equals("968")) {
                                res = ac0;
                            }
                        } else if (oi.getOpenItemType() == OpenItemType.REMAINDER_INVOICE || oi.getOpenItemType() == OpenItemType.REMAINDER_CREDITNOTE) {
                            res = "968";
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Rest-OP. Finanz-Markierungscode 968. Belegnummer: {} ", (Object)oi.getReferenceNumber());
                            }
                        } else if (!(oi.getOriginalAmount().equals(oi.getOpenAmount()) || oi.getOpenItemType() == OpenItemType.RECEIPT && oi.getIsDownPayment())) {
                            res = "968";
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("OP teilverrechnet (keine Anzhalungen). Finanz-Markierungscode 968. Belegnummer: {} ", (Object)oi.getReferenceNumber());
                            }
                        }
                    }
                } else if (fieldName == c.TEXT_MARKIERUNGSCODE) {
                    if (struct.completeOIs) {
                        if (ISoftware.isANTEHOLZ() && oi.getIsOpeningBalance()) {
                            ac0 = FactoringHellerHelper.getAnalyseCodeValue(oi);
                            if (ac0.equals("915")) {
                                res = ac0;
                            }
                        } else if (oi.getOpenItemType() == OpenItemType.RECEIPT && !oi.getIsAllocated() || oi.getOpenItemType() == OpenItemType.RECEIPT && oi.getIsDownPayment()) {
                            res = "915";
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Akontozahlung. Text-Markierungscode 915. Belegnummer: {} ", (Object)oi.getReferenceNumber());
                            }
                        }
                    }
                } else if (ISoftware.isDIHAG() && postalAddress.getCountry().getIsoCode().equals("AT") && (fieldName == c.ERLAEUTERUNG_ZK_KURZ || fieldName == c.HINWEIS_ZK_LANG || fieldName == c.ZESSIONSKENNZEICHEN)) {
                    if (fieldName == c.ZESSIONSKENNZEICHEN) {
                        res = "TB";
                    }
                    if (!StringMapper.isNullString((String)((Customer)pa).getOidCession())) {
                        BankAccount cessionBank = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(((Customer)pa).getOidCession());
                        if (fieldName == c.ERLAEUTERUNG_ZK_KURZ && cessionBank != null) {
                            res = cessionBank.getCession().getCessionShort();
                        }
                        if (fieldName == c.HINWEIS_ZK_LANG && cessionBank != null) {
                            res = cessionBank.getCession().getCessionLong().getString().replaceAll("\r\n", " ");
                        }
                    }
                }
                if (!StringMapper.isNullString((String)res)) {
                    res = FactoringHelper.checkField((String)res);
                }
                if (!isAlphaNumeric && isMandatory) {
                    FactoringHelper.validAlphaNumeric((String)res, (String)fieldName, (String)pa.getCode(), (int)fieldLength, (boolean)isAlphaNumeric, (boolean)isMandatory);
                }
                result.append(new FactoringTextField(fieldLength, isAlphaNumeric, fieldName, res).getTextField().getAsString());
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
                if (isMandatory) {
                    throw FactoringExceptionMapper.makeMandatoryFieldCannotBeCreatedDomainException((String)("Fieldname: " + fieldName));
                }
                result.append(new FactoringTextField(fieldLength, isAlphaNumeric, fieldName).getTextField().getAsString());
            }
        }
        return result.append(rowSeparator);
    }

    private static String getAnalyseCodeValue(OpenItem oi) {
        String result = "";
        String[] analyseCodes = oi.getAnalysisCodes();
        if (analyseCodes != null && analyseCodes.length > 0) {
            result = StringMapper.toString((String)analyseCodes[0]);
        }
        return result;
    }

    public static List<FactoringFieldDescription> getFieldDescription(int type) {
        FactoringHellerFieldDescriptionContainer fdc = new FactoringHellerFieldDescriptionContainer();
        if (fdc.getFieldDescriptionOpenItem().isEmpty()) {
            fdc.setFieldDescriptionOpenItem();
        }
        if (fdc.getFieldDescriptionBottomRecord().isEmpty()) {
            fdc.setFieldDescriptionBottomRecord();
        }
        switch (type) {
            case 0: {
                return fdc.getFieldDescriptionOpenItem();
            }
            case 1: {
                return fdc.getFieldDescriptionBottomRecord();
            }
        }
        return null;
    }

    public static StringBuilder getBottomRecord(String companyNumber, int rows, String amount, List<FactoringFieldDescription> listFieldDescription, FactoringHellerFieldDescriptionContainer c, FactoringHellerPresetStruct struct) throws BusinessDomainException {
        Object[] obj = new Object[]{String.valueOf(rows), amount};
        LOGGER.debug("getBottomRecord parameters: rows: {} amount: {}", obj);
        StringBuilder result = new StringBuilder();
        int fieldLength = 0;
        boolean isAlphaNumeric = true;
        String fieldName = "";
        for (FactoringFieldDescription fd : listFieldDescription) {
            try {
                String res = "";
                fieldLength = fd.getfieldLength();
                isAlphaNumeric = fd.isAlphaNumeric();
                fieldName = fd.getFieldName();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("FieldName: " + fieldName);
                }
                if (fieldName == c.DATEIKENNZEICHNUNG) {
                    res = "30";
                } else if (fieldName == c.KONZERNNUMMER) {
                    res = FactoringHellerHelper.getConcernNummer(struct.type.value());
                } else if (fieldName == c.KUNDENNUMMER) {
                    res = companyNumber;
                } else if (fieldName == c.ANZAHL_BELEGE) {
                    res = String.valueOf(rows);
                } else if (fieldName == c.GESAMTBETRAG) {
                    res = amount;
                }
                result.append(new FactoringTextField(fieldLength, isAlphaNumeric, fieldName, res).getTextField().getAsString());
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
                result.append(new FactoringTextField(fieldLength, isAlphaNumeric, fieldName).getTextField().getAsString());
            }
        }
        return result.append(rowSeparator);
    }

    private static String getConcernNummer(int type) {
        String result = "";
        switch (type) {
            case 0: {
                result = "1";
                break;
            }
            case 1: {
                result = "33";
                break;
            }
            case 2: {
                result = "4";
                break;
            }
            case 3: {
                result = "40";
                break;
            }
        }
        return result;
    }

    public static Criterion createAnalysisCodeFilter(ExtendedFilterStruct[] filtersSeq) {
        return ExtendedFilterHelper.makeFilter((ExtendedFilterStruct[])filtersSeq);
    }
}

