/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.bankstatementposting.camt.camt053.iso.version00104;

import com.varial.accounting.domain.bankstatementposting.BankStatementPostingHelper;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementAmountAndCurrency;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementHeader;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementOrderingParty;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementPayment;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementSpecialTransactionData;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.camt053.version00104.AccountStatement4;
import iso.sepa.camt053.version00104.ActiveOrHistoricCurrencyAndAmount;
import iso.sepa.camt053.version00104.AmountAndCurrencyExchange3;
import iso.sepa.camt053.version00104.BatchInformation2;
import iso.sepa.camt053.version00104.BranchAndFinancialInstitutionIdentification5;
import iso.sepa.camt053.version00104.CashAccount24;
import iso.sepa.camt053.version00104.CashAccount25;
import iso.sepa.camt053.version00104.CashBalance3;
import iso.sepa.camt053.version00104.Charges4;
import iso.sepa.camt053.version00104.CreditDebitCode;
import iso.sepa.camt053.version00104.EntryDetails3;
import iso.sepa.camt053.version00104.EntryTransaction4;
import iso.sepa.camt053.version00104.FinancialInstitutionIdentification8;
import iso.sepa.camt053.version00104.GenericOrganisationIdentification1;
import iso.sepa.camt053.version00104.GenericPersonIdentification1;
import iso.sepa.camt053.version00104.GroupHeader58;
import iso.sepa.camt053.version00104.PartyIdentification43;
import iso.sepa.camt053.version00104.PaymentReturnReason2;
import iso.sepa.camt053.version00104.ReportEntry4;
import iso.sepa.camt053.version00104.TransactionAgents3;
import iso.sepa.camt053.version00104.TransactionParties3;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class Camt053Iso00104DataMapper {
    public static BankStatementHeader mapHeader(GroupHeader58 header, AccountStatement4 statement, int numberOfTransactions) {
        BankStatementHeader result = new BankStatementHeader();
        if (header != null) {
            result.setAdditionalInfo1(header.getMsgId());
            result.setUserNumber(Camt053Iso00104DataMapper.getUserNumber(header));
        }
        result.setStatementNumber(Camt053Iso00104DataMapper.getStatementNumber(statement));
        result.setStatementDate(DateAdapter.getDate((XMLGregorianCalendar)statement.getCreDtTm()));
        if (statement.getAcct() != null) {
            CashAccount25 account = statement.getAcct();
            result.setIbanHouseBank(Camt053Iso00104DataMapper.getIban(account));
            result.setSwiftHouseBank(Camt053Iso00104DataMapper.getSwift(account));
        }
        if (!statement.getBal().isEmpty()) {
            Iterator balanceIterator = statement.getBal().iterator();
            CashBalance3 balance = null;
            block6: while (balanceIterator.hasNext()) {
                balance = (CashBalance3)balanceIterator.next();
                if (balance.getTp().getCdOrPrtry() == null) continue;
                switch (balance.getTp().getCdOrPrtry().getCd()) {
                    case PRCD: {
                        result.setOpeningBalance(Camt053Iso00104DataMapper.getBalance(balance));
                        continue block6;
                    }
                    case OPBD: {
                        result.setOpeningBalance(Camt053Iso00104DataMapper.getBalance(balance));
                        continue block6;
                    }
                    case CLBD: {
                        result.setClosingBalance(Camt053Iso00104DataMapper.getBalance(balance));
                        continue block6;
                    }
                    case CLAV: {
                        result.setClosingBalance(Camt053Iso00104DataMapper.getBalance(balance));
                        continue block6;
                    }
                }
            }
        }
        result.setNumberOfTransactions(numberOfTransactions);
        return result;
    }

    private static BigDecimal getBalance(CashBalance3 balance) {
        BigDecimal result = BigDecimal.ZERO;
        if (balance != null) {
            result = balance.getAmt().getValue();
            if (balance.getCdtDbtInd().equals((Object)CreditDebitCode.DBIT)) {
                result = result.negate();
            }
        }
        return result;
    }

    private static String getSwift(CashAccount25 account) {
        String result = "";
        if (account != null && account.getSvcr() != null && account.getSvcr().getFinInstnId() != null) {
            FinancialInstitutionIdentification8 finInst = account.getSvcr().getFinInstnId();
            result = finInst.getBICFI();
        }
        return result;
    }

    private static String getIban(CashAccount25 account) {
        String result = "";
        if (account != null && account.getId() != null && StringMapper.isNullString((String)(result = account.getId().getIBAN())) && account.getId().getOthr() != null) {
            result = account.getId().getOthr().getId();
        }
        return result;
    }

    private static String getStatementNumber(AccountStatement4 statement) {
        String result = "";
        if (!StringMapper.isNullString((String)statement.getId())) {
            result = statement.getId();
        } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)statement.getElctrncSeqNb())) {
            result = BigDecimalMapper.toString((BigDecimal)statement.getElctrncSeqNb());
        } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)statement.getLglSeqNb())) {
            result = BigDecimalMapper.toString((BigDecimal)statement.getLglSeqNb());
        }
        return result;
    }

    private static String getUserNumber(GroupHeader58 header) {
        GenericOrganisationIdentification1 genOrgId;
        String result = "";
        if (header.getMsgRcpt() != null && header.getMsgRcpt().getId() != null && header.getMsgRcpt().getId().getOrgId() != null && !header.getMsgRcpt().getId().getOrgId().getOthr().isEmpty() && (genOrgId = (GenericOrganisationIdentification1)header.getMsgRcpt().getId().getOrgId().getOthr().get(0)) != null) {
            result = genOrgId.getId();
        }
        return result;
    }

    public static BankStatementPayment mapPayment(ReportEntry4 entry) {
        EntryDetails3 entryDetail;
        BankStatementPayment result = new BankStatementPayment();
        boolean isDebit = entry.getCdtDbtInd().equals((Object)CreditDebitCode.DBIT);
        BankStatementAmountAndCurrency baseAmount = Camt053Iso00104DataMapper.mapBaseAmount(entry, isDebit);
        if (baseAmount != null) {
            result.setBaseAmount(baseAmount);
        }
        if (entry.getBookgDt() != null) {
            result.setTransactionDate(DateAdapter.getDate((XMLGregorianCalendar)entry.getBookgDt().getDt()));
        }
        if (entry.getValDt() != null) {
            result.setValueDate(DateAdapter.getDate((XMLGregorianCalendar)entry.getValDt().getDt()));
        }
        result.setAdditionalInfo2(BankStatementPostingHelper.checkAdditionalEntryInfo((String)entry.getAcctSvcrRef()));
        BankStatementSpecialTransactionData specialTransactionData = Camt053Iso00104DataMapper.mapSpecialTransactionData(entry);
        if (specialTransactionData != null) {
            result.setSpecialTransactionData(specialTransactionData);
        }
        if (!(entry.getNtryDtls().isEmpty() || (entryDetail = (EntryDetails3)entry.getNtryDtls().get(0)).getTxDtls().isEmpty() || Camt053Iso00104DataMapper.isBatch(entryDetail.getBtch()))) {
            BankStatementAmountAndCurrency chargesAmount;
            BankStatementAmountAndCurrency originalAmount;
            EntryTransaction4 entryTransactionDetail = (EntryTransaction4)entryDetail.getTxDtls().get(0);
            if (entryTransactionDetail.getPurp() != null) {
                result.setTransactionText(entryTransactionDetail.getPurp().getCd());
            }
            if ((originalAmount = Camt053Iso00104DataMapper.mapOriginalAmount(entryTransactionDetail.getAmtDtls(), isDebit)) != null) {
                result.setOriginalAmount(originalAmount);
            }
            if ((chargesAmount = Camt053Iso00104DataMapper.mapChargesAmount(entryTransactionDetail.getChrgs(), isDebit)) != null) {
                result.setCharges(chargesAmount);
            }
            result.setReferencenumber(Camt053Iso00104DataMapper.getReferenceNumber(entryTransactionDetail));
            BankStatementOrderingParty orderingParty = Camt053Iso00104DataMapper.mapOrderingParty(entryTransactionDetail, isDebit);
            if (orderingParty != null) {
                result.setOrderingParty(orderingParty);
            }
            result.setRemittances(Camt053Iso00104DataMapper.getRemittances(entryTransactionDetail));
            result.setReturnInfo(Camt053Iso00104DataMapper.getReturnInfo(entryTransactionDetail.getRtrInf()));
        }
        return result;
    }

    private static boolean isBatch(BatchInformation2 batch) {
        return batch != null && batch.getNbOfTxs() != null && !batch.getNbOfTxs().equals("0") && !batch.getNbOfTxs().equals("1");
    }

    private static BankStatementSpecialTransactionData mapSpecialTransactionData(ReportEntry4 entry) {
        BankStatementSpecialTransactionData result = new BankStatementSpecialTransactionData();
        if (entry.getBkTxCd() != null && entry.getBkTxCd().getDomn() != null) {
            if (!StringMapper.isNullString((String)entry.getBkTxCd().getDomn().getCd())) {
                result.setSpecialTransactionCode(entry.getBkTxCd().getDomn().getCd());
            }
            if (entry.getBkTxCd().getDomn().getFmly() != null) {
                if (!StringMapper.isNullString((String)entry.getBkTxCd().getDomn().getFmly().getCd())) {
                    result.setCodeOfTransactionType(entry.getBkTxCd().getDomn().getFmly().getCd());
                }
                if (!StringMapper.isNullString((String)entry.getBkTxCd().getDomn().getFmly().getSubFmlyCd())) {
                    result.setSpecialTransactionCodeSupplement(entry.getBkTxCd().getDomn().getFmly().getSubFmlyCd());
                }
            }
        }
        return result;
    }

    private static BankStatementOrderingParty mapOrderingParty(EntryTransaction4 entryTransaction, boolean isDebit) {
        TransactionAgents3 transactionAgent;
        if (entryTransaction == null) {
            return null;
        }
        BankStatementOrderingParty result = new BankStatementOrderingParty();
        String iban = "";
        String swift = "";
        String accountNumber = "";
        TransactionParties3 transactionParty = entryTransaction.getRltdPties();
        if (transactionParty != null) {
            PartyIdentification43 pi = Camt053Iso00104DataMapper.getPartyIdentification(transactionParty, isDebit);
            if (pi != null) {
                result.setOrderingPartyName1(pi.getNm());
                if (isDebit) {
                    result.setCreditorId(Camt053Iso00104DataMapper.getCreditoId(pi));
                }
            }
            CashAccount24 cashAccount = transactionParty.getDbtrAcct();
            if (isDebit) {
                cashAccount = transactionParty.getCdtrAcct();
            }
            if (cashAccount != null && cashAccount.getId() != null) {
                iban = cashAccount.getId().getIBAN();
                if (cashAccount.getId().getOthr() != null) {
                    accountNumber = cashAccount.getId().getOthr().getId();
                }
            }
        }
        if (isDebit && entryTransaction.getRefs() != null) {
            result.setMandateReference(entryTransaction.getRefs().getMndtId());
        }
        if ((transactionAgent = entryTransaction.getRltdAgts()) != null) {
            BranchAndFinancialInstitutionIdentification5 financialInstitution = transactionAgent.getDbtrAgt();
            if (isDebit) {
                financialInstitution = transactionAgent.getCdtrAgt();
            }
            if (financialInstitution != null && financialInstitution.getFinInstnId() != null) {
                swift = financialInstitution.getFinInstnId().getBICFI();
                if (financialInstitution.getFinInstnId().getOthr() != null && !StringMapper.isNullString((String)financialInstitution.getFinInstnId().getOthr().getId())) {
                    accountNumber = financialInstitution.getFinInstnId().getOthr().getId();
                }
            }
        }
        if (!StringMapper.isNullString((String)iban)) {
            result.setOrderingPartyIban(iban);
        }
        if (!StringMapper.isNullString((String)swift)) {
            result.setOrderingPartySwift(swift);
        }
        if (!StringMapper.isNullString((String)accountNumber)) {
            result.setOrderingPartyAccountNumber(accountNumber);
        }
        return result;
    }

    private static String getReturnInfo(PaymentReturnReason2 returnInfo) {
        StringBuilder sb = new StringBuilder();
        if (returnInfo != null) {
            String value;
            if (returnInfo.getOrgnlBkTxCd() != null && returnInfo.getOrgnlBkTxCd().getPrtry() != null) {
                value = returnInfo.getOrgnlBkTxCd().getPrtry().getCd();
                if (!StringMapper.isNullString((String)value)) {
                    sb.append(value).append('/');
                }
                if (!StringMapper.isNullString((String)(value = returnInfo.getOrgnlBkTxCd().getPrtry().getIssr()))) {
                    sb.append(value).append('/');
                }
            }
            if (returnInfo.getOrgtr() != null && returnInfo.getOrgtr().getId() != null && returnInfo.getOrgtr().getId().getOrgId() != null && !StringMapper.isNullString((String)(value = returnInfo.getOrgtr().getId().getOrgId().getAnyBIC()))) {
                sb.append(value).append('/');
            }
            if (returnInfo.getRsn() != null && !StringMapper.isNullString((String)(value = returnInfo.getRsn().getCd()))) {
                sb.append(value).append('/');
            }
            if (!returnInfo.getAddtlInf().isEmpty() && !StringMapper.isNullString((String)(value = (String)returnInfo.getAddtlInf().get(0)))) {
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private static String getCreditoId(PartyIdentification43 pi) {
        String result = "";
        if (pi.getId() != null && pi.getId().getPrvtId() != null && !pi.getId().getPrvtId().getOthr().isEmpty()) {
            GenericPersonIdentification1 gpId = (GenericPersonIdentification1)pi.getId().getPrvtId().getOthr().get(0);
            result = gpId.getId();
        }
        return result;
    }

    private static String getReferenceNumber(EntryTransaction4 entryTransaction) {
        String result = "";
        if (entryTransaction.getRefs() != null) {
            result = entryTransaction.getRefs().getEndToEndId();
        }
        return result;
    }

    private static PartyIdentification43 getPartyIdentification(TransactionParties3 transactionParty, boolean isDebit) {
        PartyIdentification43 result = new PartyIdentification43();
        result = isDebit ? (transactionParty.getCdtr() != null ? transactionParty.getUltmtCdtr() : transactionParty.getCdtr()) : (transactionParty.getUltmtDbtr() != null ? transactionParty.getUltmtDbtr() : transactionParty.getDbtr());
        return result;
    }

    private static List<String> getRemittances(EntryTransaction4 entryTransaction) {
        List<String> result = new ArrayList<String>();
        if (entryTransaction.getRmtInf() != null && !entryTransaction.getRmtInf().getUstrd().isEmpty()) {
            result = entryTransaction.getRmtInf().getUstrd();
        }
        return result;
    }

    private static BankStatementAmountAndCurrency mapChargesAmount(Charges4 charges, boolean isDebit) {
        if (charges != null) {
            return Camt053Iso00104DataMapper.mapAmountAndCurrency(charges.getTtlChrgsAndTaxAmt(), isDebit);
        }
        return null;
    }

    private static BankStatementAmountAndCurrency mapOriginalAmount(AmountAndCurrencyExchange3 amtDtls, boolean isDebit) {
        if (amtDtls != null && amtDtls.getInstdAmt() != null) {
            return Camt053Iso00104DataMapper.mapAmountAndCurrency(amtDtls.getInstdAmt().getAmt(), isDebit);
        }
        return null;
    }

    private static BankStatementAmountAndCurrency mapBaseAmount(ReportEntry4 entry, boolean isDebit) {
        return Camt053Iso00104DataMapper.mapAmountAndCurrency(entry.getAmt(), isDebit);
    }

    private static BankStatementAmountAndCurrency mapAmountAndCurrency(ActiveOrHistoricCurrencyAndAmount amountAndCurrency, boolean isDebit) {
        BigDecimal amount;
        if (amountAndCurrency != null && (amount = amountAndCurrency.getValue()) != null) {
            if (isDebit) {
                amount = amount.negate();
            }
            BankStatementAmountAndCurrency result = new BankStatementAmountAndCurrency();
            result.setAmount(amount);
            result.setCurrency(amountAndCurrency.getCcy());
            return result;
        }
        return null;
    }
}

