/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.bankaccount;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.bankaccount.MaturityTypeEnum;
import com.varial.accounting.bankstatementposting.BankStatementTransferFormatTypeEnum;
import com.varial.accounting.bankstatementposting.TransactionDateTypeEnum;
import com.varial.accounting.domain.ageddatatransaction.AgedDataEntry;
import com.varial.accounting.domain.asciitransferformat.ASCIITransferFormat;
import com.varial.accounting.domain.bankaccount.BankAccountAgreement;
import com.varial.accounting.domain.bankaccount.BankAccountAgreementPersistencyManager;
import com.varial.accounting.domain.bankaccount.BankAccountCodeComparator;
import com.varial.accounting.domain.bankaccount.BankAccountData;
import com.varial.accounting.domain.bankaccount.BankAccountExceptionMapper;
import com.varial.accounting.domain.bankaccount.BankAccountForwardContract;
import com.varial.accounting.domain.bankaccount.BankAccountForwardContractPersistencyManager;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.bankaccount.BankAccountType;
import com.varial.accounting.domain.bankaccount.BankData;
import com.varial.accounting.domain.bankaccount.Cession;
import com.varial.accounting.domain.bankaccount.IBankAccount;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.bankaccount.IForeignPaymentChargesAccount;
import com.varial.accounting.domain.bankaccount.MaturityTypeMapper;
import com.varial.accounting.domain.bankaccount.balance.BankAccountBalanceManager;
import com.varial.accounting.domain.bankreconciliation.BankReconciliationPersistencyManager;
import com.varial.accounting.domain.bankreconciliation.FixedAdjustmentAccountEnum;
import com.varial.accounting.domain.bankreconciliation.FixedAdjustmentPersistencyManager;
import com.varial.accounting.domain.bankstatementposting.BankStatementTransferFormatTypeMapper;
import com.varial.accounting.domain.bankstatementposting.TransactionDateTypeMapper;
import com.varial.accounting.domain.documenttype.DocumentType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nominalledger.AccountType;
import com.varial.accounting.domain.nominalledger.AssetCategory;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominaltransactionbase.BankAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountPersistencyManager;
import com.varial.accounting.domain.sequenceno.ISequenceNo;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperReportResource;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.balance.BalanceSum;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.JurisdictionFactory;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.ConversionTable;
import com.varial.framework.domain.currency.ExchangeRatePersistencyManager;
import com.varial.framework.domain.paymentexportformat.PaymentExportFormat;
import com.varial.framework.domain.reports.ReportExceptionMapper;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankAccount
extends PersistentObject
implements IBankAccount {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)BankAccount.class.getName());
    private static final String SEPA_SERVICE_ID_FIELD_NAME = "#SERVICEID=";
    protected static final String CLASSNAME = BankAccount.class.getName();
    private static final int PRIORITY = 1;
    private String mCode;
    private String mShortName;
    private BankAccountType mBankAccountType;
    private boolean mDivers;
    private boolean mReconcile;
    private boolean mStop;
    private String mBankAccountNumber;
    private String mDeviatingOwner;
    private String mNote;
    private AccountingCompany mAccountingCompany;
    private ICurrency mCurrency;
    private BankData mBankData;
    private PaymentExportFormat mExportFormat;
    private String mChequeXMLFile;
    private boolean mWithOCRA;
    private boolean mIsOrderCheque;
    private int mChequeNumber;
    private boolean mBillOfExchangeInternational;
    private DocumentType mDocTypeReceipt;
    private DocumentType mDocTypePayment;
    private String mReferenceSenderBACS;
    private String mReferenceReceiverBACS;
    private String mReferenceApplicationBACS;
    private List<BankAccountAgreement> mBankAccountAgreements;
    private List<BankAccountForwardContract> mBankAccountForwardContracts;
    private NLAccountCompanySetting mNominalAccount;
    private NLAccountCompanySetting mBankCharges;
    private NLAccountCompanySetting mOtherCharges1;
    private NLAccountCompanySetting mOtherCharges2;
    private NLAccountCompanySetting mOtherCharges3;
    private NLAccountCompanySetting mOtherCharges4;
    private NLAccountCompanySetting mOtherCharges5;
    private NLAccountCompanySetting mReceiptInCirculation;
    private NLAccountCompanySetting mPaymentInCirculation;
    private NLAccountCompanySetting mChequePayment;
    private NLAccountCompanySetting mChequeReceipt;
    private NLAccountCompanySetting mBillOfExchangePayment;
    private NLAccountCompanySetting mBillOfExchangeReceipt;
    private NLAccountCompanySetting mInterestOnLongTermLoans;
    private NLAccountCompanySetting mInterestOnOverDraw;
    private NLAccountCompanySetting mInterestOnGain;
    private NLAccountCompanySetting mInterestOnLoss;
    private NLAccountCompanySetting mRevaluationGains;
    private NLAccountCompanySetting mRevaluationLoss;
    private NLAccountCompanySetting mBsiPostingsWithoutMatch;
    private NLAccountCompanySetting mAdvicePostings;
    private NLAccountCompanySetting mBsiPostings;
    private NLAccountCompanySetting mForeignPayment;
    private FinanceSetup mCurrentFinanceSetup;
    private String mBillOfExchangeXMLFile;
    private String mTransferFileName;
    private BankStatementTransferFormatTypeEnum mTransferFormatType;
    private ASCIITransferFormat mASCIITransferFormat;
    private TransactionDateTypeEnum mTransactionDateType;
    private Cession mCession;
    private boolean mSecureAccount;
    private MaturityTypeEnum mMaturityType;
    private boolean mChangeOIStatus;
    private boolean mGenerateSepa;
    private boolean mPrintByDunningLetter;
    private String mBackupDirectory;
    private boolean mSepaExpressDirectDebit;
    private boolean mNotForVarialWIN;
    private PaymentExportFormat mBankStatementFormat;
    private ISequenceNo mSequenceNoDirectDebitFile;
    private ISequenceNo mSequenceNoPaymentFile;
    private boolean mForeignPaymentAsIso;
    private IForeignPaymentChargesAccount mForeignPaymentChargesAccount;

    public BankAccount(AccountingCompany accountingCompany) {
        super(1);
        this.mAccountingCompany = accountingCompany;
    }

    protected BankAccount(String objectid) {
        super(1, objectid);
    }

    public BankAccount(String objectid, int version) {
        super(1, objectid, version);
    }

    protected BankAccount(boolean readOnly) {
        super(1, readOnly);
    }

    protected void load() {
        BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
        bankAccountPersistencyManager.load(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.getNominalAccount().getExistPostings()) {
            throw BankAccountExceptionMapper.makeAccountCannotDeletedIsInUseDomainException();
        }
        if (!this.isNew() && PaymentSessionBankAccountPersistencyManager.usedBankAccount((BankAccount)this)) {
            throw BankAccountExceptionMapper.makeDeletingNotAllowedAsUsedInPaymentSessionDomainException();
        }
    }

    protected void deleteImpl() {
        BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
        bankAccountPersistencyManager.delete(this);
    }

    public String getClassName() {
        return CLASSNAME;
    }

    public String getDomainKey() {
        return this.getCode();
    }

    protected void saveImpl() {
        BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
        bankAccountPersistencyManager.save(this);
        if (this.getBankAccountType() == BankAccountType.CURRENT_ACCOUNT && this.getPrintByDunningLetter()) {
            this.registerForLastExecute();
        }
    }

    protected void lastExecuteImpl() throws BusinessDomainException {
        BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
        BankAccount[] bankAccounts = bankAccountPersistencyManager.getOtherBankAccountsForDunningLetter(this);
        if (bankAccounts != null) {
            bankAccountPersistencyManager.removePrintByDunningLetter(bankAccounts);
        }
    }

    public void setData(BankAccountData data) {
        this.mCode = data.getCode();
        this.mShortName = data.getShortName();
        this.mBankAccountType = data.getBankAccountType();
        this.mDivers = data.isDivers();
        this.mReconcile = data.isReconcile();
        this.mStop = data.isStop();
        this.mBankAccountNumber = data.getBankAccountNumber();
        this.mDeviatingOwner = data.getDeviatingOwner();
        this.mNote = data.getNote();
        this.mAccountingCompany = data.getAccountingCompany();
        this.mCurrency = data.getCurrency();
        this.mBankData = data.getBank();
        this.mExportFormat = data.getExportFormat();
        this.mChequeXMLFile = data.getChequeXMLFile();
        this.mReferenceSenderBACS = data.getReferenceSenderBACS();
        this.mReferenceReceiverBACS = data.getReferenceReceiverBACS();
        this.mReferenceApplicationBACS = data.getReferenceApplicationBACS();
        this.mNominalAccount = data.getNominalAccount();
        this.mBankCharges = data.getBankCharges();
        this.mOtherCharges1 = data.getOtherCharges1();
        this.mOtherCharges2 = data.getOtherCharges2();
        this.mOtherCharges3 = data.getOtherCharges3();
        this.mOtherCharges4 = data.getOtherCharges4();
        this.mOtherCharges5 = data.getOtherCharges5();
        this.mReceiptInCirculation = data.getReceiptInCirculation();
        this.mPaymentInCirculation = data.getPaymentInCirculation();
        this.mChequePayment = data.getChequePayment();
        this.mChequeReceipt = data.getChequeReceipt();
        this.mBillOfExchangePayment = data.getBillOfExchangePayment();
        this.mBillOfExchangeReceipt = data.getBillOfExchangeReceipt();
        this.mInterestOnLongTermLoans = data.getInterestOnLongTermLoans();
        this.mInterestOnOverDraw = data.getInterestOnOverDraw();
        this.mInterestOnGain = data.getInterestOnGain();
        this.mInterestOnLoss = data.getInterestOnLoss();
        this.mRevaluationGains = data.getRevaluationGains();
        this.mRevaluationLoss = data.getRevaluationLoss();
        this.mBsiPostingsWithoutMatch = data.getBsiPostingsWithoutMatch();
        this.mBsiPostings = data.getBsiPostings();
        this.mBillOfExchangeXMLFile = data.getBillOfExchangeXMLFile();
        this.mTransferFileName = data.getTransferFileName();
        this.mTransferFormatType = data.getTransferFormatType();
        this.mASCIITransferFormat = data.getAsciiTransferFormat();
        this.mTransactionDateType = data.getTransactionDateType();
        this.mCession = data.getCession();
        this.mWithOCRA = data.isWithOCRA();
        this.mIsOrderCheque = data.isOrderCheque();
        this.mChequeNumber = data.getChequeNumber();
        this.mBillOfExchangeInternational = data.isBillOfExchangeInternational();
        this.mDocTypeReceipt = data.getDocTypeReceipt();
        this.mDocTypePayment = data.getDocTypePayment();
        this.mSecureAccount = data.isSecureAccount();
        this.mMaturityType = data.getMaturityType();
        this.mChangeOIStatus = data.isChangeOIStatus();
        this.mGenerateSepa = data.isGenerateSepa();
        this.mAdvicePostings = data.getAdvicePostings();
        this.mPrintByDunningLetter = data.isPrintByDunningLetter();
        this.mForeignPayment = data.getForeignPayment();
        this.mBackupDirectory = data.getBackupDirectory();
        this.mNotForVarialWIN = data.getNotForVarialWIN();
        this.mBankStatementFormat = data.getBankStatementFormat();
        this.mSepaExpressDirectDebit = data.getSepaExpressDirectDebit();
        this.mSequenceNoDirectDebitFile = data.getSequenceNoDirectDebitFile();
        this.mSequenceNoPaymentFile = data.getSequenceNoPaymentFile();
        this.mForeignPaymentAsIso = data.isForeignPaymentAsIso();
        this.mForeignPaymentChargesAccount = data.getForeignPaymentChargesAccount();
    }

    public MaturityTypeEnum getMaturityType() {
        this.requireLoaded();
        return this.mMaturityType;
    }

    public void setMaturityType(MaturityTypeEnum maturityType) {
        MaturityTypeMapper maturityTypeMapper = new MaturityTypeMapper();
        this.protocol("maturitytype", maturityTypeMapper.toString(this.mMaturityType), maturityTypeMapper.toString(maturityType));
        this.mMaturityType = maturityType;
    }

    public boolean getSecureAccount() {
        this.requireLoaded();
        return this.mSecureAccount;
    }

    public void setSecureAccount(boolean secureAccount) {
        this.protocol("secureaccount", this.mSecureAccount, secureAccount);
        this.mSecureAccount = secureAccount;
    }

    public int getChequeNumber() {
        this.requireLoaded();
        return this.mChequeNumber;
    }

    public void setChequeNumber(int chequeNumber) {
        this.protocol("chequeNumber", this.mChequeNumber, chequeNumber);
        this.mChequeNumber = chequeNumber;
    }

    public String getChequeXMLFile() {
        this.requireLoaded();
        return this.mChequeXMLFile;
    }

    public void setChequeXMLFile(String chequeXMLFile) throws BusinessDomainException {
        this.protocol("chequeXMLFile", this.mChequeXMLFile, chequeXMLFile);
        this.mChequeXMLFile = chequeXMLFile;
        if (!StringMapper.isNullString((String)this.mChequeXMLFile)) {
            this.checkFileExists(this.mChequeXMLFile, false);
        }
    }

    private void checkFileExists(String chequeXMLFile, boolean isBill) throws BusinessDomainException {
        Object fileName = chequeXMLFile;
        String filePath = "com/varial/accounting/jasperreport/cheque/";
        if (isBill) {
            filePath = "com/varial/accounting/jasperreport/billofexchange/";
        }
        if (!StringMapper.isNullString((String)fileName) && !((String)fileName).startsWith(filePath)) {
            fileName = filePath + (String)fileName;
        }
        if (!JasperReportResource.existsReport((String)(fileName = StringMapper.toString((String)fileName)))) {
            throw ReportExceptionMapper.makeNoXmlFileDomainException((String)fileName);
        }
    }

    public String getCode() {
        this.requireLoaded();
        return this.mCode;
    }

    public void setCode(String code) {
        this.protocol("code", this.mCode, code);
        this.mCode = code;
    }

    public String getShortName() {
        this.requireLoaded();
        return this.mShortName;
    }

    public void setShortName(String shortName) {
        this.protocol("shortname", this.mShortName, shortName);
        this.mShortName = shortName;
    }

    public BankAccountType getBankAccountType() {
        this.requireLoaded();
        return this.mBankAccountType;
    }

    public void setBankAccountType(BankAccountType bankAccountType) {
        this.protocol("bankaccounttype", PersistableEnumUtils.toString((PersistableEnum)this.mBankAccountType), PersistableEnumUtils.toString((PersistableEnum)bankAccountType));
        this.mBankAccountType = bankAccountType;
    }

    public boolean getDivers() {
        this.requireLoaded();
        return this.mDivers;
    }

    public void setDivers(boolean divers) throws BusinessDomainException {
        if (!this.isNew() && this.isCashAccount() && this.mDivers && !divers && this.getNominalAccount().getExistPostings()) {
            throw BankAccountExceptionMapper.makeSeveralCannotBeChangedDomainException();
        }
        this.protocol("divers", this.mDivers, divers);
        this.mDivers = divers;
    }

    public boolean getReconcile() {
        this.requireLoaded();
        return this.mReconcile;
    }

    public void setReconcile(boolean reconcile) {
        this.protocol("reconcile", this.mReconcile, reconcile);
        this.mReconcile = reconcile;
    }

    public boolean getWithOCRA() {
        this.requireLoaded();
        return this.mWithOCRA;
    }

    public void setWithOCRA(boolean withOCRA) {
        this.protocol("withOCRA", this.mWithOCRA, withOCRA);
        this.mWithOCRA = withOCRA;
    }

    public boolean getChangeOIStatus() {
        this.requireLoaded();
        return this.mChangeOIStatus;
    }

    public void setChangeOIStatus(boolean changeOIStatus) {
        this.protocol("changeOIStatus", this.mChangeOIStatus, changeOIStatus);
        this.mChangeOIStatus = changeOIStatus;
    }

    public boolean getIsOrderCheque() {
        this.requireLoaded();
        return this.mIsOrderCheque;
    }

    public void setIsOrderCheque(boolean isOrderCheque) {
        this.protocol("isOrderCheque", this.mIsOrderCheque, isOrderCheque);
        this.mIsOrderCheque = isOrderCheque;
    }

    public boolean getStop() {
        this.requireLoaded();
        return this.mStop;
    }

    public void setStop(boolean stop) {
        this.protocol("stop", this.mStop, stop);
        this.mStop = stop;
    }

    public String getBankAccountNumber() {
        this.requireLoaded();
        return this.mBankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.protocol("bankaccountnumber", this.mBankAccountNumber, bankAccountNumber);
        this.mBankAccountNumber = bankAccountNumber;
    }

    public String getDeviatingOwner() {
        this.requireLoaded();
        return this.mDeviatingOwner;
    }

    public void setDeviatingOwner(String deviatingOwner) {
        this.protocol("deviatingowner", this.mDeviatingOwner, deviatingOwner);
        this.mDeviatingOwner = deviatingOwner;
    }

    public String getNote() {
        this.requireLoaded();
        return this.mNote;
    }

    public void setNote(String note) {
        this.protocol("note", this.mNote, note);
        this.mNote = note;
    }

    public Company getCompany() {
        return this.getAccountingCompany();
    }

    public AccountingCompany getAccountingCompany() {
        this.requireLoaded();
        return this.mAccountingCompany;
    }

    public void setAccountingCompany(AccountingCompany accountingCompany) {
        this.protocol("accountingcompany", (IPersistentObject)this.mAccountingCompany, (IPersistentObject)accountingCompany);
        this.mAccountingCompany = accountingCompany;
    }

    public ICurrency getCurrency() {
        this.requireLoaded();
        return this.mCurrency;
    }

    public void setCurrency(ICurrency currency) throws BusinessDomainException {
        if (!(this.isNew() || this.isCashAccount() || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)currency, (IPersistentObject)this.mCurrency))) {
            if (this.getNominalAccount().getExistPostings()) {
                throw BankAccountExceptionMapper.makeCurrencyCannotBeChangedDomainException();
            }
            FinancialYear year = this.getAccountingCompany().getFinancialYear(DateHelper.today());
            BankAccountBalanceManager.removeBalance((BankAccount)this, (FinancialYear)year, (ICurrency)this.mCurrency);
        }
        this.protocol("currency", (IPersistentObject)this.mCurrency, (IPersistentObject)currency);
        this.mCurrency = currency;
    }

    public BankData getBankData() {
        this.requireLoaded();
        return this.mBankData;
    }

    public void setBankData(BankData bankData) throws BusinessDomainException {
        BankData.checkIBAN((IBankData)this.mBankData, (IBankData)bankData);
        BankData.protocol((PersistentObject)this, (BankData)bankData, (BankData)this.mBankData);
        this.mBankData = bankData;
    }

    public ILanguage getCorrespondenceLanguage() {
        return this.getBankData() != null ? this.getBankData().getCorrespondenceLanguage() : null;
    }

    public IPostalAddress getPostalAddress() {
        return this.getBankData() != null ? this.getBankData().getPostalAddress() : null;
    }

    public String getOtherReference() {
        return this.getBankData() != null ? this.getBankData().getOtherReference() : "";
    }

    public String getSwift() {
        return this.getBankData() != null ? this.getBankData().getSwift() : "";
    }

    public String getBankName() {
        return this.getBankData() != null ? this.getBankData().getBankName() : "";
    }

    public String getBankSortingCode() {
        return this.getBankData() != null ? this.getBankData().getBankSortingCode() : "";
    }

    public ICountry getCountry() {
        return this.getBankData() != null ? this.getBankData().getCountry() : null;
    }

    public String getPcCode() {
        return this.getBankData() != null ? this.getBankData().getPcCode() : "";
    }

    public PaymentExportFormat getExportFormat() {
        this.requireLoaded();
        return this.mExportFormat;
    }

    public void setExportFormat(PaymentExportFormat exportFormat) {
        this.protocol("exportformat", (IPersistentObject)this.mExportFormat, (IPersistentObject)exportFormat);
        this.mExportFormat = exportFormat;
    }

    public String getReferenceSenderBACS() {
        this.requireLoaded();
        return this.mReferenceSenderBACS;
    }

    public void setReferenceSenderBACS(String referenceSenderBACS) {
        this.protocol("referencesenderbacs", this.mReferenceSenderBACS, referenceSenderBACS);
        this.mReferenceSenderBACS = referenceSenderBACS;
    }

    public String getReferenceReceiverBACS() {
        this.requireLoaded();
        return this.mReferenceReceiverBACS;
    }

    public void setReferenceReceiverBACS(String referenceReceiverBACS) {
        this.protocol("referencereceiverbacs", this.mReferenceReceiverBACS, referenceReceiverBACS);
        this.mReferenceReceiverBACS = referenceReceiverBACS;
    }

    public String getReferenceApplicationBACS() {
        this.requireLoaded();
        return this.mReferenceApplicationBACS;
    }

    public void setReferenceApplicationBACS(String referenceApplicationBACS) {
        this.protocol("referenceapplicationbacs", this.mReferenceApplicationBACS, referenceApplicationBACS);
        this.mReferenceApplicationBACS = referenceApplicationBACS;
    }

    public boolean getBillOfExchangeInternational() {
        this.requireLoaded();
        return this.mBillOfExchangeInternational;
    }

    public void setBillOfExchangeInternational(boolean billOfExchangeInternational) {
        this.protocol("billofexchangeinternational", this.mBillOfExchangeInternational, billOfExchangeInternational);
        this.mBillOfExchangeInternational = billOfExchangeInternational;
    }

    public DocumentType getDocTypeReceipt() {
        this.requireLoaded();
        return this.mDocTypeReceipt;
    }

    public void setDocTypeReceipt(DocumentType docTypeReceipt) {
        this.protocol("doctypereceipt", (IPersistentObject)this.mDocTypeReceipt, (IPersistentObject)docTypeReceipt);
        this.mDocTypeReceipt = docTypeReceipt;
    }

    public DocumentType getDocTypePayment() {
        this.requireLoaded();
        return this.mDocTypePayment;
    }

    public void setDocTypePayment(DocumentType docTypePayment) {
        this.protocol("doctypepayment", (IPersistentObject)this.mDocTypePayment, (IPersistentObject)docTypePayment);
        this.mDocTypePayment = docTypePayment;
    }

    public boolean isCashAccount() {
        return this.getBankAccountType() == BankAccountType.CASH_ACCOUNT;
    }

    public List<BankAccountAgreement> getBankAccountAgreements() {
        if (this.mBankAccountAgreements == null) {
            if (!this.isNew()) {
                this.mBankAccountAgreements = BankAccountAgreementPersistencyManager.getBankAccountAgreements((BankAccount)this, (boolean)true);
            }
            if (this.mBankAccountAgreements == null) {
                this.mBankAccountAgreements = new ArrayList<BankAccountAgreement>();
            }
        }
        return this.mBankAccountAgreements;
    }

    public void setBankAccountAgreements(List<BankAccountAgreement> entries) throws BusinessDomainException {
        this.mBankAccountAgreements = PersistentObjectUtils.removeUnusedObjects(this.getBankAccountAgreements(), entries);
    }

    public List<BankAccountForwardContract> getBankAccountForwardContracts() {
        if (this.mBankAccountForwardContracts == null) {
            if (!this.isNew()) {
                this.mBankAccountForwardContracts = BankAccountForwardContractPersistencyManager.getBankAccountForwardContracts((BankAccount)this, (boolean)true);
            }
            if (this.mBankAccountForwardContracts == null) {
                this.mBankAccountForwardContracts = new ArrayList<BankAccountForwardContract>();
            }
        }
        return this.mBankAccountForwardContracts;
    }

    public void setBankAccountForwardContracts(List<BankAccountForwardContract> entries) throws BusinessDomainException {
        this.mBankAccountForwardContracts = PersistentObjectUtils.removeUnusedObjects(this.getBankAccountForwardContracts(), entries);
    }

    public void setNominalAccount(NLAccountCompanySetting nominalAccount) throws BusinessDomainException {
        if (nominalAccount == null) {
            throw BankAccountExceptionMapper.makeControlAccountMissingDomainException();
        }
        if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)nominalAccount.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"BankAccount.setNominalAccount: the nominal account is not in the current nominal ledger");
        }
        if (!this.isNew()) {
            if (this.mNominalAccount != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)nominalAccount, (IPersistentObject)this.mNominalAccount)) {
                if (this.getNominalAccount().getExistPostings()) {
                    throw BankAccountExceptionMapper.makeNominalAccountIsUsedForPostingsDomainException();
                }
                this.protocol("nominal account", (IPersistentObject)this.mNominalAccount, (IPersistentObject)nominalAccount);
            }
        } else {
            if (nominalAccount.getExistPostingsWithoutConsolidation()) {
                throw BankAccountExceptionMapper.makeNominalAccountIsUsedForPostingsDomainException();
            }
            this.protocol("nominal account", (IPersistentObject)this.mNominalAccount, (IPersistentObject)nominalAccount);
        }
        this.mNominalAccount = nominalAccount;
    }

    public NLAccountCompanySetting getNominalAccount() {
        this.requireLoaded();
        return this.mNominalAccount;
    }

    public void setBankCharges(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Bank Charges is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mBankCharges == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mBankCharges))) {
            if (this.mBankCharges != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(6))) {
                throw BankAccountExceptionMapper.makeBankChargesIsUsedDomainException();
            }
            this.protocol("nominal account", (IPersistentObject)this.mBankCharges, (IPersistentObject)accountSetting);
        }
        this.mBankCharges = accountSetting;
    }

    public NLAccountCompanySetting getBankCharges() {
        this.requireLoaded();
        return this.mBankCharges;
    }

    public void setOtherCharges1(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Other Charges1 is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mOtherCharges1 == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mOtherCharges1))) {
            if (this.mOtherCharges1 != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(7))) {
                throw BankAccountExceptionMapper.makeOtherCharges1IsUsedDomainException();
            }
            this.protocol("other charges 1", (IPersistentObject)this.mOtherCharges1, (IPersistentObject)accountSetting);
        }
        this.mOtherCharges1 = accountSetting;
    }

    public NLAccountCompanySetting getOtherCharges1() {
        this.requireLoaded();
        return this.mOtherCharges1;
    }

    public void setOtherCharges2(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Other Charges2 is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mOtherCharges2 == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mOtherCharges2))) {
            if (this.mOtherCharges2 != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(8))) {
                throw BankAccountExceptionMapper.makeOtherCharges2IsUsedDomainException();
            }
            this.protocol("other charges 2", (IPersistentObject)this.mOtherCharges2, (IPersistentObject)accountSetting);
        }
        this.mOtherCharges2 = accountSetting;
    }

    public NLAccountCompanySetting getOtherCharges2() {
        this.requireLoaded();
        return this.mOtherCharges2;
    }

    public void setOtherCharges3(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Other Charges3 is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mOtherCharges3 == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mOtherCharges3))) {
            if (this.mOtherCharges3 != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(9))) {
                throw BankAccountExceptionMapper.makeOtherCharges3IsUsedDomainException();
            }
            this.protocol("other charges 3", (IPersistentObject)this.mOtherCharges3, (IPersistentObject)accountSetting);
        }
        this.mOtherCharges3 = accountSetting;
    }

    public NLAccountCompanySetting getOtherCharges3() {
        this.requireLoaded();
        return this.mOtherCharges3;
    }

    public void setOtherCharges4(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Other Charges4 is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mOtherCharges4 == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mOtherCharges4))) {
            if (this.mOtherCharges4 != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(10))) {
                throw BankAccountExceptionMapper.makeOtherCharges4IsUsedDomainException();
            }
            this.protocol("other charges 4", (IPersistentObject)this.mOtherCharges4, (IPersistentObject)accountSetting);
        }
        this.mOtherCharges4 = accountSetting;
    }

    public NLAccountCompanySetting getOtherCharges4() {
        this.requireLoaded();
        return this.mOtherCharges4;
    }

    public void setOtherCharges5(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Other Charges5 is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mOtherCharges5 == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mOtherCharges5))) {
            if (this.mOtherCharges5 != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(11))) {
                throw BankAccountExceptionMapper.makeOtherCharges5IsUsedDomainException();
            }
            this.protocol("other charges 5", (IPersistentObject)this.mOtherCharges5, (IPersistentObject)accountSetting);
        }
        this.mOtherCharges5 = accountSetting;
    }

    public NLAccountCompanySetting getOtherCharges5() {
        this.requireLoaded();
        return this.mOtherCharges5;
    }

    public void setReceiptInCirculation(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Receipt in Circulation is not in the current nominal ledger");
        }
        this.protocol("receipt in circulation", (IPersistentObject)this.mReceiptInCirculation, (IPersistentObject)accountSetting);
        this.mReceiptInCirculation = accountSetting;
    }

    public NLAccountCompanySetting getReceiptInCirculation() {
        this.requireLoaded();
        return this.mReceiptInCirculation;
    }

    public void setPaymentInCirculation(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Cheques in Circulation is not in the current nominal ledger");
        }
        this.protocol("payment in circulation", (IPersistentObject)this.mPaymentInCirculation, (IPersistentObject)accountSetting);
        this.mPaymentInCirculation = accountSetting;
    }

    public NLAccountCompanySetting getPaymentInCirculation() {
        this.requireLoaded();
        return this.mPaymentInCirculation;
    }

    public void setChequePayment(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Cheque Payment is not in the current nominal ledger");
        }
        this.protocol("cheque payment", (IPersistentObject)this.mChequePayment, (IPersistentObject)accountSetting);
        this.mChequePayment = accountSetting;
    }

    public NLAccountCompanySetting getChequePayment() {
        this.requireLoaded();
        return this.mChequePayment;
    }

    public void setChequeReceipt(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Cheque Payment is not in the current nominal ledger");
        }
        this.protocol("cheque receipt", (IPersistentObject)this.mChequeReceipt, (IPersistentObject)accountSetting);
        this.mChequeReceipt = accountSetting;
    }

    public NLAccountCompanySetting getChequeReceipt() {
        this.requireLoaded();
        return this.mChequeReceipt;
    }

    public void setBillOfExchangeReceipt(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Cheque Payment is not in the current nominal ledger");
        }
        this.protocol("bill of exchange receipt", (IPersistentObject)this.mBillOfExchangeReceipt, (IPersistentObject)accountSetting);
        this.mBillOfExchangeReceipt = accountSetting;
    }

    public NLAccountCompanySetting getBillOfExchangeReceipt() {
        this.requireLoaded();
        return this.mBillOfExchangeReceipt;
    }

    public void setBillOfExchangePayment(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Cheque Payment is not in the current nominal ledger");
        }
        this.protocol("bill of exchange payment", (IPersistentObject)this.mBillOfExchangePayment, (IPersistentObject)accountSetting);
        this.mBillOfExchangePayment = accountSetting;
    }

    public NLAccountCompanySetting getBillOfExchangePayment() {
        this.requireLoaded();
        return this.mBillOfExchangePayment;
    }

    public void setInterestOnLongTermLoans(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Interest on long term loans is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mInterestOnLongTermLoans == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mInterestOnLongTermLoans))) {
            if (this.mInterestOnLongTermLoans != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(3))) {
                throw BankAccountExceptionMapper.makeInterestOnLongTermLoansIsUsedDomainException();
            }
            this.protocol("nominal account", (IPersistentObject)this.mInterestOnLongTermLoans, (IPersistentObject)accountSetting);
        }
        this.mInterestOnLongTermLoans = accountSetting;
    }

    public NLAccountCompanySetting getInterestOnLongTermLoans() {
        this.requireLoaded();
        return this.mInterestOnLongTermLoans;
    }

    public void setInterestOnOverDraw(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Interest on over draw is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mInterestOnOverDraw == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mInterestOnOverDraw))) {
            if (this.mInterestOnOverDraw != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(2))) {
                throw BankAccountExceptionMapper.makeInterestOnOverDrawIsUsedDomainException();
            }
            this.protocol("interest on overDraw", (IPersistentObject)this.mInterestOnOverDraw, (IPersistentObject)accountSetting);
        }
        this.mInterestOnOverDraw = accountSetting;
    }

    public NLAccountCompanySetting getInterestOnOverDraw() {
        this.requireLoaded();
        return this.mInterestOnOverDraw;
    }

    public void setInterestOnGain(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Interest on gain is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mInterestOnGain == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mInterestOnGain))) {
            if (this.mInterestOnGain != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(4))) {
                throw BankAccountExceptionMapper.makeInterestOnGainIsUsedDomainException();
            }
            this.protocol("interest on gain", (IPersistentObject)this.mInterestOnGain, (IPersistentObject)accountSetting);
        }
        this.mInterestOnGain = accountSetting;
    }

    public NLAccountCompanySetting getInterestOnGain() {
        this.requireLoaded();
        return this.mInterestOnGain;
    }

    public void setInterestOnLoss(NLAccountCompanySetting accountSetting) throws BusinessDomainException {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Interest on loss is not in the current nominal ledger");
        }
        if (!(this.isNew() || accountSetting == null && this.mInterestOnLoss == null || PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting, (IPersistentObject)this.mInterestOnLoss))) {
            if (this.mInterestOnLoss != null && FixedAdjustmentPersistencyManager.getIsAccountUsedForAdjustments((BankAccount)this, (FixedAdjustmentAccountEnum)new FixedAdjustmentAccountEnum(5))) {
                throw BankAccountExceptionMapper.makeInterestOnLossIsUsedDomainException();
            }
            this.protocol("interest on loss", (IPersistentObject)this.mInterestOnLoss, (IPersistentObject)accountSetting);
        }
        this.mInterestOnLoss = accountSetting;
    }

    public NLAccountCompanySetting getInterestOnLoss() {
        this.requireLoaded();
        return this.mInterestOnLoss;
    }

    public void setRevaluationGains(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Revaluation gains is not in the current nominal ledger");
        }
        this.protocol("revaluation gains", (IPersistentObject)this.mRevaluationGains, (IPersistentObject)accountSetting);
        this.mRevaluationGains = accountSetting;
    }

    public NLAccountCompanySetting getRevaluationGains() {
        this.requireLoaded();
        return this.mRevaluationGains;
    }

    public void setRevaluationLoss(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Revaluation loss is not in the current nominal ledger");
        }
        this.protocol("revaluation loss", (IPersistentObject)this.mRevaluationLoss, (IPersistentObject)accountSetting);
        this.mRevaluationLoss = accountSetting;
    }

    public NLAccountCompanySetting getRevaluationLoss() {
        this.requireLoaded();
        return this.mRevaluationLoss;
    }

    public void setBsiPostingsWithoutMatch(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"BsiPostingsWithoutMatch is not in the current nominal ledger");
        }
        this.protocol("bsi postings without match", (IPersistentObject)this.mBsiPostingsWithoutMatch, (IPersistentObject)accountSetting);
        this.mBsiPostingsWithoutMatch = accountSetting;
    }

    public NLAccountCompanySetting getBsiPostingsWithoutMatch() {
        this.requireLoaded();
        return this.mBsiPostingsWithoutMatch;
    }

    public void setBsiPostings(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"BsiPostings is not in the current nominal ledger");
        }
        this.protocol("bsi postings", (IPersistentObject)this.mBsiPostings, (IPersistentObject)accountSetting);
        this.mBsiPostings = accountSetting;
    }

    public NLAccountCompanySetting getBsiPostings() {
        this.requireLoaded();
        return this.mBsiPostings;
    }

    public void setAdvicePostings(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"AdvicePostings is not in the current nominal ledger");
        }
        this.protocol("advice postings", (IPersistentObject)this.mAdvicePostings, (IPersistentObject)accountSetting);
        this.mAdvicePostings = accountSetting;
    }

    public NLAccountCompanySetting getAdvicePostings() {
        this.requireLoaded();
        return this.mAdvicePostings;
    }

    public FinanceSetup getCurrentFinanceSetup() {
        if (this.mCurrentFinanceSetup == null) {
            this.mCurrentFinanceSetup = this.getAccountingCompany().getFinanceSetup();
        }
        if (this.mCurrentFinanceSetup == null) {
            throw ExceptionMapper.makeApplicationException((String)"BankAccount: no current finance set up found");
        }
        return this.mCurrentFinanceSetup;
    }

    public void setCurrentFinanceSetup(FinanceSetup currentFinanceSetup) {
        this.mCurrentFinanceSetup = currentFinanceSetup;
    }

    public FinanceSetup getFinanceSetup(Date date) {
        FinancialYear year = this.getAccountingCompany().getFinancialYear(date);
        if (year == null) {
            throw ExceptionMapper.makeApplicationException((String)"BankAccount: no financial year for the date found");
        }
        return this.getAccountingCompany().getFinanceSetup();
    }

    protected void check() throws BusinessDomainException {
        AccountType type;
        if (this.getDivers() && this.getCurrency() != null) {
            throw BankAccountExceptionMapper.makeCurrencyNotAllowedWithDiversDomainException();
        }
        if (this.getBankData() != null && this.getBankData().getPostalAddress() != null && this.getBankData().getPostalAddress().getName() != null && this.getBankData().getPostalAddress().getTown() == null) {
            throw BankAccountExceptionMapper.makeTownIsMissingDomainException();
        }
        NominalLedgerAccount nominalLedgerAccount = this.getNominalAccount().getNominalLedgerAccount();
        if (!nominalLedgerAccount.getControlAccount()) {
            throw BankAccountExceptionMapper.makeNominalAccountMustBeControlAccountDomainException((String)nominalLedgerAccount.getDomainKey());
        }
        if (nominalLedgerAccount.getAccountType() != AccountType.ASSET) {
            throw BankAccountExceptionMapper.makeNominalAccountMustBeAssetAccountDomainException((String)nominalLedgerAccount.getDomainKey());
        }
        if (this.isCashAccount()) {
            if (nominalLedgerAccount.getAccountCategory() != AssetCategory.CASHACCOUNT) {
                throw BankAccountExceptionMapper.makeNominalAccountMustBeCashAccountCategoryDomainException();
            }
            if (this.getDivers()) {
                if (this.getNominalAccount().getForeignCurrency() != null && !this.getNominalAccount().getForeignCurrency().equals(this.getCurrentFinanceSetup().getBaseCurrency())) {
                    throw BankAccountExceptionMapper.makeCurrencyOfNlAccMustBeBaseCurrencyDomainException();
                }
            } else if (this.getNominalAccount().getForeignCurrency() != null && !this.getNominalAccount().getForeignCurrency().equals(this.getCurrentFinanceSetup().getBaseCurrency()) && !this.getNominalAccount().getForeignCurrency().equals(this.getCurrency())) {
                throw BankAccountExceptionMapper.makeCurrencyOfNlAccAndBankAccMustBeEqualDomainException();
            }
        } else {
            if (nominalLedgerAccount.getAccountCategory() != AssetCategory.BANKACCOUNT) {
                throw BankAccountExceptionMapper.makeNominalAccountMustBeBankAccountCategoryDomainException();
            }
            if (this.getNominalAccount().getForeignCurrency() != null && !this.getNominalAccount().getForeignCurrency().equals(this.getCurrentFinanceSetup().getBaseCurrency()) && !this.getNominalAccount().getForeignCurrency().equals(this.getCurrency())) {
                throw BankAccountExceptionMapper.makeCurrencyOfNlAccAndBankAccMustBeEqualDomainException();
            }
        }
        if (this.getPaymentInCirculation() != null && this.getPaymentInCirculation().getHasCosting()) {
            throw BankAccountExceptionMapper.makePaymentInCirculationHasCosting();
        }
        if (this.getReceiptInCirculation() != null && this.getReceiptInCirculation().getHasCosting()) {
            throw BankAccountExceptionMapper.makeReceiptInCirculationHasCosting();
        }
        if (this.getChequePayment() != null && this.getChequePayment().getHasCosting()) {
            throw BankAccountExceptionMapper.makeChequePaymentHasCosting();
        }
        if (this.getChequeReceipt() != null && this.getChequeReceipt().getHasCosting()) {
            throw BankAccountExceptionMapper.makeChequeReceiptHasCosting();
        }
        if (this.getBillOfExchangePayment() != null && this.getBillOfExchangePayment().getHasCosting()) {
            throw BankAccountExceptionMapper.makeBillOfExchangePaymentHasCosting();
        }
        if (this.getBillOfExchangeReceipt() != null && this.getBillOfExchangeReceipt().getHasCosting()) {
            throw BankAccountExceptionMapper.makeBillOfExchangeReceiptHasCosting();
        }
        if (!this.getReconcile() && (this.getBankCharges() != null || this.getOtherCharges1() != null || this.getOtherCharges2() != null || this.getOtherCharges4() != null || this.getOtherCharges5() != null || this.getInterestOnLongTermLoans() != null || this.getInterestOnOverDraw() != null || this.getInterestOnGain() != null || this.getInterestOnLoss() != null || !this.isNew() && BankReconciliationPersistencyManager.getIsAccountUsedForReconciliation((BankAccount)this))) {
            throw BankAccountExceptionMapper.makeReconcileMustBeSetDomainException();
        }
        if (this.getBankCharges() != null) {
            type = this.getBankCharges().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeBankChargesMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getBankCharges().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeBankChargesMustNotBeControlAccountDomainException();
            }
        }
        if (this.getOtherCharges1() != null) {
            type = this.getOtherCharges1().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeOtherCharges1MustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getOtherCharges1().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeOtherCharges1MustNotBeControlAccountDomainException();
            }
        }
        if (this.getOtherCharges2() != null) {
            type = this.getOtherCharges2().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeOtherCharges2MustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getOtherCharges2().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeOtherCharges2MustNotBeControlAccountDomainException();
            }
        }
        if (this.getOtherCharges3() != null) {
            type = this.getOtherCharges3().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeOtherCharges3MustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getOtherCharges3().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeOtherCharges3MustNotBeControlAccountDomainException();
            }
        }
        if (this.getOtherCharges4() != null) {
            type = this.getOtherCharges4().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeOtherCharges4MustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getOtherCharges4().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeOtherCharges4MustNotBeControlAccountDomainException();
            }
        }
        if (this.getOtherCharges5() != null) {
            type = this.getOtherCharges5().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeOtherCharges5MustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getOtherCharges5().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeOtherCharges5MustNotBeControlAccountDomainException();
            }
        }
        if (this.getReceiptInCirculation() != null) {
            type = this.getReceiptInCirculation().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.ASSET) {
                throw BankAccountExceptionMapper.makeReceiptInCirculationMustBeAssetAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getReceiptInCirculation().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeReceiptInCirculationMustNotBeControlAccountDomainException();
            }
        }
        if (this.getPaymentInCirculation() != null) {
            type = this.getPaymentInCirculation().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.LIABILITY) {
                throw BankAccountExceptionMapper.makePaymentInCirculationMustBeLiabilityAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getPaymentInCirculation().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makePaymentInCirculationMustNotBeControlAccountDomainException();
            }
        }
        if (this.getChequePayment() != null) {
            type = this.getChequePayment().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.LIABILITY) {
                throw BankAccountExceptionMapper.makeChequePaymentMustBeLiabilityAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getChequePayment().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeChequePaymentMustNotBeControlAccountDomainException();
            }
        }
        if (this.getBillOfExchangePayment() != null) {
            type = this.getBillOfExchangePayment().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.LIABILITY) {
                throw BankAccountExceptionMapper.makeBillOfExchangePaymentMustBeLiabilityAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getBillOfExchangePayment().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeBillOfExchangePaymentMustNotBeControlAccountDomainException();
            }
        }
        if (this.getChequeReceipt() != null) {
            type = this.getChequeReceipt().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.ASSET) {
                throw BankAccountExceptionMapper.makeChequeReceiptMustBeAssetAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getChequeReceipt().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeChequeReceiptMustNotBeControlAccountDomainException();
            }
        }
        if (this.getBillOfExchangeReceipt() != null) {
            type = this.getBillOfExchangeReceipt().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.ASSET) {
                throw BankAccountExceptionMapper.makeBillOfExchangeReceiptMustBeAssetAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getBillOfExchangeReceipt().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeBillOfExchangeReceiptMustNotBeControlAccountDomainException();
            }
        }
        if (this.getInterestOnLongTermLoans() != null) {
            type = this.getInterestOnLongTermLoans().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeInterestOnLongTermLoansMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getInterestOnLongTermLoans().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeInterestOnLongTermLoansMustNotBeControlAccountDomainException();
            }
        }
        if (this.getInterestOnOverDraw() != null) {
            type = this.getInterestOnOverDraw().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeInterestOnOverDrawMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getInterestOnOverDraw().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeInterestOnOverDrawMustNotBeControlAccountDomainException();
            }
        }
        if (this.getInterestOnGain() != null) {
            type = this.getInterestOnGain().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeInterestOnGainMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getInterestOnGain().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeInterestOnGainMustNotBeControlAccountDomainException();
            }
        }
        if (this.getInterestOnLoss() != null) {
            type = this.getInterestOnLoss().getNominalLedgerAccount().getAccountType();
            if (type != AccountType.PROFIT && type != AccountType.LOSS) {
                throw BankAccountExceptionMapper.makeInterestOnLossMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
            }
            if (this.getInterestOnLoss().getNominalLedgerAccount().getControlAccount()) {
                throw BankAccountExceptionMapper.makeInterestOnLossMustNotBeControlAccountDomainException();
            }
        }
        if (this.getRevaluationGains() != null && (type = this.getRevaluationGains().getNominalLedgerAccount().getAccountType()) != AccountType.PROFIT && type != AccountType.LOSS) {
            throw BankAccountExceptionMapper.makeRevaluationGainsMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
        }
        if (this.getRevaluationLoss() != null && (type = this.getRevaluationLoss().getNominalLedgerAccount().getAccountType()) != AccountType.PROFIT && type != AccountType.LOSS) {
            throw BankAccountExceptionMapper.makeRevaluationLossMustBeProfitOrLossAccountDomainException((String)nominalLedgerAccount.getDomainKey());
        }
        if (this.getGenerateSepa()) {
            if (this.getBankData() == null || this.getBankData().getCountry() == null || !this.getBankData().getCountry().hasSepaCodeSet()) {
                throw BankAccountExceptionMapper.makeSepaPaymentsOnlyInSepaAreaDomainException();
            }
            if (this.getCurrency() != null && !this.getCurrentFinanceSetup().getBaseCurrency().equals(this.getCurrency()) && !this.getCurrency().isTheEuro()) {
                throw BankAccountExceptionMapper.makeSepaPaymentsOnlyInEurosDomainException();
            }
            if (StringMapper.isNullString((String)this.getOtherReference())) {
                throw BankAccountExceptionMapper.makeMissingIbanForSepaPaymentsDomainException();
            }
        }
    }

    public boolean isForeignBankAccount() {
        return !this.isCashAccount() && this.getCurrency() != null && !this.getCurrentFinanceSetup().getBaseCurrency().equals(this.getCurrency());
    }

    public boolean useAverageRate(boolean payment) {
        if (!payment) {
            return false;
        }
        return this.useAverageRate();
    }

    public boolean useAverageRate() {
        if (this.isCashAccount()) {
            return true;
        }
        if (this.isForeignBankAccount()) {
            return JurisdictionFactory.getJurisdiction((JurisdictionType)this.getAccountingCompany().getJurisdictionType()).useAverageRate(this.getAccountingCompany().getCountry().getCode());
        }
        return false;
    }

    public void addEntry(BankAccountEntry entry) {
        if (!this.equals((Object)entry.getBankAccount())) {
            throw ExceptionMapper.makeApplicationException((String)"BankAccount:addEntry: wrong bankaccount in enty");
        }
        BankAccountBalanceManager.addEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public void addEntry(AgedDataEntry entry) {
        BankAccountBalanceManager.addEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public void addEntry(NominalLedgerEntry entry) {
        BankAccountBalanceManager.addEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public void removeEntry(BankAccountEntry entry) {
        if (!this.equals((Object)entry.getBankAccount())) {
            throw ExceptionMapper.makeApplicationException((String)"BankAccount:removeEntry: wrong bankaccount in enty");
        }
        BankAccountBalanceManager.removeEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public void removeEntry(AgedDataEntry entry) {
        BankAccountBalanceManager.removeEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public void removeEntry(NominalLedgerEntry entry) {
        BankAccountBalanceManager.removeEntry((BankAccount)this, (NominalLedgerEntry)entry);
    }

    public BalanceSum getCurrentBalance(ICurrency currency, FinancialYear financialYear) {
        return BankAccountBalanceManager.getCurrentBalance((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (boolean)false);
    }

    public BalanceSum getCurrentBalance(ICurrency currency, FinancialYear financialYear, Date date) {
        return BankAccountBalanceManager.getCurrentBalance((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (Date)date);
    }

    public BalanceSum getBaseCurrencyCurrentBalance(FinancialYear financialYear, ICurrency baseCurrency) {
        return this.getNominalAccount().getCurrentBalance(financialYear, baseCurrency);
    }

    public BalanceSum[] getCurrentBalances(FinancialYear financialYear, Date date) {
        return BankAccountBalanceManager.getCurrentBalances((BankAccount)this, (FinancialYear)financialYear, (Date)date);
    }

    public BalanceSum[] getCurrentBalances(FinancialYear financialYear) {
        return BankAccountBalanceManager.getCurrentBalances((BankAccount)this, (FinancialYear)financialYear);
    }

    public BalanceSum[] getCurrentBalancesWithoutNullBalances(FinancialYear financialYear) {
        return BankAccountBalanceManager.getCurrentBalancesWithoutNullBalances((BankAccount)this, (FinancialYear)financialYear);
    }

    public BalanceSum[] getBalancesForYear(FinancialYear financialYear, Date date) {
        return BankAccountBalanceManager.getBalancesForYear((BankAccount)this, (FinancialYear)financialYear, (Date)date);
    }

    public BalanceSum getBalanceForYear(ICurrency currency, FinancialYear financialYear) {
        return BankAccountBalanceManager.getBalanceForYear((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (boolean)false);
    }

    public BalanceSum getBalanceForYear(ICurrency currency, FinancialYear financialYear, Date date) {
        return BankAccountBalanceManager.getBalanceForYear((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (Date)date);
    }

    public BalanceSum getStartBalanceForYear(ICurrency currency, FinancialYear financialYear) {
        return BankAccountBalanceManager.getStartBalanceForYear((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (boolean)false);
    }

    public BalanceSum getBalanceChangesForYear(ICurrency currency, FinancialYear financialYear, Date from, Date until) {
        return BankAccountBalanceManager.getBalanceChangesForYear((BankAccount)this, (ICurrency)currency, (FinancialYear)financialYear, (Date)from, (Date)until);
    }

    public BalanceSum[] getBalancesChangesForYear(FinancialYear financialYear, Date from, Date until) {
        return BankAccountBalanceManager.getBalancesChangesForYear((BankAccount)this, (FinancialYear)financialYear, (Date)from, (Date)until);
    }

    public ConversionRate getAverageRateForCurrency(ICurrency currency, FinancialYear financialYear) {
        BalanceSum balanceSum = this.getCurrentBalance(currency, financialYear);
        return this.getAverageRateForCurrency(balanceSum);
    }

    private ConversionRate getAverageRateForCurrency(BalanceSum balanceSum) {
        return this.isAverageRateNotAvailable(balanceSum) ? null : this.calculateAverageRate(balanceSum);
    }

    private boolean isAverageRateNotAvailable(BalanceSum balanceSum) {
        BigDecimal balanceBC = balanceSum.getBalance();
        BigDecimal balanceFC = balanceSum.getQuantityBalance();
        return balanceBC.signum() == 0 || balanceFC.signum() == 0 || balanceBC.signum() < 0 && balanceFC.signum() > 0 || balanceBC.signum() > 0 && balanceFC.signum() < 0 || balanceFC.signum() < 0 && this.useDailyRateIfNegativeBalanceHU();
    }

    private boolean useDailyRateIfNegativeBalanceHU() {
        return this.getAccountingCompany().getJurisdictionType() == JurisdictionType.HU && this.isForeignBankAccount() && ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getUseDailyRateIfNegativeBalanceHU();
    }

    private ConversionRate calculateAverageRate(BalanceSum balanceSum) {
        BigDecimal baseBalance = balanceSum.getBalance();
        BigDecimal foreignBalance = balanceSum.getQuantityBalance();
        boolean useInverseRate = TransactionHelper.useInverseRate((AccountingCompany)this.getAccountingCompany(), (TransactionType)TransactionType.CASH_TRANSACTION, (ICurrency)balanceSum.getForeignCurrency(), (Date)DateHelper.today());
        if (useInverseRate) {
            BigDecimal inverseRate = foreignBalance.divide(baseBalance, 9, RoundingMode.HALF_UP);
            return new ConversionRate(inverseRate, true);
        }
        BigDecimal rate = baseBalance.divide(foreignBalance, 9, RoundingMode.HALF_UP);
        return new ConversionRate(rate, false);
    }

    public BigDecimal getRateForCurrency(ICurrency currency, FinancialYear financialYear) {
        ConversionRate averageRate = this.getAverageRateForCurrency(currency, financialYear);
        return averageRate != null ? averageRate.getRate() : null;
    }

    public ConversionRate getAverageRateForCurrencyExcludingTransaction(ICurrency currency, FinancialYear financialYear, NominalTransactionBase transaction) {
        BalanceSum balanceSum = this.getCurrentBalanceExcludingTransaction(currency, financialYear, transaction);
        return this.getAverageRateForCurrency(balanceSum);
    }

    private BalanceSum getCurrentBalanceExcludingTransaction(ICurrency currency, FinancialYear financialYear, NominalTransactionBase transaction) {
        BalanceSum balanceSum = this.getCurrentBalance(currency, financialYear);
        if (!transaction.getIsUnfinished()) {
            NominalLedgerEntry[] entries = transaction.getAllEnteredEntries();
            BankAccountEntry bankAccountEntry = null;
            for (int i = 0; i < entries.length; ++i) {
                if (!(entries[i] instanceof BankAccountEntry)) continue;
                bankAccountEntry = (BankAccountEntry)entries[i];
                break;
            }
            if (bankAccountEntry != null && bankAccountEntry.getBankAccount().equals((Object)this) && bankAccountEntry.getTransaction().getEnteredCurrency().equals(currency)) {
                if (bankAccountEntry.getIsDebit()) {
                    balanceSum.setAmountDebit(balanceSum.getAmountDebit().subtract(bankAccountEntry.getBaseAmount()));
                    balanceSum.setQuantityDebit(balanceSum.getQuantityDebit().subtract(bankAccountEntry.getEnteredAmount()));
                } else {
                    balanceSum.setAmountCredit(balanceSum.getAmountCredit().subtract(bankAccountEntry.getBaseAmount()));
                    balanceSum.setQuantityCredit(balanceSum.getQuantityCredit().subtract(bankAccountEntry.getEnteredAmount()));
                }
            }
        }
        return balanceSum;
    }

    public static ConversionRate getConversionRate(BankAccount bankAccount, boolean payment, ICurrency currency, FinancialYear financialYear, Date date) throws BusinessDomainException {
        boolean isCashAccountPayment;
        ConversionRate result = null;
        if (payment && (bankAccount.isCashAccount() || bankAccount.isForeignBankAccount() && bankAccount.useAverageRate(payment))) {
            result = bankAccount.getAverageRateForCurrency(currency, financialYear);
        }
        boolean bl = isCashAccountPayment = payment && bankAccount.isCashAccount();
        if (result == null && !isCashAccountPayment) {
            FinanceSetup financeSetup = financialYear.getCompany().getFinanceSetup();
            result = ExchangeRatePersistencyManager.getConversionRate((boolean)true, (ConversionTable)financeSetup.getBankRatesTable(), (ICurrency)currency, (ICurrency)financeSetup.getBaseCurrency(), (Date)date);
        }
        return result;
    }

    public static Comparator<BankAccount> getCodeComparator() {
        return BankAccountCodeComparator.getComparator();
    }

    public String getBillOfExchangeXMLFile() {
        this.requireLoaded();
        return this.mBillOfExchangeXMLFile;
    }

    public void setBillOfExchangeXMLFile(String billOfExchangeXMLFile) throws BusinessDomainException {
        this.protocol("BillOfExchangeXMLFile", this.mBillOfExchangeXMLFile, billOfExchangeXMLFile);
        this.mBillOfExchangeXMLFile = billOfExchangeXMLFile;
        if (!StringMapper.isNullString((String)this.mBillOfExchangeXMLFile)) {
            this.checkFileExists(this.mBillOfExchangeXMLFile, true);
        }
    }

    public String getTransferFileName() {
        this.requireLoaded();
        return this.mTransferFileName;
    }

    public void setTransferFileName(String transferFileName) {
        this.protocol("TransferFileName", this.mTransferFileName, transferFileName);
        this.mTransferFileName = transferFileName;
    }

    public BankStatementTransferFormatTypeEnum getTransferFormatType() {
        this.requireLoaded();
        return this.mTransferFormatType;
    }

    public void setTransferFormatType(BankStatementTransferFormatTypeEnum transferFormatType) {
        this.protocol("TransferFormatType", BankStatementTransferFormatTypeMapper.toString((BankStatementTransferFormatTypeEnum)this.mTransferFormatType), BankStatementTransferFormatTypeMapper.toString((BankStatementTransferFormatTypeEnum)transferFormatType));
        this.mTransferFormatType = transferFormatType;
    }

    public ASCIITransferFormat getASCIITransferFormat() {
        this.requireLoaded();
        return this.mASCIITransferFormat;
    }

    public void setASCIITransferFormat(ASCIITransferFormat asciiTransferFormat) {
        this.mASCIITransferFormat = asciiTransferFormat;
    }

    public TransactionDateTypeEnum getTransactionDateType() {
        this.requireLoaded();
        return this.mTransactionDateType;
    }

    public void setTransactionDateType(TransactionDateTypeEnum transactionDateType) {
        this.protocol("TransactionDateType", TransactionDateTypeMapper.toString((TransactionDateTypeEnum)this.mTransactionDateType), TransactionDateTypeMapper.toString((TransactionDateTypeEnum)transactionDateType));
        this.mTransactionDateType = transactionDateType;
    }

    public Cession getCession() {
        this.requireLoaded();
        if (this.hasCession()) {
            return this.mCession;
        }
        return null;
    }

    public void setCession(Cession cession) {
        this.mCession = cession;
    }

    public boolean hasCession() {
        this.requireLoaded();
        return this.mCession != null && this.mCession.getCessionLong() != null && !StringMapper.isNullString((String)this.mCession.getCessionLong().getString()) && !StringMapper.isNullString((String)this.mCession.getCessionShort());
    }

    public boolean getGenerateSepa() {
        this.requireLoaded();
        return this.mGenerateSepa;
    }

    public void setGenerateSepa(boolean generateSepa) {
        this.protocol("generatesepa", this.mGenerateSepa, generateSepa);
        this.mGenerateSepa = generateSepa;
    }

    public boolean getPrintByDunningLetter() {
        this.requireLoaded();
        return this.mPrintByDunningLetter;
    }

    public void setPrintByDunningLetter(boolean printByDunningLetter) {
        this.protocol("printbydunletter", this.mPrintByDunningLetter, printByDunningLetter);
        this.mPrintByDunningLetter = printByDunningLetter;
    }

    public void setForeignPayment(NLAccountCompanySetting accountSetting) {
        if (accountSetting != null && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)accountSetting.getFinanceSetup(), (IPersistentObject)this.getCurrentFinanceSetup())) {
            throw ExceptionMapper.makeApplicationException((String)"Foreign Payment is not in the current nominal ledger");
        }
        this.protocol("foreign payment", (IPersistentObject)this.mForeignPayment, (IPersistentObject)accountSetting);
        this.mForeignPayment = accountSetting;
    }

    public NLAccountCompanySetting getForeignPayment() {
        this.requireLoaded();
        return this.mForeignPayment;
    }

    public BigDecimal getCreditLimitForDate(Date date) {
        BigDecimal result = BigDecimal.ZERO;
        Date lastDate = VDate.getDateMin();
        if (date == null || this.getBankAccountAgreements() == null) {
            return result;
        }
        for (BankAccountAgreement element : this.mBankAccountAgreements) {
            Date contractDate = element.getDateOfContract();
            if (contractDate == null) {
                contractDate = VDate.getDateMin();
            }
            if (!DateHelper.beforeOrEqual((Date)contractDate, (Date)date) || !DateHelper.after((Date)contractDate, (Date)lastDate)) continue;
            lastDate = contractDate;
            result = BigDecimalMapper.toBigDecimal((BigDecimal)element.getAmountOfCreditLine()).abs();
        }
        return result;
    }

    public String getBackupDirectory() {
        this.requireLoaded();
        return this.mBackupDirectory;
    }

    public void setBackupDirectory(String backupDirectory) {
        this.mBackupDirectory = backupDirectory;
    }

    public boolean getNotForVarialWIN() {
        this.requireLoaded();
        return this.mNotForVarialWIN;
    }

    public void setNotForVarialWIN(boolean notForVarialWIN) {
        this.protocol("notforvarialwin", this.mNotForVarialWIN, notForVarialWIN);
        this.mNotForVarialWIN = notForVarialWIN;
    }

    public PaymentExportFormat getBankStatementFormat() {
        this.requireLoaded();
        return this.mBankStatementFormat;
    }

    public void setBankStatementFormat(PaymentExportFormat bankStatementFormat) {
        this.protocol("oidformatbankstat", (IPersistentObject)this.mBankStatementFormat, (IPersistentObject)bankStatementFormat);
        this.mBankStatementFormat = bankStatementFormat;
    }

    public boolean getSepaExpressDirectDebit() {
        this.requireLoaded();
        return this.mSepaExpressDirectDebit;
    }

    public void setSepaExpressDirectDebit(boolean sepaExpressDirectDebit) {
        this.protocol("sepaexpressdirectdebit", this.mSepaExpressDirectDebit, sepaExpressDirectDebit);
        this.mSepaExpressDirectDebit = sepaExpressDirectDebit;
    }

    public ISequenceNo getSequenceNoDirectDebitFile() {
        this.requireLoaded();
        return this.mSequenceNoDirectDebitFile;
    }

    public void setSequenceNoDirectDebitFile(ISequenceNo sequenceNoDirectDebitFile) {
        this.mSequenceNoDirectDebitFile = sequenceNoDirectDebitFile;
    }

    public ISequenceNo getSequenceNoPaymentFile() {
        this.requireLoaded();
        return this.mSequenceNoPaymentFile;
    }

    public void setSequenceNoPaymentFile(ISequenceNo sequenceNoPaymentFile) {
        this.mSequenceNoPaymentFile = sequenceNoPaymentFile;
    }

    public boolean isForeignPaymentAsIso() {
        this.requireLoaded();
        return this.mForeignPaymentAsIso;
    }

    public void setForeignPaymentAsIso(boolean foreignPaymentAsIso) {
        this.mForeignPaymentAsIso = foreignPaymentAsIso;
    }

    public IForeignPaymentChargesAccount getForeignPaymentChargesAccount() {
        this.requireLoaded();
        return this.mForeignPaymentChargesAccount;
    }

    public void setForeignPaymentChargesAccount(IForeignPaymentChargesAccount foreignPaymentChargesAccount) {
        this.mForeignPaymentChargesAccount = foreignPaymentChargesAccount;
    }

    public String getSepaServiceID() {
        String note = this.getNote();
        return note != null && note.indexOf(SEPA_SERVICE_ID_FIELD_NAME) >= 0 ? this.extractSepaServiceID(note) : null;
    }

    private String extractSepaServiceID(String note) {
        String value = note.substring(note.indexOf(SEPA_SERVICE_ID_FIELD_NAME) + SEPA_SERVICE_ID_FIELD_NAME.length());
        int endSign = 35;
        return value.indexOf(35) >= 0 ? StringMapper.toStringWithTrim((String)value.substring(0, value.indexOf(35))) : null;
    }
}

