/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.balancereport.scheduler;

import com.infor.igf.core.scheduler.SchedulerServiceException;
import com.infor.igf.core.scheduler.job.TransactionalJob;
import com.infor.igf.core.scheduler.job.URLProducing;
import com.varial.accounting.domain.balancereport.BalanceReportPreset;
import com.varial.accounting.domain.balancereport.BalanceReportPrint;
import com.varial.accounting.domain.balancereport.scheduler.BalanceReportParameter;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.session.SessionContext;
import com.varial.base.session.support.SessionFactory;
import com.varial.framework.basictypes.ReportMediaType;
import com.varial.framework.domain.reports.PrintJob;
import com.varial.framework.domain.reports.XMLUtils;
import com.varial.scheduler.Scheduler;
import com.varial.serverbase.basictypes.VDate;
import java.net.URL;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceReportPrintJob
extends TransactionalJob
implements URLProducing {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)BalanceReportPrintJob.class.getName());
    private String mRight;
    private String mOidGlobalLanguage;
    private BalanceReportPreset mPreset;
    private ReportMediaType mOutputFormat;
    private boolean mIsAdditionalOutputArchive;
    private String mOidReportingService;
    private final ApplicationServiceAdapter mApplAdapter = new ApplicationServiceAdapter();
    private List<URL> mURLs;
    private PrintJob.PrintJobType mPrintJobType;
    private String xmlDocument;

    public void setXmlDocument(String xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public List<URL> getResultList() {
        return this.mURLs;
    }

    protected void doExecute(JobExecutionContext context) {
        AuthorizationToken token = Scheduler.getInstance().loginForSchedulerJobExecution(this.getUserId());
        try {
            SessionContext.getInstance().setSession(SessionFactory.createSchedulerSession((AuthorizationToken)token));
            this.mApplAdapter.beginUpdateService();
            BalanceReportParameter parameters = (BalanceReportParameter)XMLUtils.fromXml((String)this.xmlDocument, BalanceReportParameter.class);
            if (parameters == null) {
                throw new IllegalArgumentException("Parameter object must not be null.");
            }
            this.mRight = parameters.getRight();
            this.mOidGlobalLanguage = parameters.getOidGlobalLanguage();
            this.mOutputFormat = ReportMediaType.valueOf((String)parameters.getOutputFormat());
            this.mIsAdditionalOutputArchive = parameters.getIsAdditionalOutputArchive();
            this.mOidReportingService = parameters.getOidReportingService();
            this.mPrintJobType = parameters.getPrintJobType();
            this.mPreset = new BalanceReportPreset(true);
            this.mPreset.fillParameterFromTransfer(parameters);
            BalanceReportPrint reportPrint = new BalanceReportPrint(token, this.mRight, this.mPreset, this.mOidGlobalLanguage, this.mOutputFormat, this.mIsAdditionalOutputArchive, VDate.getCurrentLocalizedTime(), null, this.mPrintJobType, this.mOidReportingService);
            reportPrint.execute();
            this.mURLs = reportPrint.getURLs();
            if (reportPrint.getTaskReminderCreated()) {
                this.mApplAdapter.getContext().flush();
            }
        }
        catch (Exception e) {
            throw new SchedulerServiceException((Throwable)e);
        }
        finally {
            this.mApplAdapter.endService();
            SessionContext.getInstance().clear();
        }
    }
}

