/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.balancereport;

import com.varial.accounting.balancereport.AccountListEnum;
import com.varial.accounting.balancereport.BalanceReportTypeEnum;
import com.varial.accounting.balancereport.WithZeroBalancedAccountsEnum;
import com.varial.accounting.balancereportform.BalanceReportFormRepTypeEnum;
import com.varial.accounting.domain.allaccountsdailybalance.AllAccountsDailyBalancePersistencyAppl;
import com.varial.accounting.domain.balancereport.BalanceReportContainer;
import com.varial.accounting.domain.balancereport.BalanceReportDataSource;
import com.varial.accounting.domain.balancereport.BalanceReportDetail;
import com.varial.accounting.domain.balancereport.BalanceReportDetailPersistencyManager;
import com.varial.accounting.domain.balancereport.BalanceReportForm;
import com.varial.accounting.domain.balancereport.BalanceReportFormRepTypeMapper;
import com.varial.accounting.domain.balancereport.BalanceReportPreset;
import com.varial.accounting.domain.balancereport.BalanceReportPresetCheck;
import com.varial.accounting.domain.balancereport.BalanceSheetPLProtocolReportContainer;
import com.varial.accounting.domain.balancereport.BalanceSheetPLProtocolReportDataSource;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedger;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.model.balancereport.BalanceReportDCPModel;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.base.text.TextFactory;
import com.varial.base.types.Ternary;
import com.varial.base.types.date.DateHelper;
import com.varial.dao.dcp.DCPModel;
import com.varial.dao.dcp.JRDataSourceWithRawValue;
import com.varial.framework.basictypes.PrintServiceDataStructCallback;
import com.varial.framework.basictypes.ReportMediaType;
import com.varial.framework.basictypes.ServiceTypeEnum;
import com.varial.framework.basictypes.VarianceEnum;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.printdocument.ReportType;
import com.varial.framework.domain.printservice.PrintService;
import com.varial.framework.domain.printservice.PrintServiceDCPManager;
import com.varial.framework.domain.printservice.PrintServicePersistencyManager;
import com.varial.framework.domain.printservice.RegionalSettingManager;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.reports.PrintJob;
import com.varial.framework.domain.taskreminder.TaskFolder;
import com.varial.framework.domain.taskreminder.TaskFolderPersistencyManager;
import com.varial.framework.domain.taskreminder.TaskFolderType;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.framework.domain.taskreminder.TaskReminderType;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.RegionalSettings;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.domain.user.IUser;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceReportPrint {
    protected final AuthorizationToken mToken;
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)BalanceReportPrint.class.getName());
    private static final Configuration CONFIGURATION = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private static final String CODE_MISEXPORT_EMG = "#MISExport#";
    protected final String mRight;
    protected BalanceReportPreset mPreset;
    protected ICurrency mCurrency;
    protected Language mGlobalLanguage;
    protected Language mReportLanguage;
    protected Language mLanguageForLangDepTexts;
    protected String mPrintTime;
    protected ReportMediaType mReportMediaType;
    protected boolean mIsAdditionalOutputArchive;
    protected String mUrlAsciiFile;
    private BigDecimalFormatter mBigDecimalFormatter;
    protected ServiceTypeEnum mServiceType;
    protected ReportType mReportTypeForOutputManager;
    protected PrintJob.PrintJobType mPrintJobType;
    protected PrintService mPrintService;
    protected List<URL> mURLs;
    private final boolean mMergePrintoutToOneFile = false;
    protected boolean mExceptionIsThrown = false;
    private static String PDFFILE_PROTOCOL_PREFIX = "PPR";
    private Criterion mWhere = null;
    private Order[] mOrder = null;
    private boolean mIsGroupReport;
    private List<IUser> mGroupMembers = null;
    private boolean mTaskReminderCreated;
    public static final int TASKREMINDER = 0;
    private static TranslateableResourceList mBalanceReportPrintList = TranslateableResourceList.createTranslateableResourceList("BalanceReportPrintList", new String[]{"Im Druckmanager liegen neue Auswertungen f\u00fcr Sie bereit."});

    public BalanceReportPrint(AuthorizationToken token, String right, BalanceReportPreset preset, String oidGlobalLanguage, ReportMediaType format, boolean isAdditionalOutputArchive, String printTime, ServiceTypeEnum serviceType, PrintJob.PrintJobType printJobType, String oidReportingService) throws BusinessDomainException {
        this.mToken = token;
        this.mRight = right;
        this.mPreset = preset;
        this.mCurrency = this.mPreset.getCurrency();
        this.mPrintTime = printTime;
        this.mReportMediaType = format;
        this.mIsAdditionalOutputArchive = isAdditionalOutputArchive;
        this.mServiceType = serviceType;
        this.mGlobalLanguage = LanguageManager.getInstance().getLanguage(oidGlobalLanguage);
        this.mReportTypeForOutputManager = BalanceReportFormRepTypeMapper.getReportType((BalanceReportFormRepTypeEnum)this.mPreset.getReportForm().getReportFormType());
        this.mPrintJobType = printJobType;
        this.mURLs = new ArrayList<URL>();
        this.mLanguageForLangDepTexts = this.mPreset.getLanguage();
        this.mReportLanguage = this.mLanguageForLangDepTexts.hasLocale() ? this.mLanguageForLangDepTexts : this.mGlobalLanguage;
        this.mBigDecimalFormatter = this.mLanguageForLangDepTexts.hasLocale() ? new BigDecimalFormatter(this.mLanguageForLangDepTexts.getLocale()) : new BigDecimalFormatter();
        this.mBigDecimalFormatter.setDecimalPlaces(Integer.valueOf(2));
        this.mPrintService = null;
        if (!StringMapper.isNullString((String)oidReportingService)) {
            this.mPrintService = PrintServicePersistencyManager.getPrintService((String)oidReportingService);
        }
        if (this.mPreset.getUserGroup() != null) {
            this.mGroupMembers = this.mPreset.getUserGroup().getUsers();
            this.mIsGroupReport = true;
        }
    }

    public void execute() throws BusinessDomainException, PutDataException {
        int i;
        BalanceReportForm reportForm = this.mPreset.getReportForm();
        boolean isNoCodeCheckWhenFromQuery = false;
        BalanceReportPresetCheck.checkObject((BalanceReportPreset)this.mPreset, (boolean)false);
        ArrayList resultList = new ArrayList();
        ArrayList<String> errorMessages = new ArrayList<String>();
        ArrayList<BalanceSheetPLProtocolReportContainer> uncodedAccounts = new ArrayList<BalanceSheetPLProtocolReportContainer>();
        BalanceReportDataSource reportDataSource = null;
        BalanceReportDataSource cumulatedReportDataSource = null;
        boolean isJurisdictionCZ = false;
        ArrayList<AccountingCompany> companies = new ArrayList<AccountingCompany>();
        if (this.mPreset.getIsMultiCompanySummarized()) {
            boolean perCompany = false;
            boolean summedUp = false;
            switch (this.mPreset.getMultiCompanyPrintout().value()) {
                case 0: {
                    perCompany = true;
                    break;
                }
                case 2: {
                    perCompany = true;
                    summedUp = true;
                    break;
                }
                case 1: {
                    summedUp = true;
                }
            }
            for (int i2 = 0; i2 < this.mPreset.getBalanceReportPresetCompanies().length; ++i2) {
                AccountingCompany queriedCompany = this.mPreset.getBalanceReportPresetCompanies()[i2];
                reportDataSource = this.queryForCompany(queriedCompany, errorMessages);
                boolean bl = isJurisdictionCZ = queriedCompany.getJurisdictionType() == JurisdictionType.CZ;
                if (perCompany) {
                    this.print(reportDataSource, isJurisdictionCZ);
                }
                if (this.mPreset.getPrintAccCheckAmounts()) {
                    uncodedAccounts.addAll(BalanceSheetPLProtocolReportDataSource.createContainerListOfUncodedAccounts((BalanceReportForm)reportForm, (Language)this.mGlobalLanguage, (AccountingCompany)queriedCompany, (boolean)true, (BalanceReportDataSource)reportDataSource, (BalanceReportPreset)this.mPreset, (boolean)false, (NominalLedger)reportDataSource.getNominalLedger()));
                }
                if (summedUp) {
                    if (i2 == 0) {
                        cumulatedReportDataSource = reportDataSource;
                        if (this.mPreset.getReportForm().getReportFormType() == BalanceReportFormRepTypeEnum.BRFRET_BALANCE && cumulatedReportDataSource != null) {
                            BalanceReportContainer.removeCapitalDeficit((List)cumulatedReportDataSource.getContainers());
                        }
                    } else if (cumulatedReportDataSource != null) {
                        cumulatedReportDataSource.add(reportDataSource);
                    }
                }
                companies.add(queriedCompany);
            }
            if (summedUp && !perCompany && cumulatedReportDataSource != null) {
                BalanceReportContainer.purgeDetails((List)cumulatedReportDataSource.getContainers(), (BalanceReportPreset)this.mPreset, (this.mPreset.getPrintAccountList() != AccountListEnum.ALE_NO ? 1 : 0) != 0);
            }
            if (summedUp && this.mPreset.getReportForm().getReportFormType() == BalanceReportFormRepTypeEnum.BRFRET_BALANCE && cumulatedReportDataSource != null && (this.mPreset.getNote() == null || this.mPreset.getNote() != null && !this.mPreset.getNote().contains("#Schalter01#"))) {
                BalanceReportContainer.assetLiabitilityAllocationCorrection((List)cumulatedReportDataSource.getContainers());
                BigDecimal[] values = BalanceReportContainer.calcBalanceSheetSummations((List)cumulatedReportDataSource.getContainers());
                BigDecimal profitOrLoss = values[0];
                BigDecimal balanceSheetTotalAktiva = values[1];
                BigDecimal balanceSheetTotalPassiva = values[2];
                BalanceReportContainer.calcSummations((List)cumulatedReportDataSource.getContainers(), (boolean)this.mPreset.getWithZeroBalancedPositions(), (WithZeroBalancedAccountsEnum)this.mPreset.getWithZeroBalancedAccounts(), errorMessages, (String)BalanceReportDataSource.getBalanceReportList().getString((ILanguage)this.mReportLanguage, 21));
                BalanceReportContainer.checkBalanceSummations((List)cumulatedReportDataSource.getContainers(), (BigDecimal)profitOrLoss, (BigDecimal)balanceSheetTotalAktiva, (BigDecimal)balanceSheetTotalPassiva, (BigDecimalFormatter)this.mBigDecimalFormatter, (Language)this.mReportLanguage, errorMessages);
            }
            if (cumulatedReportDataSource != null) {
                if (summedUp && this.mPreset.getSummaryStatementOfAcc()) {
                    BalanceReportContainer.summarizeAccountList((List)cumulatedReportDataSource.getContainers(), (Language)this.mReportLanguage);
                }
                if (summedUp && this.mPreset.getVariance() != null && this.mPreset.getVariance() != VarianceEnum.BRV_NONE) {
                    BalanceReportContainer.calcVariances((List)cumulatedReportDataSource.getContainers(), (VarianceEnum)this.mPreset.getVariance());
                }
                if (summedUp && this.mPreset.getWithPercentage()) {
                    BalanceReportContainer.calcColumnPercentages((List)cumulatedReportDataSource.getContainers());
                }
                if (summedUp && this.mPreset.getBalanceReportPresetCompanies().length > 0) {
                    cumulatedReportDataSource.reset();
                    this.print(cumulatedReportDataSource, isJurisdictionCZ);
                }
            }
        } else {
            reportDataSource = this.queryForCompany(this.mPreset.getAccountingCompany(), errorMessages);
            isJurisdictionCZ = this.mPreset.getAccountingCompany().getJurisdictionType() == JurisdictionType.CZ;
            this.print(reportDataSource, isJurisdictionCZ);
            if (this.mPreset.getPrintAccCheckAmounts()) {
                uncodedAccounts.addAll(BalanceSheetPLProtocolReportDataSource.createContainerListOfUncodedAccounts((BalanceReportForm)reportForm, (Language)this.mGlobalLanguage, (AccountingCompany)this.mPreset.getAccountingCompany(), (boolean)false, (BalanceReportDataSource)reportDataSource, (BalanceReportPreset)this.mPreset, (boolean)false, (NominalLedger)reportDataSource.getNominalLedger()));
            }
        }
        if (companies.isEmpty()) {
            companies.add(this.mPreset.getAccountingCompany());
        }
        if (!this.mPreset.getPrintAccCheckAmounts()) {
            boolean isMultiLedger = reportForm.getNominalLedgers().length > 1;
            for (i = 0; i < companies.size(); ++i) {
                AccountingCompany queriedCompany = (AccountingCompany)companies.get(i);
                List tempList = BalanceSheetPLProtocolReportDataSource.createContainerListOfUncodedAccounts((BalanceReportForm)reportForm, (Language)this.mGlobalLanguage, (AccountingCompany)queriedCompany, (boolean)false, (BalanceReportDataSource)reportDataSource, (BalanceReportPreset)this.mPreset, (boolean)isMultiLedger, (NominalLedger)queriedCompany.getCurrentNominalLedger(true));
                for (BalanceSheetPLProtocolReportContainer cont : tempList) {
                    if (uncodedAccounts.contains(cont)) continue;
                    uncodedAccounts.add(cont);
                }
            }
        }
        if (this.mReportMediaType == ReportMediaType.CSV && resultList.size() > 1) {
            Object s = (String)resultList.get(0);
            for (i = 1; i < resultList.size(); ++i) {
                String ss = (String)resultList.get(i);
                ss = ss.substring(ss.indexOf(10) + 1);
                s = (String)s + ss;
            }
            ArrayList<String> resultListReplacement = new ArrayList<String>();
            resultListReplacement.add((String)s);
            resultList = resultListReplacement;
        }
        if (this.mPreset.getReceiver() != null || this.mGroupMembers != null && this.mGroupMembers.size() > 0) {
            this.prepareTaskReminder(this.mPreset.getReceiver(), this.mGroupMembers);
        }
        if (this.mPreset.getPrintProtocol() || this.mExceptionIsThrown || this.mIsAdditionalOutputArchive) {
            this.printProtocol(companies, errorMessages, uncodedAccounts);
        }
    }

    private BalanceReportDataSource queryForCompany(AccountingCompany queriedCompany, List<String> errorMessages) throws BusinessDomainException, PutDataException {
        NominalLedger nominalLedger = queriedCompany.getCurrentNominalLedger(true);
        int rowCount = 0;
        BalanceReportForm reportForm = this.mPreset.getReportForm();
        rowCount = reportForm.getBalanceReportDetails().length;
        AllAccountsDailyBalancePersistencyAppl allAccDBAppl = new AllAccountsDailyBalancePersistencyAppl();
        for (int i = 0; i < reportForm.getBalanceReportDetails().length; ++i) {
            if (reportForm.getBalanceReportDetails()[i].getRowType().value() == 0 || reportForm.getBalanceReportDetails()[i].getRowType().value() == 2 || reportForm.getBalanceReportDetails()[i].getRowType().value() == 10) continue;
            BalanceReportDetail detail = reportForm.getBalanceReportDetails()[i];
            NominalLedgerAccount[] detailAccounts = detail.getBalanceReportDetailAccountsForNominalLedger(nominalLedger);
            rowCount += detailAccounts.length;
            if (detail.getRowType().value() != 8 && detail.getRowType().value() != 9) continue;
            NLAccountCompanySetting[] nlAccsCompSetting = new NLAccountCompanySetting[detailAccounts.length];
            for (int j = 0; j < detailAccounts.length; ++j) {
                nlAccsCompSetting[j] = detailAccounts[j].getNLAccountCompanySetting(queriedCompany);
            }
            FinancialYear baseFinYear = this.mPreset.getYearLeft();
            FinancialYear finYear = queriedCompany.getMatchingFinancialYear(baseFinYear);
            rowCount = (int)((long)rowCount + allAccDBAppl.getRowCountForPersAccs(queriedCompany, this.mCurrency, nlAccsCompSetting, this.mPreset.getUntilLeft(), finYear));
            if (this.mPreset.getReportType() != BalanceReportTypeEnum.BRT_CURRENT_YEAR_PREVIOUS_YEAR) continue;
            baseFinYear = this.mPreset.getYearRight();
            FinancialYear finYearComp = queriedCompany.getMatchingFinancialYear(baseFinYear);
            rowCount = (int)((long)rowCount + allAccDBAppl.getRowCountForPersAccs(queriedCompany, this.mCurrency, nlAccsCompSetting, this.mPreset.getUntilRight(), finYearComp));
        }
        this.mWhere = Restrictions.eq((String)"oidbalrepheader", (String)reportForm.getObjectid());
        this.mOrder = new Order[]{Order.asc((String)"rownumber")};
        PersistencyDataSet dataset = BalanceReportDetailPersistencyManager.getDataSet((Order[])this.mOrder, (Criterion)this.mWhere);
        return new BalanceReportDataSource(this.mPreset, queriedCompany, dataset, this.mLanguageForLangDepTexts, this.mReportLanguage, this.mGlobalLanguage, rowCount, this.mPrintTime, reportForm.getReportFormType(), errorMessages, this.mReportMediaType, (RegionalSettings)(this.mReportMediaType == ReportMediaType.CSV ? RegionalSettingManager.getRegionalSettings() : null), this.mIsAdditionalOutputArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(BalanceReportDataSource balanceReportDataSource, boolean isJurisdictionCZ) throws BusinessDomainException {
        block27: {
            Map parameters = balanceReportDataSource.getParameters();
            JasperReport jasperReport = this.getReportDefinition(parameters, isJurisdictionCZ);
            JRSwapFileVirtualizer virtualizer = null;
            try {
                virtualizer = new JRSwapFileVirtualizer(200, new JRSwapFile(CONFIGURATION.getVirtualizerWorkDir(), 100, 100));
                parameters.put("REPORT_VIRTUALIZER", virtualizer);
                if (this.mReportMediaType == ReportMediaType.PDF) {
                    if (this.mPreset.getAccountingCompany().getJurisdictionType() == JurisdictionType.CZ) {
                        File file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveForUserGroup((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)balanceReportDataSource, (ReportType)this.mReportTypeForOutputManager, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mIsGroupReport, (String)this.mPreset.getCode(), this.mGroupMembers, (IUser)this.mPreset.getReceiver());
                        if (!balanceReportDataSource.getHasDataToPrint()) {
                            try {
                                file.delete();
                            }
                            catch (Exception e) {
                                ExceptionMapper.printException((Throwable)e);
                            }
                        }
                        if (balanceReportDataSource.getHasDataToPrint()) {
                            this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("File name: {}", (Object)file.getName());
                            }
                        }
                        break block27;
                    }
                    JRDataSource helpDs = new JRDataSource(){
                        private boolean first = true;

                        public boolean next() throws JRException {
                            if (this.first) {
                                this.first = false;
                                return true;
                            }
                            return false;
                        }

                        public Object getFieldValue(JRField jrField) throws JRException {
                            return new Object();
                        }
                    };
                    File file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchiveForUserGroup((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)helpDs, (ReportType)this.mReportTypeForOutputManager, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsAdditionalOutputArchive, (boolean)this.mIsGroupReport, (String)this.mPreset.getCode(), this.mGroupMembers, (IUser)this.mPreset.getReceiver());
                    if (!balanceReportDataSource.getHasDataToPrint()) {
                        try {
                            file.delete();
                        }
                        catch (Exception e) {
                            ExceptionMapper.printException((Throwable)e);
                        }
                    }
                    if (balanceReportDataSource.getHasDataToPrint()) {
                        this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("File name: {}", (Object)file.getName());
                        }
                    }
                    break block27;
                }
                if (this.mReportMediaType == ReportMediaType.CSV) {
                    File file = JasperReportManager.runReportToAsciiForUserGroup((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)balanceReportDataSource, (String)this.mReportTypeForOutputManager.getPrefix(), (ReportType)this.mReportTypeForOutputManager, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)this.mIsGroupReport, (String)this.mPreset.getCode(), this.mGroupMembers, (IUser)this.mPreset.getReceiver());
                    if (balanceReportDataSource.getHasDataToPrint()) {
                        this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("File name: {}", (Object)file.getName());
                        }
                    }
                } else if (this.mReportMediaType == ReportMediaType.EXCEL) {
                    File file = PrintServiceDCPManager.runReportToExcelFromTemplateForUserGroup((String)this.mToken.getUserId(), (DCPModel)this.getDCPModel(), (JRDataSource)balanceReportDataSource, (String)this.mReportTypeForOutputManager.getPrefix(), (ReportType)this.mReportTypeForOutputManager, (PrintJob.PrintJobType)this.mPrintJobType, (PrintService)this.mPrintService, (boolean)this.mIsGroupReport, (String)this.mPreset.getCode(), this.mGroupMembers, (IUser)this.mPreset.getReceiver());
                    if (balanceReportDataSource.getHasDataToPrint()) {
                        this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("File name: {}", (Object)file.getName());
                        }
                    }
                } else if (this.mReportMediaType == ReportMediaType.DATABASE) {
                    DCPModel model = this.getDCPModel();
                    PrintServiceDCPManager.executePrintServiceProcess((PrintServiceDataStructCallback)null, (DCPModel)model, (JRDataSourceWithRawValue)balanceReportDataSource, (ServiceTypeEnum)ServiceTypeEnum.STE_DATABASE, (boolean)false, (PrintService)this.mPrintService);
                }
            }
            catch (Exception e) {
                LOGGER.error(TextFactory.makeErrorMethod((String)"BalanceReportPrint", (String)"print"), (Throwable)e);
                balanceReportDataSource.getErrorMessages().add(ExceptionMapper.toString((Throwable)e));
                this.mExceptionIsThrown = true;
                this.mPrintJobType = PrintJob.PrintJobType.ADHOCKEEPAFTERPRINTING;
            }
            finally {
                if (virtualizer != null) {
                    virtualizer.cleanup();
                }
            }
        }
    }

    protected String printProtocol(List<AccountingCompany> companies, List<String> errorMessages, List<BalanceSheetPLProtocolReportContainer> uncodedAccounts) throws BusinessDomainException {
        BalanceSheetPLProtocolReportDataSource protocolDataSource = BalanceSheetPLProtocolReportDataSource.createPresetProtocolDataSource((BalanceReportPreset)this.mPreset, (Language)this.mGlobalLanguage, (Language)this.mLanguageForLangDepTexts, (AccountingCompany)this.mPreset.getAccountingCompany(), companies, (String)this.mPrintTime, errorMessages, uncodedAccounts, (ReportMediaType)this.mReportMediaType, (boolean)this.mIsAdditionalOutputArchive);
        JasperReport protocolReport = null;
        Map parameters = protocolDataSource.getParameters();
        protocolReport = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_ProtocolReport.jrxml");
        File file = JasperReportManager.runReportToPdfWithStdProtectionForUserGroup((String)this.mToken.getUserId(), (JasperReport)protocolReport, (Map)parameters, (JRDataSource)protocolDataSource, (String)PDFFILE_PROTOCOL_PREFIX, (String)"Protokoll  Bilanz/GuV/BWA", (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsGroupReport, (String)this.mPreset.getCode(), this.mGroupMembers, (IUser)this.mPreset.getReceiver());
        this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
        return file.getName();
    }

    private JasperReport getReportDefinition(Map<String, Object> parameters, boolean isJurisdictionCZ) throws BusinessDomainException {
        JasperReport balanceReport = null;
        String reportDef = "";
        Boolean isKronoEnableCZforCYP = ISoftware.isKronospan() && isJurisdictionCZ && (this.mPreset.getAccountingCompany().getCountry().getIsoCode().equals("CY") || this.mPreset.getAccountingCompany().getCountry().getIsoCode().equals("CYP"));
        if (isJurisdictionCZ && (StringMapper.isNullString((String)this.mPreset.getNote()) || !this.mPreset.getNote().contains("#DisableCZDesign#")) && !isKronoEnableCZforCYP.booleanValue()) {
            reportDef = "com/varial/accounting/jasperreport/balancereport/CZ/BalanceSheet_PL_ReportCZ";
        } else {
            JasperReport subReportBalSheetOneYear;
            if (StringMapper.toString((String)this.mPreset.getNote()).contains("#ForeignCurrency#")) {
                subReportBalSheetOneYear = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportOneYearWithForeignCurrency.jrxml");
                parameters.put("SubReport_BalanceSheetPLOneYear", subReportBalSheetOneYear);
            } else {
                if (this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_CURRENT_YEAR || this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_OPENING_BALANCE_SHEET) {
                    subReportBalSheetOneYear = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportOneYear.jrxml");
                    parameters.put("SubReport_BalanceSheetPLOneYear", subReportBalSheetOneYear);
                }
                if (!(this.mPreset.getReportType() != BalanceReportTypeEnum.BRT_CURRENT_YEAR_PREVIOUS_YEAR && this.mPreset.getReportType() != BalanceReportTypeEnum.BRT_CURRENT_YEAR_BUDGET_YEAR || this.mPreset.getWithPercentage() || this.mPreset.getVariance() != VarianceEnum.BRV_NONE)) {
                    JasperReport subReportBalSheetTwoYear = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportTwoYear.jrxml");
                    parameters.put("SubReport_BalanceSheetPLTwoYear", subReportBalSheetTwoYear);
                }
                if ((this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_CURRENT_YEAR_PREVIOUS_YEAR || this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_CURRENT_YEAR_BUDGET_YEAR) && this.mPreset.getWithPercentage() && this.mPreset.getVariance() == VarianceEnum.BRV_NONE) {
                    JasperReport subReportBalSheetTwoYearPercent = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportTwoYearPercent.jrxml");
                    parameters.put("SubReport_BalanceSheetPLTwoYearPercent", subReportBalSheetTwoYearPercent);
                }
                if (!(this.mPreset.getReportType() != BalanceReportTypeEnum.BRT_CURRENT_YEAR_PREVIOUS_YEAR && this.mPreset.getReportType() != BalanceReportTypeEnum.BRT_CURRENT_YEAR_BUDGET_YEAR || this.mPreset.getWithPercentage() || this.mPreset.getVariance() == VarianceEnum.BRV_NONE)) {
                    JasperReport subReportBalSheetTwoYearCompare = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportTwoYearCompare.jrxml");
                    parameters.put("SubReport_BalanceSheetPLTwoYearCompare", subReportBalSheetTwoYearCompare);
                }
                if ((this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_CURRENT_YEAR_PREVIOUS_YEAR || this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_CURRENT_YEAR_BUDGET_YEAR) && this.mPreset.getWithPercentage() && this.mPreset.getVariance() != VarianceEnum.BRV_NONE) {
                    JasperReport subReportBalSheetTwoYearComparePercent = JasperReportCompiler.compileReport((String)"com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_SubReportTwoYearComparePercent.jrxml");
                    parameters.put("SubReport_BalanceSheetPLTwoYearComparePercent", subReportBalSheetTwoYearComparePercent);
                }
            }
            reportDef = "com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_Report";
        }
        if (this.mReportMediaType.equals((Object)ReportMediaType.PDF)) {
            Ternary autoArchiving = CONFIGURATION.getAutomaticArchivingType();
            if (autoArchiving != Ternary.FALSE) {
                parameters.put("Parameter_ArchiveKeywords", this.getArchivePrintLine());
            }
        } else if (this.mReportMediaType.equals((Object)ReportMediaType.CSV)) {
            reportDef = "com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_Report_grid";
            if (ISoftware.isEMG() && StringMapper.toString((String)this.mPreset.getNote()).contains(CODE_MISEXPORT_EMG)) {
                reportDef = "com/varial/accounting/jasperreport/balancereport/BalanceSheet_PL_Report_EMG_grid";
            }
        }
        balanceReport = JasperReportCompiler.compileReport((String)reportDef.concat(".jrxml"));
        return balanceReport;
    }

    private String getArchivePrintLine() {
        Date fromDate;
        FinancialYear finYear = this.mPreset.getYearLeft();
        if (this.mPreset.getReportForm().getReportFormType() == BalanceReportFormRepTypeEnum.BRFRET_BALANCE) {
            fromDate = finYear.getValidFrom();
            if (this.mPreset.getPeriodLeft() != null) {
                fromDate = this.mPreset.getPeriodLeft().getValidFrom();
            }
        } else {
            fromDate = this.mPreset.getPeriodLeft().getValidFrom();
        }
        Date untilDatePrint = this.mPreset.getPeriodLeft().getValidUntil();
        if (this.mPreset.getReportType() == BalanceReportTypeEnum.BRT_OPENING_BALANCE_SHEET) {
            this.mPreset.setPeriodLeft(null);
            untilDatePrint = DateHelper.yesterday((Date)finYear.getValidFrom());
        }
        if (DateHelper.after((Date)untilDatePrint, (Date)finYear.getValidUntil()) && DateHelper.beforeOrEqual((Date)fromDate, (Date)finYear.getValidUntil())) {
            untilDatePrint = finYear.getValidUntil();
        }
        StringBuffer strBuffer = new StringBuffer("C21003:");
        strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)DateHelper.today())).append(' ');
        strBuffer.append("C21004:");
        if (this.mPreset.getIsMultiCompanySummarized()) {
            strBuffer.append("summiert=");
            for (int i = 0; i < this.mPreset.getBalanceReportPresetCompanies().length; ++i) {
                strBuffer.append(this.mPreset.getBalanceReportPresetCompanies()[i].getCode());
                if (i >= this.mPreset.getBalanceReportPresetCompanies().length - 1) continue;
                strBuffer.append(',');
            }
            strBuffer.append(' ');
        } else {
            strBuffer.append(this.mPreset.getAccountingCompany().getCode()).append(' ');
        }
        strBuffer.append("C21005:");
        strBuffer.append(this.mPreset.getYearLeft().getCode()).append(' ');
        if (this.mPreset.getReportForm().getReportFormType() == BalanceReportFormRepTypeEnum.BRFRET_BALANCE) {
            strBuffer.append("C21042:");
            strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)untilDatePrint)).append(' ');
        } else {
            strBuffer.append("C21015:");
            strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)fromDate)).append(' ');
            strBuffer.append("C21016:");
            strBuffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)untilDatePrint)).append(' ');
        }
        switch (this.mPreset.getReportForm().getReportFormType().value()) {
            case 0: {
                strBuffer.append("C21030:Bilanz ");
                break;
            }
            case 1: {
                strBuffer.append("C21030:GuV ");
                break;
            }
            case 2: {
                strBuffer.append("C21030:BWA ");
                break;
            }
        }
        return strBuffer.toString();
    }

    public DCPModel getDCPModel() {
        return BalanceReportDCPModel.getInstance();
    }

    public List<URL> getURLs() {
        return this.mURLs;
    }

    public boolean getTaskReminderCreated() {
        return this.mTaskReminderCreated;
    }

    private void setTaskReminderCreated(boolean taskReminderCreated) {
        this.mTaskReminderCreated = taskReminderCreated;
    }

    private void prepareTaskReminder(IUser receiver, List<IUser> groupMembers) {
        this.setTaskReminderCreated(false);
        if (!ISoftware.getUseTaskReminderFinance()) {
            LOGGER.error("Dispatch type taskreminder is not allowed for config com.varial.server.UseTaskreminderFinance. Taskremminder was not sent.");
        } else {
            if (receiver != null) {
                this.createTaskReminder(receiver);
            }
            if (groupMembers != null && groupMembers.size() > 0) {
                for (int i = 0; i < groupMembers.size(); ++i) {
                    if (receiver != null && receiver.equals(groupMembers.get(i))) continue;
                    this.createTaskReminder(groupMembers.get(i));
                }
            }
        }
    }

    private void createTaskReminder(IUser receiver) {
        TaskReminder reminder = new TaskReminder();
        User creatorReminder = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode());
        reminder.setCreator(creatorReminder);
        TaskFolder creatorTodoFolder = TaskFolderPersistencyManager.getTaskFolderByType((User)creatorReminder, (TaskFolderType)TaskFolderType.PERSONALACCOUNT_INFORMATION);
        reminder.setCreatorFolder(creatorTodoFolder);
        User recepientReminder = (User)receiver;
        reminder.setRecipient(recepientReminder);
        TaskFolder recepientTodoFolder = TaskFolderPersistencyManager.getTaskFolderByType((User)recepientReminder, (TaskFolderType)TaskFolderType.PERSONALACCOUNT_INFORMATION);
        reminder.setRecipientFolder(recepientTodoFolder);
        reminder.setName(mBalanceReportPrintList.getString((ILanguage)this.mReportLanguage, 0));
        reminder.setNote("");
        reminder.setIsDone(false);
        reminder.setRecurringTask(null);
        reminder.setTaskType(TaskReminderType.SINGLE);
        reminder.setDueDate(DateHelper.today());
        reminder.setEntryDate(DateHelper.today());
        this.setTaskReminderCreated(true);
    }
}

