/*
 * Decompiled with CFR 0.152.
 */
package ce.varial.accounting.servantimpl.vatreturn;

import ce.varial.accounting.domain.vatreturn.IVATReturnCE;
import ce.varial.accounting.domain.vatreturn.VATReturnCE;
import ce.varial.accounting.domain.vatreturn.VATReturnCEHelper;
import ce.varial.accounting.domain.vatreturn.report.VATReturnCEJournalByNLReportDataSource;
import ce.varial.accounting.vatreturn.VATReturnCEJournalReportTypeEnum;
import com.varial.accounting.persistency.nominaltransact.INominaltransactDao;
import com.varial.accounting.persistency.nominaltransact.NominaltransactDao;
import com.varial.base.UtilitiesManager;
import com.varial.base.callback.AbstractAsynchronousPrintCommand;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.security.AuthorizationToken;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.printservice.PrintProgress;
import com.varial.framework.domain.printservice.ProgressInterface;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.reports.JasperReportTranslateableResource;
import com.varial.framework.domain.reports.PrintJob;
import com.varial.framework.domain.reports.ReportExceptionMapper;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VATReturnCEJournalByNLReportFileCallbackImpl
extends AbstractAsynchronousPrintCommand<ReportFileStructCallback> {
    private static final INominaltransactDao daoNominalTransAct = (INominaltransactDao)UtilitiesManager.getBean((String)"nominaltransactDao", NominaltransactDao.class);
    private static final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(VATReturnCEJournalByNLReportFileCallbackImpl.class);
    private final VATReturnCEJournalReportTypeEnum journalType;
    private final String vatReturnOID;

    public VATReturnCEJournalByNLReportFileCallbackImpl(AuthorizationToken token, ReportFileStructCallback callback, String oidVatReturnCE, VATReturnCEJournalReportTypeEnum journalType) {
        super(token, (AllCallbackOperations)callback);
        this.vatReturnOID = oidVatReturnCE;
        this.journalType = journalType;
    }

    public void execute() throws PutDataException, BusinessDomainException {
        VATReturnCE vatReturn = VATReturnCE.getVATReturnCE((String)this.vatReturnOID);
        Language language = vatReturn.getAccountingCompany().getLanguageForVATReturnReport();
        PrintProgress progressInterface = new PrintProgress((ReportFileStructCallback)this.getCallback());
        progressInterface.updateProgress(1, 2, JasperReportTranslateableResource.getMessageForClientGetData((Language)language), 1, 2);
        Criterion filter = this.getFilter(vatReturn);
        long rowCount = daoNominalTransAct.getRowCount(filter);
        if (rowCount == 0L) {
            throw ReportExceptionMapper.makeNoDataDomainException();
        }
        PersistencyDataSet dataset = daoNominalTransAct.getDataSet(this.getOrder(), filter);
        VATReturnCEJournalByNLReportDataSource vATReturnCEJournalEntryReportDataSource = new VATReturnCEJournalByNLReportDataSource((ProgressInterface)progressInterface, dataset, rowCount, (IVATReturnCE)vatReturn, this.journalType, language);
        Map<String, Object> parameters = vATReturnCEJournalEntryReportDataSource.getParameters();
        JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(500, new JRSwapFile(configuration.getVirtualizerWorkDir(), 100, 100));
        parameters.put("REPORT_VIRTUALIZER", virtualizer);
        JasperReport jasperReport = JasperReportCompiler.compileReport((String)this.getFileName());
        File file = JasperReportManager.runReportToPdfWithStdProtection((String)this.getToken().getUserId(), (JasperReport)jasperReport, parameters, (JRDataSource)vATReturnCEJournalEntryReportDataSource, (String)this.getPdfFilePrefix(), (String)"", (PrintJob.PrintJobType)PrintJob.PrintJobType.STANDARD, (boolean)false);
        String[] result = new String[]{JasperReportManager.getUrl((File)file)};
        LOGGER.debug("File name: {}", (Object)result[0]);
        virtualizer.cleanup();
        ((ReportFileStructCallback)this.getCallback()).putData(result);
    }

    private String getFileName() {
        if (this.journalType.value() == 7) {
            return "ce/varial/accounting/jasperreport/vatreturn/VATReturnJournalByTaxNLReport.jrxml";
        }
        if (this.journalType.value() == 11) {
            return "ce/varial/accounting/jasperreport/vatreturn/VATReturnJournalByTaxNLSumReport.jrxml";
        }
        return "ce/varial/accounting/jasperreport/vatreturn/VATReturnJournalByNLReport.jrxml";
    }

    private String getPdfFilePrefix() {
        return this.journalType.value() == 7 ? "VATCEJETAXNL" : "VATCEJENL";
    }

    private Criterion getFilter(VATReturnCE vatReturn) {
        return vatReturn.getIsAnnual() || vatReturn.getIsCorrection() ? VATReturnCEHelper.getReportsInFilter((String[])PersistentObjectUtils.getObjectIdsArray((IPersistentObject[])VATReturnCEHelper.getVATReturnReports((VATReturnCE)vatReturn))) : VATReturnCEHelper.getReportFilter((String)vatReturn.getObjectid());
    }

    private Order[] getOrder() {
        if (this.journalType.value() == 7 || this.journalType.value() == 11) {
            return new Order[]{Order.asc((String)"TAXCODE_1OR2"), Order.asc((String)"OIDTAXRATE_1OR2"), Order.asc((String)"CODE"), Order.asc((String)"TRANSACTIONDATE"), Order.asc((String)"T_OBJECTID"), Order.desc((String)"ISDOWNPAYMENT"), Order.desc((String)"ENTRYTYPE"), Order.asc((String)"T_TAXDATE"), Order.asc((String)"TRANSACTIONTYPE"), Order.asc((String)"REFERENCENUMBER")};
        }
        return new Order[]{Order.asc((String)"CODE"), Order.desc((String)"E_ISINPUTTAX"), Order.asc((String)"TC1_CODE"), Order.asc((String)"OIDTAXRATE"), Order.asc((String)"TRANSACTIONDATE"), Order.asc((String)"T_OBJECTID"), Order.desc((String)"ISDOWNPAYMENT"), Order.desc((String)"ENTRYTYPE"), Order.asc((String)"T_TAXDATE"), Order.asc((String)"TRANSACTIONTYPE"), Order.asc((String)"REFERENCENUMBER")};
    }
}

