/*
 * Decompiled with CFR 0.152.
 */
package ce.varial.accounting.domain.vatreturn.report;

import ce.varial.accounting.domain.vatreturn.IVATReturnCE;
import ce.varial.accounting.domain.vatreturn.VATReturnCEHelper;
import ce.varial.accounting.domain.vatreturn.report.VATReturnCEContainerNL;
import ce.varial.accounting.domain.vatreturn.report.VATReturnCERecapitulation;
import ce.varial.accounting.domain.vatreturn.report.VATReturnCEReportManager;
import ce.varial.accounting.domain.vatreturnform.TaxAssignmentNumber;
import ce.varial.accounting.vatreturn.VATReturnCEJournalReportTypeEnum;
import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.accountingcheck.AccountingCheckHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.taxcode.ITaxRate;
import com.varial.accounting.domain.taxcode.TaxCodeManager;
import com.varial.accounting.persistency.nominaltransact.NominaltransactContainer;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.printservice.ProgressInterface;
import com.varial.framework.domain.reports.JasperReportDataSourceBase;
import com.varial.framework.domain.reports.JasperReportTranslateableResource;
import com.varial.interfaces.IAccountingCompany;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.query.PutDataException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class VATReturnCEJournalByNLReportDataSource
extends JasperReportDataSourceBase {
    private final PersistencyDataSet mDataset;
    private VATReturnCEContainerNL mContainer;
    private final Map<String, String> mAssignedTaxRates;
    private final IVATReturnCE mVATReturnCE;
    private final IAccountingCompany mCompany;
    private final TaxCodeManager mTaxCodeManager;
    private final VATReturnCEReportManager mVATReturnCEReportManager;
    private final Language mLanguage;
    private final ICurrency mBaseCurrency;
    private BigDecimalFormatter mBigDecimalFormatter;
    private final VATReturnCEJournalReportTypeEnum mJournalType;
    private final VATReturnCERecapitulation mRecapitulation;
    private final Set<String> mNlentryOids;
    private final ProgressInterface mProgressInterface;
    private int mCounter;
    private final int mRowCount;
    private final String mMessageForClient;
    private final int mStepForProgressbar;
    private static final String P_BIGDECIMALFORMATTER = "P_BigDecimalFormatter";
    private static final String P_TAXNUMBER = "P_TaxNumber";
    private static final String P_ECTAXNUMBER = "P_ECTaxNumber";
    private static final String P_TAXPERIOD = "P_TaxPeriod";
    private static final String P_DATE = "P_Date";
    private static final String P_TIME = "P_Time";
    private static final String P_COMPANYNAME = "P_CompanyName";
    private static final String P_USER = "P_User";
    private static final String P_PRINTTAXATIONTYPE = "P_PrintTaxationType";
    private static final String P_PROVISIONALORDONE = "P_ProvisionalOrDone";
    private static final String P_SUMREPORT = "P_IsSumReport";
    private static final String P_RECAPITULATION = "P_Recapitulation";
    private static final String P_CURRENCY = "P_Currency";
    private static final String P_JOURNALTYPE = "P_JournalType";
    private static final String F_ISOUTPUT = "F_IsOutput";
    private static final String F_OUTPUTTAX = "F_OutputTax";
    private static final String F_TAXCODE = "F_TaxCode";
    private static final String F_TAXCODECODE = "F_TaxCodeCode";
    private static final String F_REFERENCENUMBER = "F_ReferenceNumber";
    private static final String F_GROSSAMOUNT = "F_GrossAmount";
    private static final String F_NETAMOUNT = "F_NetAmount";
    private static final String F_TAXAMOUNT = "F_TaxAmount";
    private static final String F_DEVIATION = "F_Deviation";
    private static final String F_GROSSAMOUNTDEBIT = "F_GrossAmountDebit";
    private static final String F_NETAMOUNTDEBIT = "F_NetAmountDebit";
    private static final String F_TAXAMOUNTDEBIT = "F_TaxAmountDebit";
    private static final String F_DEVIATIONDEBIT = "F_DeviationDebit";
    private static final String F_GROSSAMOUNTCREDIT = "F_GrossAmountCredit";
    private static final String F_NETAMOUNTCREDIT = "F_NetAmountCredit";
    private static final String F_TAXAMOUNTCREDIT = "F_TaxAmountCredit";
    private static final String F_DEVIATIONCREDIT = "F_DeviationCredit";
    private static final String F_REFERENCEDATE = "F_ReferenceDate";
    private static final String F_TRANSACTIONTYPE = "F_TransactionType";
    private static final String F_TAXRATE = "F_TaxRate";
    private static final String F_TAXRATEOID = "F_TaxRateOid";
    private static final String F_TAXTYPE = "F_TaxType";
    private static final String F_TAXDATE = "F_TaxDate";
    private static final String F_SEQUENCENUMBER = "F_SequenceNumber";
    private static final String F_TOTAL = "F_Total";
    private static final String F_TAXDESCRIPTION = "F_TaxDescription";
    private static final String F_NLACCOUNTCODE = "F_NLAccountCode";
    private static final String F_NLACCOUNTNAME = "F_NLAccountName";
    private static final String F_CSCODE = "F_CSCode";
    private static final String F_INPUTTAXSUM = "F_InputTaxSum";
    private static final String F_OUTPUTTAXSUM = "F_OutputTaxSum";
    private static final String F_OIDNLACCOUNT = "F_OidNLAccount";
    private static final String F_TRANSACTIONDATE = "F_TransactionDate";
    private static final String F_DESCRIPTION = "F_Description";
    private static final String F_SHORTNAME = "F_Shortname";
    private static final String F_CUSTSUPADDRESS = "F_CustSupAddress";
    private static final String F_ISTAXENTRY = "F_IsTaxEntry";
    private static final String F_NOTE = "F_Note";
    private static final String F_BALANCEAMOUNT = "F_BalanceAmount";
    private static final String S_VATRETURN = "S_VATReturn";
    private static final String S_ITEMLIST = "S_ItemList";
    private static final String S_COMPANY = "S_Company";
    private static final String S_VATNUMBER = "S_VATNumber";
    private static final String S_DATE = "S_Date";
    private static final String S_PERIOD = "S_Period";
    private static final String S_PAGE = "S_Page";
    private static final String S_TAXCODE = "S_TaxCode";
    private static final String S_SUBTOTALS = "S_SubTotals";
    private static final String S_TOTAL = "S_Total";
    private static final String S_INPUTTAX = "S_InputTax";
    private static final String S_OUTPUTTAX = "S_OutputTax";
    private static final String S_USER = "S_User";
    private static final String S_CURRENCY = "S_Currency";
    private static final int VATRETURN = 0;
    private static final int ITEMLIST = 1;
    private static final int COMPANY = 2;
    private static final int SVATNUMBER = 3;
    private static final int DATE = 4;
    private static final int PERIOD = 5;
    private static final int PAGE = 6;
    private static final int TAXCODE = 7;
    private static final int SUBTOTALS = 8;
    private static final int TOTAL = 9;
    private static final int INPUTTAX = 10;
    private static final int OUTPUTTAX = 11;
    private static final int USER = 12;
    private static final int PROVISIONAL = 13;
    private static final int DONE = 14;
    private static final int CURRENCY = 15;
    private static final int SORTBY = 16;
    private static final int NLACCOUNT = 17;
    private static final int DEVIATINGTAXDATE = 18;
    private static final int SUMLIST = 19;
    private static TranslateableResourceList mVATReturnJournalEntryByNLReportList = TranslateableResourceList.createTranslateableResourceList("VATReturnJournalEntryByNLReportList", new String[]{"VAT Return Report", "Itemized List", "Company", "VAT Number", "Date", "Period", "Page", "Tax Code", "Sub Totals", "Total", "Input Tax", "Output Tax", "User", "Provisional", "Done", "Currency", "nach", "Sachkonto", "Leistungsdatum abw. Per.", "Summenliste"});
    private static final String H_NLACCOUNTCODE = "H_NLAccountCode";
    private static final String H_NLACCOUNTNAME = "H_NLAccountName";
    private static final String H_CSCODE = "H_CSCode";
    private static final String H_CSNAME = "H_CSName";
    private static final String H_TAXDATE = "H_TaxDate";
    private static final String H_TRANSACTIONTYPE = "H_TransactionType";
    private static final String H_VATNUMBER = "H_VatNumber";
    private static final String H_REFERENCENUMBER = "H_ReferenceNumber";
    private static final String H_DOCUMENTDATE = "H_DocumentDate";
    private static final String H_GROSSAMOUNT = "H_GrossAmount";
    private static final String H_NETAMOUNT = "H_NetAmount";
    private static final String H_TAXAMOUNT = "H_TaxAmount";
    private static final String H_DEVIATION = "H_Deviation";
    private static final String H_TRANSACTIONDATE = "H_TransactionDate";
    private static final String H_SEQUENCENUMBER = "H_SequenceNumber";
    private static final String H_DESCRIPTION = "H_Description";
    private static final String H_TAXCODE = "H_TaxCode";
    private static final String H_CUSTSUPADDRESS = "H_CustSupAddress";
    private static final String H_NOTE = "H_Note";
    private static final int NLACCOUNTCODE = 0;
    private static final int NLACCOUNTNAME = 1;
    private static final int CSCODE = 2;
    private static final int CSNAME = 3;
    private static final int TAXDATE = 4;
    private static final int TRANSACTIONTPE = 5;
    private static final int VATNUMBER = 6;
    private static final int REFERENCENUMBER = 7;
    private static final int DOCUMENTDATE = 8;
    private static final int GROSSAMOUNT = 9;
    private static final int NETAMOUNT = 10;
    private static final int TAXAMOUNT = 11;
    private static final int DEVIATION = 12;
    private static final int TRANSACTIONDATE = 13;
    private static final int SEQUENCENUMBER = 14;
    private static final int DESCRIPTION = 15;
    private static final int HTAXCODE = 16;
    private static final int CUSTSUPADDRESS = 17;
    private static final int NOTE = 19;
    private static TranslateableResourceList mVATReturnJournalEntryByNLHeaderList = TranslateableResourceList.createTranslateableResourceList("VATReturnJournalEntryByNLHeaderList", new String[]{"N/L Account Code", "N/L Account Name", "C/S Code", "C/S Name", "Tax Date", "Transaction Type", "VAT Number", "Reference Number", "Document Date", "Gross Amount", "Net Amount", "Tax Amount", "Deviation", "Transaction Date", "Sequence Number", "Description", "Tax Code", "Address", "EC Tax Number", "Note"});

    public VATReturnCEJournalByNLReportDataSource(ProgressInterface progressInterface, PersistencyDataSet dataset, long datasetLength, IVATReturnCE vatReturnCE, VATReturnCEJournalReportTypeEnum reportType, Language language) throws PutDataException, BusinessDomainException {
        super(language, null);
        this.mDataset = dataset;
        this.mVATReturnCE = vatReturnCE;
        this.mCompany = this.mVATReturnCE.getAccountingCompany();
        this.mTaxCodeManager = TaxCodeManager.getTaxCodeManager((JurisdictionType)this.mCompany.getJurisdictionType());
        this.mLanguage = language;
        this.mVATReturnCEReportManager = new VATReturnCEReportManager(this.mVATReturnCE);
        this.mBaseCurrency = this.mVATReturnCE.getFinanceSetup().getBaseCurrency();
        this.mBigDecimalFormatter = new BigDecimalFormatter();
        if (this.mLanguage.hasLocale()) {
            this.mBigDecimalFormatter = new BigDecimalFormatter(this.mLanguage.getLocale());
        }
        this.mJournalType = reportType;
        this.mRecapitulation = new VATReturnCERecapitulation(1, this.mLanguage);
        this.mProgressInterface = progressInterface;
        this.mCounter = 0;
        this.mRowCount = (int)datasetLength;
        this.mStepForProgressbar = AccountingCheckHelper.getStepForProgressbar((int)this.mRowCount);
        this.mMessageForClient = JasperReportTranslateableResource.getMessageForClientPrintData((Language)language);
        this.mAssignedTaxRates = this.getAssignedTaxRatesMap();
        this.mNlentryOids = new HashSet<String>();
    }

    private Map<String, String> getAssignedTaxRatesMap() throws BusinessDomainException {
        TaxAssignmentNumber[] taxAssignments = VATReturnCEHelper.getTaxAssignments((IVATReturnCE)this.mVATReturnCE);
        return Arrays.stream(taxAssignments).flatMap(taxAssignment -> Arrays.stream(taxAssignment.getAssignedTaxRates())).map(PersistentObject::getObjectid).collect(Collectors.toSet()).stream().collect(Collectors.toMap(objectid -> objectid, objectid -> objectid));
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        Map parameters = this.getParameters(true);
        parameters.put(P_BIGDECIMALFORMATTER, this.mBigDecimalFormatter);
        parameters.put(P_TAXPERIOD, this.mVATReturnCEReportManager.getTaxReportPeriod());
        parameters.put(P_COMPANYNAME, this.mCompany.getCurrentAddress().getShortName());
        parameters.put(P_DATE, DateMapper.toString((ILanguage)this.mLanguage, (Date)DateHelper.today()));
        parameters.put(P_TIME, VDate.getCurrentLocalizedTime());
        parameters.put(P_TAXNUMBER, this.mCompany.getUKTaxNumber());
        parameters.put(P_ECTAXNUMBER, this.mCompany.getECTaxNumber(true));
        parameters.put(P_PRINTTAXATIONTYPE, this.mVATReturnCEReportManager.printTaxationType());
        parameters.put(P_USER, SessionContext.getInstance().getSession().getUserCode());
        parameters.put(P_SUMREPORT, this.mJournalType == VATReturnCEJournalReportTypeEnum.VRJRT_BY_NL_SUM);
        parameters.put(P_RECAPITULATION, this.mRecapitulation);
        parameters.put(P_CURRENCY, this.mBaseCurrency.getCode());
        parameters.put(P_JOURNALTYPE, this.mVATReturnCEReportManager.getJournalType(this.mJournalType));
        Object title = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 0);
        if (this.mJournalType.value() == 10) {
            title = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 1) + " " + mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 16);
        }
        parameters.put(S_VATRETURN, title);
        String itemList = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 1);
        if (this.mJournalType.value() == 10) {
            itemList = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 17);
        }
        if (this.mJournalType.value() == 11) {
            itemList = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 19);
        }
        parameters.put(S_ITEMLIST, itemList);
        parameters.put(S_COMPANY, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 2));
        parameters.put(S_VATNUMBER, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 3));
        parameters.put(S_DATE, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 4));
        parameters.put(S_PERIOD, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 5));
        parameters.put(S_PAGE, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 6));
        parameters.put(S_TAXCODE, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 7));
        parameters.put(S_SUBTOTALS, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 8));
        parameters.put(S_TOTAL, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 9));
        parameters.put(S_INPUTTAX, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 10));
        parameters.put(S_OUTPUTTAX, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 11));
        parameters.put(S_USER, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 12));
        parameters.put(S_CURRENCY, mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 15));
        parameters.put(H_NLACCOUNTCODE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 0));
        parameters.put(H_NLACCOUNTNAME, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 1));
        parameters.put(H_CSCODE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 2));
        parameters.put(H_REFERENCENUMBER, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 7));
        parameters.put(H_DOCUMENTDATE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 8));
        parameters.put(H_GROSSAMOUNT, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 9));
        parameters.put(H_NETAMOUNT, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 10));
        parameters.put(H_TAXAMOUNT, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 11));
        parameters.put(H_DEVIATION, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 12));
        parameters.put(H_TAXDATE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 4));
        parameters.put(H_TRANSACTIONTYPE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 5));
        parameters.put(H_VATNUMBER, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 6));
        parameters.put(H_TRANSACTIONDATE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 13));
        parameters.put(H_SEQUENCENUMBER, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 14));
        parameters.put(H_DESCRIPTION, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 15));
        parameters.put(H_TAXCODE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 16));
        if (this.mCompany.getJurisdictionType() == JurisdictionType.PL) {
            parameters.put(H_CSNAME, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 6));
            parameters.put(H_CUSTSUPADDRESS, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 17));
        } else {
            parameters.put(H_CSNAME, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 3));
        }
        parameters.put(H_NOTE, mVATReturnJournalEntryByNLHeaderList.getString((ILanguage)this.mLanguage, 19));
        String provisionalOrDone = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 13);
        if (this.mVATReturnCE.getIsClosed()) {
            provisionalOrDone = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 14);
        }
        if (this.mJournalType.value() == 10) {
            provisionalOrDone = mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 18);
        }
        parameters.put(P_PROVISIONALORDONE, provisionalOrDone);
        return parameters;
    }

    public boolean next() throws JRException {
        boolean result = false;
        this.mContainer = null;
        try {
            while (this.mDataset.hasNext() && !result) {
                NominaltransactContainer nlentry = (NominaltransactContainer)this.mDataset.getNext();
                ITaxRate nlentryTaxRate = this.getTaxRate(nlentry);
                boolean bl = result = this.assigned(nlentryTaxRate) && this.notPrinted(nlentry);
                if (result) {
                    this.mContainer = new VATReturnCEContainerNL(nlentry, this.mVATReturnCE, this.mLanguage, this.mTaxCodeManager, this.mJournalType, nlentryTaxRate);
                }
                ++this.mCounter;
                if (this.mProgressInterface == null || this.mCounter % this.mStepForProgressbar != 0) continue;
                this.mProgressInterface.updateProgress(this.mCounter, this.mRowCount, this.mMessageForClient, 2, 2);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private ITaxRate getTaxRate(NominaltransactContainer nlentry) {
        return TransactionHelper.getTaxRate((String)nlentry.oidtaxrate, (String)nlentry.oidfixtaxrate, (String)nlentry.oidfixtaxcode, (String)nlentry.oiddownpaymtaxcode, (Date)nlentry.t_taxdate);
    }

    private boolean notPrinted(NominaltransactContainer container) {
        return this.mNlentryOids.add(container.e_objectid);
    }

    private boolean assigned(ITaxRate nlEntryTaxRate) {
        return this.mAssignedTaxRates.containsKey(nlEntryTaxRate.getObjectid());
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.mContainer != null) {
            String fieldName = field.getName();
            try {
                boolean isAmount = true;
                if (F_ISOUTPUT.equals(fieldName)) {
                    value = this.mContainer.isOutput();
                } else if (F_OIDNLACCOUNT.equals(fieldName)) {
                    value = this.mContainer.getOidNLAccount();
                } else if (F_TAXDESCRIPTION.equals(fieldName)) {
                    value = this.mContainer.getTaxCodeDescription();
                } else if (F_TAXCODE.equals(fieldName)) {
                    value = this.mContainer.getTaxCodeWithTaxRatePercent();
                } else if (F_TAXCODECODE.equals(fieldName)) {
                    value = this.mContainer.getTaxCodeCode();
                } else if (F_TAXTYPE.equals(fieldName)) {
                    value = this.mContainer.getTaxType();
                } else if (F_REFERENCENUMBER.equals(fieldName)) {
                    value = this.mContainer.getReferenceNumber();
                } else if (F_CSCODE.equals(fieldName)) {
                    value = this.mContainer.getPersonalAccountCode();
                } else if (F_SHORTNAME.equals(fieldName)) {
                    if (this.mCompany.getJurisdictionType() == JurisdictionType.PL) {
                        value = this.mContainer.getTaxNumber();
                        if (!StringMapper.isNullString((String)this.mContainer.getEcTaxNumber())) {
                            value = value + "/n" + this.mContainer.getEcTaxNumber();
                        }
                    } else {
                        value = this.mContainer.getPersonalAccountShortName();
                    }
                } else if (F_CUSTSUPADDRESS.equals(fieldName)) {
                    if (this.mCompany.getJurisdictionType() == JurisdictionType.PL) {
                        value = this.mContainer.getPersonalAccountAddress();
                    }
                } else if (F_NLACCOUNTCODE.equals(fieldName)) {
                    value = this.mContainer.getNlAccountCode();
                } else if (F_NLACCOUNTNAME.equals(fieldName)) {
                    value = this.mContainer.getNlAccountName();
                } else if (F_GROSSAMOUNT.equals(fieldName)) {
                    value = this.mContainer.getGrossAmount();
                } else if (F_NETAMOUNT.equals(fieldName)) {
                    value = this.mContainer.getNetAmount();
                } else if (F_TAXAMOUNT.equals(fieldName)) {
                    value = this.mContainer.getTaxAmount();
                } else if (F_DEVIATION.equals(fieldName)) {
                    value = this.mContainer.getDeviation();
                } else if (F_BALANCEAMOUNT.equals(fieldName)) {
                    value = this.mContainer.getBalanceAmount();
                } else if (F_GROSSAMOUNTDEBIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? BigDecimal.ZERO : this.mContainer.getGrossAmount();
                } else if (F_NETAMOUNTDEBIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? BigDecimal.ZERO : this.mContainer.getNetAmount();
                } else if (F_TAXAMOUNTDEBIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? BigDecimal.ZERO : this.mContainer.getTaxAmount();
                } else if (F_DEVIATIONDEBIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? BigDecimal.ZERO : this.mContainer.getDeviation();
                } else if (F_GROSSAMOUNTCREDIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? this.mContainer.getGrossAmount() : BigDecimal.ZERO;
                } else if (F_NETAMOUNTCREDIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? this.mContainer.getNetAmount() : BigDecimal.ZERO;
                } else if (F_TAXAMOUNTCREDIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? this.mContainer.getTaxAmount() : BigDecimal.ZERO;
                } else if (F_DEVIATIONCREDIT.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? this.mContainer.getDeviation() : BigDecimal.ZERO;
                } else if (F_REFERENCEDATE.equals(fieldName)) {
                    value = this.mContainer.getDocumentDate();
                } else if (F_TRANSACTIONTYPE.equals(fieldName)) {
                    value = this.mContainer.getTransactionType();
                } else if (F_TAXRATE.equals(fieldName)) {
                    value = this.mContainer.getTaxRatePercent();
                    isAmount = false;
                    value = ((BigDecimal)value).setScale(2);
                } else if (F_TAXRATEOID.equals(fieldName)) {
                    value = this.mContainer.getOidTaxRate();
                } else if (F_TAXDATE.equals(fieldName)) {
                    value = this.mContainer.getTaxDate();
                } else if (F_SEQUENCENUMBER.equals(fieldName)) {
                    value = this.mContainer.getSequenceNumber();
                } else if (F_TOTAL.equals(fieldName)) {
                    value = this.mVATReturnCE.getReportedAmount();
                } else if (F_OUTPUTTAX.equals(fieldName)) {
                    value = this.mContainer.isOutput() ? mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 11) : mVATReturnJournalEntryByNLReportList.getString((ILanguage)this.mLanguage, 10);
                } else if (F_INPUTTAXSUM.equals(fieldName)) {
                    value = BigDecimalMapper.ZERO;
                } else if (F_OUTPUTTAXSUM.equals(fieldName)) {
                    value = BigDecimalMapper.ZERO;
                } else if (F_DESCRIPTION.equals(fieldName)) {
                    value = this.mContainer.getNote();
                } else if (F_TRANSACTIONDATE.equals(fieldName)) {
                    value = this.mContainer.getTransactionDate();
                } else if (F_ISTAXENTRY.equals(fieldName)) {
                    value = this.mContainer.isTaxEntry();
                } else if (F_NOTE.equals(fieldName)) {
                    value = this.mContainer.getNote();
                }
                if (value instanceof String) {
                    value = StringUtil.toJasperString((String)((String)value));
                } else if (value instanceof Date) {
                    value = DateMapper.toString((ILanguage)this.mLanguage, (Date)((Date)value));
                } else if (value instanceof BigDecimal && isAmount) {
                    value = this.toAmount((BigDecimal)value);
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        return value;
    }

    private BigDecimal toAmount(BigDecimal amount) {
        return amount != null ? this.mBaseCurrency.round(amount) : null;
    }

    public boolean getHasDataToPrintBeforeRun() {
        return true;
    }

    public boolean getHasDataToPrintAfterRun() {
        return true;
    }
}

