/*
 * Decompiled with CFR 0.152.
 */
package ce.varial.accounting.domain.vatreturn.report;

import ce.varial.accounting.domain.vatreturn.IVATReturnCE;
import ce.varial.accounting.domain.vatreturn.VATReturnCEHelper;
import ce.varial.accounting.vatreturn.VATReturnCEJournalReportTypeEnum;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.custsupaddress.CustSupAddressPersistencyManagerBase;
import com.varial.accounting.domain.documenttype.DocumentCategoryMapper;
import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySettingPersistencyManager;
import com.varial.accounting.domain.nominalledger.TaxAccountTypeEnum;
import com.varial.accounting.domain.nominaltransactionbase.DownPaymentHelper;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.openitem.OpenItemTaxManager;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.taxcode.CalculatedTax;
import com.varial.accounting.domain.taxcode.ITaxCode;
import com.varial.accounting.domain.taxcode.ITaxRate;
import com.varial.accounting.domain.taxcode.TaxCodeManager;
import com.varial.accounting.domain.taxcode.TaxHandlingType;
import com.varial.accounting.persistency.nominaltransact.NominaltransactContainer;
import com.varial.accounting.persistency.taxreturnnlentry.ITaxreturnnlentryDao;
import com.varial.accounting.persistency.taxreturnnlentry.TaxreturnnlentryContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.interfaces.IAccountingCompany;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class VATReturnCEContainerNL {
    private static final ITaxreturnnlentryDao dao = (ITaxreturnnlentryDao)UtilitiesManager.getBean((String)"taxreturnnlentryDao", ITaxreturnnlentryDao.class);
    private final boolean outputTax;
    private final boolean isTaxEntry;
    private final boolean ecPurchaseTaxCode;
    private final String oidTransaction;
    private final String oidNlEntry;
    private final String oidNLAccount;
    private final String oidTaxRate;
    private final String taxCodeDescription;
    private final String taxCodeCode;
    private final String taxCodeWithTaxRatePercent;
    private final String taxType;
    private final BigDecimal taxRatePercent;
    private final Date taxDate;
    private final String note;
    private final String referenceNumber;
    private final Date documentDate;
    private final String transactionType;
    private final String sequenceNumber;
    private final Date transactionDate;
    private String personalAccountCode;
    private String personalAccountShortName;
    private String personalAccountAddress;
    private String taxNumber;
    private String ecTaxNumber;
    private final String nlAccountCode;
    private final String nlAccountName;
    private final BigDecimal grossAmount;
    private final BigDecimal netAmount;
    private final BigDecimal taxAmount;
    private final BigDecimal deviation;
    private final BigDecimal balanceAmount;

    public VATReturnCEContainerNL(NominaltransactContainer nlentry, IVATReturnCE vatReturn, Language reportLanguage, TaxCodeManager taxCodeManager, VATReturnCEJournalReportTypeEnum reportType, ITaxRate nlentryTaxRate) {
        PersonalAccount personalAccount;
        ITaxCode taxCode = nlentryTaxRate.getTaxCode();
        this.taxCodeCode = taxCode.getCode();
        this.taxCodeDescription = nlentryTaxRate.getDescription(reportLanguage);
        this.taxType = taxCodeManager.getTaxType(reportLanguage, taxCode);
        this.ecPurchaseTaxCode = taxCodeManager.isECPurchaseListTaxCode(taxCode);
        this.taxDate = this.getTaxDate(nlentry, taxCode);
        this.taxRatePercent = nlentryTaxRate.getRate();
        this.oidTaxRate = nlentryTaxRate.getObjectid();
        this.taxCodeWithTaxRatePercent = taxCode.getCode() + " - " + BigDecimalMapper.toString((BigDecimal)this.taxRatePercent.setScale(2)) + "%";
        this.personalAccountCode = "";
        this.personalAccountAddress = "";
        this.personalAccountShortName = "";
        this.taxNumber = "";
        this.ecTaxNumber = "";
        IAccountingCompany company = vatReturn.getAccountingCompany();
        if (this.isNotSummarisedReport(reportType) && (personalAccount = this.getPersonalAccount(nlentry)) != null) {
            this.personalAccountCode = personalAccount.getCode();
            CustSupAddress custSupAddress = this.getCustSupAddress(personalAccount, nlentry);
            if (custSupAddress != null) {
                this.taxNumber = custSupAddress.getVatTaxNumber();
                this.ecTaxNumber = custSupAddress.getEcTaxNumber();
                this.personalAccountShortName = FactoringHelper.checkField((String)custSupAddress.getPostalAddress().getName1());
                this.personalAccountAddress = FactoringHelper.checkField((String)custSupAddress.getPostalAddress().getFormatedAddress((ICompany)company, (ILanguage)reportLanguage));
            }
        }
        this.oidTransaction = nlentry.t_objectid;
        this.oidNlEntry = nlentry.e_objectid;
        this.outputTax = !nlentry.e_isinputtax;
        this.documentDate = nlentry.documentdate;
        this.referenceNumber = nlentry.referencenumber;
        this.sequenceNumber = nlentry.sequencenumber;
        this.transactionType = DocumentCategoryMapper.toString((Language)reportLanguage, (int)nlentry.documentcategory);
        this.transactionDate = nlentry.transactiondate;
        this.note = nlentry.description;
        this.isTaxEntry = nlentry.entrytype == 1;
        List<TaxreturnnlentryContainer> actTaxations = this.getActtaxations(nlentryTaxRate, nlentry, vatReturn);
        NLAccountCompanySetting nlAccount = this.getNlAccount(nlentry, actTaxations);
        this.oidNLAccount = nlAccount.getObjectid();
        this.nlAccountCode = nlAccount.getNominalLedgerItemCode();
        this.nlAccountName = nlAccount.getShortName();
        if (nlentry.entrytype == 1) {
            this.taxAmount = this.setSignum(this.getTaxAmount(nlentry, actTaxations), nlentry.debit);
            this.netAmount = VATReturnCEHelper.getNetAmount((BigDecimal)this.setSignum(this.getNetAmount(nlentry, actTaxations), nlentry.debit), (BigDecimal)this.taxAmount, (boolean)nlentry.isinputtaxdeduct, (JurisdictionType)company.getJurisdictionType(), null);
            this.deviation = this.getTaxVariance(nlentry, actTaxations);
            this.grossAmount = VATReturnCEHelper.getGrossAmount((BigDecimal)VATReturnCEHelper.getGrossAmount((int)nlentry.entrytype, (ITaxCode)taxCode, (BigDecimal)this.netAmount, (BigDecimal)this.taxAmount, (boolean)nlentry.isinputtaxdeduct), (boolean)nlentry.isinputtaxdeduct, (JurisdictionType)company.getJurisdictionType());
        } else {
            BigDecimal calculatedNetAmount;
            BigDecimal calculatedTaxAmount;
            ICurrency baseCurrency = company.getFinanceSetup().getBaseCurrency();
            if (nlentry.entrytype == 4) {
                PersonalAccountEntry downPaymentPersonalAccountEntry = PersonalAccountEntry.getPersonalAccountEntry((String)nlentry.e_objectid);
                NominalTaxEntry[] downPaymentTaxEntries = DownPaymentHelper.getTaxEntries((PersonalAccountEntry)downPaymentPersonalAccountEntry);
                calculatedTaxAmount = this.getDownPaymentBaseAmount(downPaymentTaxEntries, DownPaymentHelper.DownPaymentAmountType.DPAT_BASE_TAX_AMOUNT, nlentry.iscanceltransact);
                calculatedNetAmount = this.getDownPaymentBaseAmount(downPaymentTaxEntries, DownPaymentHelper.DownPaymentAmountType.DPAT_BASE_NET_AMOUNT, nlentry.iscanceltransact);
            } else {
                BigDecimal baseAmount;
                calculatedNetAmount = baseAmount = nlentry.baseamount;
                if (nlentry.isinputtaxdeduct) {
                    calculatedTaxAmount = BigDecimalMapper.negate((BigDecimal)baseAmount);
                } else if (taxCode.isEuErwerb()) {
                    calculatedTaxAmount = BigDecimalMapper.ZERO;
                } else {
                    CalculatedTax calculatedTax = OpenItemTaxManager.calculateTax((BigDecimal)baseAmount, (boolean)false, null, (ITaxRate[])new ITaxRate[]{nlentryTaxRate}, (ICurrency)baseCurrency, (boolean)this.outputTax, (JurisdictionType)nlentryTaxRate.getTaxCode().getJurisdictionType());
                    calculatedTaxAmount = calculatedTax.getTaxAmount();
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)baseAmount) && baseAmount.signum() < 0) {
                        calculatedTaxAmount = BigDecimalMapper.negate((BigDecimal)calculatedTaxAmount);
                    }
                }
            }
            this.netAmount = this.setSignum(calculatedNetAmount, nlentry.debit);
            this.taxAmount = this.setSignum(calculatedTaxAmount, nlentry.debit);
            this.deviation = BigDecimalMapper.ZERO;
            this.grossAmount = VATReturnCEHelper.getGrossAmount((int)nlentry.entrytype, (ITaxCode)taxCode, (BigDecimal)this.netAmount, (BigDecimal)this.taxAmount, (boolean)nlentry.isinputtaxdeduct);
        }
        this.balanceAmount = this.getBalanceAmount(nlentry.entrytype, this.taxAmount, this.netAmount, this.grossAmount);
    }

    private boolean isActTaxation(ITaxRate taxRate, NominaltransactContainer nlentry) {
        if (nlentry.entrytype == 1) {
            return VATReturnCEHelper.isActTaxation((int)nlentry.taxaccounttype);
        }
        if (nlentry.entrytype == 4) {
            return false;
        }
        return (nlentry.transactiontype == TransactionType.INVOICE_PAYABLE.persistentValue() || nlentry.transactiontype == TransactionType.INVOICE_RECEIVABLE.persistentValue()) && taxRate.getIsActTaxation();
    }

    private BigDecimal getTaxAmount(NominaltransactContainer nlentry, List<TaxreturnnlentryContainer> actTaxations) {
        if (actTaxations.size() > 0) {
            return this.getAmount(AmountType.TAX_AMOUNT, actTaxations);
        }
        return nlentry.baseamount;
    }

    private BigDecimal getNetAmount(NominaltransactContainer nlentry, List<TaxreturnnlentryContainer> actTaxations) {
        if (actTaxations.size() > 0) {
            return this.getAmount(AmountType.NET_AMOUNT, actTaxations);
        }
        return nlentry.netamount;
    }

    private BigDecimal getTaxVariance(NominaltransactContainer nlentry, List<TaxreturnnlentryContainer> actTaxations) {
        if (actTaxations.size() > 0) {
            return this.getAmount(AmountType.VARIANCE, actTaxations);
        }
        return nlentry.taxvariance;
    }

    private BigDecimal getAmount(AmountType amountType, List<TaxreturnnlentryContainer> actTaxations) {
        if (actTaxations.size() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = BigDecimal.ZERO;
        for (TaxreturnnlentryContainer actTaxation : actTaxations) {
            BigDecimal amount = this.getAmount(amountType, actTaxation);
            sum = BigDecimalMapper.add((BigDecimal)sum, (BigDecimal)amount);
        }
        return sum;
    }

    private BigDecimal getAmount(AmountType amountType, TaxreturnnlentryContainer actTaxation) {
        switch (amountType) {
            case TAX_AMOUNT: {
                return actTaxation.reportedtaxamount;
            }
            case NET_AMOUNT: {
                return actTaxation.reportednetamount;
            }
            case VARIANCE: {
                return actTaxation.reportedtaxvarianc;
            }
        }
        return null;
    }

    private NLAccountCompanySetting getNlAccount(NominaltransactContainer nlentry, List<TaxreturnnlentryContainer> actTaxations) {
        if (nlentry.entrytype == 1 && actTaxations.size() > 0) {
            return VATReturnCEHelper.getTaxAccount((TaxreturnnlentryContainer)actTaxations.get(0));
        }
        return NLItemCompanySettingPersistencyManager.getNLAccountCompanySetting((String)nlentry.oidaccount);
    }

    private List<TaxreturnnlentryContainer> getActtaxations(ITaxRate taxRate, NominaltransactContainer nlentry, IVATReturnCE vatReturn) {
        if (nlentry.entrytype != 1) {
            return Collections.emptyList();
        }
        boolean actTaxation = this.isActTaxation(taxRate, nlentry);
        if (!actTaxation) {
            return Collections.emptyList();
        }
        TaxreturnnlentryContainer[] actTaxations = dao.getRows(null, (Criterion)Restrictions.conjunction().add(Restrictions.eq((String)"OIDNLENTRY", (String)nlentry.e_objectid)).add(VATReturnCEHelper.getJournalReportInFilter((IVATReturnCE)vatReturn)).add(Restrictions.isNotNull((String)"oidopenitemalloc")));
        return actTaxations != null ? Arrays.asList(actTaxations) : Collections.emptyList();
    }

    private PersonalAccount getPersonalAccount(NominaltransactContainer nlentry) {
        if (!StringMapper.isNullString((String)nlentry.oidcontrapersacc)) {
            return PersonalAccountPersistencyManager.getPersonalAccount((String)nlentry.oidcontrapersacc);
        }
        if (!StringMapper.isNullString((String)nlentry.oidpersonalacc)) {
            return PersonalAccountPersistencyManager.getPersonalAccount((String)nlentry.oidpersonalacc);
        }
        return null;
    }

    private CustSupAddress getCustSupAddress(PersonalAccount personalAccount, NominaltransactContainer nlentry) {
        if (personalAccount == null) {
            return null;
        }
        return personalAccount.getOneOffAccount() ? this.getOneOffAccountAddress(nlentry) : personalAccount.getAddress();
    }

    private CustSupAddress getOneOffAccountAddress(NominaltransactContainer nlentry) {
        if (!StringMapper.isNullString((String)nlentry.oidcustsupadr)) {
            return CustSupAddressPersistencyManagerBase.getCustSupAddress((String)nlentry.oidcompany, (String)nlentry.oidcustsupadr);
        }
        if (!StringMapper.isNullString((String)nlentry.oidcontroneoffadr)) {
            return CustSupAddressPersistencyManagerBase.getCustSupAddress((String)nlentry.oidcompany, (String)nlentry.oidcontroneoffadr);
        }
        return null;
    }

    private BigDecimal getBalanceAmount(int entryType, BigDecimal taxAmount, BigDecimal netAmount, BigDecimal grossAmount) {
        if (entryType == 1) {
            return taxAmount;
        }
        if (entryType == 4) {
            return grossAmount;
        }
        return netAmount;
    }

    private BigDecimal setSignum(BigDecimal amount, boolean debit) {
        if (amount == null) {
            return null;
        }
        return !debit ? amount.negate() : amount;
    }

    public boolean isOutput() {
        return this.outputTax;
    }

    public boolean isEcPurchaseTaxCode() {
        return this.ecPurchaseTaxCode;
    }

    public BigDecimal getGrossAmount() {
        return this.grossAmount;
    }

    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public BigDecimal getDeviation() {
        return this.deviation;
    }

    public Date getDocumentDate() {
        return this.documentDate;
    }

    public BigDecimal getTaxRatePercent() {
        return this.taxRatePercent;
    }

    public Date getTaxDate() {
        return this.taxDate;
    }

    public Date getTransactionDate() {
        return this.transactionDate;
    }

    public boolean isTaxEntry() {
        return this.isTaxEntry;
    }

    public String getNote() {
        return this.note;
    }

    public String getTaxCodeDescription() {
        return this.taxCodeDescription;
    }

    public String getTaxCodeCode() {
        return this.taxCodeCode;
    }

    public String getTaxCodeWithTaxRatePercent() {
        return this.taxCodeWithTaxRatePercent;
    }

    public String getTaxType() {
        return this.taxType;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public String getPersonalAccountCode() {
        return this.personalAccountCode;
    }

    public String getPersonalAccountShortName() {
        return this.personalAccountShortName;
    }

    public String getPersonalAccountAddress() {
        return this.personalAccountAddress;
    }

    public String getTaxNumber() {
        return this.taxNumber;
    }

    public String getEcTaxNumber() {
        return this.ecTaxNumber;
    }

    public String getNlAccountCode() {
        return this.nlAccountCode;
    }

    public String getNlAccountName() {
        return this.nlAccountName;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getOidTaxRate() {
        return this.oidTaxRate;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getOidTransaction() {
        return this.oidTransaction;
    }

    public String getOidNlEntry() {
        return this.oidNlEntry;
    }

    public String getOidNLAccount() {
        return this.oidNLAccount;
    }

    public BigDecimal getBalanceAmount() {
        return this.balanceAmount;
    }

    private Date getTaxDate(NominaltransactContainer nlentry, ITaxCode taxCode) {
        Date taxConfirmationDate = this.getTaxConfirmationDate(nlentry, taxCode);
        return taxConfirmationDate != null ? taxConfirmationDate : nlentry.t_taxdate;
    }

    private Date getTaxConfirmationDate(NominaltransactContainer nlentry, ITaxCode taxCode) {
        if (taxCode == null || taxCode.getJurisdictionType() != JurisdictionType.PL) {
            return null;
        }
        switch (nlentry.entrytype) {
            case 1: {
                return nlentry.taxconfirmdate;
            }
            case 0: {
                return taxCode != null && taxCode.isConfirmation() ? this.getNlentryTaxConfirmationDate(nlentry) : null;
            }
        }
        return null;
    }

    private Date getNlentryTaxConfirmationDate(NominaltransactContainer nlentry) {
        TaxreturnnlentryContainer correspondingTaxEntry = this.getCorrespondingTaxEntry(nlentry);
        return correspondingTaxEntry != null ? correspondingTaxEntry.taxconfirmdate : null;
    }

    private TaxreturnnlentryContainer getCorrespondingTaxEntry(NominaltransactContainer nlentry) {
        TaxreturnnlentryContainer[] taxEntries = dao.getRows(null, (Criterion)Restrictions.conjunction().add(Restrictions.eq((String)"OIDTRANSACTION", (String)nlentry.t_objectid)).add(Restrictions.eq((String)"OIDTAXRATE", (String)nlentry.oidtaxrate)));
        if (taxEntries == null || taxEntries.length == 0) {
            return null;
        }
        boolean netNegative = TransactionHelper.isAmountNegative((BigDecimal)nlentry.enteredamount);
        TaxreturnnlentryContainer result = null;
        for (TaxreturnnlentryContainer taxEntry : taxEntries) {
            boolean taxZero;
            boolean taxNegative = TransactionHelper.isAmountNegative((BigDecimal)taxEntry.enteredamount);
            boolean bl = taxZero = taxEntry.enteredamount != null && taxEntry.enteredamount.signum() == 0;
            if (netNegative != taxNegative && !taxZero || nlentry.debit != taxEntry.debit) continue;
            result = taxEntry;
            break;
        }
        return result;
    }

    private BigDecimal getDownPaymentBaseAmount(NominalTaxEntry[] downPaymentTaxEntries, DownPaymentHelper.DownPaymentAmountType downPaymentAmountType, boolean cancelTransaction) {
        if (downPaymentTaxEntries == null || downPaymentTaxEntries.length == 0) {
            return BigDecimalMapper.ZERO;
        }
        BigDecimal total = BigDecimalMapper.ZERO;
        for (NominalTaxEntry taxEntry : downPaymentTaxEntries) {
            BigDecimal amount = this.getDownPaymentAmount(taxEntry, downPaymentAmountType);
            total = taxEntry.getIsDebit() ? BigDecimalMapper.add((BigDecimal)total, (BigDecimal)amount) : BigDecimalMapper.subtract((BigDecimal)total, (BigDecimal)amount);
        }
        total = total.abs();
        if (cancelTransaction) {
            total = total.negate();
        }
        return total;
    }

    private BigDecimal getDownPaymentAmount(NominalTaxEntry taxEntry, DownPaymentHelper.DownPaymentAmountType downPaymentAmountType) {
        return downPaymentAmountType == DownPaymentHelper.DownPaymentAmountType.DPAT_BASE_NET_AMOUNT ? this.getDownPaymentNetAmount(taxEntry) : taxEntry.getBaseAmount();
    }

    private BigDecimal getDownPaymentNetAmount(NominalTaxEntry taxEntry) {
        return taxEntry.getTaxRate().getTaxCode().getTaxHandlingType() == TaxHandlingType.REVERSE_CHARGE && taxEntry.getTaxAccountType() == TaxAccountTypeEnum.TATE_OUTPUTTAX ? BigDecimalMapper.ZERO : taxEntry.getBaseNetAmount();
    }

    private boolean isNotSummarisedReport(VATReturnCEJournalReportTypeEnum reportType) {
        return reportType.value() != 5 && reportType.value() != 11 && reportType.value() != 9;
    }

    private static enum AmountType {
        TAX_AMOUNT,
        NET_AMOUNT,
        VARIANCE;

    }
}

